/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=325")
public class X509IdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = UaIds.X509IdentityToken_DefaultBinary.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId XML = UaIds.X509IdentityToken_DefaultXml.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId JSON = UaIds.X509IdentityToken_DefaultJson.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId ID = UaIds.X509IdentityToken.asExpandedNodeId();
    public static final StructureSpecification SPECIFICATION;
    private ByteString f_certificateData;

    public X509IdentityToken() {
    }

    public X509IdentityToken(ByteString byteString) {
        this.f_certificateData = byteString;
    }

    public X509IdentityToken(String string, ByteString byteString) {
        super(string);
        this.f_certificateData = byteString;
    }

    public ByteString getCertificateData() {
        return this.f_certificateData;
    }

    public void setCertificateData(ByteString byteString) {
        this.f_certificateData = byteString;
    }

    @Override
    public X509IdentityToken clone() {
        X509IdentityToken x509IdentityToken = (X509IdentityToken)super.clone();
        x509IdentityToken.f_certificateData = StructureUtils.clone(this.f_certificateData);
        return x509IdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        X509IdentityToken x509IdentityToken = (X509IdentityToken)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), x509IdentityToken.getPolicyId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getCertificateData(), x509IdentityToken.getCertificateData());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId(), this.getCertificateData());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_certificateData = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        return StructureUtils.createFieldsMap(this.specification(), new Object[]{this.getPolicyId(), this.getCertificateData()});
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        if (Fields.CertificateData.equals(fieldSpecification)) {
            return this.getCertificateData();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        if (Fields.CertificateData.equals(fieldSpecification)) {
            this.setCertificateData((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = X509IdentityToken.builder();
        builder.setPolicyId(StructureUtils.clone(this.getPolicyId()));
        builder.setCertificateData(StructureUtils.clone(this.getCertificateData()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId);
        builder.addField(Fields.CertificateData);
        builder.setBinaryEncodeId(UaIds.X509IdentityToken_DefaultBinary);
        builder.setXmlEncodeId(UaIds.X509IdentityToken_DefaultXml);
        builder.setJsonEncodeId(UaIds.X509IdentityToken_DefaultJson);
        builder.setTypeId(UaIds.X509IdentityToken);
        builder.addSuperTypeId(UaIds.UserIdentityToken);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("X509IdentityToken");
        builder.setJavaClass(X509IdentityToken.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(X509IdentityToken.class, SPECIFICATION);
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String f_policyId;
        private ByteString f_certificateData;

        protected Builder() {
        }

        @Override
        public String getPolicyId() {
            return this.f_policyId;
        }

        @Override
        public Builder setPolicyId(String string) {
            this.f_policyId = string;
            return this;
        }

        public ByteString getCertificateData() {
            return this.f_certificateData;
        }

        public Builder setCertificateData(ByteString byteString) {
            this.f_certificateData = byteString;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), builder.getPolicyId())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getCertificateData(), builder.getCertificateData());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getPolicyId(), this.getCertificateData());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                return this.getPolicyId();
            }
            if (Fields.CertificateData.equals(fieldSpecification)) {
                return this.getCertificateData();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            if (Fields.CertificateData.equals(fieldSpecification)) {
                this.setCertificateData((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_certificateData = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public X509IdentityToken build() {
            return new X509IdentityToken(this.f_policyId, this.f_certificateData);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        PolicyId("PolicyId", String.class, false, UaIds.String, -1, null, false),
        CertificateData("CertificateData", ByteString.class, false, UaIds.ByteString, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

