/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeDescription;
import com.prosysopc.ua.stack.core.StructureDefinition;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15487")
public class StructureDescription
extends DataTypeDescription {
    @Deprecated
    public static final ExpandedNodeId BINARY = UaIds.StructureDescription_DefaultBinary.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId XML = UaIds.StructureDescription_DefaultXml.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId JSON = UaIds.StructureDescription_DefaultJson.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId ID = UaIds.StructureDescription.asExpandedNodeId();
    public static final StructureSpecification SPECIFICATION;
    private StructureDefinition f_structureDefinition;

    public StructureDescription() {
    }

    public StructureDescription(StructureDefinition structureDefinition) {
        this.f_structureDefinition = structureDefinition;
    }

    public StructureDescription(NodeId nodeId, QualifiedName qualifiedName, StructureDefinition structureDefinition) {
        super(nodeId, qualifiedName);
        this.f_structureDefinition = structureDefinition;
    }

    public StructureDefinition getStructureDefinition() {
        return this.f_structureDefinition;
    }

    public void setStructureDefinition(StructureDefinition structureDefinition) {
        this.f_structureDefinition = structureDefinition;
    }

    @Override
    public StructureDescription clone() {
        StructureDescription structureDescription = (StructureDescription)super.clone();
        structureDescription.f_structureDefinition = StructureUtils.clone(this.f_structureDefinition);
        return structureDescription;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StructureDescription structureDescription = (StructureDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getDataTypeId(), structureDescription.getDataTypeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), structureDescription.getName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getStructureDefinition(), structureDescription.getStructureDefinition());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getDataTypeId(), this.getName(), this.getStructureDefinition());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_structureDefinition = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        return StructureUtils.createFieldsMap(this.specification(), new Object[]{this.getDataTypeId(), this.getName(), this.getStructureDefinition()});
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DataTypeId.equals(fieldSpecification)) {
            return this.getDataTypeId();
        }
        if (Fields.Name.equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.StructureDefinition.equals(fieldSpecification)) {
            return this.getStructureDefinition();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DataTypeId.equals(fieldSpecification)) {
            this.setDataTypeId((NodeId)object);
            return;
        }
        if (Fields.Name.equals(fieldSpecification)) {
            this.setName((QualifiedName)object);
            return;
        }
        if (Fields.StructureDefinition.equals(fieldSpecification)) {
            this.setStructureDefinition((StructureDefinition)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = StructureDescription.builder();
        builder.setDataTypeId(StructureUtils.clone(this.getDataTypeId()));
        builder.setName(StructureUtils.clone(this.getName()));
        builder.setStructureDefinition(StructureUtils.clone(this.getStructureDefinition()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.DataTypeId);
        builder.addField(Fields.Name);
        builder.addField(Fields.StructureDefinition);
        builder.setBinaryEncodeId(UaIds.StructureDescription_DefaultBinary);
        builder.setXmlEncodeId(UaIds.StructureDescription_DefaultXml);
        builder.setJsonEncodeId(UaIds.StructureDescription_DefaultJson);
        builder.setTypeId(UaIds.StructureDescription);
        builder.addSuperTypeId(UaIds.DataTypeDescription);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("StructureDescription");
        builder.setJavaClass(StructureDescription.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(StructureDescription.class, SPECIFICATION);
    }

    public static class Builder
    extends DataTypeDescription.Builder {
        private NodeId f_dataTypeId;
        private QualifiedName f_name;
        private StructureDefinition f_structureDefinition;

        protected Builder() {
        }

        @Override
        public NodeId getDataTypeId() {
            return this.f_dataTypeId;
        }

        @Override
        public Builder setDataTypeId(NodeId nodeId) {
            this.f_dataTypeId = nodeId;
            return this;
        }

        @Override
        public QualifiedName getName() {
            return this.f_name;
        }

        @Override
        public Builder setName(QualifiedName qualifiedName) {
            this.f_name = qualifiedName;
            return this;
        }

        public StructureDefinition getStructureDefinition() {
            return this.f_structureDefinition;
        }

        public Builder setStructureDefinition(StructureDefinition structureDefinition) {
            this.f_structureDefinition = structureDefinition;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getDataTypeId(), builder.getDataTypeId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getName(), builder.getName())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getStructureDefinition(), builder.getStructureDefinition());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getDataTypeId(), this.getName(), this.getStructureDefinition());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.DataTypeId.equals(fieldSpecification)) {
                return this.getDataTypeId();
            }
            if (Fields.Name.equals(fieldSpecification)) {
                return this.getName();
            }
            if (Fields.StructureDefinition.equals(fieldSpecification)) {
                return this.getStructureDefinition();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DataTypeId.equals(fieldSpecification)) {
                this.setDataTypeId((NodeId)object);
                return this;
            }
            if (Fields.Name.equals(fieldSpecification)) {
                this.setName((QualifiedName)object);
                return this;
            }
            if (Fields.StructureDefinition.equals(fieldSpecification)) {
                this.setStructureDefinition((StructureDefinition)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_structureDefinition = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public StructureDescription build() {
            return new StructureDescription(this.f_dataTypeId, this.f_name, this.f_structureDefinition);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        DataTypeId("DataTypeId", NodeId.class, false, UaIds.NodeId, -1, null, false),
        Name("Name", QualifiedName.class, false, UaIds.QualifiedName, -1, null, false),
        StructureDefinition("StructureDefinition", StructureDefinition.class, false, UaIds.StructureDefinition, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

