/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=296")
public class Argument
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = UaIds.Argument_DefaultBinary.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId XML = UaIds.Argument_DefaultXml.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId JSON = UaIds.Argument_DefaultJson.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId ID = UaIds.Argument.asExpandedNodeId();
    public static final StructureSpecification SPECIFICATION;
    private String f_name;
    private NodeId f_dataType;
    private Integer f_valueRank;
    private UnsignedInteger[] f_arrayDimensions;
    private LocalizedText f_description;

    public Argument() {
    }

    public Argument(String string, NodeId nodeId, Integer n2, UnsignedInteger[] unsignedIntegerArray, LocalizedText localizedText) {
        this.f_name = string;
        this.f_dataType = nodeId;
        this.f_valueRank = n2;
        this.f_arrayDimensions = unsignedIntegerArray;
        this.f_description = localizedText;
    }

    public String getName() {
        return this.f_name;
    }

    public void setName(String string) {
        this.f_name = string;
    }

    public NodeId getDataType() {
        return this.f_dataType;
    }

    public void setDataType(NodeId nodeId) {
        this.f_dataType = nodeId;
    }

    public Integer getValueRank() {
        return this.f_valueRank;
    }

    public void setValueRank(Integer n2) {
        this.f_valueRank = n2;
    }

    public UnsignedInteger[] getArrayDimensions() {
        return this.f_arrayDimensions;
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.f_arrayDimensions = unsignedIntegerArray;
    }

    public LocalizedText getDescription() {
        return this.f_description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.f_description = localizedText;
    }

    @Override
    public Argument clone() {
        Argument argument = (Argument)super.clone();
        argument.f_name = StructureUtils.clone(this.f_name);
        argument.f_dataType = StructureUtils.clone(this.f_dataType);
        argument.f_valueRank = StructureUtils.clone(this.f_valueRank);
        argument.f_arrayDimensions = StructureUtils.clone(this.f_arrayDimensions);
        argument.f_description = StructureUtils.clone(this.f_description);
        return argument;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Argument argument = (Argument)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), argument.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataType(), argument.getDataType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getValueRank(), argument.getValueRank())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getArrayDimensions(), argument.getArrayDimensions())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDescription(), argument.getDescription());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getName(), this.getDataType(), this.getValueRank(), this.getArrayDimensions(), this.getDescription());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_name = null;
        this.f_dataType = null;
        this.f_valueRank = null;
        this.f_arrayDimensions = null;
        this.f_description = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        return StructureUtils.createFieldsMap(this.specification(), new Object[]{this.getName(), this.getDataType(), this.getValueRank(), this.getArrayDimensions(), this.getDescription()});
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Name.equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.DataType.equals(fieldSpecification)) {
            return this.getDataType();
        }
        if (Fields.ValueRank.equals(fieldSpecification)) {
            return this.getValueRank();
        }
        if (Fields.ArrayDimensions.equals(fieldSpecification)) {
            return this.getArrayDimensions();
        }
        if (Fields.Description.equals(fieldSpecification)) {
            return this.getDescription();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Name.equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        if (Fields.DataType.equals(fieldSpecification)) {
            this.setDataType((NodeId)object);
            return;
        }
        if (Fields.ValueRank.equals(fieldSpecification)) {
            this.setValueRank((Integer)object);
            return;
        }
        if (Fields.ArrayDimensions.equals(fieldSpecification)) {
            this.setArrayDimensions((UnsignedInteger[])object);
            return;
        }
        if (Fields.Description.equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = Argument.builder();
        builder.setName(StructureUtils.clone(this.getName()));
        builder.setDataType(StructureUtils.clone(this.getDataType()));
        builder.setValueRank(StructureUtils.clone(this.getValueRank()));
        builder.setArrayDimensions(StructureUtils.clone(this.getArrayDimensions()));
        builder.setDescription(StructureUtils.clone(this.getDescription()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Name);
        builder.addField(Fields.DataType);
        builder.addField(Fields.ValueRank);
        builder.addField(Fields.ArrayDimensions);
        builder.addField(Fields.Description);
        builder.setBinaryEncodeId(UaIds.Argument_DefaultBinary);
        builder.setXmlEncodeId(UaIds.Argument_DefaultXml);
        builder.setJsonEncodeId(UaIds.Argument_DefaultJson);
        builder.setTypeId(UaIds.Argument);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("Argument");
        builder.setJavaClass(Argument.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(Argument.class, SPECIFICATION);
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String f_name;
        private NodeId f_dataType;
        private Integer f_valueRank;
        private UnsignedInteger[] f_arrayDimensions;
        private LocalizedText f_description;

        protected Builder() {
        }

        public String getName() {
            return this.f_name;
        }

        public Builder setName(String string) {
            this.f_name = string;
            return this;
        }

        public NodeId getDataType() {
            return this.f_dataType;
        }

        public Builder setDataType(NodeId nodeId) {
            this.f_dataType = nodeId;
            return this;
        }

        public Integer getValueRank() {
            return this.f_valueRank;
        }

        public Builder setValueRank(Integer n2) {
            this.f_valueRank = n2;
            return this;
        }

        public UnsignedInteger[] getArrayDimensions() {
            return this.f_arrayDimensions;
        }

        public Builder setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
            this.f_arrayDimensions = unsignedIntegerArray;
            return this;
        }

        public LocalizedText getDescription() {
            return this.f_description;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.f_description = localizedText;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getName(), builder.getName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDataType(), builder.getDataType())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getValueRank(), builder.getValueRank())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getArrayDimensions(), builder.getArrayDimensions())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getDescription(), builder.getDescription());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getName(), this.getDataType(), this.getValueRank(), this.getArrayDimensions(), this.getDescription());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Name.equals(fieldSpecification)) {
                return this.getName();
            }
            if (Fields.DataType.equals(fieldSpecification)) {
                return this.getDataType();
            }
            if (Fields.ValueRank.equals(fieldSpecification)) {
                return this.getValueRank();
            }
            if (Fields.ArrayDimensions.equals(fieldSpecification)) {
                return this.getArrayDimensions();
            }
            if (Fields.Description.equals(fieldSpecification)) {
                return this.getDescription();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Name.equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            if (Fields.DataType.equals(fieldSpecification)) {
                this.setDataType((NodeId)object);
                return this;
            }
            if (Fields.ValueRank.equals(fieldSpecification)) {
                this.setValueRank((Integer)object);
                return this;
            }
            if (Fields.ArrayDimensions.equals(fieldSpecification)) {
                this.setArrayDimensions((UnsignedInteger[])object);
                return this;
            }
            if (Fields.Description.equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_name = null;
            this.f_dataType = null;
            this.f_valueRank = null;
            this.f_arrayDimensions = null;
            this.f_description = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public Argument build() {
            return new Argument(this.f_name, this.f_dataType, this.f_valueRank, this.f_arrayDimensions, this.f_description);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Name("Name", String.class, false, UaIds.String, -1, null, false),
        DataType("DataType", NodeId.class, false, UaIds.NodeId, -1, null, false),
        ValueRank("ValueRank", Integer.class, false, UaIds.Int32, -1, null, false),
        ArrayDimensions("ArrayDimensions", UnsignedInteger[].class, false, UaIds.UInt32, 1, UaArrayDimensions.valueOf(0L), false),
        Description("Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

