/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=728")
public class AggregateFilter
extends MonitoringFilter {
    @Deprecated
    public static final ExpandedNodeId BINARY = UaIds.AggregateFilter_DefaultBinary.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId XML = UaIds.AggregateFilter_DefaultXml.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId JSON = UaIds.AggregateFilter_DefaultJson.asExpandedNodeId();
    @Deprecated
    public static final ExpandedNodeId ID = UaIds.AggregateFilter.asExpandedNodeId();
    public static final StructureSpecification SPECIFICATION;
    private DateTime f_startTime;
    private NodeId f_aggregateType;
    private Double f_processingInterval;
    private AggregateConfiguration f_aggregateConfiguration;

    public AggregateFilter() {
    }

    public AggregateFilter(DateTime dateTime, NodeId nodeId, Double d2, AggregateConfiguration aggregateConfiguration) {
        this.f_startTime = dateTime;
        this.f_aggregateType = nodeId;
        this.f_processingInterval = d2;
        this.f_aggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getStartTime() {
        return this.f_startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.f_startTime = dateTime;
    }

    public NodeId getAggregateType() {
        return this.f_aggregateType;
    }

    public void setAggregateType(NodeId nodeId) {
        this.f_aggregateType = nodeId;
    }

    public Double getProcessingInterval() {
        return this.f_processingInterval;
    }

    public void setProcessingInterval(Double d2) {
        this.f_processingInterval = d2;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.f_aggregateConfiguration;
    }

    public void setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.f_aggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public AggregateFilter clone() {
        AggregateFilter aggregateFilter = (AggregateFilter)super.clone();
        aggregateFilter.f_startTime = StructureUtils.clone(this.f_startTime);
        aggregateFilter.f_aggregateType = StructureUtils.clone(this.f_aggregateType);
        aggregateFilter.f_processingInterval = StructureUtils.clone(this.f_processingInterval);
        aggregateFilter.f_aggregateConfiguration = StructureUtils.clone(this.f_aggregateConfiguration);
        return aggregateFilter;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AggregateFilter aggregateFilter = (AggregateFilter)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), aggregateFilter.getStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAggregateType(), aggregateFilter.getAggregateType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getProcessingInterval(), aggregateFilter.getProcessingInterval())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAggregateConfiguration(), aggregateFilter.getAggregateConfiguration());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getStartTime(), this.getAggregateType(), this.getProcessingInterval(), this.getAggregateConfiguration());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_startTime = null;
        this.f_aggregateType = null;
        this.f_processingInterval = null;
        this.f_aggregateConfiguration = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        return StructureUtils.createFieldsMap(this.specification(), new Object[]{this.getStartTime(), this.getAggregateType(), this.getProcessingInterval(), this.getAggregateConfiguration()});
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StartTime.equals(fieldSpecification)) {
            return this.getStartTime();
        }
        if (Fields.AggregateType.equals(fieldSpecification)) {
            return this.getAggregateType();
        }
        if (Fields.ProcessingInterval.equals(fieldSpecification)) {
            return this.getProcessingInterval();
        }
        if (Fields.AggregateConfiguration.equals(fieldSpecification)) {
            return this.getAggregateConfiguration();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StartTime.equals(fieldSpecification)) {
            this.setStartTime((DateTime)object);
            return;
        }
        if (Fields.AggregateType.equals(fieldSpecification)) {
            this.setAggregateType((NodeId)object);
            return;
        }
        if (Fields.ProcessingInterval.equals(fieldSpecification)) {
            this.setProcessingInterval((Double)object);
            return;
        }
        if (Fields.AggregateConfiguration.equals(fieldSpecification)) {
            this.setAggregateConfiguration((AggregateConfiguration)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AggregateFilter.builder();
        builder.setStartTime(StructureUtils.clone(this.getStartTime()));
        builder.setAggregateType(StructureUtils.clone(this.getAggregateType()));
        builder.setProcessingInterval(StructureUtils.clone(this.getProcessingInterval()));
        builder.setAggregateConfiguration(StructureUtils.clone(this.getAggregateConfiguration()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.StartTime);
        builder.addField(Fields.AggregateType);
        builder.addField(Fields.ProcessingInterval);
        builder.addField(Fields.AggregateConfiguration);
        builder.setBinaryEncodeId(UaIds.AggregateFilter_DefaultBinary);
        builder.setXmlEncodeId(UaIds.AggregateFilter_DefaultXml);
        builder.setJsonEncodeId(UaIds.AggregateFilter_DefaultJson);
        builder.setTypeId(UaIds.AggregateFilter);
        builder.addSuperTypeId(UaIds.MonitoringFilter);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("AggregateFilter");
        builder.setJavaClass(AggregateFilter.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(AggregateFilter.class, SPECIFICATION);
    }

    public static class Builder
    extends MonitoringFilter.Builder {
        private DateTime f_startTime;
        private NodeId f_aggregateType;
        private Double f_processingInterval;
        private AggregateConfiguration f_aggregateConfiguration;

        protected Builder() {
        }

        public DateTime getStartTime() {
            return this.f_startTime;
        }

        public Builder setStartTime(DateTime dateTime) {
            this.f_startTime = dateTime;
            return this;
        }

        public NodeId getAggregateType() {
            return this.f_aggregateType;
        }

        public Builder setAggregateType(NodeId nodeId) {
            this.f_aggregateType = nodeId;
            return this;
        }

        public Double getProcessingInterval() {
            return this.f_processingInterval;
        }

        public Builder setProcessingInterval(Double d2) {
            this.f_processingInterval = d2;
            return this;
        }

        public AggregateConfiguration getAggregateConfiguration() {
            return this.f_aggregateConfiguration;
        }

        public Builder setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.f_aggregateConfiguration = aggregateConfiguration;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), builder.getStartTime())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getAggregateType(), builder.getAggregateType())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getProcessingInterval(), builder.getProcessingInterval())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getAggregateConfiguration(), builder.getAggregateConfiguration());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getStartTime(), this.getAggregateType(), this.getProcessingInterval(), this.getAggregateConfiguration());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.StartTime.equals(fieldSpecification)) {
                return this.getStartTime();
            }
            if (Fields.AggregateType.equals(fieldSpecification)) {
                return this.getAggregateType();
            }
            if (Fields.ProcessingInterval.equals(fieldSpecification)) {
                return this.getProcessingInterval();
            }
            if (Fields.AggregateConfiguration.equals(fieldSpecification)) {
                return this.getAggregateConfiguration();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StartTime.equals(fieldSpecification)) {
                this.setStartTime((DateTime)object);
                return this;
            }
            if (Fields.AggregateType.equals(fieldSpecification)) {
                this.setAggregateType((NodeId)object);
                return this;
            }
            if (Fields.ProcessingInterval.equals(fieldSpecification)) {
                this.setProcessingInterval((Double)object);
                return this;
            }
            if (Fields.AggregateConfiguration.equals(fieldSpecification)) {
                this.setAggregateConfiguration((AggregateConfiguration)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_startTime = null;
            this.f_aggregateType = null;
            this.f_processingInterval = null;
            this.f_aggregateConfiguration = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public AggregateFilter build() {
            return new AggregateFilter(this.f_startTime, this.f_aggregateType, this.f_processingInterval, this.f_aggregateConfiguration);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        StartTime("StartTime", DateTime.class, false, UaIds.UtcTime, -1, null, false),
        AggregateType("AggregateType", NodeId.class, false, UaIds.NodeId, -1, null, false),
        ProcessingInterval("ProcessingInterval", Double.class, false, UaIds.Duration, -1, null, false),
        AggregateConfiguration("AggregateConfiguration", AggregateConfiguration.class, false, UaIds.AggregateConfiguration, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

