/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Comparator;

public final class QualifiedName
implements UaNamespaceTranslateable<QualifiedName>,
Comparable<QualifiedName> {
    @Deprecated
    public static final NodeId ID = Identifiers.QualifiedName;
    public static final QualifiedName NULL = new QualifiedName(UnsignedShort.valueOf(0), null);
    public static final QualifiedName DEFAULT_BINARY_ENCODING = new QualifiedName("Default Binary");
    public static final QualifiedName DEFAULT_XML_ENCODING = new QualifiedName("Default XML");
    public static final QualifiedName EMPTY = new QualifiedName("");
    public static final QualifiedName[] EMPTY_ARRAY = new QualifiedName[0];
    private int namespaceIndex;
    private String name;

    public static QualifiedName[] arrayFrom(UaQualifiedName[] uaQualifiedNameArray, NamespaceTable namespaceTable) {
        if (uaQualifiedNameArray == null) {
            return null;
        }
        if (uaQualifiedNameArray.length == 0) {
            return EMPTY_ARRAY;
        }
        QualifiedName[] qualifiedNameArray = new QualifiedName[uaQualifiedNameArray.length];
        for (int i2 = 0; i2 < uaQualifiedNameArray.length; ++i2) {
            qualifiedNameArray[i2] = QualifiedName.from(uaQualifiedNameArray[i2], namespaceTable);
        }
        return qualifiedNameArray;
    }

    public static QualifiedName from(UaQualifiedName uaQualifiedName, NamespaceTable namespaceTable) {
        if (uaQualifiedName == null) {
            return null;
        }
        return uaQualifiedName.toQualifiedName(namespaceTable);
    }

    public static boolean isNull(QualifiedName qualifiedName) {
        return qualifiedName == null || qualifiedName.equals(NULL);
    }

    public static boolean isNullOrEmpty(QualifiedName qualifiedName) {
        if (QualifiedName.isNull(qualifiedName)) {
            return true;
        }
        return "".equals(qualifiedName.name);
    }

    public static QualifiedName parseQualifiedName(String string) {
        String[] stringArray = string.split(":");
        UnsignedShort unsignedShort = UnsignedShort.ZERO;
        String string2 = string;
        if (stringArray.length > 1) {
            try {
                unsignedShort = UnsignedShort.parseUnsignedShort(stringArray[0]);
                string2 = string.substring(stringArray[0].length() + 1);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new QualifiedName(unsignedShort, string2);
    }

    public QualifiedName(int n2, String string) {
        if (n2 < UnsignedShort.MIN_VALUE.intValue() || n2 > UnsignedShort.MAX_VALUE.intValue()) {
            throw new IllegalArgumentException("namespace index out of bounds");
        }
        this.namespaceIndex = n2;
        this.name = string;
    }

    public QualifiedName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        this.namespaceIndex = 0;
        this.name = string;
    }

    public QualifiedName(UnsignedShort unsignedShort, String string) {
        this.namespaceIndex = unsignedShort.intValue();
        this.name = string;
    }

    @Override
    public int compareTo(QualifiedName qualifiedName) {
        if (this == qualifiedName) {
            return 0;
        }
        int n2 = Integer.compare(this.namespaceIndex, qualifiedName.namespaceIndex);
        if (n2 != 0) {
            return n2;
        }
        return Comparator.nullsFirst((string, string2) -> string.compareTo((String)string2)).compare(this.name, qualifiedName.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return QualifiedName.isNull(this);
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QualifiedName qualifiedName = (QualifiedName)object;
        if (this.namespaceIndex != qualifiedName.namespaceIndex) {
            return false;
        }
        return !(this.name == null ? qualifiedName.name != null : !this.name.equals(qualifiedName.name));
    }

    public String getName() {
        return this.name;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + this.namespaceIndex;
        return n3;
    }

    public String toString() {
        if (this.namespaceIndex > 0) {
            return this.namespaceIndex + ":" + this.name;
        }
        return this.name;
    }

    @Override
    public QualifiedName withTranslatedNamespaces(UaNamespaceTranslateable.Context context) {
        return new QualifiedName(context.getNamespaceIndexTranslation().apply(this.getNamespaceIndex()), this.name);
    }
}

