/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NodeId
implements UaNamespaceTranslateable<NodeId>,
Comparable<NodeId> {
    private static final ByteString NULL_OPAQUE_VALUE = ByteString.EMPTY;
    private static final UUID NULL_GUID_VALUE = new UUID(0L, 0L);
    @Deprecated
    public static final NodeId ZERO = new NodeId(0, UnsignedInteger.getFromBits(0));
    public static final NodeId NULL_NUMERIC = new NodeId(0, UnsignedInteger.getFromBits(0));
    public static final NodeId NULL_STRING = NodeId.get(IdType.String, 0, "");
    public static final NodeId NULL_GUID = NodeId.get(IdType.Guid, 0, NULL_GUID_VALUE);
    public static final NodeId NULL_OPAQUE = NodeId.get(IdType.Opaque, 0, NULL_OPAQUE_VALUE);
    public static final NodeId NULL = NULL_NUMERIC;
    @Deprecated
    public static final NodeId ID = Identifiers.NodeId;
    static final Pattern sM = Pattern.compile("ns=(\\d*);i=(\\d*)");
    static final Pattern sN = Pattern.compile("i=(\\d*)");
    static final Pattern sO = Pattern.compile("ns=(\\d*);s=(.*)");
    static final Pattern sP = Pattern.compile("s=(.*)");
    static final Pattern sQ = Pattern.compile("ns=(\\d*);g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    static final Pattern sR = Pattern.compile("g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    static final Pattern sS = Pattern.compile("ns=(\\d*);b=([0-9a-zA-Z\\+/=]*)");
    static final Pattern sT = Pattern.compile("b=([0-9a-zA-Z\\+/=]*)");
    public static final NodeId[] EMPTY_ARRAY = new NodeId[0];
    final IdType sK;
    final int namespaceIndex;
    final Object value;
    final boolean isNull;
    final int hash;

    public static NodeId[] arrayFrom(UaNodeId[] uaNodeIdArray, NamespaceTable namespaceTable) {
        if (uaNodeIdArray == null) {
            return null;
        }
        if (uaNodeIdArray.length == 0) {
            return EMPTY_ARRAY;
        }
        NodeId[] nodeIdArray = new NodeId[uaNodeIdArray.length];
        for (int i2 = 0; i2 < uaNodeIdArray.length; ++i2) {
            nodeIdArray[i2] = NodeId.from(uaNodeIdArray[i2], namespaceTable);
        }
        return nodeIdArray;
    }

    @Deprecated
    public static NodeId decode(String string) throws IllegalArgumentException {
        return NodeId.parseNodeId(string);
    }

    @Deprecated
    public static boolean equals(NodeId nodeId, NodeId nodeId2) {
        return Objects.equals(nodeId, nodeId2);
    }

    public static NodeId from(UaNodeId uaNodeId, NamespaceTable namespaceTable) {
        if (uaNodeId == null) {
            return null;
        }
        return uaNodeId.asNodeId(namespaceTable);
    }

    public static NodeId get(IdType idType, int n2, Object object) {
        if (idType == IdType.Guid) {
            return new NodeId(n2, (UUID)object);
        }
        if (idType == IdType.Numeric) {
            return new NodeId(n2, (UnsignedInteger)object);
        }
        if (idType == IdType.Opaque) {
            if (object instanceof byte[]) {
                return new NodeId(n2, ByteString.valueOf((byte[])object));
            }
            return new NodeId(n2, (ByteString)object);
        }
        if (idType == IdType.String) {
            return new NodeId(n2, (String)object);
        }
        throw new IllegalArgumentException("bad type");
    }

    public static boolean isNull(NodeId nodeId) {
        return nodeId == null || nodeId.isNullNodeId();
    }

    public static NodeId parseNodeId(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null arg");
        }
        Matcher matcher = sP.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return new NodeId(0, string2);
        }
        matcher = sN.matcher(string);
        if (matcher.matches()) {
            UnsignedInteger unsignedInteger = UnsignedInteger.valueOf(matcher.group(1));
            return new NodeId(0, unsignedInteger);
        }
        matcher = sR.matcher(string);
        if (matcher.matches()) {
            UUID uUID = UUID.fromString(matcher.group(1));
            return new NodeId(0, uUID);
        }
        matcher = sT.matcher(string);
        if (matcher.matches()) {
            byte[] byArray = CryptoUtil.base64Decode(matcher.group(1));
            return new NodeId(0, ByteString.valueOf(byArray));
        }
        matcher = sM.matcher(string);
        if (matcher.matches()) {
            Integer n2 = Integer.valueOf(matcher.group(1));
            UnsignedInteger unsignedInteger = UnsignedInteger.valueOf(matcher.group(2));
            return new NodeId((int)n2, unsignedInteger);
        }
        matcher = sO.matcher(string);
        if (matcher.matches()) {
            Integer n3 = Integer.valueOf(matcher.group(1));
            String string3 = matcher.group(2);
            return new NodeId((int)n3, string3);
        }
        matcher = sQ.matcher(string);
        if (matcher.matches()) {
            Integer n4 = Integer.valueOf(matcher.group(1));
            UUID uUID = UUID.fromString(matcher.group(2));
            return new NodeId((int)n4, uUID);
        }
        matcher = sS.matcher(string);
        if (matcher.matches()) {
            Integer n5 = Integer.valueOf(matcher.group(1));
            byte[] byArray = CryptoUtil.base64Decode(matcher.group(2));
            return new NodeId((int)n5, ByteString.valueOf(byArray));
        }
        throw new IllegalArgumentException("Invalid string representation of a nodeId: " + string);
    }

    public static NodeId randomGUID(int n2) {
        return new NodeId(n2, UUID.randomUUID());
    }

    static boolean a(int n2, IdType idType, Object object) {
        if (object == null) {
            return true;
        }
        if (n2 != 0) {
            return false;
        }
        switch (idType) {
            case Numeric: {
                return ((UnsignedInteger)object).intValue() == 0;
            }
            case String: {
                return ((String)object).length() == 0;
            }
            case Guid: {
                return object.equals(NULL_GUID_VALUE);
            }
            case Opaque: {
                return object.equals(NULL_OPAQUE_VALUE);
            }
        }
        return false;
    }

    public NodeId(int n2, byte[] byArray) {
        this(n2, ByteString.valueOf(byArray));
    }

    public NodeId(int n2, ByteString byteString) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (byteString != null && byteString.getLength() > 4096) {
            throw new IllegalArgumentException("The length is restricted to 4096 bytes");
        }
        this.sK = IdType.Opaque;
        this.value = byteString;
        this.namespaceIndex = n2;
        this.isNull = NodeId.a(n2, this.sK, byteString);
        this.hash = this.calcHashCode();
    }

    public NodeId(int n2, int n3) {
        this(n2, UnsignedInteger.getFromBits(n3));
    }

    public NodeId(int n2, String string) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (string != null && string.length() > 4096) {
            throw new IllegalArgumentException("The length is restricted to 4096 characters");
        }
        this.sK = IdType.String;
        this.value = string;
        this.namespaceIndex = n2;
        this.isNull = NodeId.a(n2, this.sK, string);
        this.hash = this.calcHashCode();
    }

    public NodeId(int n2, UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("Numeric NodeId cannot be null");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        this.value = unsignedInteger;
        this.namespaceIndex = n2;
        this.sK = IdType.Numeric;
        this.isNull = NodeId.a(n2, this.sK, unsignedInteger);
        this.hash = this.calcHashCode();
    }

    public NodeId(int n2, UUID uUID) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (uUID == null) {
            throw new IllegalArgumentException("Numeric NodeId cannot be null");
        }
        this.sK = IdType.Guid;
        this.value = uUID;
        this.namespaceIndex = n2;
        this.isNull = NodeId.a(n2, this.sK, uUID);
        this.hash = this.calcHashCode();
    }

    @Override
    public int compareTo(NodeId nodeId) {
        if (this == nodeId) {
            return 0;
        }
        int n2 = this.namespaceIndex - nodeId.namespaceIndex;
        if (n2 == 0) {
            n2 = this.sK.getValue() - nodeId.sK.getValue();
        }
        if (n2 == 0) {
            switch (this.sK) {
                case Numeric: {
                    return ((UnsignedInteger)this.value).compareTo((UnsignedInteger)nodeId.value);
                }
                case String: {
                    return ((String)this.value).compareTo((String)nodeId.value);
                }
                case Guid: {
                    return ((UUID)this.value).compareTo((UUID)nodeId.value);
                }
                case Opaque: {
                    return ((ByteString)this.value).compareTo((ByteString)nodeId.value);
                }
            }
            throw new Error("Unkonwn IdType:" + this.sK);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return NodeId.isNull(this);
        }
        if (object instanceof NodeId) {
            NodeId nodeId = (NodeId)object;
            if (this.hash != nodeId.hash) {
                return false;
            }
            if (NodeId.isNull(this) || NodeId.isNull(nodeId)) {
                return NodeId.isNull(this) == NodeId.isNull(nodeId);
            }
            if (nodeId.namespaceIndex != this.namespaceIndex || nodeId.sK != this.sK) {
                return false;
            }
            if (this.value == nodeId.value) {
                return true;
            }
            return nodeId.value.equals(this.value);
        }
        if (object instanceof ExpandedNodeId) {
            ExpandedNodeId expandedNodeId = (ExpandedNodeId)object;
            if (expandedNodeId.namespaceUri != null && expandedNodeId.namespaceUri != "http://opcfoundation.org/UA/" || !expandedNodeId.isLocal()) {
                return false;
            }
            if (this.namespaceIndex != expandedNodeId.namespaceIndex || this.sK != expandedNodeId.sK) {
                return false;
            }
            if (this.value == expandedNodeId.value) {
                return true;
            }
            return this.value.equals(expandedNodeId.value);
        }
        return false;
    }

    public IdType getIdType() {
        return this.sK;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isNullNodeId() {
        return this.isNull;
    }

    public String toString() {
        String string;
        String string2 = string = this.namespaceIndex > 0 ? "ns=" + this.namespaceIndex + ";" : "";
        if (this.sK == IdType.Numeric) {
            return string + "i=" + this.value;
        }
        if (this.sK == IdType.String) {
            return string + "s=" + this.value;
        }
        if (this.sK == IdType.Guid) {
            return string + "g=" + this.value;
        }
        if (this.sK == IdType.Opaque) {
            if (this.value == null) {
                return string + "b=null";
            }
            return string + "b=" + new String(CryptoUtil.base64Encode(((ByteString)this.value).getValue()));
        }
        return "error";
    }

    @Override
    public NodeId withTranslatedNamespaces(UaNamespaceTranslateable.Context context) {
        return NodeId.get(this.getIdType(), context.getNamespaceIndexTranslation().apply(this.getNamespaceIndex()), this.getValue());
    }

    private int calcHashCode() {
        int n2 = 13 * this.namespaceIndex;
        if (this.value != null) {
            n2 += 3 * this.value.hashCode();
        }
        return n2;
    }
}

