/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.instantiation.UaTypeInstanceDeclarationHierarchy;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaTypeNode
extends BaseNode
implements UaType {
    private static final Logger logger = LoggerFactory.getLogger(UaTypeNode.class);
    private UaTypeInstanceDeclarationHierarchy sa = null;
    private UaType sb;
    boolean sc = false;

    protected UaTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    protected UaTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected UaTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void addSubType(UaType uaType) {
        this.addReference((UaNode)uaType, Identifiers.HasSubtype, false);
    }

    @Override
    public UaNode getComponent(QualifiedName qualifiedName) {
        UaType uaType;
        UaNode uaNode = super.getComponent(qualifiedName);
        logger.debug("getComponent: type={} component={}", (Object)this.getBrowseName(), (Object)uaNode);
        if (uaNode == null && (uaType = this.getSuperType()) != null) {
            uaNode = uaType.getComponent(qualifiedName);
        }
        return uaNode;
    }

    public synchronized UaTypeInstanceDeclarationHierarchy getInstanceDeclarationHierarchy() {
        if (this.sa == null) {
            this.resetInstanceDeclarationHierarchy();
        }
        return this.sa;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.sc;
    }

    @Override
    public UaType getSuperType() {
        return this.sb;
    }

    @Override
    public boolean hasSuperType() {
        return this.getSuperType() != null;
    }

    @Override
    public boolean inheritsFrom(NodeId nodeId) {
        if (NodeId.isNull(nodeId)) {
            return false;
        }
        if (this.getNodeId().equals(nodeId)) {
            return true;
        }
        UaType uaType = this.getSuperType();
        return uaType != null && uaType.inheritsFrom(nodeId);
    }

    @Override
    public boolean inheritsFrom(UaType uaType) {
        if (uaType == null) {
            return false;
        }
        if (this.getNodeId().equals(uaType.getNodeId())) {
            return true;
        }
        UaType uaType2 = this.getSuperType();
        return uaType2 != null && uaType2.inheritsFrom(uaType);
    }

    public synchronized void resetInstanceDeclarationHierarchy() {
        this.sa = UaTypeInstanceDeclarationHierarchy.fromUaType(this);
    }

    @Override
    public void setIsAbstract(Boolean bl) {
        this.sc = bl;
    }

    @Override
    public void setSuperType(UaType uaType) {
        if (uaType != this.sb) {
            if (uaType == null) {
                throw new NullPointerException("UaTypeNode.setSuperType() cannot take null");
            }
            UaReference uaReference = this.getReference(Identifiers.HasSubtype, true);
            if (uaReference != null) {
                this.deleteReference(uaReference);
            }
            this.sb = uaType;
            this.addReference((UaNode)uaType, Identifiers.HasSubtype, true);
            uaType.addSubType(this);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", IsAbstract=" + this.sc;
    }

    @Override
    protected void afterAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals(Identifiers.HasSubtype)) {
            UaType uaType = (UaType)uaReference.getSourceNode();
            UaType uaType2 = (UaType)uaReference.getTargetNode();
            if (uaReference.getIsInverse(this)) {
                this.setSuperType(uaType);
            } else {
                uaType2.setSuperType(this);
            }
        }
        super.afterAddReference(uaReference);
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals(Identifiers.HasSubtype) && !uaReference.getIsInverse(this)) {
            UaReference[] uaReferenceArray = this.getReferences(Identifiers.HasSubtype, false);
            UaType uaType = (UaType)uaReference.getTargetNode();
            for (UaReference uaReference2 : uaReferenceArray) {
                if (uaReference2.getTargetNode() != uaType) continue;
                return false;
            }
        }
        return super.beforeAddReference(uaReference);
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.IsAbstract);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.IsAbstract)) {
            dataValue.setValue(new Variant(this.sc));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals(Attributes.IsAbstract)) {
            this.sc = (Boolean)object;
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

