/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainVariable<T>
extends UaVariableNode {
    private static final StatusCode rE = new StatusCode(StatusCodes.Bad_WaitingForInitialData);
    private static Logger logger = LoggerFactory.getLogger(PlainVariable.class);
    private volatile T rJ;
    private volatile DateTime rK;
    private volatile UnsignedShort rL = UnsignedShort.ZERO;
    private volatile DateTime rF = INITIALIZATION_TIME;
    private volatile StatusCode fV = rE;

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected PlainVariable(UaNode.Parameters parameters) {
        super(parameters);
    }

    public final T getCurrentValue() {
        return this.rJ;
    }

    public DateTime getServerTimestamp() {
        return this.rK;
    }

    public DateTime getSourceTimestamp() {
        return this.rF;
    }

    @Override
    public StatusCode getStatus() {
        return this.fV;
    }

    @Override
    public DataValue getValue() {
        DataValue dataValue = this.rJ == null ? new DataValue(this.fV) : new DataValue(new Variant(this.rJ), this.fV);
        dataValue.setServerTimestamp(this.rK);
        dataValue.setSourceTimestamp(this.rF);
        dataValue.setSourcePicoseconds(this.rL);
        return dataValue;
    }

    public Class<?> getValueClass() {
        return this.rJ.getClass();
    }

    public boolean setCurrentValue(T t2) {
        return this.setCurrentValue(t2, DateTime.currentTime());
    }

    public boolean setCurrentValue(T t2, DateTime dateTime) {
        return this.setCurrentValue(t2, StatusCode.GOOD, dateTime, null);
    }

    public boolean setCurrentValue(T t2, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) {
        boolean bl = !Objects.equals(t2, this.getCurrentValue());
        try {
            this.updateValue(t2, statusCode, dateTime, unsignedShort);
            if (bl) {
                if (NodeId.isNull(this.getDataTypeId())) {
                    Structure[] structureArray;
                    Class<Structure[]> clazz;
                    DataValue dataValue;
                    if (t2 instanceof Structure) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(((Structure)t2).getTypeId()));
                    } else if (t2.getClass().isArray() && !(dataValue = this.getValue()).isNull() && (clazz = dataValue.getValue().getCompositeClass()).isAssignableFrom(Structure[].class) && (structureArray = (Structure[])dataValue.getValue().getValue()).length > 0) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(structureArray[0].getTypeId()));
                    }
                }
                if (this.getValueRank() == -2) {
                    if (t2.getClass().isArray()) {
                        this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                        this.setValueRank(0);
                    } else {
                        this.setValueRank(-1);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return bl;
    }

    @Override
    public void setStatus(StatusCode statusCode) {
        this.fV = statusCode;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            this.rJ = null;
            this.rF = null;
            this.rK = DateTime.currentTime();
        } else {
            this.rJ = dataValue.isNull() ? null : dataValue.getValue().getValue();
            this.fV = dataValue.getStatusCode();
            this.rF = dataValue.getSourceTimestamp();
            this.rL = dataValue.getSourcePicoseconds();
            this.rK = dataValue.getServerTimestamp();
            if (this.rK == null) {
                this.rK = DateTime.currentTime();
            }
        }
    }

    @Override
    protected void updateValue(Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        super.updateValue(object, statusCode, dateTime, unsignedShort);
    }
}

