/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.GeneratedNode;
import com.prosysopc.ua.server.GeneratedNodes;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.CacheVariable;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeneratedVariableNode
extends CacheVariable
implements GeneratedNode {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGeneratedVariableNode.class);

    public AbstractGeneratedVariableNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    protected AbstractGeneratedVariableNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public QualifiedName getQualifiedName(String string, String string2) {
        return GeneratedNodes.getQualifiedName(this, string, string2);
    }

    protected void callAfterCreateIfExists(UaNode uaNode) {
        if (uaNode instanceof GeneratedNode) {
            ((GeneratedNode)uaNode).afterCreate();
        }
    }

    @Override
    protected ExpandedNodeId getDefaultTypeDefinition() {
        try {
            return AnnotationUtils.readTypeDefinitionId(this.getClass());
        }
        catch (AnnotationException annotationException) {
            return super.getDefaultTypeDefinition();
        }
    }

    protected Enumeration getEnumerationFromRawValue(UaVariable uaVariable) {
        Variant variant = uaVariable.getValue().getValue();
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        try {
            int n2 = variant.intValue();
            NodeId nodeId = uaVariable.getDataTypeId();
            NamespaceTable namespaceTable = this.getAddressSpace().getNamespaceTable();
            EnumerationSpecification enumerationSpecification = this.getNodeManager().getServer().getEncoderContext().getEnumerationSpecification(UaNodeId.fromLocal(nodeId, namespaceTable));
            if (enumerationSpecification != null) {
                return enumerationSpecification.getByValue(n2);
            }
            return DynamicEnumeration.valueOf(n2);
        }
        catch (Exception exception) {
            logger.error("Could not resolve Variant {} to Enumeration", (Object)variant, (Object)exception);
            return null;
        }
    }
}

