/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.RelativeNamePath;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.instantiation.b;
import com.prosysopc.ua.server.instantiation.h;
import com.prosysopc.ua.server.instantiation.k;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TemporaryInstanceDeclaration {
    private final Set<RelativeNamePath> qO;
    private final Set<b> qP;
    private final Set<h> rh;
    private final UaNode node;
    private final List<UaNode> nodes;
    private final NodeId nodeId;

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        return new Builder(temporaryInstanceDeclaration);
    }

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, RelativeNamePath relativeNamePath) {
        return new Builder(temporaryInstanceDeclaration, relativeNamePath);
    }

    public static Builder builder(UaNode uaNode, RelativeNamePath relativeNamePath) {
        return new Builder(uaNode, relativeNamePath);
    }

    public static Builder builder(UaType uaType) {
        return TemporaryInstanceDeclaration.builder(uaType, RelativeNamePath.EMPTY);
    }

    private TemporaryInstanceDeclaration(UaNode uaNode, List<UaNode> list, LinkedHashSet<RelativeNamePath> linkedHashSet, LinkedHashSet<b> linkedHashSet2, LinkedHashSet<h> linkedHashSet3) {
        this.node = uaNode;
        this.nodeId = uaNode.getNodeId();
        this.nodes = Collections.unmodifiableList(new ArrayList<UaNode>(list));
        this.qO = Collections.unmodifiableSet(linkedHashSet);
        this.qP = Collections.unmodifiableSet(linkedHashSet2);
        this.rh = Collections.unmodifiableSet(linkedHashSet3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TemporaryInstanceDeclaration temporaryInstanceDeclaration = (TemporaryInstanceDeclaration)object;
        if (this.qO == null ? temporaryInstanceDeclaration.qO != null : !this.qO.equals(temporaryInstanceDeclaration.qO)) {
            return false;
        }
        if (this.qP == null ? temporaryInstanceDeclaration.qP != null : !this.qP.equals(temporaryInstanceDeclaration.qP)) {
            return false;
        }
        if (this.rh == null ? temporaryInstanceDeclaration.rh != null : !this.rh.equals(temporaryInstanceDeclaration.rh)) {
            return false;
        }
        return !(this.nodeId == null ? temporaryInstanceDeclaration.nodeId != null : !this.nodeId.equals(temporaryInstanceDeclaration.nodeId));
    }

    public Set<RelativeNamePath> getBrowsePaths() {
        return this.qO;
    }

    public Set<b> getExternalReferences() {
        return this.qP;
    }

    public Set<h> getInternalReferences() {
        return this.rh;
    }

    public UaNode getNode() {
        return this.node;
    }

    public List<UaNode> getNodes() {
        return this.nodes;
    }

    public RelativeNamePath getPrimaryPath() {
        return this.qO.iterator().next();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.qO == null ? 0 : this.qO.hashCode());
        n3 = 31 * n3 + (this.qP == null ? 0 : this.qP.hashCode());
        n3 = 31 * n3 + (this.rh == null ? 0 : this.rh.hashCode());
        n3 = 31 * n3 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n3;
    }

    public boolean hasPath(RelativeNamePath relativeNamePath) {
        return this.qO.contains(relativeNamePath);
    }

    public boolean isRoot() {
        return this.qO.size() == 1 && this.getPrimaryPath().isEmpty();
    }

    public String toString() {
        return "Paths=" + this.qO;
    }

    TemporaryInstanceDeclaration b(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        Builder builder = TemporaryInstanceDeclaration.builder(this);
        builder.nodes.addAll(temporaryInstanceDeclaration.nodes);
        builder.addBrowsePath(temporaryInstanceDeclaration.qO);
        builder.addExternalReference(temporaryInstanceDeclaration.qP);
        builder.addInternalReference(temporaryInstanceDeclaration.rh);
        return builder.build();
    }

    public static class Builder {
        private final LinkedHashSet<RelativeNamePath> ri = new LinkedHashSet();
        private final LinkedHashSet<b> rj = new LinkedHashSet();
        private final LinkedHashSet<h> rk = new LinkedHashSet();
        private final UaNode node;
        private final List<UaNode> nodes = new ArrayList<UaNode>();

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
            this.node = temporaryInstanceDeclaration.node;
            this.nodes.add(this.node);
            this.ri.addAll(temporaryInstanceDeclaration.qO);
            this.rj.addAll(temporaryInstanceDeclaration.qP);
            this.rk.addAll(temporaryInstanceDeclaration.rh);
        }

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, RelativeNamePath relativeNamePath) {
            this.node = temporaryInstanceDeclaration.node;
            this.nodes.add(this.node);
            for (Comparable<RelativeNamePath> comparable : temporaryInstanceDeclaration.qO) {
                this.ri.add(relativeNamePath.append((RelativeNamePath)comparable));
            }
            this.rj.addAll(temporaryInstanceDeclaration.qP);
            for (Comparable<RelativeNamePath> comparable : temporaryInstanceDeclaration.rh) {
                this.rk.add(new h(((k)comparable).getReferenceType(), relativeNamePath.append(((h)comparable).cnA())));
            }
        }

        private Builder(UaNode uaNode, RelativeNamePath relativeNamePath) {
            this.node = uaNode;
            this.nodes.add(uaNode);
            this.ri.add(relativeNamePath);
        }

        public void addBrowsePath(Collection<? extends RelativeNamePath> collection) {
            this.ri.addAll(collection);
        }

        public void addBrowsePath(RelativeNamePath relativeNamePath) {
            this.ri.add(relativeNamePath);
        }

        public void addExternalReference(Collection<? extends b> collection) {
            this.rj.addAll(collection);
        }

        public void addExternalReference(b b2) {
            this.rj.add(b2);
        }

        public void addInternalReference(Collection<? extends h> collection) {
            this.rk.addAll(collection);
        }

        public void addInternalReference(h h2) {
            this.rk.add(h2);
        }

        public TemporaryInstanceDeclaration build() {
            return new TemporaryInstanceDeclaration(this.node, this.nodes, this.ri, this.rj, this.rk);
        }

        public UaNode getNode() {
            return this.node;
        }

        public RelativeNamePath getPrimaryPath() {
            return (RelativeNamePath)this.ri.iterator().next();
        }
    }
}

