/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.DiagnosticsManager;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionManagerAdapter;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManagerListener;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AggregateFilter;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.ContentFilterResult;
import com.prosysopc.ua.stack.core.CreateSubscriptionRequest;
import com.prosysopc.ua.stack.core.DataChangeFilter;
import com.prosysopc.ua.stack.core.DataChangeNotification;
import com.prosysopc.ua.stack.core.DeadbandType;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.ModifySubscriptionRequest;
import com.prosysopc.ua.stack.core.MonitoredItemCreateRequest;
import com.prosysopc.ua.stack.core.MonitoredItemModifyRequest;
import com.prosysopc.ua.stack.core.MonitoredItemNotification;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.NotificationMessage;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.RepublishRequest;
import com.prosysopc.ua.stack.core.RepublishResponse;
import com.prosysopc.ua.stack.core.SetTriggeringRequest;
import com.prosysopc.ua.stack.core.SetTriggeringResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionAcknowledgement;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final int oN = 10000;
    private static final int oO = 3600000;
    private static final int oP = 100;
    private static final int oQ = 10;
    private static final double oR = 3600000.0;
    private static final int oS = Integer.MAX_VALUE;
    private static final int oT = 100;
    private static final double oU = 1.0;
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionManager.class);
    private static final long oV = (long)Math.floor(UnsignedInteger.MAX_VALUE.doubleValue() / 3.0);
    private final AtomicReference<UnsignedInteger> oW;
    private int maxNotificationsPerPublish = 50000;
    private double oX = 3600000.0;
    private int oY = 100;
    private int oZ = 10;
    private double pa = 3600000.0;
    private int pb = 10000;
    private int pc = Integer.MAX_VALUE;
    private double pd = 100.0;
    private double pe = 1.0;
    private final a<SubscriptionBase> pf = new a(Session.INTERNAL_SESSION);
    private final ConcurrentHashMap<NodeId, a<SubscriptionBase>> pg = new ConcurrentHashMap();
    private volatile boolean nD = false;
    private final SessionManagerListener sessionManagerListener = new SessionManagerAdapter(){

        @Override
        public void onCloseSession(Session session, boolean bl) {
            logger.debug("sessionClose: {}", (Object)session);
            SubscriptionManager.this.a(session, null);
            for (Subscription subscription : SubscriptionManager.this.ph.values()) {
                if (!session.equals(subscription.getSession())) continue;
                subscription.setPublishQueue(null, true);
                if (!bl) continue;
                try {
                    SubscriptionManager.this.removeSubscription(ServiceContext.INTERNAL_OPERATION_CONTEXT, subscription, false);
                }
                catch (ServiceException serviceException) {
                    logger.debug("sessionClose(" + session + ")", (Throwable)serviceException);
                }
            }
        }
    };
    private final Map<UnsignedInteger, Subscription> ph = new ConcurrentHashMap<UnsignedInteger, Subscription>();
    protected final List<SubscriptionManagerListener> listeners = new CopyOnWriteArrayList<SubscriptionManagerListener>();
    protected final NodeManagerTable nodeManagerTable;
    protected final SessionManager sessionManager;
    private boolean pi = false;
    private boolean pj = false;

    private static String a(String string, DateTime dateTime, UnsignedShort unsignedShort) {
        if (dateTime != null && !dateTime.equals(DateTime.MIN_VALUE)) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.systemDefault());
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(dateTimeFormatter.format(dateTime.toInstant()));
            if (unsignedShort != null && !unsignedShort.equals(UnsignedShort.valueOf(0))) {
                stringBuilder.append(String.format(Locale.ROOT, "/%d picos", unsignedShort.getValue()));
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public SubscriptionManager(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        this.sessionManager = sessionManager;
        this.nodeManagerTable = nodeManagerTable;
        long l2 = Instant.now().getEpochSecond();
        long l3 = l2 % 0xFFFFFFFFL;
        this.oW = new AtomicReference<UnsignedInteger>(UnsignedInteger.valueOf(++l3));
        sessionManager.addListener(this.sessionManagerListener);
    }

    public void addListener(SubscriptionManagerListener subscriptionManagerListener) {
        if (!this.hasListener(subscriptionManagerListener)) {
            this.listeners.add(subscriptionManagerListener);
        }
    }

    public int getMaxMonitoredItemsPerSubscription() {
        return this.pb;
    }

    public int getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public double getMaxPublishingInterval() {
        return this.oX;
    }

    public int getMaxPublishRequestCount() {
        return this.oY > 0 ? this.oY : 100;
    }

    public int getMaxRetransmissionQueueSize() {
        return this.oZ;
    }

    public double getMaxSamplingInterval() {
        return this.pa;
    }

    public int getMaxSubscriptionCount() {
        return this.pc;
    }

    public double getMinPublishingInterval() {
        return this.pd;
    }

    public double getMinSamplingInterval() {
        return this.pe;
    }

    public UnsignedInteger getNextSubscriptionId() {
        return this.oW.get();
    }

    public NodeManagerTable getNodeManagerTable() {
        return this.nodeManagerTable;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Subscription getSubscription(UnsignedInteger unsignedInteger) throws ServiceException {
        if (unsignedInteger == null || unsignedInteger.equals(UnsignedInteger.ZERO)) {
            logger.debug("SubscriptionId {} not found:", (Object)unsignedInteger);
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
        Subscription subscription = this.ph.get(unsignedInteger);
        if (subscription == null) {
            logger.debug("SubscriptionId {} not found:", (Object)unsignedInteger);
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
        return subscription;
    }

    public int getSubscriptionCount() {
        return this.ph.size();
    }

    public Collection<Subscription> getSubscriptions() {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        arrayList.addAll(this.ph.values());
        return Collections.unmodifiableList(arrayList);
    }

    public boolean hasListener(SubscriptionManagerListener subscriptionManagerListener) {
        if (subscriptionManagerListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.listeners.contains(subscriptionManagerListener);
    }

    public boolean isImmediatePublishing() {
        return this.pi;
    }

    public boolean isRunning() {
        return this.nD;
    }

    public boolean isTrackModelChanges() {
        return this.pj;
    }

    public void removeListener(SubscriptionManagerListener subscriptionManagerListener) {
        this.listeners.remove(subscriptionManagerListener);
    }

    public void setImmediatePublishing(boolean bl) {
        this.pi = bl;
    }

    public void setMaxMonitoredItemsPerSubscription(int n2) {
        this.pb = n2;
        this.getSessionManager().getServer().updateServerCapabilities();
    }

    public void setMaxNotificationsPerPublish(int n2) {
        this.maxNotificationsPerPublish = n2;
    }

    public void setMaxPublishingInterval(double d2) {
        this.oX = d2;
    }

    public void setMaxPublishRequestCount(int n2) {
        this.oY = n2;
    }

    public void setMaxRetransmissionQueueSize(int n2) {
        this.oZ = n2;
    }

    public void setMaxSamplingInterval(double d2) {
        this.pa = d2;
    }

    public void setMaxSubscriptionCount(int n2) {
        this.pc = n2;
        this.getSessionManager().getServer().updateServerCapabilities();
    }

    public void setMinPublishingInterval(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("minPublishingInterval must be greater than 0");
        }
        this.pd = d2;
    }

    public void setMinSamplingInterval(double d2) {
        this.pe = d2;
        this.getSessionManager().getServer().updateServerCapabilities();
    }

    public void setNextSubscriptionId(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null || UnsignedInteger.ZERO.equals(unsignedInteger)) {
            unsignedInteger = UnsignedInteger.ONE;
        }
        this.oW.set(unsignedInteger);
    }

    public void setTrackModelChanges(boolean bl) {
        this.pj = bl;
    }

    private UnsignedInteger a(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        if (unsignedInteger.longValue() < 3L * unsignedInteger2.longValue()) {
            return UnsignedInteger.valueOf(3L * unsignedInteger2.longValue());
        }
        return unsignedInteger;
    }

    private UnsignedInteger i(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.longValue() <= 0L) {
            return UnsignedInteger.valueOf(1L);
        }
        if (unsignedInteger.longValue() > oV) {
            return UnsignedInteger.valueOf(oV);
        }
        return unsignedInteger;
    }

    private double b(Double d2) {
        if (d2.equals(Double.NaN)) {
            return this.getMinPublishingInterval();
        }
        if (d2.equals(0.0)) {
            return this.getMinPublishingInterval();
        }
        if (d2 < this.getMinPublishingInterval()) {
            return this.getMinPublishingInterval();
        }
        if (d2 > this.getMaxPublishingInterval()) {
            return this.getMaxPublishingInterval();
        }
        return d2;
    }

    private String g(DataValue dataValue) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Status: ");
        stringBuilder.append(dataValue.getStatusCode());
        if (dataValue.getStatusCode().isNotBad()) {
            stringBuilder.append(" | Value: ");
            if (dataValue.isNull()) {
                stringBuilder.append("NULL");
            } else {
                Variant variant = dataValue.getValue();
                stringBuilder.append("(" + variant.getCompositeClass() + ")");
                Object object = dataValue.getValue().getValue();
                if (dataValue.getValue().isArray()) {
                    stringBuilder.append(MultiDimensionArrayUtils.toString(object));
                } else {
                    stringBuilder.append(object);
                }
            }
        }
        stringBuilder.append(SubscriptionManager.a(" | ServerTimestamp: ", dataValue.getServerTimestamp(), dataValue.getServerPicoseconds()));
        stringBuilder.append(SubscriptionManager.a(" | SourceTimestamp: ", dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds()));
        return stringBuilder.toString();
    }

    private MonitoringFilter a(MonitoringParameters monitoringParameters) throws StatusException {
        MonitoringFilter monitoringFilter = null;
        try {
            monitoringFilter = monitoringParameters.getFilter() == null ? null : (MonitoringFilter)monitoringParameters.getFilter().decode(this.nodeManagerTable.getEncoderContext());
        }
        catch (DecodingException decodingException) {
            throw new StatusException(StatusCodes.Bad_MonitoredItemFilterInvalid, (Throwable)decodingException);
        }
        return monitoringFilter;
    }

    private void a(ServiceContext serviceContext, Subscription subscription) throws ServiceException {
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAddSubscription(serviceContext, subscription);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAddSubscription", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        if (monitoredItem instanceof MonitoredEventItem) {
            this.nodeManagerTable.afterCreateMonitoredEventItem(serviceContext, subscription, (MonitoredEventItem)monitoredItem);
        } else {
            this.nodeManagerTable.afterCreateMonitoredDataItem(serviceContext, subscription, (MonitoredDataItem)monitoredItem);
        }
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterCreateMonitoredItem(serviceContext, subscription, monitoredItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void fireAfterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.nodeManagerTable.afterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void fireAfterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.nodeManagerTable.afterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterModifyMonitoredItem(serviceContext, subscription, monitoredDataItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.nodeManagerTable.afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterModifyMonitoredItem(serviceContext, subscription, monitoredEventItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        this.nodeManagerTable.createMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onCreateMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onCreateMonitoredDataItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, EventFilter eventFilter, NodeId nodeId, EventFilterResult eventFilterResult) throws StatusException {
        this.nodeManagerTable.createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onCreateMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onCreateMonitoredEventItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void fireDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.nodeManagerTable.deleteMonitoredItem(serviceContext, subscription, monitoredItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onDeleteMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.nodeManagerTable.modifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onModifyMonitoredDataItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.nodeManagerTable.modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onModifyMonitoredEventItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void b(ServiceContext serviceContext, Subscription subscription) {
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onModifySubscription(serviceContext, subscription);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterModifySubscription", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void c(ServiceContext serviceContext, Subscription subscription) throws ServiceException {
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onRemoveSubscription(serviceContext, subscription);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onRemoveSubscription", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private DiagnosticsManager getDiagnosticsManager() {
        return this.getSessionManager().getServer().getDiagnosticsManager();
    }

    private void a(Subscription subscription, Session session, boolean bl) {
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue(session);
        subscription.setPublishQueue(blockingQueue, bl);
    }

    private void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, (Throwable)runtimeException);
        throw runtimeException;
    }

    private void a(ServiceContext serviceContext, Subscription subscription, TimestampsToReturn timestampsToReturn, MonitoringParameters monitoringParameters, MonitoredDataItem monitoredDataItem, MonitoringFilter monitoringFilter) throws StatusException {
        AggregateFilterResult aggregateFilterResult = null;
        if (monitoringFilter instanceof AggregateFilter) {
            aggregateFilterResult = new AggregateFilterResult();
        }
        if (monitoringFilter instanceof DataChangeFilter) {
            this.a(monitoredDataItem.getNodeId(), (DataChangeFilter)monitoringFilter);
        }
        this.a(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
        this.a(monitoredDataItem, monitoringParameters, timestampsToReturn);
        if (monitoringFilter != null) {
            try {
                monitoredDataItem.setFilter(monitoringFilter);
                aggregateFilterResult = (AggregateFilterResult)monitoredDataItem.getFilterResult();
            }
            catch (ServiceException serviceException) {
                throw new StatusException(serviceException.getServiceResult());
            }
            monitoredDataItem.setFilterResult(aggregateFilterResult);
        }
        this.fireAfterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter) throws StatusException {
        try {
            EventFilterResult eventFilterResult = new EventFilterResult();
            eventFilterResult.setSelectClauseResults(new StatusCode[eventFilter.getSelectClauses().length]);
            eventFilterResult.setSelectClauseDiagnosticInfos(new DiagnosticInfo[eventFilter.getSelectClauses().length]);
            eventFilterResult.setWhereClauseResult(new ContentFilterResult());
            this.a(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
            monitoredEventItem.setFilterResult(eventFilterResult);
            monitoredEventItem.setFilter(eventFilter);
            this.a(serviceContext, subscription, monitoredEventItem);
        }
        catch (ClassCastException classCastException) {
            throw new StatusException(classCastException.getMessage(), StatusCodes.Bad_EventFilterInvalid);
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
    }

    private String a(NotificationMessage notificationMessage, UnsignedInteger unsignedInteger) {
        ExtensionObject[] extensionObjectArray = notificationMessage.getNotificationData();
        try {
            DataChangeNotification dataChangeNotification = (DataChangeNotification)extensionObjectArray[0].decode(this.nodeManagerTable.getEncoderContext());
            MonitoredItemNotification monitoredItemNotification = dataChangeNotification.getMonitoredItems()[0];
            DataValue dataValue = monitoredItemNotification.getValue();
            return this.g(dataValue);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void a(Session session, Subscription subscription) {
        logger.debug("removePublishQueue: session={} subscription={}", (Object)session, (Object)subscription);
        Queue queue = this.pg.remove(session.getAuthenticationToken());
        if (queue != null && logger.isDebugEnabled()) {
            logger.debug("removePublishQueue: queue={}", (Object)Arrays.toString(queue.toArray()));
        }
        if (queue != null && queue.isEmpty() && subscription != null) {
            queue.offer(subscription);
        }
    }

    private void a(MonitoredItem monitoredItem, MonitoringParameters monitoringParameters, TimestampsToReturn timestampsToReturn) throws StatusException {
        logger.trace("setMonitoringParameters");
        monitoredItem.setTimestampsToReturn(timestampsToReturn);
        if (monitoringParameters != null) {
            UnsignedInteger unsignedInteger;
            monitoredItem.setClientHandle(monitoringParameters.getClientHandle());
            Boolean bl = monitoringParameters.getDiscardOldest();
            if (bl != null) {
                monitoredItem.setDiscardOldest(bl);
            }
            if (monitoredItem instanceof MonitoredDataItem) {
                this.a((MonitoredDataItem)monitoredItem, monitoringParameters);
            }
            if ((unsignedInteger = monitoringParameters.getQueueSize()) != null) {
                try {
                    monitoredItem.setQueueSize(unsignedInteger);
                }
                catch (ServiceException serviceException) {
                    throw new StatusException(serviceException.getServiceResult());
                }
            }
        }
    }

    private void a(MonitoredItemCreateRequest monitoredItemCreateRequest, MonitoredItem monitoredItem) {
        NodeId nodeId = monitoredItemCreateRequest.getItemToMonitor().getNodeId();
        UaNode uaNode = this.nodeManagerTable.findNode(nodeId);
        if (uaNode != null) {
            monitoredItem.setNode(uaNode);
        }
    }

    private void a(NodeId nodeId, DataChangeFilter dataChangeFilter) throws StatusException {
        Cloneable cloneable;
        DeadbandType deadbandType = DeadbandType.valueOf(dataChangeFilter.getDeadbandType());
        if (deadbandType == null || deadbandType == DeadbandType.None) {
            return;
        }
        try {
            cloneable = new DataValue();
            this.nodeManagerTable.readAttribute(ServiceContext.INTERNAL_OPERATION_CONTEXT, null, nodeId, Attributes.DataType, null, TimestampsToReturn.Neither, DateTime.MIN_VALUE, (DataValue)cloneable);
            NodeId nodeId2 = (NodeId)((DataValue)cloneable).getValue().getValue();
            UaType uaType = (UaType)this.nodeManagerTable.getNode(nodeId2);
            if (uaType == null || !uaType.inheritsFrom(Identifiers.Number)) {
                throw new Exception("DataType does not inherit from Number");
            }
        }
        catch (Exception exception) {
            logger.debug("DataType not Number", (Throwable)exception);
            throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
        }
        if (deadbandType == DeadbandType.Percent) {
            if (dataChangeFilter.getDeadbandValue() < 0.0 || dataChangeFilter.getDeadbandValue() > 100.0) {
                throw new StatusException(StatusCodes.Bad_DeadbandFilterInvalid);
            }
            cloneable = new ArrayList();
            try {
                this.getNodeManagerTable().browseNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, (List<ReferenceDescription>)((Object)cloneable), nodeId, 0, BrowseDirection.Forward, Identifiers.HasProperty, true, new QualifiedName("EURange"), NodeClass.ALL, BrowseResultMask.ALL, null, 0);
                if (cloneable.isEmpty()) {
                    throw new StatusException(StatusCodes.Bad_MonitoredItemFilterUnsupported);
                }
            }
            catch (ServiceException serviceException) {
                throw new StatusException(StatusCodes.Bad_MonitoredItemFilterUnsupported);
            }
        }
    }

    private void a(MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters) {
        Double d2 = monitoringParameters.getSamplingInterval();
        if (d2 != null && d2 >= 0.0) {
            if (d2 < this.getMinSamplingInterval()) {
                d2 = this.getMinSamplingInterval();
            }
            if (d2 > this.getMaxSamplingInterval()) {
                d2 = this.getMaxSamplingInterval();
            }
            monitoredDataItem.setSamplingInterval(d2);
        } else {
            monitoredDataItem.setSamplingInterval(monitoredDataItem.getSubscription().getPublishingInterval());
        }
    }

    protected void acknowledge(ServiceContext serviceContext, PublishRequest publishRequest, PublishResponse publishResponse) {
        SubscriptionAcknowledgement[] subscriptionAcknowledgementArray = publishRequest.getSubscriptionAcknowledgements();
        if (subscriptionAcknowledgementArray != null) {
            StatusCode[] statusCodeArray = new StatusCode[subscriptionAcknowledgementArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[subscriptionAcknowledgementArray.length];
            this.acknowledgeSubscriptions(serviceContext, subscriptionAcknowledgementArray, statusCodeArray, diagnosticInfoArray);
            publishResponse.setResults(statusCodeArray);
            publishResponse.setDiagnosticInfos(diagnosticInfoArray);
        } else {
            publishResponse.setResults(null);
            publishResponse.setDiagnosticInfos(null);
        }
    }

    protected void acknowledgeSubscriptions(ServiceContext serviceContext, SubscriptionAcknowledgement[] subscriptionAcknowledgementArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) {
        logger.debug("acknowledgeSubscriptions length: {}", (Object)subscriptionAcknowledgementArray.length);
        for (int i2 = 0; i2 < subscriptionAcknowledgementArray.length; ++i2) {
            try {
                UnsignedInteger unsignedInteger = subscriptionAcknowledgementArray[i2].getSubscriptionId();
                Subscription subscription = this.getSubscription(unsignedInteger);
                subscription.acknowledge(subscriptionAcknowledgementArray[i2].getSequenceNumber());
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ack error: ", (Throwable)serviceException);
                statusCodeArray[i2] = serviceException.getServiceResult();
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
            }
        }
    }

    protected SubscriptionBase addSubscription(ServiceContext serviceContext, CreateSubscriptionRequest createSubscriptionRequest) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("addSubscription");
        }
        if (serviceContext.getSession().getSubscriptionCount() >= this.getMaxSubscriptionCount()) {
            throw new ServiceException("Max allowed subscriptions = " + this.getMaxSubscriptionCount(), StatusCodes.Bad_TooManySubscriptions);
        }
        double d2 = this.b(createSubscriptionRequest.getRequestedPublishingInterval());
        UnsignedInteger unsignedInteger = this.i(createSubscriptionRequest.getRequestedMaxKeepAliveCount());
        UnsignedInteger unsignedInteger2 = this.a(createSubscriptionRequest.getRequestedLifetimeCount(), unsignedInteger);
        UnsignedInteger unsignedInteger3 = this.nextSubscriptionId();
        while (this.ph.containsKey(unsignedInteger3)) {
            unsignedInteger3 = this.nextSubscriptionId();
        }
        Subscription subscription = this.createSubscription(this, unsignedInteger3, createSubscriptionRequest.getPublishingEnabled(), d2, unsignedInteger2, unsignedInteger, createSubscriptionRequest.getMaxNotificationsPerPublish(), createSubscriptionRequest.getPriority());
        Session session = serviceContext.getSession();
        this.a(serviceContext, subscription);
        subscription.setSession(session);
        this.ph.put(unsignedInteger3, subscription);
        if (logger.isDebugEnabled()) {
            logger.debug("addSubscription: subscription=" + subscription);
        }
        this.a(subscription, session, true);
        this.getDiagnosticsManager().addSubscription(session, subscription);
        return subscription;
    }

    protected void addTriggeringLink(Subscription subscription, MonitoredItemBase monitoredItemBase, UnsignedInteger unsignedInteger) throws StatusException {
        MonitoredItem monitoredItem = (MonitoredItem)subscription.getItem(unsignedInteger);
        ((MonitoredItem)monitoredItemBase).addLink(monitoredItem);
    }

    protected NumericRange checkIndexRangeForMonitoredItem(String string, UnsignedInteger unsignedInteger) throws ServiceException {
        try {
            return NumericRange.parse(string);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    protected void checkSession(ServiceContext serviceContext, Subscription subscription) throws ServiceException {
        if (!subscription.getSession().equals(serviceContext.getSession())) {
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
    }

    protected void close() {
        logger.debug("close");
        for (Subscription subscription : this.ph.values()) {
            subscription.internalClose(false);
        }
        this.nD = false;
    }

    protected MonitoredDataItem createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredItemCreateRequest monitoredItemCreateRequest, TimestampsToReturn timestampsToReturn, MonitoringFilter monitoringFilter) throws ServiceException, StatusException {
        UnsignedInteger unsignedInteger;
        ReadValueId readValueId = monitoredItemCreateRequest.getItemToMonitor();
        NodeId nodeId = readValueId.getNodeId();
        if (logger.isDebugEnabled()) {
            logger.debug("createMonitoredDataItem: " + nodeId);
        }
        if (!AttributesUtil.isValid(unsignedInteger = readValueId.getAttributeId())) {
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
        if (monitoringFilter != null && !unsignedInteger.equals(Attributes.Value)) {
            throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
        }
        if (monitoringFilter instanceof DataChangeFilter) {
            this.a(nodeId, (DataChangeFilter)monitoringFilter);
        }
        QualifiedName qualifiedName = readValueId.getDataEncoding();
        this.a(monitoredItemCreateRequest.getMonitoringMode());
        NumericRange numericRange = this.checkIndexRangeForMonitoredItem(readValueId.getIndexRange(), unsignedInteger);
        MonitoringParameters monitoringParameters = monitoredItemCreateRequest.getRequestedParameters();
        AggregateFilterResult aggregateFilterResult = monitoringFilter instanceof AggregateFilter ? new AggregateFilterResult() : null;
        this.a(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoredItemCreateRequest.getMonitoringMode());
        MonitoredDataItem monitoredDataItem = subscription.addDataItem(serviceContext, nodeId, unsignedInteger, numericRange, qualifiedName, monitoredItemCreateRequest.getMonitoringMode());
        this.a(monitoredItemCreateRequest, monitoredDataItem);
        monitoredDataItem.setFilter(monitoringFilter);
        if (logger.isDebugEnabled()) {
            logger.debug("createMonitoredDataItem: " + monitoredDataItem);
        }
        return monitoredDataItem;
    }

    protected MonitoredItem createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredItemCreateRequest monitoredItemCreateRequest, EventFilter eventFilter) throws StatusException {
        NodeId nodeId = monitoredItemCreateRequest.getItemToMonitor().getNodeId();
        if (logger.isDebugEnabled()) {
            logger.debug("createMonitoredEventItem: " + nodeId);
        }
        EventFilterResult eventFilterResult = new EventFilterResult();
        eventFilterResult.setSelectClauseResults(new StatusCode[eventFilter.getSelectClauses().length]);
        eventFilterResult.setSelectClauseDiagnosticInfos(new DiagnosticInfo[eventFilter.getSelectClauses().length]);
        eventFilterResult.setWhereClauseResult(new ContentFilterResult());
        this.a(serviceContext, subscription, eventFilter, nodeId, eventFilterResult);
        MonitoredEventItem monitoredEventItem = subscription.addEventItem(serviceContext, nodeId, eventFilter, eventFilterResult);
        this.a(monitoredItemCreateRequest, monitoredEventItem);
        return monitoredEventItem;
    }

    protected MonitoredItem createMonitoredItem(ServiceContext serviceContext, Subscription subscription, TimestampsToReturn timestampsToReturn, MonitoredItemCreateRequest monitoredItemCreateRequest) throws StatusException, ServiceException {
        if (subscription.getItemCount() >= this.getMaxMonitoredItemsPerSubscription()) {
            throw new StatusException(StatusCodes.Bad_TooManyMonitoredItems);
        }
        MonitoredItem monitoredItem = null;
        MonitoringParameters monitoringParameters = monitoredItemCreateRequest.getRequestedParameters();
        MonitoringFilter monitoringFilter = this.a(monitoringParameters);
        if (monitoredItemCreateRequest.getItemToMonitor().getAttributeId().equals(Attributes.EventNotifier) && monitoringFilter != null) {
            if (!(monitoringFilter instanceof EventFilter)) {
                throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
            }
            monitoredItem = this.createMonitoredEventItem(serviceContext, subscription, monitoredItemCreateRequest, (EventFilter)monitoringFilter);
        } else {
            if (monitoringFilter instanceof EventFilter) {
                throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
            }
            monitoredItem = this.createMonitoredDataItem(serviceContext, subscription, monitoredItemCreateRequest, timestampsToReturn, monitoringFilter);
        }
        this.a(monitoredItem, monitoringParameters, timestampsToReturn);
        this.a(serviceContext, subscription, monitoredItem);
        if (Session.INTERNAL_SESSION != serviceContext.getSession()) {
            serviceContext.getSession().getSessionDiagnostics().clm().incrementAndGet();
            serviceContext.getSession().updateDiagnostics();
        }
        return monitoredItem;
    }

    protected Subscription createSubscription(SubscriptionManager subscriptionManager, UnsignedInteger unsignedInteger, Boolean bl, double d2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, UnsignedInteger unsignedInteger4, UnsignedByte unsignedByte) {
        return new Subscription(subscriptionManager, unsignedInteger, bl, d2, unsignedInteger2, unsignedInteger3, unsignedInteger4, unsignedByte);
    }

    protected MonitoredItemBase deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("deleteMonitoredItem: " + subscription + " ItemId=" + unsignedInteger);
        }
        MonitoredItem monitoredItem = (MonitoredItem)subscription.getItem(unsignedInteger);
        this.fireDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
        try {
            subscription.internalRemoveItem(monitoredItem);
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
        if (!ServiceContext.INTERNAL_OPERATION_CONTEXT.equals(serviceContext)) {
            serviceContext.getSession().getSessionDiagnostics().clm().decrementAndGet();
            serviceContext.getSession().updateDiagnostics();
        }
        this.fireAfterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
        return monitoredItem;
    }

    protected Subscription getNextSubscriptionToPublish(ServiceContext serviceContext, long l2) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("getNextSubscriptionToPublish: session=" + serviceContext.getSession());
        }
        if (!this.isRunning()) {
            throw new ServiceException(StatusCodes.Bad_NoSubscription);
        }
        Session session = serviceContext.getSession();
        if (!session.isActive()) {
            throw new ServiceException(StatusCodes.Bad_SessionClosed);
        }
        Subscription subscription = session.getTransferredSubscriptions().poll();
        if (subscription != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNextSubscriptionToPublish: transferred=" + subscription);
            }
            return subscription;
        }
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue(session);
        if (logger.isDebugEnabled()) {
            logger.debug("getNextSubscriptionToPublish: queue=" + blockingQueue);
        }
        if (blockingQueue != null) {
            try {
                long l3 = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug("getNextSubscriptionToPublish: subscriptionCount=" + session.getSubscriptionCount());
                }
                if (session.getSubscriptionCount() == 0) {
                    subscription = (Subscription)blockingQueue.poll();
                } else if (l2 > 0L) {
                    subscription = (Subscription)blockingQueue.poll(l2, TimeUnit.MILLISECONDS);
                    if (subscription == null) {
                        throw new ServiceException(StatusCodes.Bad_Timeout);
                    }
                } else {
                    subscription = (Subscription)blockingQueue.take();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("getNextSubscriptionToPublish: subscription=" + subscription + "; dt=" + (System.currentTimeMillis() - l3));
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug("getNextSubscriptionToPublish interrupted", (Throwable)interruptedException);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNextSubscriptionToPublish: " + subscription);
        }
        if (subscription == null) {
            throw new ServiceException(StatusCodes.Bad_NoSubscription);
        }
        return subscription;
    }

    protected BlockingQueue<SubscriptionBase> getPublishQueue(Session session) {
        if (session == null) {
            return null;
        }
        if (Session.INTERNAL_SESSION == session) {
            return this.pf;
        }
        a<SubscriptionBase> a2 = this.pg.get(session.getAuthenticationToken());
        if (a2 == null) {
            a2 = new a(session);
            a<SubscriptionBase> a3 = this.pg.putIfAbsent(session.getAuthenticationToken(), a2);
            if (a3 != null) {
                return a3;
            }
        }
        return a2;
    }

    protected MonitoredItem modifyMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItemModifyRequest monitoredItemModifyRequest, TimestampsToReturn timestampsToReturn, MonitoringParameters monitoringParameters) throws StatusException {
        MonitoredItem monitoredItem = (MonitoredItem)subscription.getItem(monitoredItemModifyRequest.getMonitoredItemId());
        MonitoringFilter monitoringFilter = this.a(monitoringParameters);
        if (monitoredItem instanceof MonitoredEventItem) {
            this.a(serviceContext, subscription, (MonitoredEventItem)monitoredItem, (EventFilter)monitoringFilter);
        } else {
            this.a(serviceContext, subscription, timestampsToReturn, monitoringParameters, (MonitoredDataItem)monitoredItem, monitoringFilter);
        }
        monitoredItem.setServiceContext(serviceContext);
        return monitoredItem;
    }

    protected SubscriptionBase modifySubscription(ServiceContext serviceContext, ModifySubscriptionRequest modifySubscriptionRequest) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("modifySubscription");
        }
        Subscription subscription = this.getSubscription(modifySubscriptionRequest.getSubscriptionId());
        this.checkSession(serviceContext, subscription);
        double d2 = this.b(modifySubscriptionRequest.getRequestedPublishingInterval());
        UnsignedInteger unsignedInteger = this.i(modifySubscriptionRequest.getRequestedMaxKeepAliveCount());
        UnsignedInteger unsignedInteger2 = this.a(modifySubscriptionRequest.getRequestedLifetimeCount(), unsignedInteger);
        subscription.setMaxNotificationsPerPublish(modifySubscriptionRequest.getMaxNotificationsPerPublish());
        subscription.setLifetimeCount(unsignedInteger2);
        subscription.setMaxKeepAliveCount(unsignedInteger);
        subscription.setPublishingInterval(d2);
        subscription.setPriority(modifySubscriptionRequest.getPriority());
        subscription.resetLastAliveTime();
        this.b(serviceContext, subscription);
        subscription.getDiagnostics().cmD().increment();
        subscription.updateDiagnostics();
        return subscription;
    }

    protected UnsignedInteger nextSubscriptionId() {
        return this.oW.getAndUpdate(unsignedInteger -> unsignedInteger.incOrWrapTo(UnsignedInteger.ONE));
    }

    protected void publish(ServiceContext serviceContext, PublishRequest publishRequest, PublishResponse publishResponse) throws ServiceException {
        Subscription subscription;
        if (logger.isTraceEnabled()) {
            logger.debug("publish(session=" + serviceContext.getSession().getSessionName() + "): " + publishRequest);
        } else if (logger.isDebugEnabled()) {
            logger.debug("publish(session=" + serviceContext.getSession().getSessionName() + "): " + publishRequest.getClass().getSimpleName());
        }
        try {
            long l2 = publishRequest.getRequestHeader().getTimeoutHint().getValue();
            subscription = this.getNextSubscriptionToPublish(serviceContext, l2);
            if (logger.isDebugEnabled()) {
                logger.debug("publish: subscription=" + subscription);
            }
        }
        catch (ServiceException serviceException) {
            publishResponse.setSubscriptionId(UnsignedInteger.valueOf(0L));
            logger.debug("ServiceException: ", (Throwable)serviceException);
            throw serviceException;
        }
        NotificationMessage notificationMessage = subscription.getNextNotificationMessage(serviceContext.getSession());
        publishResponse.setSubscriptionId(subscription.getSubscriptionId());
        publishResponse.setAvailableSequenceNumbers(subscription.getAvailableSequenceNumbers());
        if (logger.isDebugEnabled()) {
            logger.debug("publish: Available sequence numbers on Subscription " + subscription.getSubscriptionId() + ": " + Arrays.toString(publishResponse.getAvailableSequenceNumbers()));
        }
        publishResponse.setNotificationMessage(notificationMessage);
        publishResponse.setMoreNotifications(subscription.hasMoreNotifications());
        if (logger.isDebugEnabled()) {
            logger.debug("publish: Notification data: " + publishResponse.getNotificationMessage().getNotificationData());
            logger.debug("publish: MoreNotifications=" + publishResponse.getMoreNotifications());
        }
        publishResponse.setDiagnosticInfos(ServiceHandler.validateOperationalDiagnostics(publishRequest, publishResponse.getDiagnosticInfos()));
        if (logger.isDebugEnabled()) {
            logger.debug("publish: subscriptionId=" + publishResponse.getSubscriptionId() + "; SN=" + publishResponse.getNotificationMessage().getSequenceNumber() + this.a(notificationMessage, publishResponse.getSubscriptionId()));
        }
    }

    protected void removeSubscription(ServiceContext serviceContext, Subscription subscription, boolean bl) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("removeSubscription: subscription=" + subscription);
        }
        Session session = serviceContext.getSession();
        if (serviceContext != ServiceContext.INTERNAL_OPERATION_CONTEXT && !subscription.getSession().equals(session)) {
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
        this.c(serviceContext, subscription);
        this.getDiagnosticsManager().removeSubscription(session, subscription);
        subscription.internalClose(bl);
        this.ph.remove(subscription.getSubscriptionId());
        if (logger.isDebugEnabled()) {
            logger.debug("removeSubscription: subscriptions=" + Arrays.toString(this.ph.keySet().toArray()));
        }
    }

    protected void removeTriggeringLink(SubscriptionBase subscriptionBase, MonitoredItemBase monitoredItemBase, UnsignedInteger unsignedInteger) throws StatusException {
        MonitoredItem monitoredItem = (MonitoredItem)subscriptionBase.getItem(unsignedInteger);
        ((MonitoredItem)monitoredItemBase).removeLink(monitoredItem);
    }

    protected void republish(ServiceContext serviceContext, RepublishRequest republishRequest, RepublishResponse republishResponse) throws ServiceException {
        Subscription subscription = this.getSubscription(republishRequest.getSubscriptionId());
        this.checkSession(serviceContext, subscription);
        subscription.resetLastAliveTime();
        subscription.getDiagnostics().cmO().increment();
        subscription.getDiagnostics().cmN().increment();
        subscription.updateDiagnostics();
        republishResponse.setNotificationMessage(subscription.getNotificationMessage(republishRequest.getRetransmitSequenceNumber()));
        subscription.getDiagnostics().cmM().increment();
        subscription.updateDiagnostics();
    }

    protected void setMonitoringMode(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) throws ServiceException, StatusException {
        this.checkSession(serviceContext, subscription);
        MonitoredItemBase monitoredItemBase = subscription.getItem(unsignedInteger);
        monitoredItemBase.setMonitoringMode(monitoringMode);
        if (monitoredItemBase instanceof MonitoredEventItem) {
            this.a(serviceContext, subscription, (MonitoredEventItem)monitoredItemBase);
        } else {
            this.fireAfterModifyMonitoredDataItem(serviceContext, subscription, (MonitoredDataItem)monitoredItemBase);
        }
    }

    protected void setPublishingMode(ServiceContext serviceContext, UnsignedInteger unsignedInteger, Boolean bl) throws ServiceException, StatusException {
        Subscription subscription = this.getSubscription(unsignedInteger);
        this.checkSession(serviceContext, subscription);
        subscription.setPublishingEnabled(bl);
        subscription.resetLastAliveTime();
    }

    protected void setTriggering(ServiceContext serviceContext, SetTriggeringRequest setTriggeringRequest, SetTriggeringResponse setTriggeringResponse) throws ServiceException {
        MonitoredItemBase monitoredItemBase;
        if (setTriggeringRequest.getLinksToAdd() == null) {
            setTriggeringRequest.setLinksToAdd(new UnsignedInteger[0]);
        }
        if (setTriggeringRequest.getLinksToRemove() == null) {
            setTriggeringRequest.setLinksToRemove(new UnsignedInteger[0]);
        }
        Subscription subscription = this.getSubscription(setTriggeringRequest.getSubscriptionId());
        try {
            monitoredItemBase = subscription.getItem(setTriggeringRequest.getTriggeringItemId());
        }
        catch (StatusException statusException) {
            throw new ServiceException(statusException.getMessage(), statusException.getStatusCode());
        }
        UnsignedInteger[] unsignedIntegerArray = setTriggeringRequest.getLinksToAdd();
        UnsignedInteger[] unsignedIntegerArray2 = setTriggeringRequest.getLinksToRemove();
        if (unsignedIntegerArray.length == 0 && unsignedIntegerArray2.length == 0) {
            throw new ServiceException(StatusCodes.Bad_NothingToDo);
        }
        StatusCode[] statusCodeArray = new StatusCode[unsignedIntegerArray2.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[unsignedIntegerArray2.length];
        for (int i2 = 0; i2 < unsignedIntegerArray2.length; ++i2) {
            try {
                this.removeTriggeringLink(subscription, monitoredItemBase, unsignedIntegerArray2[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("Error while removeTriggeringLink", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        setTriggeringResponse.setRemoveResults(statusCodeArray);
        setTriggeringResponse.setRemoveDiagnosticInfos(ServiceHandler.validateOperationalDiagnostics(setTriggeringRequest, diagnosticInfoArray));
        StatusCode[] statusCodeArray2 = new StatusCode[unsignedIntegerArray.length];
        DiagnosticInfo[] diagnosticInfoArray2 = new DiagnosticInfo[unsignedIntegerArray.length];
        for (int i3 = 0; i3 < unsignedIntegerArray.length; ++i3) {
            try {
                this.addTriggeringLink(subscription, monitoredItemBase, unsignedIntegerArray[i3]);
                statusCodeArray2[i3] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("Error while addTriggeringLink", (Throwable)statusException);
                statusCodeArray2[i3] = statusException.getStatusCode();
                diagnosticInfoArray2[i3] = statusException.getDiagnosticInfo();
            }
        }
        setTriggeringResponse.setAddResults(statusCodeArray2);
        setTriggeringResponse.setAddDiagnosticInfos(ServiceHandler.validateOperationalDiagnostics(setTriggeringRequest, diagnosticInfoArray2));
    }

    protected void start() {
        this.nD = true;
    }

    protected Subscription transferSubscription(ServiceContext serviceContext, UnsignedInteger unsignedInteger, boolean bl) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("transferSubscription: ID=" + unsignedInteger);
            logger.debug("serviceContext=" + serviceContext);
        }
        Session session = serviceContext.getSession();
        if (logger.isDebugEnabled()) {
            logger.debug("session=" + session);
        }
        Subscription subscription = this.getSubscription(unsignedInteger);
        if (logger.isDebugEnabled()) {
            logger.debug("subscription=" + subscription);
            logger.debug("subscription.getSession()=" + subscription.getSession());
            logger.debug("subscription.getSession().getUserIdentity()=" + subscription.getSession().getUserIdentity());
            logger.debug("session.getUserIdentity()=" + session.getUserIdentity());
        }
        if (!subscription.getSession().getUserIdentity().equals(session.getUserIdentity())) {
            throw new ServiceException(StatusCodes.Bad_UserAccessDenied);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("subscription.getSession().getTransferredSubscriptions()=" + subscription.getSession().getTransferredSubscriptions());
        }
        subscription.getSession().getTransferredSubscriptions().add(subscription);
        subscription.setSession(session);
        if (logger.isDebugEnabled()) {
            logger.debug("subscription.getItems()=" + Arrays.toString(subscription.getItems()));
        }
        for (MonitoredItemBase monitoredItemBase : subscription.getItems()) {
            ((MonitoredItem)monitoredItemBase).setServiceContext(serviceContext);
        }
        this.a(subscription, session, bl);
        return subscription;
    }

    void a(MonitoringMode monitoringMode) throws ServiceException {
        if (monitoringMode == null) {
            throw new ServiceException(StatusCodes.Bad_MonitoringModeInvalid);
        }
    }

    void a(ServiceContext serviceContext, Subscription subscription, List<MonitoredItem> list) {
        if (list.isEmpty()) {
            return;
        }
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterCreateMonitoredItems(serviceContext, subscription, list);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterCreateMonitoredItems", subscriptionManagerListener, runtimeException);
            }
        }
    }

    void b(ServiceContext serviceContext, Subscription subscription, List<MonitoredItem> list) {
        if (list.isEmpty()) {
            return;
        }
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterDeleteMonitoredItems(serviceContext, subscription, list);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterDeleteMonitoredItems", subscriptionManagerListener, runtimeException);
            }
        }
    }

    void c(ServiceContext serviceContext, Subscription subscription, List<MonitoredItem> list) throws StatusException {
        if (list.isEmpty()) {
            return;
        }
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onDeleteMonitoredItems(serviceContext, subscription, list);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onDeleteMonitoredItems", subscriptionManagerListener, runtimeException);
            }
        }
    }

    synchronized void a(UaNode uaNode, ModelChangeType ... modelChangeTypeArray) {
        boolean bl;
        UaNode uaNode2;
        if (!this.isTrackModelChanges()) {
            return;
        }
        if (modelChangeTypeArray == null || modelChangeTypeArray.length != 1) {
            return;
        }
        ModelChangeType modelChangeType = modelChangeTypeArray[0];
        NodeId nodeId = uaNode.getNodeId();
        if (ModelChangeType.NodeAdded == modelChangeType) {
            uaNode2 = uaNode;
            bl = false;
        } else if (ModelChangeType.NodeDeleted == modelChangeType) {
            uaNode2 = null;
            bl = true;
        } else {
            return;
        }
        this.getSubscriptions().forEach(subscription -> {
            MonitoredItemBase[] monitoredItemBaseArray = subscription.getItems();
            for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
                MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBaseArray[i2];
                if (!Objects.equals(nodeId, monitoredItem.getNodeId())) continue;
                monitoredItem.setNode(uaNode2);
                if (!bl || !(monitoredItem instanceof MonitoredDataItem)) continue;
                MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItem;
                monitoredDataItem.notifyDataChange(new DataValue(StatusCode.valueOf(StatusCodes.Bad_NodeIdUnknown)));
            }
        });
    }

    private class a<T>
    extends PriorityBlockingQueue<T> {
        private final Session mm;

        public a(Session session) {
            this.mm = session;
        }

        public Session getSession() {
            return this.mm;
        }

        @Override
        public String toString() {
            return "Session=" + this.getSession() + " Elements=" + super.toString();
        }
    }
}

