/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerAdapter;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.SubscriptionDiagnostics;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.DataChangeNotification;
import com.prosysopc.ua.stack.core.EventFieldList;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.EventNotificationList;
import com.prosysopc.ua.stack.core.MonitoredItemNotification;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.NotificationData;
import com.prosysopc.ua.stack.core.NotificationMessage;
import com.prosysopc.ua.stack.core.StatusChangeNotification;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription
extends SubscriptionBase {
    private static int nQ = 15;
    private volatile boolean closed;
    private final AtomicBoolean nR = new AtomicBoolean(true);
    private final AtomicBoolean nS = new AtomicBoolean(true);
    private final AtomicInteger nT = new AtomicInteger(0);
    private final AtomicInteger nU = new AtomicInteger(0);
    private final AtomicReference<DateTime> nV = new AtomicReference<DateTime>(DateTime.currentTime());
    private final AtomicLong nW = new AtomicLong(0L);
    private final AtomicReference<DateTime> nX = new AtomicReference<DateTime>(DateTime.currentTime());
    private final AtomicLong nY = new AtomicLong(0L);
    private volatile MonitoredItemBase nZ;
    private final Logger logger = LoggerFactory.getLogger(Subscription.class);
    private final AtomicLong oa = new AtomicLong(1L);
    private ScheduledExecutorService ob;
    private final AtomicReference<BlockingQueue<SubscriptionBase>> oc = new AtomicReference();
    private ScheduledFuture<?> od;
    private final Map<UnsignedInteger, NotificationMessage> oe = new ConcurrentHashMap<UnsignedInteger, NotificationMessage>();
    private volatile Session mm;
    private final SessionManagerListener sessionManagerListener = new SessionManagerAdapter(){

        @Override
        public void onActivateSessionError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
            this.cmo();
        }

        @Override
        public void onAfterActivateSession(Session session) {
            this.cmo();
        }

        public void cmo() {
            for (MonitoredItemBase monitoredItemBase : Subscription.this.getItems()) {
                if (!(monitoredItemBase instanceof MonitoredDataItem)) continue;
                ((MonitoredDataItem)monitoredItemBase).updateAccessible(Subscription.this.mm);
            }
        }
    };
    private final SubscriptionManager subscriptionManager;
    private final Map<UnsignedInteger, MonitoredItem> of = new ConcurrentHashMap<UnsignedInteger, MonitoredItem>();
    private final SubscriptionDiagnostics og;
    private volatile boolean oh;

    protected static void setPublishTimeCheckAllowedThresholdMS(int n2) {
        nQ = n2;
    }

    public Subscription(SubscriptionManager subscriptionManager, UnsignedInteger unsignedInteger, Boolean bl, Double d2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, UnsignedInteger unsignedInteger4, UnsignedByte unsignedByte) {
        super(unsignedInteger, bl, d2, unsignedInteger2, unsignedInteger3, unsignedInteger4, unsignedByte);
        if (subscriptionManager == null) {
            throw new NullPointerException("subscriptionManager required");
        }
        this.subscriptionManager = subscriptionManager;
        this.og = new SubscriptionDiagnostics(null, unsignedInteger, unsignedByte, d2, unsignedInteger3, unsignedInteger2, unsignedInteger4, bl);
        subscriptionManager.getSessionManager().addListener(this.sessionManagerListener);
    }

    public MonitoredDataItem addDataItem(ServiceContext serviceContext, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, QualifiedName qualifiedName, MonitoringMode monitoringMode) {
        this.logger.trace("addDataItem: SubscriptionID={}", (Object)this.getSubscriptionId());
        if (monitoringMode == null) {
            throw new NullPointerException("monitoringMode");
        }
        if (unsignedInteger.equals(Attributes.EventNotifier)) {
            throw new IllegalArgumentException("addItem called with EventNotifier, use addEventItme instead");
        }
        MonitoredDataItem monitoredDataItem = this.createMonitoredDataItem(serviceContext, this, this.cml(), nodeId, unsignedInteger, numericRange, monitoringMode);
        this.addItem(monitoredDataItem, monitoredDataItem.getMonitoredItemId());
        return monitoredDataItem;
    }

    public MonitoredDataItem addDataItem(ServiceContext serviceContext, UaNode uaNode, UnsignedInteger unsignedInteger, NumericRange numericRange, QualifiedName qualifiedName, MonitoringMode monitoringMode) {
        MonitoredDataItem monitoredDataItem = this.addDataItem(serviceContext, uaNode.getNodeId(), unsignedInteger, numericRange, qualifiedName, monitoringMode);
        monitoredDataItem.setNode(uaNode);
        return monitoredDataItem;
    }

    public MonitoredEventItem addEventItem(ServiceContext serviceContext, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.logger.debug("addEventItem: SubscriptionID={}", (Object)this.getSubscriptionId());
        MonitoredEventItem monitoredEventItem = this.createMonitoredEventItem(serviceContext, this, this.cml(), nodeId, eventFilter, eventFilterResult);
        this.addItem(monitoredEventItem, monitoredEventItem.getMonitoredItemId());
        return monitoredEventItem;
    }

    public void beginNotify() {
        this.nT.incrementAndGet();
    }

    public void close() throws ServiceException {
        this.logger.debug("close");
        if (!this.closed) {
            this.subscriptionManager.getSessionManager().removeListener(this.sessionManagerListener);
            this.subscriptionManager.removeSubscription(ServiceContext.INTERNAL_OPERATION_CONTEXT, this, false);
        }
    }

    @Override
    public int compareTo(SubscriptionBase subscriptionBase) {
        Subscription subscription = (Subscription)subscriptionBase;
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        BlockingQueue<SubscriptionBase> blockingQueue2 = subscription.getPublishQueue();
        if (blockingQueue == null && blockingQueue2 != null) {
            return 1;
        }
        if (blockingQueue != null && blockingQueue2 == null) {
            return -1;
        }
        if (this.cmk() && !subscription.cmk()) {
            return 1;
        }
        if (!this.cmk() && subscription.cmk()) {
            return -1;
        }
        int n2 = super.compareTo(subscriptionBase);
        if (n2 == 0 && subscriptionBase instanceof Subscription) {
            return subscription.cmj().compareTo(this.cmj());
        }
        return n2;
    }

    public void endNotify() {
        int n2 = this.nT.decrementAndGet();
        if (n2 == 0) {
            this.b(false);
        } else if (n2 < 0) {
            throw new RuntimeException("endNotify() called more times than beginNotify()");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SubscriptionBase subscriptionBase = (SubscriptionBase)object;
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        UnsignedInteger unsignedInteger2 = subscriptionBase.getSubscriptionId();
        return !(unsignedInteger == null ? unsignedInteger2 != null : !unsignedInteger.equals(unsignedInteger2));
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        Object[] objectArray = this.oe.keySet().toArray(new UnsignedInteger[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public SubscriptionDiagnostics getDiagnostics() {
        return this.og;
    }

    @Override
    public MonitoredItem getItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        return (MonitoredItem)super.getItem(nodeId, unsignedInteger);
    }

    @Override
    public int getMaxNotificationsPerPublish() {
        int n2 = super.getMaxNotificationsPerPublish();
        try {
            if (n2 == 0 || n2 > this.subscriptionManager.getMaxNotificationsPerPublish()) {
                n2 = this.subscriptionManager.getMaxNotificationsPerPublish();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n2;
    }

    public Session getSession() {
        return this.mm;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public boolean hasExpired() {
        long l2 = DateTime.currentTime().getTimeInMillis() - this.cmi().getTimeInMillis();
        boolean bl = (double)l2 > (double)this.lifetimeCount * this.publishingInterval;
        this.logger.trace("hasExpired: result={} lifetimeCount={} publishingInterval={} elapsed={}", new Object[]{bl, this.lifetimeCount, this.publishingInterval, l2});
        return bl;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        n3 = 31 * n3 + (unsignedInteger == null ? 0 : unsignedInteger.hashCode());
        return n3;
    }

    public Boolean hasMoreNotifications() {
        boolean bl;
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        boolean bl2 = bl = blockingQueue != null && blockingQueue.contains(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("hasMoreNotifications: lastSentItem={}", (Object)this.nZ);
            this.logger.trace("hasMoreNotifications: hasMoreDataChangeNotifications={}", (Object)this.nR.get());
            this.logger.trace("hasMoreNotifications: hasMoreEventNotifications={}", (Object)this.nS.get());
            this.logger.trace("hasMoreNotifications: isInQueue={}", (Object)bl);
        }
        return this.nZ != null || this.nR.get() || this.nS.get() || bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public MonitoredItemBase removeItem(MonitoredItemBase monitoredItemBase) throws ServiceException, StatusException {
        return this.removeItem(monitoredItemBase.getMonitoredItemId());
    }

    @Override
    public MonitoredItemBase removeItem(UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        return this.subscriptionManager.deleteMonitoredItem(ServiceContext.INTERNAL_OPERATION_CONTEXT, this, unsignedInteger);
    }

    public void start() {
        this.logger.debug("start");
        this.startPublishing();
    }

    private List<ExtensionObject> a(List<ExtensionObject> list, NotificationData notificationData, Session session) {
        if (list == null) {
            list = new ArrayList<ExtensionObject>();
        }
        try {
            List<Locale> list2 = Collections.emptyList();
            if (session != null) {
                list2 = session.getLocales();
            }
            list.add(ExtensionObject.binaryEncode(notificationData, this.getSubscriptionManager().getNodeManagerTable().getServer().getEncoderContext(), list2));
        }
        catch (EncodingException encodingException) {
            this.logger.error("EncodingException: ", (Throwable)encodingException);
        }
        catch (NullPointerException nullPointerException) {
            this.logger.error("Invalid session: {}", (Object)session);
        }
        return list;
    }

    private void a(NotificationMessage notificationMessage) {
        if (!this.isClosed()) {
            this.oe.put(notificationMessage.getSequenceNumber(), notificationMessage);
            int n2 = this.subscriptionManager.getMaxRetransmissionQueueSize();
            while (this.oe.size() > n2) {
                this.oe.remove(Collections.min(this.oe.keySet()));
                this.og.cmv().increment();
            }
            this.og.cmU().reset();
            this.og.cmU().add(this.oe.size());
            this.updateDiagnostics();
        }
    }

    private void cme() {
        this.b(true);
    }

    private void b(boolean bl) {
        long l2 = this.cmh();
        if (this.nY.get() != 0L && this.isTimeToPublish(l2)) {
            this.addToPublishQueue(l2, false, bl);
        }
    }

    private DataChangeNotification cmf() {
        this.logger.trace("getDataChangeNotification");
        DataChangeNotification dataChangeNotification = new DataChangeNotification();
        ArrayList<MonitoredItemNotification> arrayList = new ArrayList<MonitoredItemNotification>();
        boolean bl = false;
        this.oh = false;
        int n2 = this.getMaxNotificationsPerPublish();
        MonitoredItemBase monitoredItemBase = null;
        while (!this.items.isEmpty()) {
            this.nR.set(false);
            for (MonitoredItemBase monitoredItemBase2 : this.items.values()) {
                if (this.nZ != null) {
                    if (monitoredItemBase2 != this.nZ) continue;
                    this.nZ = null;
                    continue;
                }
                this.nZ = null;
                if (!(monitoredItemBase2 instanceof MonitoredDataItem)) continue;
                MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItemBase2;
                if (bl) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("getDataChangeNotification: monitoredItemId={} hasMoreSamples={}", (Object)monitoredItemBase2.getMonitoredItemId(), (Object)monitoredDataItem.hasMoreSamples());
                    }
                    if (!monitoredDataItem.hasMoreSamples()) continue;
                    this.nZ = monitoredItemBase;
                    break;
                }
                DataValue dataValue = monitoredDataItem.getNextSample(this.of.containsKey(monitoredDataItem.getMonitoredItemId()));
                this.logger.debug("getDataChangeNotification: dataItem.MonitoredItemId={} nodeId={} value={}", new Object[]{monitoredDataItem.getMonitoredItemId(), monitoredDataItem.getNodeId(), dataValue});
                this.logger.debug("getDataChangeNotification: hasMoreSamples={}", (Object)monitoredDataItem.hasMoreSamples());
                if (!monitoredDataItem.hasMoreSamples()) {
                    this.of.remove(monitoredDataItem.getMonitoredItemId());
                }
                if (dataValue == MonitoredDataItem.DELAY_SAMPLE) {
                    this.oh = true;
                    continue;
                }
                if (dataValue == null) continue;
                arrayList.add(new MonitoredItemNotification(monitoredItemBase2.getClientHandle(), dataValue));
                if (monitoredDataItem.hasMoreSamples()) {
                    this.nR.set(true);
                }
                if (n2 <= 0 || arrayList.size() < n2) continue;
                bl = true;
                monitoredItemBase = monitoredItemBase2;
                this.logger.debug("isFull");
            }
            if (this.nR.get() && !bl) continue;
        }
        this.logger.debug("getDataChangeNotification: notifications.size()={}", (Object)arrayList.size());
        dataChangeNotification.setMonitoredItems(arrayList.toArray(new MonitoredItemNotification[arrayList.size()]));
        return dataChangeNotification;
    }

    private EventNotificationList cmg() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getEventNotifications");
        }
        ArrayList<EventFieldList> arrayList = new ArrayList<EventFieldList>();
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            ((MonitoredEventItem)monitoredItemBase).getEvents(arrayList);
        }
        return new EventNotificationList(arrayList.toArray(new EventFieldList[0]));
    }

    private long cmh() {
        return System.currentTimeMillis();
    }

    private DateTime cmi() {
        return this.nV.get();
    }

    private DateTime cmj() {
        return this.nX.get();
    }

    private boolean cmk() {
        return (double)DateTime.currentTime().getTimeInMillis() > (double)this.cmj().getTimeInMillis() + (double)this.getMaxKeepAliveCount() * this.publishingInterval;
    }

    private UnsignedInteger cml() {
        return UnsignedInteger.valueOf(this.nW.incrementAndGet());
    }

    private void removeAllItems() {
        for (Map.Entry entry : this.items.entrySet()) {
            MonitoredItemBase monitoredItemBase = (MonitoredItemBase)entry.getValue();
            try {
                this.removeItem(monitoredItemBase);
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Exception while removing all items: item=" + monitoredItemBase.getMonitoredItemId() + " of subscription " + this.getSubscriptionId() + " of session " + this.getSession() + ". Exception=" + exception.getMessage());
            }
        }
    }

    private void cmm() {
        for (MonitoredItemBase monitoredItemBase : this.getItems()) {
            MonitoredDataItem monitoredDataItem;
            if (!(monitoredItemBase instanceof MonitoredDataItem) || (monitoredDataItem = (MonitoredDataItem)monitoredItemBase).hasMoreSamples()) continue;
            monitoredDataItem.addNewSample(monitoredDataItem.getLastValue(), false);
        }
    }

    private void cmn() {
        for (MonitoredItemBase monitoredItemBase : this.getItems()) {
            if (monitoredItemBase instanceof MonitoredDataItem) {
                ((MonitoredDataItem)monitoredItemBase).updateQueue();
                continue;
            }
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            ((MonitoredEventItem)monitoredItemBase).updateQueue();
        }
    }

    protected void acknowledge(UnsignedInteger unsignedInteger) throws ServiceException {
        if (this.oe.remove(unsignedInteger) == null) {
            this.logger.info("Acknowledge on Subscription " + this.getSubscriptionId() + ": " + unsignedInteger + " - Bad_SequenceNumberUnknown");
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo();
            diagnosticInfo.setAdditionalInfo(unsignedInteger.toString());
            throw new ServiceException("Cannot acknowledge", StatusCodes.Bad_SequenceNumberUnknown, diagnosticInfo, null);
        }
        this.og.cmU().reset();
        this.og.cmU().add(this.oe.size());
        this.updateDiagnostics();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Acknowledged on Subscription " + this.getSubscriptionId() + ": " + unsignedInteger);
            this.logger.debug("Available sequence numbers on Subscription " + this.getSubscriptionId() + ": " + Arrays.toString(this.oe.keySet().toArray()));
        }
    }

    protected void addToPublishQueue(long l2, boolean bl, boolean bl2) {
        int n2;
        if (bl2 && !bl && (n2 = this.nT.get()) != 0) {
            return;
        }
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        this.logger.debug("addToPublishQueue: subscriptionId={} queue={}", (Object)this.getSubscriptionId(), blockingQueue);
        if (blockingQueue != null) {
            this.nR.set(false);
            this.nS.set(false);
            if (bl) {
                blockingQueue.remove(this);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Needs keepalive = true");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Needs keepalive = false");
            }
            if (!blockingQueue.contains(this)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("addToPublishQueue: q.offer()");
                }
                blockingQueue.offer(this);
            }
            if (l2 > 0L) {
                this.nY.set(l2);
            }
            this.resetKeepAliveCounter();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("addToPublishQueue done. queue=" + blockingQueue);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("addToPublishQueue: queue=null");
        }
    }

    protected MonitoredDataItem createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, NodeId nodeId, UnsignedInteger unsignedInteger2, NumericRange numericRange, MonitoringMode monitoringMode) {
        return new MonitoredDataItem(serviceContext, subscription, unsignedInteger, nodeId, unsignedInteger2, numericRange, monitoringMode);
    }

    protected MonitoredEventItem createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        return new MonitoredEventItem(serviceContext, subscription, unsignedInteger, nodeId, eventFilter, eventFilterResult);
    }

    @Override
    protected void enabledChanged() throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("enabledChanged:" + Boolean.toString(this.isPublishingEnabled()));
        }
        if (this.isPublishingEnabled() && this.mm != null) {
            this.cmn();
            this.cmm();
            this.cme();
            this.startPublishing();
        }
        this.og.cmJ().set(this.isPublishingEnabled());
        this.updateDiagnostics();
    }

    protected NotificationMessage getNextNotificationMessage(Session session) {
        AbstractStructure abstractStructure;
        Object object;
        Session session2 = this.getSession();
        this.logger.debug("getNextNotificationMessage: session={}", (Object)session);
        this.logger.debug("getNextNotificationMessage: getSession()={}", (Object)session2);
        boolean bl = true;
        List<ExtensionObject> list = null;
        if (session2 != null && !session2.equals(session)) {
            object = new StatusChangeNotification();
            ((StatusChangeNotification)object).setStatus(StatusCode.valueOf(StatusCodes.Good_SubscriptionTransferred));
            this.logger.debug("getNextNotificationMessage: transferNotification={}", object);
            list = this.a(list, (NotificationData)object, session2);
        } else {
            if (this.hasExpired()) {
                object = new StatusChangeNotification();
                ((StatusChangeNotification)object).setStatus(StatusCode.valueOf(StatusCodes.Bad_Timeout));
                this.logger.debug("getNextNotificationMessage: timeoutNotification={}", object);
                list = this.a(list, (NotificationData)object, session);
                try {
                    this.close();
                }
                catch (ServiceException serviceException) {
                    this.logger.error("ServiceException: ", (Throwable)serviceException);
                }
            }
            if (this.isPublishingEnabled()) {
                object = this.cmf();
                this.logger.debug("DataChangeNotification: ", object);
                abstractStructure = this.cmg();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("getNextNotificationMessage: dataChangeNotification.getMonitoredItems().length=" + ((DataChangeNotification)object).getMonitoredItems().length + " " + (this.nZ == null ? "null" : this.nZ.getMonitoredItemId()));
                }
                if (((DataChangeNotification)object).getMonitoredItems().length > 0) {
                    list = this.a(list, (NotificationData)object, session);
                    bl = false;
                    this.og.cms().add(((DataChangeNotification)object).getMonitoredItems().length);
                    this.updateDiagnostics();
                }
                this.logger.debug("getNextNotificationMessage: eventNotification.getEvents().length={}", (Object)((EventNotificationList)abstractStructure).getEvents().length);
                if (((EventNotificationList)abstractStructure).getEvents().length > 0) {
                    list = this.a(list, (NotificationData)abstractStructure, session);
                    bl = false;
                }
            }
        }
        object = DateTime.currentTime();
        if (list != null) {
            this.og.cmH().add(list.size());
        }
        abstractStructure = new NotificationMessage(this.getNextSequenceNumber(bl), (DateTime)object, list == null ? null : list.toArray(new ExtensionObject[list.size()]));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getNextNotificationMessage: isKeepaliveMessage=" + bl);
        }
        if (!bl) {
            this.a((NotificationMessage)abstractStructure);
        }
        this.nX.set((DateTime)object);
        this.nV.set((DateTime)object);
        if (this.hasMoreNotifications().booleanValue()) {
            this.addToPublishQueue(0L, false, false);
        }
        this.logger.debug("getNextNotificationMessage: notificationMessage={}", (Object)abstractStructure);
        this.og.cmL().increment();
        this.updateDiagnostics();
        return abstractStructure;
    }

    protected UnsignedInteger getNextSequenceNumber(boolean bl) {
        long l2 = bl ? this.oa.get() : this.oa.getAndIncrement();
        try {
            return UnsignedInteger.valueOf(l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.oa.set(bl ? 1L : 2L);
            return UnsignedInteger.valueOf(1L);
        }
    }

    protected NotificationMessage getNotificationMessage(UnsignedInteger unsignedInteger) throws ServiceException {
        NotificationMessage notificationMessage = this.oe.get(unsignedInteger);
        if (notificationMessage == null) {
            throw new ServiceException(StatusCodes.Bad_MessageNotAvailable);
        }
        return notificationMessage;
    }

    protected BlockingQueue<SubscriptionBase> getPublishQueue() {
        return this.mm != null && this.mm.isActive() ? this.oc.get() : null;
    }

    protected void incrementOverflowCount() {
        this.getDiagnostics().cmF().increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose(boolean bl) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("internalClose: SubscriptionId=" + this.getSubscriptionId() + " removeFromQueue=" + bl);
        }
        this.publishingEnabled = false;
        BlockingQueue<SubscriptionBase> blockingQueue = this.oc.get();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("internalClose: PublishQueue: " + blockingQueue);
        }
        if (blockingQueue != null) {
            if (bl) {
                blockingQueue.remove(this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("PublishQueue after remove: " + blockingQueue);
            }
            this.setPublishQueue(null, true);
        }
        this.stopPublishing();
        this.removeAllItems();
        if (this.mm != null) {
            this.mm.removeSubscription(this);
        }
        this.subscriptionManager.getSessionManager().removeListener(this.sessionManagerListener);
        Subscription subscription = this;
        synchronized (subscription) {
            this.oe.clear();
            this.mm = null;
            this.closed = true;
        }
    }

    protected void internalRemoveItem(MonitoredItem monitoredItem) throws ServiceException, StatusException {
        super.removeItem(monitoredItem.getMonitoredItemId());
        monitoredItem.close();
    }

    protected boolean isTimeToPublish(long l2) {
        int n2 = nQ;
        long l3 = l2 - this.nY.get();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("isTimeToPublish: now-lastPublishCheckTime=" + l3 + " publishingInterval=" + this.publishingInterval);
        }
        return (double)l3 >= this.publishingInterval - (double)n2;
    }

    protected void monitoringModeChanged(MonitoredItem monitoredItem) {
        long l2 = 0L;
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            if (MonitoringMode.Disabled != monitoredItemBase.getMonitoringMode()) continue;
            ++l2;
        }
        this.og.cmu().reset();
        this.og.cmu().add(l2);
        this.updateDiagnostics();
    }

    protected void needTrigger(MonitoredItem monitoredItem, boolean bl, boolean bl2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("needTrigger: triggering item monitoredItemId=" + monitoredItem.getMonitoredItemId() + " needDataChange=" + bl + " needEventChange=" + bl2);
        }
        for (MonitoredItem monitoredItem2 : monitoredItem.links) {
            this.of.put(monitoredItem2.getMonitoredItemId(), monitoredItem2);
        }
        if (bl) {
            this.nR.set(true);
        }
        if (bl2) {
            this.nS.set(true);
        }
        this.cme();
    }

    protected void newEventAvailable(MonitoredEventItem monitoredEventItem) {
        this.logger.debug("newEventAvailable");
        this.nS.set(true);
        if (this.subscriptionManager.isImmediatePublishing()) {
            this.cme();
        }
    }

    protected void newSampleAvailable(MonitoredItem monitoredItem) {
        this.logger.debug("newSampleAvailable: monitoredItemId={}", (Object)monitoredItem.getMonitoredItemId());
        this.nR.set(true);
        if (this.subscriptionManager.isImmediatePublishing()) {
            this.cme();
        }
    }

    @Override
    protected void paramChanged() throws ServiceException {
        this.logger.debug("paramChanged");
        if (this.isPublishingEnabled() && this.mm != null) {
            this.cme();
            this.startPublishing();
            BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("paramChanged: queue before=" + blockingQueue);
            }
            if (blockingQueue.contains(this)) {
                blockingQueue.remove(this);
                blockingQueue.offer(this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("paramChanged: queue after=" + blockingQueue);
            }
        }
        this.og.cmB().set(UnsignedInteger.valueOf(this.getLifetimeCount()));
        this.og.cmA().set(UnsignedInteger.valueOf(this.getMaxKeepAliveCount()));
        this.og.cmC().set(UnsignedInteger.valueOf(this.getMaxNotificationsPerPublish()));
        this.og.cmI().set(UnsignedByte.valueOf(this.getPriority()));
        this.og.cmK().set(this.getPublishingInterval());
        this.updateDiagnostics();
    }

    protected void resetKeepAliveCounter() {
        this.nU.set(0);
    }

    protected void resetLastAliveTime() {
        this.nV.set(DateTime.currentTime());
    }

    protected void setPublishQueue(BlockingQueue<SubscriptionBase> blockingQueue, boolean bl) {
        BlockingQueue<SubscriptionBase> blockingQueue2 = this.getPublishQueue();
        if (blockingQueue != blockingQueue2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setPublishQueue: " + blockingQueue);
            }
            if (blockingQueue != null && blockingQueue2 != null) {
                blockingQueue2.remove(this);
            }
            this.oc.set(blockingQueue);
            if (blockingQueue != null) {
                for (MonitoredItemBase monitoredItemBase : this.getItems()) {
                    if (!(monitoredItemBase instanceof MonitoredDataItem)) continue;
                    ((MonitoredDataItem)monitoredItemBase).startSampling(bl);
                }
            }
        }
    }

    protected void setSession(Session session) {
        if (session != this.mm) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setSession: " + session);
            }
            if (this.mm != null) {
                this.mm.removeSubscription(this);
            }
            this.mm = session;
            if (session != null) {
                session.addSubscription(this);
            }
            this.start();
        }
    }

    protected synchronized void startPublishing() {
        long l2;
        if (this.ob == null) {
            this.ob = Executors.newScheduledThreadPool(1, StackUtils.newNamedThreadFactory("PublishExecutor-" + this.getSession().getSessionName() + "-Subscription" + this.getSubscriptionId()));
        }
        if (this.od != null) {
            this.od.cancel(false);
            this.logger.debug("startPublishing: canceled existing scheduled publish task");
        }
        if ((l2 = (long)this.getPublishingInterval()) <= 0L) {
            l2 = 10L;
        }
        this.od = this.ob.scheduleAtFixedRate(new PublishTask(), l2, l2, TimeUnit.MILLISECONDS);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("startPublishing: publishExecutor scheduled, interval=" + this.getPublishingInterval());
        }
    }

    protected synchronized void stopPublishing() {
        if (this.ob != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("stopPublishing: publishExecutor.shutdown()");
            }
            this.ob.shutdown();
            this.ob = null;
        }
    }

    protected void updateDiagnostics() {
        SubscriptionManager subscriptionManager = this.getSubscriptionManager();
        if (subscriptionManager != null) {
            subscriptionManager.getSessionManager().getServer().getDiagnosticsManager().updateSubscription(this);
        }
    }

    public class PublishTask
    implements Runnable {
        @Override
        public void run() {
            this.cmp();
        }

        private void cmp() {
            Subscription.this.logger.debug("publishCheck: SubscriptionID={}", (Object)Subscription.this.getSubscriptionId());
            long l2 = Subscription.this.cmh();
            Subscription.this.logger.debug("now={}", (Object)l2);
            if (Subscription.this.isTimeToPublish(l2)) {
                Subscription.this.logger.debug("lastPublishCheckTime(was)={}", (Object)Subscription.this.nY);
                if (Subscription.this.hasMoreNotifications().booleanValue()) {
                    Subscription.this.addToPublishQueue(l2, false, true);
                } else {
                    this.incKeepAliveCounter(l2);
                    if (Subscription.this.oh) {
                        Subscription.this.addToPublishQueue(l2, false, true);
                    }
                }
                if (Subscription.this.hasExpired()) {
                    try {
                        Subscription.this.logger.info("Subscription timeout: SubscriptionId=" + Subscription.this.getSubscriptionId() + " Session=" + Subscription.this.getSession());
                        Subscription.this.addToPublishQueue(l2, true, false);
                        Subscription.this.close();
                    }
                    catch (ServiceException serviceException) {
                        Subscription.this.logger.warn("While removing expired subscription " + Subscription.this.getSubscriptionId() + " of session " + Subscription.this.getSession(), (Throwable)serviceException);
                    }
                }
            }
            Subscription.this.updateDiagnostics();
        }

        protected void incKeepAliveCounter(long l2) {
            Subscription.this.logger.debug("incKeepAliveCounter: SubscriptionId={} Count={} Max=", new Object[]{Subscription.this.getSubscriptionId(), Subscription.this.nU.get(), Subscription.this.getMaxKeepAliveCount()});
            if ((long)Subscription.this.nU.incrementAndGet() >= Subscription.this.getMaxKeepAliveCount()) {
                Subscription.this.nU.set(0);
                Subscription.this.og.cmq().reset();
                Subscription.this.addToPublishQueue(l2, true, false);
            } else {
                Subscription.this.og.cmq().increment();
            }
        }
    }
}

