/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.UaLoopbackClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.RequestResponseListener;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ActivateSessionRequest;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.CreateSessionRequest;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.types.opcua.server.OperationLimitsTypeNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;

public abstract class ServiceHandler {
    private static int mn = 10000;
    protected static final String[] stringTable = new String[]{"en", "Please see AdditionalInfo for a detailed description of the error", "http://www.prosysopc.com/UA", "0"};
    private final EncoderContext at;
    private final NodeManagerTable nodeManagerTable;
    private volatile RequestResponseListener mo;
    private final SessionManager sessionManager;

    public static int getMaxOperationsPerRequest() {
        return mn;
    }

    public static void setMaxOperationsPerRequest(int n2) {
        mn = n2;
    }

    public static DiagnosticInfo[] validateOperationalDiagnostics(ServiceRequest serviceRequest, DiagnosticInfo[] diagnosticInfoArray) {
        if (ServiceHandler.a(diagnosticInfoArray)) {
            return null;
        }
        if (ServiceHandler.a(serviceRequest, (byte)31, 0)) {
            return null;
        }
        ServiceHandler.b(diagnosticInfoArray);
        return diagnosticInfoArray;
    }

    private static boolean a(DiagnosticInfo[] diagnosticInfoArray) {
        if (diagnosticInfoArray == null) {
            return true;
        }
        for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
            if (diagnosticInfo == null) continue;
            return false;
        }
        return true;
    }

    private static void a(DiagnosticInfo diagnosticInfo) {
        if (diagnosticInfo != null && diagnosticInfo.getStringTable() == null) {
            diagnosticInfo.setStringTable(Arrays.asList(stringTable));
            diagnosticInfo.setLocale(0);
            diagnosticInfo.setLocalizedText(1);
            diagnosticInfo.setNamespaceUri(2);
            diagnosticInfo.setSymbolicId(3);
        }
    }

    private static void b(DiagnosticInfo[] diagnosticInfoArray) {
        if (diagnosticInfoArray != null) {
            for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
                ServiceHandler.a(diagnosticInfo);
            }
        }
    }

    private static boolean a(ServiceRequest serviceRequest, byte by, int n2) {
        int n3 = serviceRequest.getRequestHeader().getReturnDiagnostics().intValue();
        int n4 = (n3 & by) >> n2;
        return n4 == 0;
    }

    protected static List<Locale> localizationHintsForServiceContext(ServiceContext serviceContext) {
        if (serviceContext == null || serviceContext.getSession() == null || serviceContext.getSession().getLocales() == null) {
            return Collections.emptyList();
        }
        return serviceContext.getSession().getLocales();
    }

    protected static ExtensionObject toExtensionObject(ServiceContext serviceContext, Structure structure, QualifiedName qualifiedName, EncoderContext encoderContext) throws ServiceException {
        if (structure == null) {
            return null;
        }
        if (qualifiedName == null) {
            qualifiedName = serviceContext.getSession().getDefaultEncoding();
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_BINARY_ENCODING)) {
            try {
                return ExtensionObject.binaryEncode(structure, encoderContext, ServiceHandler.localizationHintsForServiceContext(serviceContext));
            }
            catch (EncodingException encodingException) {
                throw new ServiceException(StatusCodes.Bad_DataEncodingInvalid);
            }
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_XML_ENCODING)) {
            throw new ServiceException(StatusCodes.Bad_DataEncodingUnsupported);
        }
        throw new ServiceException(StatusCodes.Bad_DataEncodingInvalid);
    }

    public ServiceHandler(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        if (nodeManagerTable == null) {
            throw new NullPointerException("NodeManager required");
        }
        this.sessionManager = sessionManager;
        this.nodeManagerTable = nodeManagerTable;
        this.at = nodeManagerTable.getEncoderContext();
    }

    protected ServiceHandler(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.nodeManagerTable = null;
        this.at = sessionManager.getServer().getEncoderContext();
    }

    public final UaNode getNode(NodeId nodeId) throws StatusException {
        return this.nodeManagerTable.getNode(nodeId);
    }

    public NodeManagerTable getNodeManagerTable() {
        return this.nodeManagerTable;
    }

    public UaServer getServer() {
        return this.getSessionManager().getServer();
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean hasNode(NodeId nodeId) {
        return this.nodeManagerTable.hasNode(nodeId);
    }

    public void setRequestResponseListener(RequestResponseListener requestResponseListener) {
        this.mo = requestResponseListener;
    }

    private void a(ServiceRequest serviceRequest, ServiceResponse serviceResponse) {
        ResponseHeader responseHeader = serviceResponse.getResponseHeader();
        if (responseHeader == null) {
            responseHeader = new ResponseHeader();
        }
        if (responseHeader.getTimestamp() == null || responseHeader.getTimestamp().equals(DateTime.MIN_VALUE)) {
            responseHeader.setTimestamp(new DateTime());
        }
        if (responseHeader.getServiceResult() == null) {
            responseHeader.setServiceResult(StatusCode.GOOD);
        }
        if (responseHeader.getRequestHandle() == null) {
            responseHeader.setRequestHandle(serviceRequest.getRequestHeader().getRequestHandle());
        }
        responseHeader.setServiceDiagnostics(this.validateServiceDiagnostics(serviceRequest, responseHeader.getServiceDiagnostics()));
        if (responseHeader.getServiceDiagnostics() != null) {
            responseHeader.setStringTable(stringTable);
        }
        serviceResponse.setResponseHeader(responseHeader);
    }

    protected void checkRequestLength(Object[] objectArray, int n2) throws ServiceException {
        if (objectArray == null || objectArray.length == 0) {
            throw new ServiceException(StatusCodes.Bad_NothingToDo);
        }
        if (n2 <= 0) {
            n2 = mn;
        }
        if (n2 > 0 && objectArray.length > n2) {
            throw new ServiceException("Requested operations " + objectArray.length + " exceeds the OperationLimit " + n2, StatusCodes.Bad_TooManyOperations);
        }
    }

    protected ServiceContext createServiceContext(RequestHeader requestHeader) throws ServiceException {
        Session session = this.sessionManager.getSession(requestHeader.getAuthenticationToken());
        return new ServiceContext(session, requestHeader);
    }

    protected void fireRequestResponse(ServiceRequest serviceRequest, ServiceResponse serviceResponse, ServiceContext serviceContext) {
        Logger logger = this.getLogger();
        if (logger.isTraceEnabled()) {
            DateTime dateTime = serviceRequest.getRequestHeader().getTimestamp();
            DateTime dateTime2 = serviceResponse.getResponseHeader().getTimestamp();
            long l2 = dateTime2.getTimeInMillis() - dateTime.getTimeInMillis();
            logger.trace("Response: (dt=" + l2 + " ms) " + serviceResponse);
        }
        if (serviceContext != null && serviceContext.getSession() != null) {
            serviceContext.getSession().a(serviceResponse);
        }
        try {
            if (this.mo != null) {
                this.mo.onRequestResponse(serviceRequest, serviceResponse);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected EncoderContext getEncoderContext() {
        return this.at;
    }

    protected Logger getLogger() {
        throw new RuntimeException("getLogger must be overridden");
    }

    protected OperationLimitsTypeNode getOperationLimits() {
        return this.getServer().getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getOperationLimitsNode();
    }

    protected void handleServiceResultException(ServiceResponse serviceResponse, ServiceException serviceException) {
        this.getLogger().debug("handleServiceResultException:", (Throwable)serviceException);
        ResponseHeader responseHeader = new ResponseHeader();
        responseHeader.setServiceResult(serviceException.getServiceResult());
        responseHeader.setServiceDiagnostics(serviceException.getDiagnosticInfo());
        serviceResponse.setResponseHeader(responseHeader);
    }

    protected void validateEncoding(ReadValueId readValueId) throws StatusException {
        if (!Attributes.Value.equals(readValueId.getAttributeId()) && !QualifiedName.isNullOrEmpty(readValueId.getDataEncoding())) {
            throw new StatusException(StatusCodes.Bad_DataEncodingInvalid);
        }
        if (!QualifiedName.isNullOrEmpty(readValueId.getDataEncoding())) {
            UaType uaType = null;
            try {
                DataValue dataValue = new DataValue();
                this.nodeManagerTable.readAttribute(ServiceContext.INTERNAL_OPERATION_CONTEXT, null, readValueId.getNodeId(), Attributes.DataType, null, TimestampsToReturn.Neither, DateTime.MIN_VALUE, dataValue);
                NodeId nodeId = (NodeId)dataValue.getValue().getValue();
                uaType = (UaType)this.nodeManagerTable.getNode(nodeId);
            }
            catch (Exception exception) {
                this.getLogger().error("Could not parse nodeId to UaType", (Throwable)exception);
            }
            if (uaType != null && !uaType.inheritsFrom(Identifiers.Structure)) {
                throw new StatusException(StatusCodes.Bad_DataEncodingInvalid);
            }
            if (QualifiedName.DEFAULT_XML_ENCODING.equals(readValueId.getDataEncoding())) {
                throw new StatusException(StatusCodes.Bad_DataEncodingUnsupported);
            }
            if (!QualifiedName.DEFAULT_BINARY_ENCODING.equals(readValueId.getDataEncoding())) {
                throw new StatusException(StatusCodes.Bad_DataEncodingUnsupported);
            }
        }
    }

    protected ServiceContext validateRequest(EndpointServiceRequest<?, ?> endpointServiceRequest) throws ServiceException {
        if (endpointServiceRequest instanceof UaLoopbackClient.InternalEndpointServiceRequest) {
            return ServiceContext.INTERNAL_OPERATION_CONTEXT;
        }
        return this.validateRequest((ServiceRequest)endpointServiceRequest.getRequest(), endpointServiceRequest.getChannel());
    }

    protected ServiceContext validateRequest(ServiceRequest serviceRequest, ServerSecureChannel serverSecureChannel) throws ServiceException {
        Session session;
        Object object;
        RequestHeader requestHeader = serviceRequest.getRequestHeader();
        if (requestHeader == null) {
            throw new ServiceException(StatusCodes.Bad_RequestHeaderInvalid);
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("validateRequest: sessionManager=" + this.sessionManager);
            if (this.sessionManager != null) {
                this.getLogger().trace("validateRequest: sessionManager.isRunning=" + this.sessionManager.isRunning());
            }
        }
        if (this.sessionManager != null && !this.sessionManager.isRunning()) {
            throw new ServiceException(StatusCodes.Bad_SessionClosed);
        }
        if (this.getLogger().isTraceEnabled()) {
            object = requestHeader.getTimestamp();
            long l2 = System.currentTimeMillis() - ((DateTime)object).getTimeInMillis();
            this.getLogger().trace("validateRequest: Request=" + serviceRequest.getClass().getSimpleName() + " RequestHandle=" + requestHeader.getRequestHandle() + "; rt(ms)=" + object + " dt(ms)=" + l2);
        }
        if ((session = ((ServiceContext)(object = this.createServiceContext(requestHeader))).getSession()) != null) {
            session.a(serviceRequest);
            if (!(session.isActive() || serviceRequest instanceof CreateSessionRequest || serviceRequest instanceof ActivateSessionRequest)) {
                this.getLogger().warn("validateRequest: Request=" + serviceRequest.getClass().getSimpleName() + " session not active");
                throw new ServiceException(StatusCodes.Bad_SessionNotActivated);
            }
            if (session.getChannel().getSecureChannelId() != serverSecureChannel.getSecureChannelId() && !(serviceRequest instanceof CreateSessionRequest) && !(serviceRequest instanceof ActivateSessionRequest)) {
                this.getLogger().warn("validateRequest: Request=" + serviceRequest.getClass().getSimpleName() + " serverSecureChannel=" + serverSecureChannel + " session.SecureChannelId=" + session.getChannel() + " session=" + session);
                throw new ServiceException(StatusCodes.Bad_SecureChannelIdInvalid);
            }
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("Request: " + serviceRequest.getClass().getSimpleName() + " session=" + session);
        }
        return object;
    }

    protected void validateResponse(ServiceRequest serviceRequest, ServiceResponse serviceResponse, ServiceContext serviceContext) {
        this.a(serviceRequest, serviceResponse);
        this.fireRequestResponse(serviceRequest, serviceResponse, serviceContext);
    }

    protected DiagnosticInfo[] validateResponse(ServiceRequest serviceRequest, ServiceResponse serviceResponse, ServiceContext serviceContext, DiagnosticInfo[] diagnosticInfoArray) {
        this.a(serviceRequest, serviceResponse);
        DiagnosticInfo[] diagnosticInfoArray2 = ServiceHandler.validateOperationalDiagnostics(serviceRequest, diagnosticInfoArray);
        if (diagnosticInfoArray2 != null) {
            serviceResponse.getResponseHeader().setStringTable(stringTable);
        }
        this.fireRequestResponse(serviceRequest, serviceResponse, serviceContext);
        return diagnosticInfoArray2;
    }

    protected DiagnosticInfo validateServiceDiagnostics(ServiceRequest serviceRequest, DiagnosticInfo diagnosticInfo) {
        if (ServiceHandler.a(serviceRequest, (byte)-32, 5)) {
            return null;
        }
        ServiceHandler.a(diagnosticInfo);
        return diagnosticInfo;
    }
}

