/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RequestHeader;

public class ServiceContext {
    public static final ServiceContext INTERNAL_OPERATION_CONTEXT = new ServiceContext(Session.INTERNAL_SESSION, null);
    final RequestHeader ml;
    final Session mm;

    public ServiceContext(Session session, RequestHeader requestHeader) {
        this.mm = session;
        this.ml = requestHeader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ServiceContext)) {
            return false;
        }
        ServiceContext serviceContext = (ServiceContext)object;
        if (this.ml == null) {
            return serviceContext.ml == null;
        }
        if (serviceContext.ml == null) {
            return false;
        }
        if (this.ml.getRequestHandle() != null && this.ml.getRequestHandle().getValue() != 0L) {
            return this.ml.getRequestHandle().equals(serviceContext.ml.getRequestHandle());
        }
        if (this.ml.getRequestHandle() != null && this.ml.getTimestamp() != null) {
            return this.ml.getTimestamp().equals(serviceContext.ml.getTimestamp());
        }
        return false;
    }

    public String getAuditEntryId() {
        return this.ml.getAuditEntryId();
    }

    public UnsignedInteger getReturnDiagnostics() {
        return this.ml.getReturnDiagnostics();
    }

    public Session getSession() {
        return this.mm;
    }

    public UnsignedInteger getTimeoutHint() {
        return this.ml.getTimeoutHint();
    }

    public DateTime getTimestamp() {
        return this.ml.getTimestamp();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.ml == null ? 0 : this.ml.hashCode());
        n3 = 31 * n3 + (this.mm == null ? 0 : this.mm.hashCode());
        return n3;
    }

    public boolean isInternal() {
        return this.equals(INTERNAL_OPERATION_CONTEXT);
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.getTimestamp().getTimeInMillis() + this.getTimeoutHint().getValue();
    }
}

