/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.IssuedIdentityToken;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserNameIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.core.X509IdentityToken;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUserIdentity
extends UserIdentity {
    private static final Logger logger = LoggerFactory.getLogger(ServerUserIdentity.class);
    private final UserIdentityToken mk;

    @Deprecated
    public ServerUserIdentity(SessionManager sessionManager, UserIdentityToken userIdentityToken, SignatureData signatureData, ApplicationIdentity applicationIdentity, ByteString byteString, SecurityPolicy securityPolicy) throws SecureIdentityException {
        this(sessionManager, userIdentityToken, signatureData, applicationIdentity.getKeys(), byteString, securityPolicy);
    }

    public ServerUserIdentity(SessionManager sessionManager, UserIdentityToken userIdentityToken, SignatureData signatureData, KeyPair keyPair, ByteString byteString, SecurityPolicy securityPolicy) throws SecureIdentityException {
        this(sessionManager, userIdentityToken, signatureData, new KeyPair[]{keyPair}, byteString, securityPolicy);
    }

    public ServerUserIdentity(SessionManager sessionManager, UserIdentityToken userIdentityToken, SignatureData signatureData, KeyPair[] keyPairArray, ByteString byteString, SecurityPolicy object) throws SecureIdentityException {
        HashMap<String, UserTokenPolicy> hashMap = new HashMap<String, UserTokenPolicy>();
        for (UserTokenPolicy object2 : sessionManager.getServer().getServer().getUserTokenPolicies()) {
            hashMap.put(object2.getPolicyId(), object2);
        }
        this.mk = userIdentityToken;
        if (userIdentityToken != null) {
            Object object3;
            if (userIdentityToken instanceof UserNameIdentityToken) {
                object3 = (UserNameIdentityToken)userIdentityToken;
                this.name = ((UserNameIdentityToken)object3).getUserName();
                this.encryptedPassword = ByteString.asByteArray(((UserNameIdentityToken)object3).getPassword());
                if (this.name == null || this.name.isEmpty()) {
                    throw new SecureIdentityException("UserName not defined for UserNameIdentityToken");
                }
                this.decryptPassword(userIdentityToken, keyPairArray, byteString, hashMap);
                this.type = UserTokenType.UserName;
            } else if (userIdentityToken instanceof IssuedIdentityToken) {
                this.issuedIdentityToken = ByteString.asByteArray(((IssuedIdentityToken)userIdentityToken).getTokenData());
                this.type = UserTokenType.IssuedToken;
            } else if (userIdentityToken instanceof X509IdentityToken) {
                try {
                    boolean bl;
                    object3 = (X509IdentityToken)userIdentityToken;
                    byte[] byArray = ByteString.asByteArray(((X509IdentityToken)object3).getCertificateData());
                    String string = signatureData.getAlgorithm();
                    String string2 = object.getAsymmetricSignatureAlgorithm().getUri();
                    boolean bl2 = false;
                    if (string != null && !string.equals(string2)) {
                        logger.debug("UserTokenSignature.Algorithm does not match the one defined by the userTokenPolicy: " + string + " vs. " + string2);
                        bl = false;
                        for (SecurityPolicy securityPolicy : SecurityPolicy.values()) {
                            if (securityPolicy.getAsymmetricSignatureAlgorithm() == null || securityPolicy.getAsymmetricSignatureAlgorithm().getUri() == null || !securityPolicy.getAsymmetricSignatureAlgorithm().getUri().equals(string)) continue;
                            object = securityPolicy;
                            bl = true;
                            logger.debug("Found a matching security policy: " + securityPolicy.getPolicyUri());
                            break;
                        }
                        if (!bl) {
                            logger.warn("Could not find a matching security policy for the signature algorithm " + string + " -> Using the Token Policy algorithm " + string2);
                        }
                    } else {
                        bl2 = true;
                    }
                    if (signatureData == null || signatureData.getAlgorithm() == null || signatureData.getSignature() == null) {
                        throw new SecureIdentityException("Invalid userTokenSignature", StatusCodes.Bad_IdentityTokenInvalid);
                    }
                    bl = false;
                    for (KeyPair keyPair : keyPairArray) {
                        try {
                            if (!sessionManager.a(signatureData, keyPair.getCertificate(), byteString, (SecurityPolicy)((Object)object), byArray)) continue;
                            bl = true;
                        }
                        catch (SecureIdentityException secureIdentityException) {
                            // empty catch block
                        }
                    }
                    if (!bl) {
                        if (!bl2) {
                            throw new SecureIdentityException("Invalid algorithm in userTokenSignature", StatusCodes.Bad_IdentityTokenInvalid);
                        }
                        throw new SecureIdentityException("Failed to verify userTokenSignature", StatusCodes.Bad_IdentityTokenRejected);
                    }
                    this.certificate = new Cert(byArray);
                }
                catch (ServiceResultException serviceResultException) {
                    throw new SecureIdentityException("Failed to create certificate", serviceResultException);
                }
                this.type = UserTokenType.Certificate;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public UserIdentityToken getToken() {
        return this.mk;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

