/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.SemanticChangeStructureDataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SemanticChangeEvent {
    private final Map<NodeId, SemanticChangeStructureDataType> lW = new ConcurrentHashMap<NodeId, SemanticChangeStructureDataType>();
    private final NamespaceTable iX;
    private SemanticChangeStructureDataType[] lX = null;

    public SemanticChangeEvent(NamespaceTable namespaceTable) {
        this.iX = namespaceTable;
    }

    public void addChange(NodeId nodeId, NodeId nodeId2) {
        if (!this.lW.containsKey(nodeId)) {
            this.lW.put(nodeId, new SemanticChangeStructureDataType(nodeId, nodeId2));
        }
    }

    public void addChange(UaNode uaNode) {
        NodeId nodeId = uaNode.getNodeId();
        NodeId nodeId2 = NodeId.NULL;
        if (uaNode instanceof UaInstance) {
            try {
                nodeId2 = this.iX.toNodeId(((UaInstance)uaNode).getTypeDefinitionId());
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        this.addChange(nodeId, nodeId2);
    }

    public void clearChanges() {
        this.lW.clear();
        this.lX = null;
    }

    public SemanticChangeStructureDataType[] getChanges() {
        if (this.lX != null) {
            return this.lX;
        }
        return this.lW.values().toArray(new SemanticChangeStructureDataType[this.lW.size()]);
    }

    public void setChanges(SemanticChangeStructureDataType[] semanticChangeStructureDataTypeArray) {
        this.clearChanges();
        this.lX = semanticChangeStructureDataTypeArray;
    }
}

