/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.CallableListener;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.nodes.UaCallable;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Argument;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodManagerUaNode
extends MethodManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodManagerUaNode.class);
    private List<CallableListener> listeners;

    public MethodManagerUaNode(NodeManager nodeManager) {
        super(nodeManager);
    }

    public void addCallListener(CallableListener callableListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<CallableListener>();
        }
        this.listeners.add(callableListener);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Variant[] variantArray2;
        logger.debug("callMethod: objectId={}; methodId={}", (Object)nodeId, (Object)nodeId2);
        UaNode uaNode = this.getNode(nodeId);
        logger.debug(" node: {}", (Object)uaNode);
        UaMethod uaMethod = null;
        try {
            uaMethod = (UaMethod)this.getNode(nodeId2);
            logger.debug(" method: {}", (Object)uaMethod);
        }
        catch (ClassCastException classCastException) {
            logger.debug("MethodId does not correspond to a method object");
            throw new StatusException(StatusCodes.Bad_MethodInvalid, (Throwable)classCastException);
        }
        try {
            Argument[] argumentArray = uaMethod.getOutputArguments();
            variantArray2 = argumentArray == null ? new Variant[]{} : new Variant[argumentArray.length];
        }
        catch (MethodArgumentException methodArgumentException) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument, (Throwable)methodArgumentException);
        }
        this.checkInputArguments(variantArray, statusCodeArray, diagnosticInfoArray, uaMethod);
        boolean bl = this.fireCall(serviceContext, variantArray, statusCodeArray, diagnosticInfoArray, nodeId, uaNode, nodeId2, uaMethod, variantArray2);
        logger.debug(" handled: {}", (Object)bl);
        if (!bl) {
            block12: {
                if (uaNode instanceof UaCallable) {
                    try {
                        variantArray2 = ((UaCallable)((Object)uaNode)).callMethod(serviceContext, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
                        bl = true;
                    }
                    catch (StatusException statusException) {
                        if (statusException.getStatusCode().isStatusCode(StatusCodes.Bad_MethodInvalid)) break block12;
                        throw statusException;
                    }
                }
            }
            if (!bl) {
                if (uaMethod instanceof UaCallable) {
                    variantArray2 = ((UaCallable)((Object)uaMethod)).callMethod(serviceContext, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
                } else {
                    throw new StatusException(StatusCodes.Bad_MethodInvalid);
                }
            }
        }
        this.checkOutputArguments(variantArray2, uaMethod);
        if (variantArray2 == null) {
            variantArray2 = new Variant[]{};
        }
        return variantArray2;
    }

    public void removeCallListener(CallableListener callableListener) {
        this.listeners.remove(callableListener);
    }

    protected void checkInputArguments(Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, UaMethod uaMethod) throws StatusException {
        Argument[] argumentArray;
        try {
            argumentArray = uaMethod.getInputArguments();
        }
        catch (MethodArgumentException methodArgumentException) {
            argumentArray = null;
        }
        int n2 = variantArray == null ? 0 : variantArray.length;
        int n3 = argumentArray == null ? 0 : argumentArray.length;
        logger.debug("checkInputArguments: methodInputs={}; inputArguments={}", (Object)n3, (Object)n2);
        if (n2 < n3) {
            throw new StatusException(StatusCodes.Bad_ArgumentsMissing);
        }
        if (n2 > n3) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        boolean bl = false;
        for (int i2 = 0; i2 < n3; ++i2) {
            variantArray[i2] = this.getNodeManager().getIoManager().autoConvert(variantArray[i2], argumentArray[i2].getDataType());
            boolean bl2 = this.dataTypeEquals(variantArray[i2], argumentArray[i2].getDataType());
            boolean bl3 = this.arrayDimensionsMatch(variantArray[i2], argumentArray[i2].getValueRank(), argumentArray[i2].getArrayDimensions());
            if (bl2 && bl3) {
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            if (!bl2) {
                UaNode uaNode;
                statusCodeArray[i2] = StatusCode.valueOf(StatusCodes.Bad_TypeMismatch);
                try {
                    uaNode = this.getNode(argumentArray[i2].getDataType());
                }
                catch (StatusException statusException) {
                    uaNode = null;
                }
                String string = uaNode != null ? uaNode.toString() : argumentArray[i2].getDataType().toString();
                String string2 = String.format(Locale.ROOT, "DataType (%s) of inputArgument #%d (%s) does not match the expected (%s)", variantArray[i2].getCompositeClass(), i2, argumentArray[i2].getName(), string);
                logger.info(string2);
                diagnosticInfoArray[i2] = new DiagnosticInfo(string2, null, null, null, null, null, null);
            }
            if (!bl3) {
                statusCodeArray[i2] = StatusCode.valueOf(StatusCodes.Bad_TypeMismatch);
                logger.info("Dimensions of the inputargument does not match given ValueRank and ArrayDimensions of the Method InputArgument");
            }
            bl = true;
        }
        if (bl) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
    }

    protected void checkOutputArguments(Variant[] variantArray, UaMethod uaMethod) throws StatusException {
        int n2;
        Argument[] argumentArray;
        try {
            argumentArray = uaMethod.getOutputArguments();
        }
        catch (MethodArgumentException methodArgumentException) {
            argumentArray = null;
        }
        int n3 = variantArray == null ? 0 : variantArray.length;
        int n4 = n2 = argumentArray == null ? 0 : argumentArray.length;
        if (logger.isDebugEnabled()) {
            logger.debug("checkOutputArguments: outputArguments={}", (Object)Arrays.toString(variantArray));
        }
        if (n3 != n2) {
            logger.warn("checkOutputArguments: methodOutputs={} != outputArguments={}", (Object)n2, (Object)n3);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                UaNode uaNode;
                if (this.dataTypeEquals(variantArray[i2], argumentArray[i2].getDataType())) continue;
                try {
                    uaNode = this.getNode(argumentArray[i2].getDataType());
                }
                catch (StatusException statusException) {
                    uaNode = null;
                }
                String string = uaNode != null ? uaNode.toString() : argumentArray[i2].getDataType().toString();
                String string2 = String.format(Locale.ROOT, "Method %s(ID=%s): DataType (%s) of outputArgument #%d (%s) does not match the expected (%s)", uaMethod.getBrowseName(), uaMethod.getNodeId(), variantArray[i2].getCompositeClass(), i2, argumentArray[i2].getName(), string);
                logger.warn(string2);
            }
        }
    }

    protected boolean fireCall(ServiceContext serviceContext, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, NodeId nodeId, UaNode uaNode, NodeId nodeId2, UaMethod uaMethod, Variant[] variantArray2) throws StatusException {
        logger.debug(" method: {}", (Object)uaMethod);
        for (CallableListener callableListener : this.listeners) {
            if (!callableListener.onCall(serviceContext, nodeId, uaNode, nodeId2, uaMethod, variantArray, statusCodeArray, diagnosticInfoArray, variantArray2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }
}

