/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.server.io.IoManagerListenerChain;
import com.prosysopc.ua.server.io.IoManagerListenerChainImpl;
import com.prosysopc.ua.server.io.NodeIoManagerListener;
import com.prosysopc.ua.server.io.UaNodeIoListener;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoManager
extends ServiceManagerBase {
    private static final IoManagerListener jB = new IoManagerListener(){

        @Override
        public AccessLevelType onGetUserAccessLevel(ServiceContext serviceContext, NodeId nodeId, UaVariable uaVariable) {
            if (uaVariable != null) {
                return uaVariable.getAccessLevel();
            }
            return AccessLevelType.of(AccessLevelType.Options.values());
        }

        @Override
        public Boolean onGetUserExecutable(ServiceContext serviceContext, NodeId nodeId, UaMethod uaMethod) {
            if (uaMethod != null) {
                return uaMethod.getExecutable();
            }
            return false;
        }

        @Override
        public AttributeWriteMask onGetUserWriteMask(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode) {
            if (uaNode != null) {
                return uaNode.getWriteMask();
            }
            return AttributeWriteMask.of(AttributeWriteMask.Options.values());
        }

        @Override
        public boolean onReadNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
            return false;
        }

        @Override
        public boolean onReadValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
            return false;
        }

        @Override
        public boolean onWriteNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
            return false;
        }

        @Override
        public boolean onWriteValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
            return false;
        }
    };
    private static Logger logger = LoggerFactory.getLogger(IoManager.class);
    private final IoManagerListenerChain jC = new IoManagerListenerChainImpl();
    private final NodeIoManagerListener jD = new NodeIoManagerListener();
    private final NodeManager iF;

    public static void applyIndexRangeToReadValue(DataValue dataValue, NumericRange numericRange) throws StatusException {
        logger.debug("applyIndexRangeToReadValue: dataValue={}", (Object)dataValue);
        logger.debug("applyIndexRangeToReadValue: indexRange={}", (Object)numericRange);
        if (dataValue.getStatusCode().isNotBad() && !NumericRange.isNullOrEmpty(numericRange)) {
            Object object = dataValue.getValue().getValue();
            object = IoManager.applyIndexRangeToReadValue(object, numericRange, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("applyIndexRangeToReadValue: value={}", (Object)MultiDimensionArrayUtils.toString(object));
                logger.debug("applyIndexRangeToReadValue: class={}", object.getClass());
            }
            dataValue.setValue(new Variant(object));
        }
    }

    public static DataValue applyIndexRangeToWriteValue(DataValue dataValue, DataValue dataValue2, NumericRange numericRange) throws StatusException {
        logger.debug("applyIndexRangeToWriteValue: currentValue={}", (Object)dataValue);
        logger.debug("applyIndexRangeToWriteValue: newValue={}", (Object)dataValue2);
        logger.debug("applyIndexRangeToWriteValue: indexRange={}", (Object)numericRange);
        if (!NumericRange.isNullOrEmpty(numericRange)) {
            dataValue2 = dataValue2.clone();
            Object object = dataValue.getValue().getValue();
            if (object == null) {
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
            }
            if (object instanceof String) {
                String string = (String)object;
                String string2 = string.substring(numericRange.getBegin(), numericRange.getEnd() + 1);
                dataValue2.setValue(new Variant(string2));
            } else if (object instanceof ByteString) {
                byte[] byArray = ((ByteString)object).getValue();
                byte[] byArray2 = Arrays.copyOfRange(byArray, 0, byArray.length);
                byte[] byArray3 = ((ByteString)dataValue2.getValue().getValue()).getValue();
                try {
                    int n2 = numericRange.getBegin();
                    int n3 = 0;
                    while (n2 <= numericRange.getEnd()) {
                        byArray2[n2] = byArray3[n3];
                        ++n2;
                        ++n3;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    logger.debug("Index error", (Throwable)arrayIndexOutOfBoundsException);
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                dataValue2.setValue(new Variant(ByteString.valueOf(byArray2)));
            } else {
                int n4 = dataValue.getValue().getDimension();
                if (n4 == 1) {
                    Object[] objectArray = (Object[])object;
                    Class<?> clazz = objectArray.getClass();
                    T[] TArray = Arrays.copyOfRange(objectArray, 0, objectArray.length, clazz);
                    Object[] objectArray2 = (Object[])dataValue2.getValue().getValue();
                    try {
                        int n5 = numericRange.getBegin();
                        int n6 = 0;
                        while (n5 <= numericRange.getEnd()) {
                            TArray[n5] = objectArray2[n6];
                            ++n5;
                            ++n6;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Index error", (Throwable)arrayIndexOutOfBoundsException);
                        }
                        throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                    }
                    dataValue2.setValue(new Variant(TArray));
                } else if (n4 >= 2) {
                    Object object2;
                    Class<?> clazz = object.getClass();
                    int[] nArray = new int[n4];
                    int[] nArray2 = new int[n4];
                    Object[] objectArray = (Object[])dataValue.getValue().getValue();
                    Object[] objectArray3 = (Object[])dataValue2.getValue().getValue();
                    Class<?> clazz2 = clazz;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        clazz2 = clazz2.getComponentType();
                        nArray[i2] = objectArray.length;
                        nArray2[i2] = objectArray3.length;
                        if (i2 >= n4 - 1) continue;
                        objectArray = (Object[])objectArray[0];
                        objectArray3 = (Object[])objectArray3[0];
                    }
                    Object object3 = MultiDimensionArrayUtils.muxArray(object, nArray, clazz2);
                    Object[] objectArray4 = (Object[])object3;
                    MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(dataValue2.getValue().getValue(), nArray2);
                    while (arrayIterator.hasNext()) {
                        object2 = arrayIterator.getIndices();
                        int n7 = 0;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            int n8;
                            int n9 = 1;
                            for (n8 = i3 + 1; n8 < n4; ++n8) {
                                n9 *= nArray[n8];
                            }
                            n8 = numericRange.getBegin(i3);
                            if (n8 == -1) {
                                n8 = 0;
                            }
                            n7 += n9 * (object2[i3] + n8);
                        }
                        try {
                            objectArray4[n7] = arrayIterator.next();
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Index error", (Throwable)arrayIndexOutOfBoundsException);
                            }
                            throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                        }
                    }
                    object2 = MultiDimensionArrayUtils.demuxArray(object3, nArray, clazz2);
                    dataValue2.setValue(new Variant(object2));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("applyIndexRangeToWriteValue: newValue={}", (Object)dataValue2);
            }
        }
        return dataValue2;
    }

    protected static Object applyIndexRangeToReadValue(Object objectArray, NumericRange numericRange, int n2) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("applyIndexRangeToReadValue: dimension={} indexRange={}", (Object)n2, (Object)numericRange);
            logger.debug("applyIndexRangeToReadValue: value={}", (Object)MultiDimensionArrayUtils.toString(objectArray));
        }
        if (objectArray != null && Object[].class.isAssignableFrom(objectArray.getClass())) {
            try {
                Object[] objectArray2 = objectArray;
                int n3 = numericRange.getBegin(n2);
                int n4 = numericRange.getEnd(n2);
                if (n3 >= objectArray2.length) {
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                int n5 = n4 < 0 ? n3 + 1 : (n4 < objectArray2.length ? n4 + 1 : objectArray2.length);
                objectArray2 = Arrays.copyOfRange(objectArray2, n3, n5, objectArray2.getClass());
                if (n2 + 1 < numericRange.getDimensions()) {
                    for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                        objectArray2[i2] = IoManager.applyIndexRangeToReadValue(objectArray2[i2], numericRange, n2 + 1);
                    }
                }
                objectArray = objectArray2;
            }
            catch (Exception exception) {
                logger.debug("Failed to copy the requested range " + numericRange.getBegin(n2) + ":" + numericRange.getEnd(n2), (Throwable)exception);
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData, (Throwable)exception);
            }
        } else if (objectArray instanceof ByteString) {
            byte[] byArray = ((ByteString)objectArray).getValue();
            try {
                if (byArray.length == 0 || numericRange.getBegin(n2) > byArray.length - 1) {
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                if (byArray.length < numericRange.getEnd(n2) + 1) {
                    objectArray = ByteString.valueOf(Arrays.copyOfRange(byArray, numericRange.getBegin(n2), byArray.length));
                }
                objectArray = ByteString.valueOf(Arrays.copyOfRange(byArray, numericRange.getBegin(n2), numericRange.getEnd(n2) + 1));
            }
            catch (Exception exception) {
                logger.debug("Failed to copy the requested range " + numericRange.getBegin(n2) + ":" + numericRange.getEnd(n2) + " from byte array " + CryptoUtil.toHex(byArray), (Throwable)exception);
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData, (Throwable)exception);
            }
        } else if (objectArray instanceof String) {
            try {
                objectArray = ((String)objectArray).substring(numericRange.getBegin(n2), numericRange.getEnd(n2) + 1);
            }
            catch (Exception exception) {
                logger.debug("Failed to copy the requested range " + numericRange.getBegin(n2) + ":" + numericRange.getEnd(n2) + " from string " + objectArray, (Throwable)exception);
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData, (Throwable)exception);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyIndexRangeToReadValue: result={}", (Object)MultiDimensionArrayUtils.toString(objectArray));
        }
        return objectArray;
    }

    protected static void checkIndexRange(Object object, NumericRange numericRange, int n2) throws StatusException {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            IoManager.validateIndexRange(n2, collection.size(), numericRange);
        } else if (object instanceof String) {
            IoManager.validateIndexRange(n2, ((String)object).length(), numericRange);
        }
    }

    protected static void validateIndexRange(int n2, int n3, NumericRange numericRange) throws StatusException {
        int n4 = numericRange.getBegin(n2);
        int n5 = numericRange.getEnd(n2);
        if (n4 >= n3 || n5 >= n3) {
            throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
        }
    }

    public IoManager(NodeManager nodeManager) {
        super(nodeManager.getServer());
        this.iF = nodeManager;
        nodeManager.setIoManager(this);
        this.jC.setListeners(this.jD, jB);
    }

    public void addListeners(IoManagerListener ... ioManagerListenerArray) {
        this.jC.addListeners(ioManagerListenerArray);
    }

    public void addNodeListener(NodeId nodeId, UaNodeIoListener uaNodeIoListener) {
        this.jD.addListener(nodeId, uaNodeIoListener);
    }

    public final Variant autoConvert(Variant variant, NodeId nodeId) {
        if (variant == null || variant.getValue() == null) {
            return variant;
        }
        try {
            Object object = variant.getValue();
            if (object instanceof ByteString) {
                UaType uaType = this.iF.getNodeManagerTable().getNodeManagerRoot().getType(nodeId);
                if (uaType.inheritsFrom(Identifiers.Byte)) {
                    byte[] byArray = ((ByteString)object).getValue();
                    UnsignedByte[] unsignedByteArray = new UnsignedByte[byArray.length];
                    for (int i2 = 0; i2 < byArray.length; ++i2) {
                        unsignedByteArray[i2] = UnsignedByte.getFromBits(byArray[i2]);
                    }
                    return new Variant(unsignedByteArray);
                }
                return variant;
            }
            if (object instanceof BigDecimal[]) {
                BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                if (bigDecimalArray.length > 0) {
                    return variant;
                }
                UaType uaType = this.iF.getNodeManagerTable().getType(nodeId);
                if (uaType.inheritsFrom(DataTypeIdentifiers.Structure)) {
                    return new Variant(this.h(nodeId));
                }
                return variant;
            }
            if (object instanceof Structure[]) {
                Structure[] structureArray = (Structure[])object;
                if (structureArray.length > 0) {
                    return variant;
                }
                UaType uaType = this.iF.getNodeManagerTable().getType(nodeId);
                if (uaType.inheritsFrom(DataTypeIdentifiers.Structure)) {
                    return new Variant(this.h(nodeId));
                }
                if (uaType.inheritsFrom(DataTypeIdentifiers.Decimal)) {
                    return new Variant(new BigDecimal[0]);
                }
                return variant;
            }
            return variant;
        }
        catch (Exception exception) {
            logger.error("Error while autoconverting Value={} to DataTypeId={}", new Object[]{variant, nodeId, exception});
            return variant;
        }
    }

    public IoManagerListener getDefaultListener() {
        return jB;
    }

    public IoManagerListener getNodeListener() {
        return this.jD;
    }

    public NodeManager getNodeManager() {
        return this.iF;
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DateTime dateTime) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readAttribute(ServiceContext.INTERNAL_OPERATION_CONTEXT, null, nodeId, unsignedInteger, numericRange, TimestampsToReturn.Both, dateTime, dataValue);
        return dataValue;
    }

    public void removeListeners(IoManagerListener ... ioManagerListenerArray) {
        this.jC.removeListeners(ioManagerListenerArray);
    }

    public void setListeners(IoManagerListener ... ioManagerListenerArray) {
        this.jC.setListeners(ioManagerListenerArray);
    }

    public void writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        this.writeAttribute(ServiceContext.INTERNAL_OPERATION_CONTEXT, null, nodeId, unsignedInteger, numericRange, dataValue);
    }

    private Object h(NodeId nodeId) {
        if (Identifiers.Structure.equals(nodeId)) {
            return new Structure[0];
        }
        UaNodeId uaNodeId = UaNodeId.fromLocal(nodeId, this.getNodeManager().getNamespaceTable());
        StructureSpecification structureSpecification = this.getNodeManager().getServer().getEncoderContext().getStructureSpecification(uaNodeId);
        if (structureSpecification == null) {
            logger.error("IoManager, cannot find StructureSpecification for type: {}, cannot create proper array type", (Object)nodeId);
            return new Structure[0];
        }
        return Array.newInstance(structureSpecification.getJavaClass(), 0);
    }

    private void a(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        this.jC.onReadNonValue(serviceContext, nodeId, uaNode, unsignedInteger, dataValue);
    }

    private void a(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        logger.debug("fireReadValue");
        this.jC.onReadValue(serviceContext, nodeId, uaValueNode, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    private boolean b(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        return this.jC.onWriteNonValue(serviceContext, nodeId, uaNode, unsignedInteger, dataValue);
    }

    private boolean a(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.jC.onWriteValue(serviceContext, nodeId, uaValueNode, numericRange, dataValue);
    }

    protected Object beginRead(ServiceContext serviceContext, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        return null;
    }

    protected Object beginWrite(ServiceContext serviceContext, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        return null;
    }

    protected void checkAccessLevel(ServiceContext serviceContext, Object object, NodeId nodeId, UaVariable uaVariable, AccessLevelType.Options options) throws StatusException {
        logger.debug("checkAccessLevel: variable={}", (Object)uaVariable);
        AccessLevelType accessLevelType = this.getAccessLevel(serviceContext, object, nodeId, uaVariable);
        logger.debug("variableAccessLevel={}", (Object)accessLevelType);
        if (accessLevelType == null || !accessLevelType.contains(options)) {
            throw new StatusException(String.format(Locale.ROOT, "AccessLevel of node '%s(ID=%s) does not enable %s'", uaVariable == null ? "" : uaVariable.getClass(), nodeId, options), options.equals(AccessLevelType.Options.CurrentRead) || options.equals(AccessLevelType.Options.HistoryRead) ? StatusCodes.Bad_NotReadable : StatusCodes.Bad_NotWritable);
        }
        AccessLevelType accessLevelType2 = this.getUserAccessLevel(serviceContext, object, nodeId, uaVariable);
        logger.debug("userAccessLevel={}", (Object)accessLevelType2);
        if (accessLevelType2 == null || !accessLevelType2.contains(options)) {
            throw new StatusException(String.format(Locale.ROOT, "UserAccessLevel of node '(ID=%s) does not enable %s'", nodeId, options), StatusCodes.Bad_UserAccessDenied);
        }
    }

    protected void checkDataType(NodeId nodeId, UaValueNode uaValueNode, DataValue dataValue) throws StatusException {
        NodeId nodeId2 = this.getVariableDataType(nodeId, uaValueNode);
        dataValue.setValue(this.autoConvert(dataValue.getValue(), nodeId2));
        if (!this.dataTypeEquals(dataValue.getValue(), nodeId2)) {
            throw new StatusException(StatusCodes.Bad_TypeMismatch);
        }
    }

    protected void checkExecutable(ServiceContext serviceContext, Object object, NodeId nodeId, UaMethod uaMethod) throws StatusException {
        logger.debug("checkExecutable: method={}, methodId={}", (Object)uaMethod, (Object)nodeId);
        boolean bl = this.getExecutable(serviceContext, object, nodeId, uaMethod);
        logger.debug("Executable={}", (Object)bl);
        if (!bl) {
            throw new StatusException(String.format(Locale.ROOT, "Node %s is not executable", nodeId), StatusCodes.Bad_NotExecutable);
        }
        boolean bl2 = this.getUserExecutable(serviceContext, object, nodeId, uaMethod);
        logger.debug("UserExecutable={}", (Object)bl2);
        if (!bl2) {
            throw new StatusException(String.format(Locale.ROOT, "Node %s is not executable by the user", nodeId), StatusCodes.Bad_UserAccessDenied);
        }
    }

    protected void checkSupportsAttribute(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger) throws StatusException {
        if (uaNode != null && !uaNode.supportsAttribute(unsignedInteger)) {
            throw new StatusException(String.format(Locale.ROOT, "Attribute '%s' not supported by node type '%s'", AttributesUtil.toString(unsignedInteger), uaNode.getClass()), StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    protected void checkWriteMask(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger) throws StatusException {
        logger.debug("checkWriteMask: node={}", (Object)uaNode);
        AttributeWriteMask attributeWriteMask = this.getWriteMask(serviceContext, object, nodeId, uaNode);
        logger.debug("checkWriteMask:nodeWriteMask={}", (Object)attributeWriteMask);
        if (attributeWriteMask == null || !AttributesUtil.hasAccessToAttribute(attributeWriteMask, unsignedInteger)) {
            throw new StatusException(String.format(Locale.ROOT, "Attribute '%s' not writable in node '%s(ID=%s)'", AttributesUtil.toString(unsignedInteger), uaNode.getClass(), nodeId), StatusCodes.Bad_NotWritable);
        }
        AttributeWriteMask attributeWriteMask2 = this.getUserWriteMask(serviceContext, object, nodeId, uaNode);
        if (attributeWriteMask2 == null || !AttributesUtil.hasAccessToAttribute(attributeWriteMask2, unsignedInteger)) {
            throw new StatusException(String.format(Locale.ROOT, "Attribute '%s' not user writable in node '(ID=%s)'", AttributesUtil.toString(unsignedInteger), nodeId), StatusCodes.Bad_UserAccessDenied);
        }
    }

    protected void endRead(ServiceContext serviceContext, Object object, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
    }

    protected void endWrite(ServiceContext serviceContext, Object object, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
    }

    protected AccessLevelType getAccessLevel(ServiceContext serviceContext, Object object, NodeId nodeId, UaVariable uaVariable) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readNonValue(serviceContext, object, nodeId, uaVariable, Attributes.AccessLevel, dataValue);
        if (dataValue.isNull() || dataValue.getStatusCode().isBad()) {
            return null;
        }
        Variant variant = dataValue.getValue();
        Object object2 = variant.getValue();
        if (object2 instanceof AccessLevelType) {
            return (AccessLevelType)object2;
        }
        return AccessLevelType.of((UnsignedByte)object2);
    }

    protected boolean getExecutable(ServiceContext serviceContext, Object object, NodeId nodeId, UaMethod uaMethod) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readNonValue(serviceContext, object, nodeId, uaMethod, Attributes.Executable, dataValue);
        if (dataValue.isNull() || dataValue.getStatusCode().isBad()) {
            return false;
        }
        Variant variant = dataValue.getValue();
        return variant.booleanValue();
    }

    protected AccessLevelType getUserAccessLevel(ServiceContext serviceContext, Object object, NodeId nodeId, UaVariable uaVariable) {
        return this.jC.onGetUserAccessLevel(serviceContext, nodeId, uaVariable);
    }

    protected boolean getUserExecutable(ServiceContext serviceContext, Object object, NodeId nodeId, UaMethod uaMethod) {
        return this.jC.onGetUserExecutable(serviceContext, nodeId, uaMethod);
    }

    protected AttributeWriteMask getUserWriteMask(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode) {
        return this.jC.onGetUserWriteMask(serviceContext, nodeId, uaNode);
    }

    protected NodeId getVariableDataType(NodeId nodeId, UaValueNode uaValueNode) throws StatusException {
        return this.getNodeManager().getVariableDataType(nodeId, uaValueNode);
    }

    protected AttributeWriteMask getWriteMask(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readNonValue(serviceContext, object, nodeId, uaNode, Attributes.WriteMask, dataValue);
        if (dataValue.isNull() || dataValue.getStatusCode().isBad()) {
            return null;
        }
        Variant variant = dataValue.getValue();
        Object object2 = variant.getValue();
        if (object2 instanceof AttributeWriteMask) {
            return (AttributeWriteMask)object2;
        }
        return AttributeWriteMask.of((UnsignedInteger)variant.getValue());
    }

    protected void initializeMonitoredDataItem(ServiceContext serviceContext, MonitoredDataItem monitoredDataItem, DataValue dataValue) throws StatusException {
        this.readAttribute(serviceContext, null, monitoredDataItem.getNodeId(), monitoredDataItem.getAttributeId(), monitoredDataItem.getIndexRange(), monitoredDataItem.getTimestampsToReturn(), DateTime.MIN_VALUE, dataValue);
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        UaNode uaNode = this.getNode(nodeId);
        if (unsignedInteger.equals(Attributes.Value)) {
            this.checkIsValueNode(uaNode);
            UaValueNode uaValueNode = (UaValueNode)uaNode;
            if (this.isVariable(uaValueNode)) {
                this.checkAccessLevel(serviceContext, object, nodeId, (UaVariable)uaValueNode, AccessLevelType.Options.CurrentRead);
            }
            this.readValue(serviceContext, object, nodeId, uaValueNode, numericRange, timestampsToReturn, dateTime, dataValue);
            this.a(serviceContext, object, nodeId, uaValueNode, numericRange, timestampsToReturn, dateTime, dataValue);
            return;
        }
        dataValue.setStatusCode(StatusCode.GOOD);
        if (unsignedInteger.equals(Attributes.AccessLevel)) {
            this.checkIsVariable(uaNode);
            UaVariable uaVariable = (UaVariable)uaNode;
            AccessLevelType accessLevelType = this.getAccessLevel(serviceContext, object, nodeId, uaVariable);
            dataValue.setValue(new Variant(accessLevelType.asBuiltInType()));
        } else if (unsignedInteger.equals(Attributes.UserAccessLevel)) {
            this.checkIsVariable(uaNode);
            UaVariable uaVariable = (UaVariable)uaNode;
            AccessLevelType accessLevelType = this.getUserAccessLevel(serviceContext, object, nodeId, uaVariable);
            AccessLevelType accessLevelType2 = this.getAccessLevel(serviceContext, object, nodeId, uaVariable);
            if (accessLevelType2 != null && accessLevelType != null) {
                Set<AccessLevelType.Options> set = accessLevelType.toSet();
                set.retainAll(accessLevelType2.toSet());
                accessLevelType = AccessLevelType.of(set);
            }
            dataValue.setValue(new Variant(accessLevelType.asBuiltInType()));
        } else if (unsignedInteger.equals(Attributes.Executable)) {
            this.checkIsMethod(uaNode);
            boolean bl = this.getExecutable(serviceContext, object, nodeId, (UaMethod)uaNode);
            dataValue.setValue(new Variant(bl));
        } else if (unsignedInteger.equals(Attributes.UserExecutable)) {
            this.checkIsMethod(uaNode);
            boolean bl = this.getUserExecutable(serviceContext, object, nodeId, (UaMethod)uaNode);
            boolean bl2 = this.getExecutable(serviceContext, object, nodeId, (UaMethod)uaNode);
            dataValue.setValue(new Variant(bl && bl2));
        } else if (unsignedInteger.equals(Attributes.WriteMask)) {
            AttributeWriteMask attributeWriteMask = this.getWriteMask(serviceContext, object, nodeId, uaNode);
            dataValue.setValue(new Variant(attributeWriteMask == null ? AttributeWriteMask.of() : attributeWriteMask));
        } else if (unsignedInteger.equals(Attributes.UserWriteMask)) {
            AttributeWriteMask attributeWriteMask = this.getUserWriteMask(serviceContext, object, nodeId, uaNode);
            AttributeWriteMask attributeWriteMask2 = this.getWriteMask(serviceContext, object, nodeId, uaNode);
            if (attributeWriteMask2 != null && attributeWriteMask != null) {
                Set<AttributeWriteMask.Options> set = attributeWriteMask.toSet();
                set.retainAll(attributeWriteMask2.toSet());
                attributeWriteMask = AttributeWriteMask.of(set);
            }
            dataValue.setValue(new Variant(attributeWriteMask == null ? AttributeWriteMask.of() : attributeWriteMask));
        } else {
            this.readNonValue(serviceContext, object, nodeId, uaNode, unsignedInteger, dataValue);
        }
        dataValue.setServerTimestamp(new DateTime());
        this.a(serviceContext, object, nodeId, uaNode, unsignedInteger, dataValue);
    }

    protected void readNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
    }

    protected void readValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        logger.debug("writeAttribute: nodeId={}; attributeId={}; indexRange={}; value={}", new Object[]{nodeId, unsignedInteger, numericRange, dataValue});
        UaNode uaNode = this.getNode(nodeId);
        if (unsignedInteger.equals(Attributes.Value)) {
            this.checkIsValueNode(uaNode);
            UaValueNode uaValueNode = (UaValueNode)uaNode;
            if (this.isVariable(uaValueNode)) {
                this.checkAccessLevel(serviceContext, object, nodeId, (UaVariable)uaValueNode, AccessLevelType.Options.CurrentWrite);
            } else {
                this.checkWriteMask(serviceContext, object, nodeId, uaValueNode, Attributes.Value);
            }
            this.checkDataType(nodeId, uaValueNode, dataValue);
            return this.a(serviceContext, object, nodeId, uaValueNode, numericRange, dataValue) || this.writeValue(serviceContext, object, nodeId, uaValueNode, numericRange, dataValue);
        }
        logger.debug("checking that node supports attribute");
        this.checkSupportsAttribute(serviceContext, nodeId, uaNode, unsignedInteger);
        logger.debug("node does support attribute, checking writeMask");
        this.checkWriteMask(serviceContext, object, nodeId, uaNode, unsignedInteger);
        logger.debug("node supports writing attribute");
        return this.b(serviceContext, object, nodeId, uaNode, unsignedInteger, dataValue) || this.writeNonValue(serviceContext, object, nodeId, uaNode, unsignedInteger, dataValue);
    }

    protected boolean writeNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        return false;
    }

    protected boolean writeValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return false;
    }
}

