/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ModelChangeStructureDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GeneralModelChangeEvent {
    private final Collection<UaNode> iU = new HashSet<UaNode>();
    private final List<ModelChangeStructureDataType> iV = new ArrayList<ModelChangeStructureDataType>();
    private final Map<NodeId, ModelChangeStructureDataType> iW = new HashMap<NodeId, ModelChangeStructureDataType>();
    private final NamespaceTable iX;

    public GeneralModelChangeEvent(NamespaceTable namespaceTable) {
        this.iX = namespaceTable;
    }

    public synchronized void addChange(NodeId nodeId, NodeId nodeId2, int n2) {
        ModelChangeStructureDataType modelChangeStructureDataType = this.iW.get(nodeId);
        if (modelChangeStructureDataType != null) {
            modelChangeStructureDataType.setVerb(UnsignedByte.valueOf(modelChangeStructureDataType.getVerb().getValue() | n2));
        } else {
            modelChangeStructureDataType = new ModelChangeStructureDataType(nodeId, nodeId2, UnsignedByte.valueOf(n2));
            this.iW.put(nodeId, modelChangeStructureDataType);
            this.iV.add(modelChangeStructureDataType);
        }
    }

    public void addChange(NodeId nodeId, NodeId nodeId2, ModelChangeType ... modelChangeTypeArray) {
        int n2 = 0;
        for (ModelChangeType modelChangeType : modelChangeTypeArray) {
            n2 |= modelChangeType.getValue();
        }
        this.addChange(nodeId, nodeId2, n2);
    }

    public synchronized void addChange(NodeId nodeId, NodeId nodeId2, UnsignedByte unsignedByte) {
        this.addChange(nodeId, nodeId2, unsignedByte.getValue());
    }

    public void addChange(UaNode uaNode, ModelChangeType ... modelChangeTypeArray) {
        NodeId nodeId = uaNode.getNodeId();
        NodeId nodeId2 = NodeId.NULL;
        if (uaNode instanceof UaInstance) {
            try {
                nodeId2 = this.iX.toNodeId(((UaInstance)uaNode).getTypeDefinitionId());
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        this.addAffectedNode(uaNode);
        this.addChange(nodeId, nodeId2, modelChangeTypeArray);
    }

    public void addChanges(List<ModelChangeStructureDataType> list) {
        for (ModelChangeStructureDataType modelChangeStructureDataType : list) {
            this.addChange(modelChangeStructureDataType.getAffected(), modelChangeStructureDataType.getAffectedType(), modelChangeStructureDataType.getVerb());
        }
    }

    public void addChanges(ModelChangeStructureDataType[] modelChangeStructureDataTypeArray) {
        if (modelChangeStructureDataTypeArray != null) {
            this.addChanges(Arrays.asList(modelChangeStructureDataTypeArray));
        }
    }

    public synchronized void clearChanges() {
        this.iU.clear();
        this.iW.clear();
        this.iV.clear();
    }

    public synchronized UaNode[] getAffectedNodes() {
        return this.iU.toArray(new UaNode[0]);
    }

    public synchronized ModelChangeStructureDataType[] getChanges() {
        return this.iV.toArray(new ModelChangeStructureDataType[this.iV.size()]);
    }

    public synchronized boolean hasChanges() {
        return !this.iV.isEmpty();
    }

    public synchronized boolean hasChanges(NodeId nodeId) {
        return this.iW.containsKey(nodeId);
    }

    public synchronized void setChanges(ModelChangeStructureDataType[] modelChangeStructureDataTypeArray) {
        this.clearChanges();
        this.addChanges(modelChangeStructureDataTypeArray);
    }

    public void updateNodeVersions() {
        for (UaNode uaNode : this.getAffectedNodes()) {
            if (!(uaNode instanceof BaseNode)) continue;
            BaseNode baseNode = (BaseNode)uaNode;
            try {
                baseNode.incNodeVersion();
            }
            catch (NumberFormatException numberFormatException) {
                baseNode.setNodeVersion("1");
            }
        }
    }

    protected void addAffectedNode(UaNode uaNode) {
        if (uaNode != null) {
            this.iU.add(uaNode);
        }
    }
}

