/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.c;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.SessionDiagnosticsDataType;
import com.prosysopc.ua.stack.core.SessionSecurityDiagnosticsDataType;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionDiagnosticsDataType;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionsDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsTypeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticsManager {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsManager.class);
    private final AtomicBoolean iu = new AtomicBoolean(false);
    private SubscriptionDiagnosticsArrayTypeNode iv;
    private boolean iw = true;
    private final UaServer hz;
    private ServerDiagnosticsTypeNode ix;
    private final c iy = new c();
    private final Map<Session, SessionDiagnosticsObjectTypeNode> iz = new ConcurrentHashMap<Session, SessionDiagnosticsObjectTypeNode>();
    private SessionsDiagnosticsSummaryTypeNode iA;
    private final Map<Subscription, SubscriptionDiagnosticsTypeNode> iB = new ConcurrentHashMap<Subscription, SubscriptionDiagnosticsTypeNode>();
    private volatile boolean iC = this.iu.get();

    protected DiagnosticsManager(UaServer uaServer) {
        this.hz = uaServer;
    }

    public boolean isEnabled() {
        return this.iu.get();
    }

    public boolean isRemoveSamplingIntervalDiagnosticsArrayOnStart() {
        return this.iw;
    }

    public void setRemoveSamplingIntervalDiagnosticsArrayOnStart(boolean bl) {
        this.iw = bl;
    }

    private void a(Collection<Session> collection, SessionDiagnosticsArrayTypeNode sessionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionDiagnosticsDataType> arrayList = new ArrayList<SessionDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iz.get(session);
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionDiagnostics());
            }
            sessionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private void a(Collection<Session> collection, SessionSecurityDiagnosticsArrayTypeNode sessionSecurityDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionSecurityDiagnosticsDataType> arrayList = new ArrayList<SessionSecurityDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iz.get(session);
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnostics());
            }
            sessionSecurityDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionSecurityDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private void a(Collection<Subscription> collection, SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SubscriptionDiagnosticsDataType> arrayList = new ArrayList<SubscriptionDiagnosticsDataType>();
            for (Subscription subscription : collection) {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.iB.get(subscription);
                if (subscriptionDiagnosticsTypeNode == null) continue;
                arrayList.add((SubscriptionDiagnosticsDataType)subscriptionDiagnosticsTypeNode.getValue().getValue().getValue());
            }
            subscriptionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SubscriptionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private SubscriptionManager getSubscriptionManager() {
        return this.hz.getSubscriptionManager();
    }

    private void cjM() throws StatusException {
        this.ix = this.hz.getNodeManagerRoot().getServerData().getServerDiagnosticsNode();
        this.iA = this.ix.getSessionsDiagnosticsSummaryNode();
        this.iv = this.ix.getSubscriptionDiagnosticsArrayNode();
        DataChangeListener dataChangeListener = new DataChangeListener(){

            @Override
            public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
                if (dataValue2.isNull()) {
                    return;
                }
                boolean bl = dataValue2.getValue().booleanValue();
                DiagnosticsManager.this.iu.set(bl);
                if (bl) {
                    DiagnosticsManager.this.onDiagnosticsEnabled();
                } else {
                    DiagnosticsManager.this.onDiagnosticsDisabled();
                }
            }
        };
        this.ix.addEnabledChangeListener(dataChangeListener);
        DataValue dataValue = this.ix.getEnabledFlagNode().getValue();
        if (dataValue != null && !dataValue.isNull() && ((Boolean)dataValue.getValue().getValue()).booleanValue()) {
            dataChangeListener.onDataChange(this.ix, null, dataValue);
        }
    }

    private void cjN() {
        try {
            UaNode uaNode = this.hz.getNodeManagerRoot().getNode(Identifiers.ViewsFolder);
            this.iy.ckS().set(uaNode.getComponents().length);
            this.cjP();
        }
        catch (StatusException statusException) {
            logger.warn("ViewsFolder not available", (Throwable)statusException);
        }
    }

    private void cjO() {
        DataValue dataValue = new DataValue(StatusCode.valueOf(StatusCodes.Bad_NotReadable));
        try {
            for (NodeId nodeId : this.hz.getNodeManagerRoot().cks()) {
                UaVariable uaVariable = (UaVariable)this.hz.getAddressSpace().getNode(nodeId);
                uaVariable.setValue(dataValue);
            }
        }
        catch (Exception exception) {
            logger.error("Could not update diagnostics", (Throwable)exception);
        }
    }

    private void cjP() {
        if (this.isEnabled()) {
            try {
                this.ix.setServerDiagnosticsSummary(this.iy.ckI());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    protected void addSession(Session session) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hz.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.iz.put(session, sessionDiagnosticsObjectTypeNode);
                this.iA.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.iA.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.iA.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.iy.ckL().incrementAndGet();
                this.cjQ();
                this.cjP();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        } else {
            this.cjQ();
        }
    }

    protected void addSessionNoIncrement(Session session) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hz.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.iz.put(session, sessionDiagnosticsObjectTypeNode);
                this.iA.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.iA.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.iA.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.iy.ckL().incrementAndGet();
                this.cjP();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        }
    }

    protected void addSubscription(Session session, Subscription subscription) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        if (this.isEnabled()) {
            try {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.hz.getNodeManagerUaServer().createInstance(SubscriptionDiagnosticsTypeNode.class, subscription.getSubscriptionId().toString(), NodeId.randomGUID(this.hz.getNodeManagerUaServer().getNamespaceIndex()));
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.iB.put(subscription, subscriptionDiagnosticsTypeNode);
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iz.get(session);
                logger.trace("addSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.ix.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.updateSubscription(subscription);
                this.cjR();
                this.iy.ckM().incrementAndGet();
                this.cjP();
                session.getSessionDiagnostics().clo().incrementAndGet();
            }
            catch (Exception exception) {
                logger.error("Could not add diagnostics node", (Throwable)exception);
            }
        } else {
            this.cjR();
        }
    }

    protected void close() {
        logger.debug("close");
        if (this.ix != null) {
            this.ix.setEnabled(false);
        }
        this.ix = null;
    }

    protected void onDiagnosticsDisabled() {
        if (this.iC) {
            for (Subscription object : this.hz.getSubscriptionManager().getSubscriptions()) {
                this.removeSubscription(object.getSession(), object);
            }
            for (Session session : this.hz.getSessionManager().getSessions()) {
                this.removeSession(session);
            }
            this.cjO();
        } else {
            logger.trace("Diagnostics is disabled, onDiagnosticsDisabled aborted");
        }
        this.iC = false;
    }

    protected void onDiagnosticsEnabled() {
        if (!this.iC) {
            for (Session iterator : this.hz.getSessionManager().getSessions()) {
                iterator.resetDiagnostics();
                this.hz.getDiagnosticsManager().addSessionNoIncrement(iterator);
            }
            this.iy.ckL().set(this.hz.getSessionManager().getSessionCount());
            SubscriptionManager subscriptionManager = this.getSubscriptionManager();
            this.iy.ckM().set(0L);
            this.cjP();
            for (Subscription subscription : subscriptionManager.getSubscriptions()) {
                if (Session.INTERNAL_SESSION == subscription.getSession()) continue;
                subscription.getSession().getSessionDiagnostics().clo().set(0L);
            }
            for (Subscription subscription : subscriptionManager.getSubscriptions()) {
                subscription.getDiagnostics().clR();
                this.addSubscription(subscription.getSession(), subscription);
                if (Session.INTERNAL_SESSION == subscription.getSession()) continue;
                subscription.getSession().getSessionDiagnostics().clm().set(subscription.getItemCount());
            }
            this.cjN();
        } else {
            logger.trace("Diagnostics is enabled, onDiagnosticsEnabled aborted");
        }
        this.iC = true;
    }

    protected void removeSession(Session session) {
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iz.remove(session);
        logger.trace("removeSession, session: {}, diag: {}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
        if (sessionDiagnosticsObjectTypeNode != null) {
            try {
                logger.trace("removeSession, deleting diagnostics nodes");
                this.iA.getSessionDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.iA.getSessionSecurityDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.iA.removeComponent(sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getNodeManager().deleteNode(sessionDiagnosticsObjectTypeNode, true, true);
                logger.trace("removeSession, deleted diagnostics nodes");
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", (Throwable)exception);
            }
        }
        if (this.ix != null && this.ix.isEnabled()) {
            this.iy.ckL().set(this.hz.getSessionManager().getSessionCount());
            this.cjP();
        }
    }

    protected void removeSubscription(Session session, Subscription subscription) {
        logger.trace("removeSubscription, session: {}, subscription {}", (Object)session, (Object)subscription);
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.iB.remove(subscription);
        if (subscriptionDiagnosticsTypeNode != null) {
            try {
                if (session != null) {
                    SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iz.get(session);
                    logger.trace("removeSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                    if (sessionDiagnosticsObjectTypeNode != null) {
                        sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                    }
                }
                this.ix.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                subscriptionDiagnosticsTypeNode.getNodeManager().deleteNode(subscriptionDiagnosticsTypeNode, true, true);
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", (Throwable)exception);
            }
        }
        if (this.isEnabled()) {
            try {
                this.iy.ckM().decrementAndGet();
                this.cjP();
                if (session.getSessionDiagnostics() != null) {
                    session.getSessionDiagnostics().clo().decrementAndGet();
                    session.updateDiagnostics();
                }
                this.a(this.iB.keySet(), this.iv);
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        }
    }

    protected void start() throws StatusException {
        logger.debug("start");
        if (this.iw) {
            try {
                this.hz.getNodeManagerRoot().deleteNode(Identifiers.Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray, true, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cjM();
    }

    protected void updateSession(Session session) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        logger.trace("updateSession, session: {}", (Object)session);
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iz.get(session);
        if (this.isEnabled() && sessionDiagnosticsObjectTypeNode != null) {
            try {
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.a(this.iz.keySet(), this.iA.getSessionDiagnosticsArrayNode());
                this.a(this.iz.keySet(), this.iA.getSessionSecurityDiagnosticsArrayNode());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    protected void updateSubscription(Subscription subscription) {
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.iB.get(subscription);
        if (this.isEnabled() && subscriptionDiagnosticsTypeNode != null) {
            try {
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.a(this.iB.keySet(), this.iv);
                Session session = subscription.getSession();
                if (session == null) {
                    return;
                }
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iz.get(session);
                logger.debug("diag object debug: {}, session: {}, subscription", new Object[]{sessionDiagnosticsObjectTypeNode, session, subscription});
                if (sessionDiagnosticsObjectTypeNode == null) {
                    return;
                }
                SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode();
                if (subscriptionDiagnosticsArrayTypeNode != null) {
                    this.a(session.cla(), subscriptionDiagnosticsArrayTypeNode);
                }
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    void cjQ() {
        this.iy.ckJ().incrementAndGet();
        this.cjP();
    }

    void cjR() {
        this.iy.ckK().incrementAndGet();
        this.cjP();
    }

    void cjS() {
        this.iy.ckP().incrementAndGet();
        this.cjP();
    }

    void cjT() {
        this.iy.ckR().incrementAndGet();
        this.cjP();
    }

    void cjU() {
        this.iy.ckU().incrementAndGet();
        this.cjP();
    }
}

