/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaBrowsePath;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.UaReferenceTypeIds;
import com.prosysopc.ua.UaRelativePath;
import com.prosysopc.ua.UaRelativePathElement;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.BrowsePath;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public interface UaNode {
    public UaReference addComponent(UaNode var1);

    default public UaReference addOrganizes(UaNode uaNode) {
        return this.addReference(uaNode, ReferenceTypeIdentifiers.Organizes);
    }

    public UaReference addProperty(UaProperty var1);

    default public UaReference addReference(ExpandedNodeId expandedNodeId, NodeId nodeId) {
        return this.addReference(expandedNodeId, nodeId, false);
    }

    public UaReference addReference(ExpandedNodeId var1, NodeId var2, boolean var3);

    default public UaReference addReference(NodeId nodeId, NodeId nodeId2) {
        return this.addReference(nodeId, nodeId2, false);
    }

    public UaReference addReference(NodeId var1, NodeId var2, boolean var3);

    default public UaReference addReference(UaNode uaNode, NodeId nodeId) {
        return this.addReference(uaNode, nodeId, false);
    }

    public UaReference addReference(UaNode var1, NodeId var2, boolean var3);

    public UaReference deleteReference(ExpandedNodeId var1, NodeId var2, boolean var3);

    public UaReference deleteReference(NodeId var1, NodeId var2, boolean var3);

    public UaReference deleteReference(UaNode var1, NodeId var2, boolean var3);

    public UaReference deleteReference(UaReference var1);

    public UaAddressSpace getAddressSpace();

    public NodeAttributes getAttributes();

    public Map<UnsignedInteger, Object> getAttributesMap();

    public QualifiedName getBrowseName();

    default public List<BrowsePath> getBrowsePaths() {
        ArrayList<BrowsePath> arrayList = new ArrayList<BrowsePath>();
        List<UaBrowsePath> list = this.getUaBrowsePaths();
        for (UaBrowsePath uaBrowsePath : list) {
            arrayList.add(uaBrowsePath.toBrowsePath(this.getAddressSpace().getNamespaceTable()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public UaNode getComponent(QualifiedName var1);

    public UaNode[] getComponents();

    public LocalizedText getDescription();

    public LocalizedText getDisplayName();

    public UaReference[] getForwardReferences(NodeId ... var1);

    public UaReference[] getInverseReferences(NodeId ... var1);

    public UaMethod getMethod(QualifiedName var1) throws ClassCastException;

    public NodeClass getNodeClass();

    public NodeId getNodeId();

    public UaProperty getNodeVersionNode();

    public UaProperty[] getProperties();

    public UaProperty getProperty(QualifiedName var1);

    public UaReference getReference(NodeId var1, boolean var2);

    public UaReference[] getReferences();

    public UaReference[] getReferences(NodeId var1, boolean var2);

    public UnsignedInteger[] getSupportedAttributes();

    default public List<UaBrowsePath> getUaBrowsePaths() {
        ArrayList<UaBrowsePath> arrayList = new ArrayList<UaBrowsePath>();
        UaReference[] uaReferenceArray = this.getInverseReferences(ReferenceTypeIdentifiers.Aggregates);
        if (uaReferenceArray != null && uaReferenceArray.length > 0) {
            UaRelativePathElement uaRelativePathElement = UaRelativePathElement.builder().setIncludeSubtypes(true).setIsInverse(false).setReferenceTypeId(UaReferenceTypeIds.Aggregates).setTargetName(UaQualifiedName.from(this.getBrowseName(), this.getAddressSpace().getNamespaceTable())).build();
            for (int i2 = 0; i2 < uaReferenceArray.length; ++i2) {
                UaNode uaNode = uaReferenceArray[i2].getSourceNode();
                uaNode.getUaBrowsePaths().forEach(uaBrowsePath -> arrayList.add(uaBrowsePath.append(uaRelativePathElement)));
            }
        } else {
            arrayList.add(UaBrowsePath.from(UaNodeId.fromLocal(this.getNodeId(), this.getAddressSpace().getNamespaceTable()), UaRelativePath.EMPTY));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public AttributeWriteMask getUserWriteMask();

    public AttributeWriteMask getWriteMask();

    public boolean hasUserWriteAccess(UnsignedInteger var1);

    public boolean hasWriteAccess(UnsignedInteger var1);

    public DataValue readAttribute(UnsignedInteger var1);

    public void readAttribute(UnsignedInteger var1, DataValue var2, Locale var3);

    public UaNode removeComponent(UaNode var1);

    public UaProperty removeProperty(QualifiedName var1);

    public void setAttribute(UnsignedInteger var1, DataValue var2) throws StatusException;

    public void setAttributes(NodeAttributes var1);

    public void setBrowseName(QualifiedName var1);

    public void setDescription(LocalizedText var1);

    public void setDisplayName(LocalizedText var1);

    public void setReferences(UaReference[] var1);

    public void setUserWriteMask(AttributeWriteMask var1);

    public void setWriteMask(AttributeWriteMask var1);

    public boolean supportsAttribute(UnsignedInteger var1);

    public boolean writeAttribute(UnsignedInteger var1, DataValue var2) throws StatusException;

    public static interface Parameters {
        public UaAddressSpace getAddressSpace();

        public UaQualifiedName getBrowseName();

        public LocalizedText getDisplayName();

        public UaNodeId getNodeId();
    }
}

