/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.MonitoredItemErrorListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredItem
extends MonitoredItemBase {
    private static AtomicInteger fr = new AtomicInteger(0);
    protected static final Logger logger = LoggerFactory.getLogger(MonitoredItem.class);
    private StatusCode fs;
    private ExpandedNodeId ft;
    private boolean modified;
    private boolean fu;
    private Subscription fv;
    private StatusCode fw = null;
    private volatile MonitoredItemErrorListener fx = null;

    private static UnsignedInteger ciL() {
        return UnsignedInteger.valueOf(fr.incrementAndGet());
    }

    protected MonitoredItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.ciL(), null, null, unsignedInteger, monitoringMode);
        this.ft = expandedNodeId;
    }

    protected MonitoredItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.ciL(), null, nodeId, unsignedInteger, monitoringMode);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MonitoredItem monitoredItem = (MonitoredItem)object;
            return this.fv == monitoredItem.fv;
        }
        return false;
    }

    public StatusCode getErrorCode() {
        return this.fs;
    }

    public MonitoredItemErrorListener getErrorListener() {
        return this.fx;
    }

    public ExpandedNodeId getExpandedNodeId() {
        return this.ft;
    }

    public StatusCode getInitialStatus() {
        return this.fw;
    }

    @Override
    public NodeId getNodeId() {
        if (this.ft != null) {
            try {
                return this.getSubscription().getClient().getNamespaceTable().toNodeId(this.ft);
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        return super.getNodeId();
    }

    public Subscription getSubscription() {
        return this.fv;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isMonitoringModeModified() {
        return this.fu;
    }

    public void setErrorListener(MonitoredItemErrorListener monitoredItemErrorListener) {
        this.fx = monitoredItemErrorListener;
    }

    protected void clearModified() {
        this.modified = false;
    }

    protected void clearMonitoringModeModified() {
        this.fu = false;
    }

    protected void fireError(StatusCode statusCode) {
        MonitoredItemErrorListener monitoredItemErrorListener = this.fx;
        if (monitoredItemErrorListener != null) {
            monitoredItemErrorListener.onError(this, statusCode);
        }
    }

    @Override
    protected String getNodeIdAsString() {
        if (this.ft != null) {
            return this.ft.toString();
        }
        return super.getNodeIdAsString();
    }

    protected void itemChanged() throws ServiceException {
        if (this.fv != null) {
            if (this.fv.isConnected()) {
                this.modified = true;
            }
            this.fv.itemChanged(this);
        }
    }

    @Override
    protected void monitoringModeChanged() throws ServiceException {
        super.monitoringModeChanged();
        if (this.fv != null) {
            if (this.fv.isConnected()) {
                this.fu = true;
            }
            this.fv.monitoringModeChanged(this);
        }
    }

    protected void setClientHandle(int n2) {
        this.clientHandle = UnsignedInteger.valueOf(n2);
    }

    protected void setErrorCode(StatusCode statusCode) {
        StatusCode statusCode2 = this.fs;
        this.fs = statusCode;
        if (this.fw == null) {
            this.fw = statusCode;
        }
        if (!Objects.equals(statusCode, statusCode2)) {
            this.fireError(statusCode);
        }
    }

    @Override
    protected void setFilterResult(MonitoringFilterResult monitoringFilterResult) {
        super.setFilterResult(monitoringFilterResult);
    }

    @Override
    protected void setMonitoredItemId(UnsignedInteger unsignedInteger) {
        super.setMonitoredItemId(unsignedInteger);
    }

    protected void setRevisedQueueSize(UnsignedInteger unsignedInteger) {
        this.queueSize = unsignedInteger.longValue();
    }

    @Override
    protected void updateFilter() throws ServiceException {
        super.updateFilter();
        this.itemChanged();
    }

    @Override
    protected void updateQueue() throws ServiceException {
        super.updateQueue();
        this.itemChanged();
    }

    void a(Subscription subscription) {
        this.fv = subscription;
    }
}

