/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.RelativePathElement;
import java.util.Objects;

public final class UaRelativePathElement {
    private final UaNodeId ed;
    private final Boolean ee;
    private final Boolean ef;
    private final UaQualifiedName eg;

    public static Builder builder() {
        return new Builder();
    }

    public static UaRelativePathElement from(RelativePathElement relativePathElement, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        if (relativePathElement == null) {
            return null;
        }
        Builder builder = UaRelativePathElement.builder();
        builder.setIncludeSubtypes(relativePathElement.getIncludeSubtypes());
        builder.setIsInverse(relativePathElement.getIsInverse());
        builder.setReferenceTypeId(UaNodeId.fromLocal(relativePathElement.getReferenceTypeId(), namespaceTable));
        builder.setTargetName(UaQualifiedName.from(relativePathElement.getTargetName(), namespaceTable));
        return builder.build();
    }

    private UaRelativePathElement(UaNodeId uaNodeId, Boolean bl, Boolean bl2, UaQualifiedName uaQualifiedName) {
        this.ed = uaNodeId;
        this.ee = bl;
        this.ef = bl2;
        this.eg = uaQualifiedName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UaRelativePathElement)) {
            return false;
        }
        UaRelativePathElement uaRelativePathElement = (UaRelativePathElement)object;
        return Objects.equals(this.ef, uaRelativePathElement.ef) && Objects.equals(this.ee, uaRelativePathElement.ee) && Objects.equals(this.ed, uaRelativePathElement.ed) && Objects.equals(this.eg, uaRelativePathElement.eg);
    }

    public Boolean getIncludeSubtypes() {
        return this.ef;
    }

    public Boolean getIsInverse() {
        return this.ee;
    }

    public UaNodeId getReferenceTypeId() {
        return this.ed;
    }

    public UaQualifiedName getTargetName() {
        return this.eg;
    }

    public int hashCode() {
        return Objects.hash(this.ef, this.ee, this.ed, this.eg);
    }

    public Builder toBuilder() {
        Builder builder = UaRelativePathElement.builder();
        builder.setIncludeSubtypes(this.ef);
        builder.setIsInverse(this.ee);
        builder.setReferenceTypeId(this.ed);
        builder.setTargetName(this.eg);
        return builder;
    }

    public RelativePathElement toRelativePathElement(NamespaceTable namespaceTable) {
        RelativePathElement.Builder builder = RelativePathElement.builder();
        builder.setIncludeSubtypes(this.ef);
        builder.setIsInverse(this.ee);
        builder.setReferenceTypeId(NodeId.from(this.ed, namespaceTable));
        builder.setTargetName(QualifiedName.from(this.eg, namespaceTable));
        return builder.build();
    }

    public String toString() {
        return "UaRelativePathElement [referenceTypeId=" + this.ed + ", isInverse=" + this.ee + ", includeSubtypes=" + this.ef + ", targetName=" + this.eg + "]";
    }

    public static final class Builder {
        private UaNodeId ed;
        private Boolean ee;
        private Boolean ef;
        private UaQualifiedName eg;

        private Builder() {
        }

        public UaRelativePathElement build() {
            return new UaRelativePathElement(this.ed, this.ee, this.ef, this.eg);
        }

        public Boolean getIncludeSubtypes() {
            return this.ef;
        }

        public Boolean getIsInverse() {
            return this.ee;
        }

        public UaNodeId getReferenceTypeId() {
            return this.ed;
        }

        public UaQualifiedName getTargetName() {
            return this.eg;
        }

        public Builder setIncludeSubtypes(Boolean bl) {
            this.ef = bl;
            return this;
        }

        public Builder setIsInverse(Boolean bl) {
            this.ee = bl;
            return this;
        }

        public Builder setReferenceTypeId(UaNodeId uaNodeId) {
            this.ed = uaNodeId;
            return this;
        }

        public Builder setTargetName(UaQualifiedName uaQualifiedName) {
            this.eg = uaQualifiedName;
            return this;
        }
    }
}

