/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.InternalNamespaceUtils;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import java.util.Comparator;

public class UaQualifiedName
implements Comparable<UaQualifiedName> {
    private static final UaQualifiedName[] eb = new UaQualifiedName[0];
    private final UaNamespace cV;
    private final String name;

    public static UaQualifiedName[] arrayFrom(QualifiedName[] qualifiedNameArray, NamespaceTable namespaceTable) {
        if (qualifiedNameArray == null) {
            return null;
        }
        if (qualifiedNameArray.length == 0) {
            return eb;
        }
        UaQualifiedName[] uaQualifiedNameArray = new UaQualifiedName[qualifiedNameArray.length];
        for (int i2 = 0; i2 < qualifiedNameArray.length; ++i2) {
            uaQualifiedNameArray[i2] = UaQualifiedName.from(qualifiedNameArray[i2], namespaceTable);
        }
        return uaQualifiedNameArray;
    }

    public static UaQualifiedName from(QualifiedName qualifiedName, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "NamespaceTable");
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given NamespaceTable cannot be null");
        }
        if (qualifiedName == null) {
            return null;
        }
        UaNamespace uaNamespace = InternalNamespaceUtils.getNamespaceOrUseInvalidPattern(qualifiedName.getNamespaceIndex(), namespaceTable);
        return UaQualifiedName.from(uaNamespace, qualifiedName.getName());
    }

    public static UaQualifiedName from(String string, String string2) {
        return new UaQualifiedName(UaNamespace.from(string), string2);
    }

    public static UaQualifiedName from(UaNamespace uaNamespace, String string) {
        if (uaNamespace == null) {
            throw new IllegalArgumentException("The given namespace cannot be null");
        }
        return new UaQualifiedName(uaNamespace, string);
    }

    public static UaQualifiedName parse(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("nsu=")) {
            throw new IllegalArgumentException("The given String doesn't start with nsu=, given String: " + string);
        }
        int n2 = string.indexOf(";name=");
        if (n2 < 0) {
            throw new IllegalArgumentException("The given String doesn't have ';name=' that would separate namespaceuri and the name part, given String: " + string);
        }
        String string2 = string.substring(4, n2);
        String string3 = string.substring(n2 + 6);
        return UaQualifiedName.from(string2, string3);
    }

    public static UaQualifiedName standard(String string) {
        return new UaQualifiedName(UaNamespace.STANDARD, string);
    }

    private UaQualifiedName(UaNamespace uaNamespace, String string) {
        if (uaNamespace == null) {
            throw new IllegalArgumentException("Given namespace cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Given name cannot be null");
        }
        this.cV = uaNamespace;
        this.name = string;
    }

    @Override
    public int compareTo(UaQualifiedName uaQualifiedName) {
        if (this == uaQualifiedName) {
            return 0;
        }
        int n2 = this.cV.compareTo(uaQualifiedName.cV);
        if (n2 != 0) {
            return n2;
        }
        return Comparator.nullsFirst((string, string2) -> string.compareTo((String)string2)).compare(this.name, uaQualifiedName.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaQualifiedName uaQualifiedName = (UaQualifiedName)object;
        if (this.name == null ? uaQualifiedName.name != null : !this.name.equals(uaQualifiedName.name)) {
            return false;
        }
        return !(this.cV == null ? uaQualifiedName.cV != null : !this.cV.equals(uaQualifiedName.cV));
    }

    public String getName() {
        return this.name;
    }

    public UaNamespace getNamespace() {
        return this.cV;
    }

    public String getNamespaceUri() {
        return this.cV.getURI();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + (this.cV == null ? 0 : this.cV.hashCode());
        return n3;
    }

    public QualifiedName toQualifiedName(NamespaceTable namespaceTable) {
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        try {
            int n2 = InternalNamespaceUtils.getIndexFromPotentialInvalidPattern(this.cV.getURI(), namespaceTable);
            return new QualifiedName(n2, this.name);
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("Cannot find Namespace to URI mapping in given table, uri:" + this.cV, serviceResultException);
        }
    }

    public String toString() {
        return "nsu=" + UaNamespace.encodeNamespaceUri(this.getNamespaceUri()) + ";name=" + this.name;
    }
}

