/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaRelativePath;
import com.prosysopc.ua.UaRelativePathElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.BrowsePath;

public class UaBrowsePath {
    private final UaNodeId cQ;
    private final UaRelativePath cS;

    public static UaBrowsePath from(BrowsePath browsePath, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        if (browsePath == null) {
            return null;
        }
        return new UaBrowsePath(UaNodeId.fromLocal(browsePath.getStartingNode(), namespaceTable), UaRelativePath.from(browsePath.getRelativePath(), namespaceTable));
    }

    public static UaBrowsePath from(UaNodeId uaNodeId, UaRelativePath uaRelativePath) {
        return new UaBrowsePath(uaNodeId, uaRelativePath);
    }

    private UaBrowsePath(UaNodeId uaNodeId, UaRelativePath uaRelativePath) {
        this.cQ = InternalArguments.checkNotNull(uaNodeId, "startingNode");
        this.cS = InternalArguments.checkNotNull(uaRelativePath, "relativePath");
    }

    public UaBrowsePath append(UaRelativePath uaRelativePath) {
        return UaBrowsePath.from(this.cQ, this.cS.append(uaRelativePath));
    }

    public UaBrowsePath append(UaRelativePathElement uaRelativePathElement) {
        return UaBrowsePath.from(this.cQ, this.cS.append(uaRelativePathElement));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaBrowsePath uaBrowsePath = (UaBrowsePath)object;
        if (this.cS == null ? uaBrowsePath.cS != null : !this.cS.equals(uaBrowsePath.cS)) {
            return false;
        }
        return !(this.cQ == null ? uaBrowsePath.cQ != null : !this.cQ.equals(uaBrowsePath.cQ));
    }

    public UaRelativePath getRelativePath() {
        return this.cS;
    }

    public UaNodeId getStartingNode() {
        return this.cQ;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.cS == null ? 0 : this.cS.hashCode());
        n3 = 31 * n3 + (this.cQ == null ? 0 : this.cQ.hashCode());
        return n3;
    }

    public BrowsePath toBrowsePath(NamespaceTable namespaceTable) {
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        return new BrowsePath(this.cQ.asNodeId(namespaceTable), this.cS.toRelativePath(namespaceTable));
    }

    public String toString() {
        return "UaBrowsePath [startingNode=" + this.cQ + ", relativePath=" + this.cS + "]";
    }
}

