/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class RelativeNamePath
implements Comparable<RelativeNamePath> {
    public static final RelativeNamePath EMPTY = new RelativeNamePath(new QualifiedName[0]);
    private final List<QualifiedName> list;

    public static RelativeNamePath from(int n2, String ... stringArray) {
        return EMPTY.append(n2, stringArray);
    }

    public static RelativeNamePath from(QualifiedName ... qualifiedNameArray) {
        return EMPTY.append(qualifiedNameArray);
    }

    private RelativeNamePath(List<QualifiedName> list) {
        this.list = Collections.unmodifiableList(new ArrayList<QualifiedName>(InternalArguments.checkNotNullCollectionAndElements(list, "browseNames")));
    }

    private RelativeNamePath(QualifiedName ... qualifiedNameArray) {
        this(Arrays.asList((Object[])InternalArguments.checkNotNull(qualifiedNameArray)));
    }

    public RelativeNamePath append(int n2, String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("nameparts cannot be null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("nameparts cannot be empty");
        }
        ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
        for (String string : Arrays.asList(stringArray)) {
            arrayList.add(new QualifiedName(n2, string));
        }
        return this.append(arrayList.toArray(new QualifiedName[arrayList.size()]));
    }

    public RelativeNamePath append(QualifiedName ... qualifiedNameArray) {
        if (qualifiedNameArray == null) {
            throw new IllegalArgumentException("the qualified names to append cannot be null");
        }
        if (qualifiedNameArray.length == 0) {
            return this;
        }
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.addAll(Arrays.asList(qualifiedNameArray));
        return new RelativeNamePath(linkedList);
    }

    public RelativeNamePath append(RelativeNamePath relativeNamePath) {
        return this.append(relativeNamePath.toArray());
    }

    @Override
    public int compareTo(RelativeNamePath relativeNamePath) {
        QualifiedName qualifiedName;
        QualifiedName qualifiedName2;
        if (this == relativeNamePath) {
            return 0;
        }
        if (this.equals(relativeNamePath)) {
            return 0;
        }
        Iterator<QualifiedName> iterator = this.list.iterator();
        Iterator<QualifiedName> iterator2 = relativeNamePath.list.iterator();
        do {
            if (!iterator.hasNext()) {
                return -1;
            }
            qualifiedName2 = iterator.next();
            if (!iterator2.hasNext()) {
                return 1;
            }
            qualifiedName = iterator2.next();
        } while (qualifiedName2.equals(qualifiedName));
        return this.a(qualifiedName2, qualifiedName);
    }

    public boolean equals(Object object) {
        if (object instanceof RelativeNamePath) {
            RelativeNamePath relativeNamePath = (RelativeNamePath)object;
            return this.list.equals(relativeNamePath.list);
        }
        return super.equals(object);
    }

    public QualifiedName getFirst() {
        if (this.list.isEmpty()) {
            return QualifiedName.NULL;
        }
        return this.list.get(0);
    }

    public QualifiedName getLast() {
        if (this.list.isEmpty()) {
            return QualifiedName.NULL;
        }
        return this.list.get(this.list.size() - 1);
    }

    public int getSize() {
        return this.list.size();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public RelativeNamePath removeFirst() {
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.pollFirst();
        return new RelativeNamePath(linkedList);
    }

    public RelativeNamePath removeLast() {
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.pollLast();
        return new RelativeNamePath(linkedList);
    }

    public QualifiedName[] toArray() {
        if (this.list == null) {
            return new QualifiedName[0];
        }
        return this.list.toArray(new QualifiedName[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("/");
        Iterator<QualifiedName> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            QualifiedName qualifiedName = iterator.next();
            stringBuilder.append(qualifiedName.getNamespaceIndex()).append(':').append(qualifiedName.getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    private int a(QualifiedName qualifiedName, QualifiedName qualifiedName2) {
        int n2 = Integer.compare(qualifiedName.getNamespaceIndex(), qualifiedName2.getNamespaceIndex());
        if (n2 != 0) {
            return n2;
        }
        return qualifiedName.getName().compareTo(qualifiedName2.getName());
    }
}

