/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.types.opcua.BaseEventType;
import com.prosysopc.ua.types.opcua.ConditionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventData {
    public static final QualifiedName[] EVENT_TYPE_PATH = new QualifiedName[]{new QualifiedName("EventType")};
    public static final QualifiedName[] TIME_PATH = new QualifiedName[]{new QualifiedName("Time")};
    private static final Logger logger = LoggerFactory.getLogger(EventData.class);
    private final List<LocalizedText> comments = new ArrayList<LocalizedText>();
    private final ByteString S;
    private UaType T;
    private final Map<List<QualifiedName>, Variant> fieldValues = new HashMap<List<QualifiedName>, Variant>();
    private final NodeId nodeId;

    public static EventData fromNodeHierarchy(UaNode uaNode, ByteString byteString, Iterable<NodeClass> iterable) {
        HashSet<NodeClass> hashSet = new HashSet<NodeClass>();
        if (iterable != null) {
            for (NodeClass nodeClass : iterable) {
                hashSet.add(nodeClass);
            }
        }
        return new EventData(uaNode, byteString, hashSet);
    }

    public static EventData fromNodeHierarchy(UaNode uaNode, ByteString byteString, NodeClass ... nodeClassArray) {
        HashSet<NodeClass> hashSet = new HashSet<NodeClass>();
        if (nodeClassArray != null) {
            for (NodeClass nodeClass : nodeClassArray) {
                hashSet.add(nodeClass);
            }
        }
        return new EventData(uaNode, byteString, hashSet);
    }

    public static EventData raw(NodeId nodeId, ByteString byteString) {
        return new EventData(nodeId, byteString);
    }

    @Deprecated
    public EventData(NodeId nodeId, ByteString byteString) {
        logger.debug("EventData: nodeId={}", (Object)nodeId);
        this.nodeId = nodeId;
        this.S = byteString;
    }

    @Deprecated
    public EventData(UaNode uaNode, ByteString byteString) {
        this(uaNode, byteString, new HashSet<NodeClass>());
    }

    protected EventData(UaNode uaNode, ByteString byteString, Set<NodeClass> set) {
        logger.debug("EventData: node={}", (Object)uaNode);
        this.nodeId = uaNode instanceof BaseEventType && !(uaNode instanceof ConditionType) ? NodeId.NULL : uaNode.getNodeId();
        this.S = byteString;
        this.b(uaNode, set);
        this.a(uaNode, set);
        logger.debug("EventData: eventTypeId={}", (Object)this.getEventTypeId());
    }

    public void addComment(LocalizedText localizedText) {
        this.comments.add(localizedText);
    }

    public LocalizedText[] getComments() {
        return this.comments.toArray(new LocalizedText[this.comments.size()]);
    }

    public ByteString getEventId() {
        return this.S;
    }

    public UaType getEventType() {
        return this.T;
    }

    public NodeId getEventTypeId() {
        if (this.T == null) {
            Variant variant = this.getFieldValue(EVENT_TYPE_PATH);
            return variant == null ? NodeId.NULL : variant.asClass(NodeId.class, NodeId.NULL);
        }
        return this.T.getNodeId();
    }

    public Set<List<QualifiedName>> getFieldNames() {
        return this.fieldValues.keySet();
    }

    public Variant getFieldValue(List<QualifiedName> list) {
        QualifiedName qualifiedName;
        Variant variant = this.fieldValues.get(list);
        if (variant == null && (qualifiedName = list.get(0)).getNamespaceIndex() == 0 && "EventId".equals(qualifiedName.getName())) {
            return new Variant(this.getEventId());
        }
        logger.debug(" getFieldValue return:{}", (Object)variant);
        return variant;
    }

    public Variant getFieldValue(QualifiedName[] qualifiedNameArray) {
        return this.getFieldValue(Arrays.asList(qualifiedNameArray));
    }

    public Variant[] getFieldValues(List<List<QualifiedName>> list) {
        logger.debug("getFieldList");
        int n2 = list.size();
        Variant[] variantArray = new Variant[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                List<QualifiedName> list2 = list.get(i2);
                variantArray[i2] = list2 != null ? this.getFieldValue(list2) : new Variant(this.getNodeId());
                logger.debug("getFieldList: field={}; fieldValue={}", list2, (Object)variantArray[i2]);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.warn("getFieldList: " + indexOutOfBoundsException);
            }
        }
        return variantArray;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public DateTime getTime() {
        Variant variant = this.getFieldValue(TIME_PATH);
        return variant == null ? DateTime.MIN_VALUE : variant.asClass(DateTime.class, DateTime.MIN_VALUE);
    }

    public void setEventType(UaType uaType) {
        this.T = uaType;
    }

    public void setFieldValue(List<QualifiedName> list, Variant variant) {
        this.fieldValues.put(list, variant);
    }

    public void setFieldValue(QualifiedName[] qualifiedNameArray, Variant variant) {
        this.setFieldValue(Arrays.asList(qualifiedNameArray), variant);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EventData: " + this.S);
        for (List<QualifiedName> list : this.fieldValues.keySet()) {
            stringBuilder.append("\n " + list + "=" + this.getFieldValue(list));
        }
        return stringBuilder.toString();
    }

    private void a(UaNode uaNode, Set<NodeClass> set) {
        this.a(uaNode, set, null);
    }

    private void a(UaNode uaNode, Set<NodeClass> set, List<QualifiedName> list) {
        Object[] objectArray = uaNode.getReferences(Identifiers.HasComponent, false);
        if (logger.isDebugEnabled()) {
            logger.debug("addComponentFields: components=" + Arrays.toString(objectArray));
        }
        for (Object object : objectArray) {
            UaVariable uaVariable;
            Variant variant;
            UaNode uaNode2 = ((UaReference)object).getTargetNode();
            if (set.contains(uaNode2.getNodeClass())) continue;
            ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
            if (list != null) {
                arrayList.addAll(list);
            }
            arrayList.add(uaNode2.getBrowseName());
            if (uaNode2 instanceof UaVariable && (variant = this.a(uaVariable = (UaVariable)uaNode2)) != null && !variant.isEmpty()) {
                this.setFieldValue(arrayList, variant);
            }
            this.b(uaNode2, set, arrayList);
            this.a(uaNode2, set, arrayList);
        }
    }

    private void b(UaNode uaNode, Set<NodeClass> set) {
        this.b(uaNode, set, null);
    }

    private void b(UaNode uaNode, Set<NodeClass> set, List<QualifiedName> list) {
        Object[] objectArray = uaNode.getProperties();
        if (logger.isDebugEnabled()) {
            logger.debug("addPropertyFields: node=" + uaNode.getBrowseName() + "; properties=" + (objectArray == null ? "null" : Arrays.toString(objectArray)));
            logger.debug("basePath=" + (list == null ? "null" : list));
        }
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (set.contains(object.getNodeClass())) continue;
                ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>(1);
                if (list != null) {
                    arrayList.addAll(list);
                }
                arrayList.add(object.getBrowseName());
                Variant variant = this.a((UaVariable)object);
                logger.debug("browsePath={}; v={}", arrayList, (Object)variant);
                if (variant == null || variant.isEmpty()) continue;
                this.setFieldValue(arrayList, variant);
            }
        }
    }

    private Variant a(UaVariable uaVariable) {
        if (uaVariable == null) {
            return null;
        }
        DataValue dataValue = uaVariable.getValue();
        if (dataValue == null || dataValue.isNull()) {
            return null;
        }
        return dataValue.getValue();
    }
}

