/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.alarm.AlarmActionEnum;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.fox.sys.BFoxSession;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.BUuid;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmPortalTool"}, requiredPermissions="r")})
public class BPortalAlarmConsole
extends BAlarmConsole {
    @Generated
    public static final Type TYPE = Sys.loadType(BPortalAlarmConsole.class);
    BAlarmPortalTool tool;
    BButton serviceToggle;
    public Command startCommand;
    public Command stopCommand;
    public ToggleCommand autoStartCommand;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void stopped() throws Exception {
        if (this.sourceTable.getModel() instanceof DynamicTableModel) {
            DynamicTableModel dtm = (DynamicTableModel)this.sourceTable.getModel();
            StringBuilder colStr = new StringBuilder();
            for (int i = 0; i < dtm.getRootColumnCount(); ++i) {
                if (!dtm.showColumn(i)) continue;
                colStr.append(i + ",");
            }
            if (dtm.getRootColumnCount() > 0) {
                this.options.setDisplayColumns(colStr.toString());
            }
        }
        this.options.setSortColumn(this.sourceModel.getLastSortColumn());
        this.options.setSortAscending(this.sourceModel.getLastSortAscending());
        this.options.save();
        if (!this.tool.serviceRunning()) {
            Enumeration<String> keys = this.tool.recipients.keys();
            while (keys.hasMoreElements()) {
                BConsoleRecipient recipient = this.tool.recipients.get(keys.nextElement());
                if (this.channel(recipient) == null) continue;
                this.channel(recipient).unregister(recipient);
                this.channel(recipient).unregister(this);
            }
            if (this.tool.trayIcon != null && this.tool.trayIcon.isShowing()) {
                this.tool.trayIcon.hide();
            }
        }
    }

    @Override
    public void doLoadValue(BObject value, Context cx) throws Exception {
        this.tool = (BAlarmPortalTool)value;
        super.doLoadValue((BObject)this.tool.getAlarmPortalConsoleRecipient(), cx);
        this.sourceTable.setCellRenderer((TableCellRenderer)new AlarmPortalTableCellRenderer());
    }

    @Override
    public BGridPane makeToolBar() {
        BGridPane toolBar = super.makeToolBar();
        return toolBar;
    }

    @Override
    public void doTimeRangeModified() throws Exception {
        this.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
        this.reload();
    }

    @Override
    public void doProcessAlarm(BAlarmRecord alarm) {
        super.doProcessAlarm(alarm);
        if (this.options.getAlarmFilters().accept((BComplex)alarm)) {
            int acked = this.getAckedAlarmCount();
            int unacked = this.getUnackedAlarmCount();
            this.tool.updateTrayIcon(acked, unacked, this.sourcesInAlarm());
            this.tool.showAlarmDialog(acked, unacked, this.sourcesInAlarm(), alarm);
        }
    }

    public int getAckedAlarmCount() {
        if (this.sourceModel == null || this.tool == null) {
            return 0;
        }
        int acked = 0;
        int rows = this.sourceModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            acked += this.sourceModel.getAckedCountForSource(this.sourceModel.getRecord(i).getSource());
        }
        this.tool.acked = acked;
        return acked;
    }

    public int getUnackedAlarmCount() {
        if (this.sourceModel == null || this.tool == null) {
            return 0;
        }
        int unacked = 0;
        int rows = this.sourceModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            unacked += this.sourceModel.getUnackedCountForSource(this.sourceModel.getRecord(i).getSource());
        }
        this.tool.unacked = unacked;
        return unacked;
    }

    public boolean sourcesInAlarm() {
        if (this.sourceModel == null || this.tool == null) {
            return false;
        }
        boolean sourcesInAlarm = false;
        int rows = this.sourceModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            sourcesInAlarm |= !this.sourceModel.getRecord(i).isNormal();
        }
        this.tool.sourcesInAlarm = sourcesInAlarm;
        return sourcesInAlarm;
    }

    public BAlarmRecord getMostRecentRecord() {
        if (this.sourceModel == null || this.tool == null) {
            return null;
        }
        BAlarmRecord lastAlarm = new BAlarmRecord(BUuid.make());
        lastAlarm.setTimestamp(BAbsTime.NULL);
        int rows = this.sourceModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            BAlarmRecord test = this.sourceModel.getRecord(i);
            if (!test.getTimestamp().isAfter(lastAlarm.getTimestamp())) continue;
            lastAlarm = test;
        }
        return lastAlarm;
    }

    public void removeAlarmsFrom(BConsoleRecord rec) {
        String foxScheme = rec.getUseFoxs() ? "|foxs:" : "|fox:";
        BOrd consoleSrc = BOrd.make((String)(rec.getHostOrd() + foxScheme + rec.getPort() + "|station:|" + rec.getConsoleOrd()));
        if (this.sourceModel == null) {
            return;
        }
        int sourceCount = this.sourceModel.getRowCount();
        ArrayList<BOrdList> toRemove = new ArrayList<BOrdList>();
        for (int i = 0; i < sourceCount; ++i) {
            BOrdList src = this.sourceModel.getRecord(i).getSource();
            if (!this.ordListContains(src, consoleSrc)) continue;
            toRemove.add(src);
        }
        for (BOrdList srcToRemove : toRemove) {
            try {
                this.sourceModel.removeSource(srcToRemove);
            }
            catch (Exception exception) {}
        }
    }

    private boolean ordListContains(BOrdList list, BOrd src) {
        for (int i = 0; i < list.size(); ++i) {
            BOrd ord = list.get(i);
            if (!ord.equals((Object)src)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Enumeration<String> keys = this.tool.recipients.keys();
        this.sourceModel.clear();
        while (keys.hasMoreElements()) {
            BConsoleRecipient recipient = this.tool.recipients.get(keys.nextElement());
            BConsoleRecord record = this.tool.getRecordForRecipient(recipient);
            String foxScheme = record.getUseFoxs() ? "foxs:" : "fox:";
            BOrd newOrd = BOrd.make((BOrd)record.getHostOrd(), (String)(foxScheme + record.getPort() + "|station:|" + record.getConsoleOrd().toString()));
            this.enterBusy();
            try {
                StringBuilder ordText = new StringBuilder(this.channel(recipient).getInitialAlarmQuery(this, recipient, newOrd).toString());
                StringBuilder predicate = new StringBuilder(64);
                String filterQual = this.options.getAlarmFilters().getPredicate();
                Pattern r = Pattern.compile("\\(source\\s|\\(source\\.");
                Matcher m = r.matcher(filterQual);
                if (m.find()) {
                    int startIndex = m.start();
                    int endIndex = filterQual.indexOf(")", startIndex);
                    filterQual = filterQual.replace(filterQual.substring(startIndex, endIndex + 1), "(".concat(filterQual.substring(startIndex, endIndex + 1)).concat(" OR ").concat(filterQual.substring(startIndex, endIndex + 1).replace("source", "alarmData.sourceName")).concat(")"));
                }
                if (filterQual != null && filterQual.length() > 0) {
                    if (predicate.length() != 0) {
                        predicate.append(" and ");
                    }
                    predicate.append(filterQual);
                }
                if (predicate.length() != 0) {
                    ordText.append(" and ").append(predicate.toString());
                }
                if (!this.timeRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
                    BAbsTimeFilter timeFilter = new BAbsTimeFilter();
                    timeFilter.initFromDynamicTimeRange(this.timeRange);
                    String timeRangePredicate = timeFilter.getPredicate(BAlarmRecord.timestamp.getName());
                    ordText.append(" and ").append(timeRangePredicate.toString());
                }
                ordText.append(" order by timestamp desc, ");
                ordText.append(this.sourceModel.getColumns().getColumn(this.options.getSortColumn()).getQueryName());
                if (this.options.getSortAscending()) {
                    ordText.append(" asc");
                } else {
                    ordText.append(" desc");
                }
                BOrd ord = BOrd.make((BOrd)((BWbShell)this.getShell()).getActiveOrd(), (BOrd)BOrd.make((String)ordText.toString()));
                BITable result = (BITable)ord.resolve((BObject)recipient).get();
                BAlarmRecord add = null;
                TableCursor recs = result.cursor();
                Throwable throwable = null;
                try {
                    if (!recs.next()) continue;
                    add = (BAlarmRecord)recs.get();
                    BOrdList src = add.getSource();
                    src = BOrdList.add((BOrdList)src, (BOrd)newOrd);
                    add.setSource(src);
                    this.sourceModel.update(add);
                    this.sourceTable.sizeColumnsToFit();
                    while (recs.next()) {
                        add = (BAlarmRecord)recs.get();
                        src = add.getSource();
                        src = BOrdList.add((BOrdList)src, (BOrd)newOrd);
                        add.setSource(src);
                        this.sourceModel.update(add, false);
                    }
                    this.sourceModel.sortByColumn(this.sourceModel.getLastSortColumn(), this.sourceModel.getLastSortAscending());
                    this.sourceModel.updateTable();
                    this.sourceTable.sizeColumnsToFit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (recs == null) continue;
                    if (throwable != null) {
                        try {
                            recs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    recs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.exitBusy();
                this.loadComplete();
                this.sourceModel.init(this, this.ctx);
                this.sourceTable.sizeColumnsToFit();
            }
        }
        this.exitBusy();
        BAlarmRecord mostRecent = null;
        for (int i = 0; i < this.sourceModel.getRowCount(); ++i) {
            BAlarmRecord record = this.sourceModel.getRecord(i);
            if (record.isAlarm()) {
                this.soundAlarmFor(record);
            }
            if (mostRecent == null) {
                mostRecent = record;
                continue;
            }
            if (!mostRecent.getTimestamp().isBefore(record.getTimestamp())) continue;
            mostRecent = record;
        }
    }

    protected void init() {
        this.sourceModel.init(this, this.ctx);
    }

    @Override
    protected void ackAlarms(BAlarmRecord[] recs) {
        try {
            BAlarmRecord rec;
            BAlarmRecord alarm;
            Hashtable<BConsoleRecipient, Array> acks = new Hashtable<BConsoleRecipient, Array>();
            BAlarmRecord[] bAlarmRecordArray = recs;
            int n = bAlarmRecordArray.length;
            for (int i = 0; i < n && !(alarm = (BAlarmRecord)(rec = bAlarmRecordArray[i]).newCopy()).isAcknowledged(); ++i) {
                BOrdList almSrc = alarm.getSource();
                BOrd almOrd = almSrc.get(almSrc.size() - 1);
                BConsoleRecord entry = this.tool.getConsoleRecordFor(almOrd);
                BConsoleRecipient recipient = this.tool.getRecipientForRecord(entry);
                alarm.setUser(this.getUsername(alarm));
                alarm.setAckTime(BAbsTime.now());
                alarm.setAckState(BAckState.ackPending);
                this.sourceModel.update(alarm);
                Array recArray = (Array)acks.get(recipient);
                if (recArray == null) {
                    recArray = new Array(BAlarmRecord.class);
                }
                BAlarmRecord alarmRec = (BAlarmRecord)alarm.newCopy();
                alarmRec.setSource(BOrdList.remove((BOrdList)alarm.getSource(), (int)(alarm.getSource().size() - 1)));
                recArray.add((Object)alarmRec);
                acks.put(recipient, recArray);
            }
            Enumeration recips = acks.keys();
            while (recips.hasMoreElements()) {
                BConsoleRecipient recip = (BConsoleRecipient)recips.nextElement();
                Array recArray = (Array)acks.get(recip);
                this.channel(recip).ackAlarms(this.tool.getAlarmPortalConsoleRecipient(), (BAlarmRecord[])recArray.trim());
            }
            this.sourceTable.sizeColumnsToFit();
            this.sourceTable.fireTableModified(null);
            if (this.alarmTable != null) {
                this.alarmTable.fireTableModified(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getUsername(BAlarmRecord alarm) {
        BOrdList almSrc = alarm.getSource();
        BOrd almOrd = almSrc.get(almSrc.size() - 1);
        BConsoleRecord entry = this.tool.getConsoleRecordFor(almOrd);
        if (entry == null) {
            return null;
        }
        BConsoleRecipient recipient = this.tool.getRecipientForRecord(entry);
        if (!recipient.isMounted()) {
            return null;
        }
        return ((BFoxSession)recipient.getSession()).getUsername();
    }

    @Override
    public BAlarmService getAlarmService() {
        SourceTableModel model = (SourceTableModel)((DynamicTableModel)this.sourceModel.getModel()).getRootModel();
        BAlarmRecord alarm = model.getRecord(this.sourceModel.getSelection().getSelection().getRow());
        BOrdList almSrc = alarm.getSource();
        BOrd almOrd = almSrc.get(almSrc.size() - 1);
        String station = almOrd.toString();
        station = station.substring(0, station.indexOf("|station:|"));
        BConsoleRecord entry = this.tool.getConsoleRecordForStation(BOrd.make((String)station));
        BConsoleRecipient recipient = this.tool.getRecipientForRecord(entry);
        BOrd serviceOrd = BOrd.make((String)"service:alarm:AlarmService");
        BAlarmService alarmService = (BAlarmService)serviceOrd.resolve((BObject)recipient).get();
        alarmService.lease();
        return alarmService;
    }

    @Override
    protected boolean canModifySelectedAlarms(TableSelection sel) {
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        int[] selIndex = sel.getRows();
        SourceTableModel model = (SourceTableModel)((DynamicTableModel)this.sourceModel.getModel()).getRootModel();
        for (int i = 0; i < selIndex.length; ++i) {
            BAlarmRecord alarm = model.getRecord(selIndex[i]);
            BOrdList almSrc = alarm.getSource();
            BOrd almOrd = almSrc.get(almSrc.size() - 1);
            String station = almOrd.toString();
            station = station.substring(0, station.indexOf("|station:|"));
            BConsoleRecord entry = this.tool.getConsoleRecordForStation(BOrd.make((String)station));
            BConsoleRecipient recipient = this.tool.getRecipientForRecord(entry);
            BOrd serviceOrd = BOrd.make((String)"service:alarm:AlarmService");
            BAlarmService alarmService = (BAlarmService)serviceOrd.resolve((BObject)recipient).get();
            alarmService.lease();
            BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarm.getAlarmClass());
            if (!(alarmClass == null ? !alarmService.getDefaultAlarmClass().getPermissions(this.ctx).hasOperatorWrite() : !alarmClass.getPermissions(this.ctx).hasOperatorWrite())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void hyperlink(BAlarmRecord alarm) {
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            BOrd hyperlink = BOrd.make((String)alarm.getAlarmData().get("hyperlinkOrd").toString());
            if (hyperlink == null || hyperlink.isNull()) {
                BAlarmClassMapping mapping = this.options.getAlarmClassMapping();
                BAlarmClassDef acDef = mapping.getAlarmClassDefFor(alarm.getAlarmClass());
                hyperlink = acDef.getAlarmUrl();
            }
            if (!hyperlink.isNull()) {
                BOrdList almSrc = alarm.getSource();
                BOrd almOrd = almSrc.get(almSrc.size() - 1);
                String station = almOrd.toString();
                station = station.substring(0, station.indexOf("|station:|"));
                BConsoleRecord entry = this.tool.getConsoleRecordForStation(BOrd.make((String)station));
                BConsoleRecipient recip = this.tool.getRecipientForRecord(entry);
                BOrd ord = BOrd.make((BOrd)recip.getNavOrd(), (BOrd)hyperlink);
                shell.hyperlink(ord);
                if (this.detailsDlg != null) {
                    this.detailsDlg.close();
                }
                if (this.alarmReport != null) {
                    this.alarmReport.close();
                }
            }
        }
    }

    @Override
    public void soundAlarmFor(BAlarmRecord alarm) {
        BOrd sfOrd = BOrd.NULL;
        if (alarm.getAlarmData().get("soundFile") != null) {
            sfOrd = BOrd.make((BOrd)BOrd.toSpace((BObject)this.getRecipientForAlarm(alarm)).getNavOrd(), (String)alarm.getAlarmData().get("soundFile").toString());
        }
        if (sfOrd == null || sfOrd.isNull()) {
            BAlarmClassMapping mapping;
            BAlarmClassDef acDef = null;
            if (this.options != null && (mapping = this.options.getAlarmClassMapping()) != null && (acDef = mapping.getAlarmClassDefFor(alarm.getAlarmClass())) != null) {
                sfOrd = acDef.getAlarmSound();
            }
        }
        try {
            if (sfOrd == null || sfOrd.isNull()) {
                this.soundAlarm(alarm);
            } else {
                this.soundAlarm(alarm.getSource(), sfOrd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected BConsoleRecipient getRecipientForAlarm(BAlarmRecord alarm) {
        if (alarm == null) {
            return null;
        }
        BOrdList almSrc = alarm.getSource();
        BOrd almOrd = almSrc.get(almSrc.size() - 1);
        String station = almOrd.toString();
        station = station.substring(0, station.indexOf("|station:|"));
        BConsoleRecord entry = this.tool.getConsoleRecordForStation(BOrd.make((String)station));
        return this.tool.getRecipientForRecord(entry);
    }

    @Override
    public BAlarmService getAlarmService(BAlarmRecord rec) {
        BConsoleRecipient recip = this.getRecipientForAlarm(rec);
        BConsoleRecord consoleRec = this.tool.getRecordForRecipient(recip);
        if (recip == null) {
            return null;
        }
        if (consoleRec == null || !consoleRec.isInitialLoadComplete()) {
            return null;
        }
        try {
            return (BAlarmService)BOrd.make((String)"service:alarm:AlarmService").resolve((BObject)recip).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void sendUpdatedAlarm(BAlarmRecord alarm, AlarmActionEnum alarmAction) throws Exception {
        BOrdList almSrc = alarm.getSource();
        BOrd almOrd = almSrc.get(almSrc.size() - 1);
        BConsoleRecord entry = this.tool.getConsoleRecordFor(almOrd);
        BConsoleRecipient recipient = this.tool.getRecipientForRecord(entry);
        BAlarmRecord rec = (BAlarmRecord)alarm.newCopy();
        rec.setSource(BOrdList.remove((BOrdList)almSrc, (int)(almSrc.size() - 1)));
        this.channel(recipient).updateAlarm(rec, alarmAction);
    }

    public class AlarmPortalTableCellRenderer
    extends BAlarmConsole.AlarmTableCellRenderer {
        public AlarmPortalTableCellRenderer() {
            super(BPortalAlarmConsole.this);
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            int row = cell.row;
            BAlarmRecord rec = BPortalAlarmConsole.this.sourceModel.getRecord(row);
            BOrd consoleOrd = rec.getSource().get(rec.getSource().size() - 1);
            BConsoleRecipient recip = BPortalAlarmConsole.this.tool.recipients.get(consoleOrd.toString());
            return recip != null && recip.isMounted() ? super.getForeground(cell) : BBrush.makeSolid((BColor)BColor.gray);
        }
    }

    public static class SourceModCursor
    extends AbstractCursor<BAlarmRecord> {
        Cursor<BAlarmRecord> inner;
        BOrd srcAdd;
        BAlarmRecord rec;

        public SourceModCursor(BOrd srcAdd, Cursor<BAlarmRecord> inner) {
            this.srcAdd = srcAdd;
            this.inner = inner;
        }

        public Context getContext() {
            return this.inner.getContext();
        }

        protected BAlarmRecord doGet() {
            if (this.rec == null) {
                this.rec = (BAlarmRecord)this.inner.get();
                BOrdList src = this.rec.getSource();
                src = BOrdList.add((BOrdList)src, (BOrd)this.srcAdd);
                this.rec.setSource(src);
            }
            return this.rec;
        }

        protected boolean advanceCursor() {
            this.rec = null;
            return this.inner.next();
        }

        protected void closeCursor() {
            this.inner.close();
        }
    }
}

