/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BAlarmTitlePane;
import com.tridium.alarm.ui.ConsoleTableModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType
public class BAlarmReportDialog
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmReportDialog.class);
    BAlarmConsole console;
    BTable table;
    String title;
    private Command ackCmd;
    private Command closeCmd;
    private Command hyperlinkCmd;
    private Command notesCmd;
    private Command detailsCmd;
    private Command showVideoCmd;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmReportDialog() {
        throw new IllegalStateException();
    }

    public BAlarmReportDialog(BAlarmConsole console, String source, BTable table) {
        super((BWidget)console, source, true);
        this.console = console;
        this.table = table;
        this.hyperlinkCmd = new HyperlinkCommand((BWidget)this);
        BButton urlBtn = new BButton(this.hyperlinkCmd, true, true);
        this.ackCmd = new AckCommand((BWidget)this);
        BButton ackBtn = new BButton(this.ackCmd, true, true);
        this.notesCmd = new NotesCommand((BWidget)this);
        BButton notesBtn = new BButton(this.notesCmd, true, true);
        this.showVideoCmd = new ShowVideoCommand((BWidget)this);
        BButton showVideoBtn = new BButton(this.showVideoCmd, true, true);
        this.closeCmd = new CloseCommand((BWidget)this);
        BButton closeBtn = new BButton(this.closeCmd, true, true);
        this.detailsCmd = new DetailsCommand((BWidget)this);
        BGridPane toolBar = new BGridPane(BAlarmConsole.isVideoDriverAvailable() ? 5 : 4);
        toolBar.setColumnAlign(BHalign.fill);
        toolBar.setUniformColumnWidth(true);
        ConsoleTableModel model = (ConsoleTableModel)((DynamicTableModel)table.getModel()).getRootModel();
        if (model.getRowCount() > 0) {
            BAlarmRecord record = model.getRecord(0);
            BAlarmService service = console.getAlarmService();
            BAlarmClass alarmClass = service.lookupAlarmClass(record.getAlarmClass());
            BPermissions permissions = alarmClass.getPermissions(console.ctx);
            if (permissions.hasOperatorWrite()) {
                toolBar.add("ack", (BValue)ackBtn);
            }
        } else {
            toolBar.add("ack", (BValue)ackBtn);
        }
        toolBar.add("url", (BValue)urlBtn);
        toolBar.add("notes", (BValue)notesBtn);
        if (BAlarmConsole.isVideoDriverAvailable()) {
            toolBar.add("showVideo", (BValue)showVideoBtn);
        }
        toolBar.add("close", (BValue)closeBtn);
        BEdgePane pane = new BEdgePane();
        pane.setBottom((BWidget)new BBorderPane((BWidget)toolBar));
        Controller crtl = new Controller();
        table.setController((TableController)crtl);
        pane.setCenter((BWidget)BAlarmTitlePane.makePane(console.getTitle(), table));
        table.getSelection().select(0);
        crtl.enableCommands();
        this.setContent((BWidget)pane);
    }

    public void close() {
        ((BEdgePane)this.getContent()).setCenter((BWidget)new BNullWidget());
        super.close();
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            this.enableCommands();
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            this.enableCommands();
        }

        void enableCommands() {
            TableSelection sel = this.getTable().getSelection();
            if (sel.getRows().length == 1) {
                ConsoleTableModel tm = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                BAlarmRecord alarm = tm.getRecord(sel.getRow());
                BString str = (BString)alarm.getAlarmData().get("hyperlinkOrd");
                BOrd hyperlink = BOrd.NULL;
                if (str != null) {
                    hyperlink = BOrd.make((String)str.toString());
                }
                if (hyperlink == null || hyperlink.isNull()) {
                    BAlarmClassMapping mapping = BAlarmReportDialog.this.console.options.getAlarmClassMapping();
                    BAlarmClassDef acDef = mapping.getAlarmClassDefFor(alarm.getAlarmClass());
                    hyperlink = acDef.getAlarmUrl();
                }
                if (hyperlink != null && !hyperlink.isNull()) {
                    BAlarmReportDialog.this.hyperlinkCmd.setEnabled(true);
                } else {
                    BAlarmReportDialog.this.hyperlinkCmd.setEnabled(false);
                }
                String alarmSourceExtCamera = alarm.getAlarmData().gets("cameraOrd", null);
                if (alarmSourceExtCamera != null) {
                    BOrd videoCameraOrd = BOrd.make((String)alarmSourceExtCamera);
                    if (!videoCameraOrd.equals((Object)BOrd.NULL)) {
                        BAlarmReportDialog.this.showVideoCmd.setEnabled(true);
                    } else {
                        BAlarmReportDialog.this.showVideoCmd.setEnabled(false);
                    }
                } else {
                    BAlarmReportDialog.this.showVideoCmd.setEnabled(false);
                }
                BAlarmReportDialog.this.notesCmd.setEnabled(true);
            } else {
                BAlarmReportDialog.this.hyperlinkCmd.setEnabled(false);
                BAlarmReportDialog.this.notesCmd.setEnabled(false);
                BAlarmReportDialog.this.detailsCmd.setEnabled(false);
                BAlarmReportDialog.this.showVideoCmd.setEnabled(false);
            }
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                BAlarmReportDialog.this.console.showDetailsDialog(BAlarmReportDialog.this.table, row);
            }
        }

        protected void cellPopup(BMouseEvent event, int x, int y) {
            BMenu menu = new BMenu();
            menu.add("ack", BAlarmReportDialog.this.ackCmd);
            menu.add("url", BAlarmReportDialog.this.hyperlinkCmd);
            menu.add("notes", BAlarmReportDialog.this.notesCmd);
            menu.add("details", BAlarmReportDialog.this.detailsCmd);
            if (BAlarmConsole.isVideoDriverAvailable()) {
                menu.add("showVideo", BAlarmReportDialog.this.showVideoCmd);
            }
            menu.open((BWidget)BAlarmReportDialog.this.table, event.getX(), event.getY());
        }

        public BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            menu.add("acSep", (BValue)new BSeparator());
            menu.add("addColumn", BAlarmReportDialog.this.console.addColumnCommand);
            menu.add("removeColumn", BAlarmReportDialog.this.console.removeColumnCommand);
            return menu;
        }
    }

    private class ShowVideoCommand
    extends Command {
        public ShowVideoCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.showVideo");
        }

        public CommandArtifact doInvoke() {
            block9: {
                try {
                    Class videoAlmConsoleExt = Sys.loadClass((String)"videoDriver", (String)"com.tridium.videoDriver.ui.alarm.AlarmConsoleExt");
                    if (videoAlmConsoleExt != null) {
                        Method doShowVideoMethod = videoAlmConsoleExt.getMethod("doShowVideo", BAlarmConsole.class, BAlarmRecord.class);
                        if (doShowVideoMethod != null) {
                            BAlarmRecord[] selectedRecords = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
                            if (selectedRecords != null && selectedRecords.length > 0) {
                                doShowVideoMethod.invoke((Object)videoAlmConsoleExt, BAlarmReportDialog.this.console, selectedRecords[0]);
                            }
                        } else {
                            System.out.println("The 'doShowVideo' method was not found on class AlarmConsoleExt in videoDriver.jar. Please have my program fixed");
                        }
                        break block9;
                    }
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)cnfe);
                }
                catch (NoSuchMethodException nsme) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)nsme);
                }
                catch (InvocationTargetException ite) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)ite);
                }
                catch (IllegalAccessException iae) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)iae);
                }
            }
            return null;
        }
    }

    private class DetailsCommand
    extends Command {
        public DetailsCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.details");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BAlarmReportDialog.this.table.getSelection().getRows();
            if (rows.length != 1) {
                return null;
            }
            BAlarmReportDialog.this.console.showDetailsDialog(BAlarmReportDialog.this.table, rows[0]);
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand(BWidget owner) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.close");
        }

        public CommandArtifact doInvoke() {
            BAlarmReportDialog.this.close();
            return null;
        }
    }

    private class NotesCommand
    extends Command {
        public NotesCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.notes");
        }

        public CommandArtifact doInvoke() {
            BAlarmRecord[] alarms = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
            if (alarms.length == 0) {
                return null;
            }
            BAlarmReportDialog.this.console.showNotes((BWidget)BAlarmReportDialog.this.table, alarms);
            return null;
        }
    }

    private class HyperlinkCommand
    extends Command {
        public HyperlinkCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.hyperlink");
        }

        public CommandArtifact doInvoke() {
            BAlarmRecord[] alarms = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
            if (alarms.length == 0) {
                return null;
            }
            BAlarmReportDialog.this.console.hyperlink(alarms[0]);
            return null;
        }
    }

    private class AckCommand
    extends Command {
        public AckCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.acknowledge");
        }

        public CommandArtifact doInvoke() {
            BAlarmRecord[] alarms = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
            if (alarms.length == 0) {
                return null;
            }
            BAlarmReportDialog.this.console.acknowledgeAlarms(alarms);
            return null;
        }
    }
}

