/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BNotesDialog;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.ui.theme.Theme;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
public class BAlarmDetailsDialog
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmDetailsDialog.class);
    BAlarmConsole console;
    BAlarmService alarmService;
    BGridPane alarmPane = new BGridPane(2);
    protected BAlarmRecord alarm;
    BTimeZoneDisplay timeZoneDisplay;
    String username;
    AlarmDbConnection connection;
    ConsoleTableModel tm;
    Logger logger = Logger.getLogger("alarm");
    Command ackCmd;
    Command closeCmd;
    Command hyperlinkCmd;
    Command notesCmd;
    Command showVideoCmd;
    Command nextCmd;
    Command prevCmd;
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);
    public static final UiLexicon lex = UiLexicon.makeUiLexicon(BAlarmDetailsDialog.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmDetailsDialog() {
        throw new IllegalStateException();
    }

    public BAlarmDetailsDialog(BAlarmConsole console, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm) {
        this(console, timeZoneDisplay, alarm, tm, null);
    }

    public BAlarmDetailsDialog(BAlarmService alarmService, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm, Context cx) {
        this(alarmService, null, timeZoneDisplay, alarm, tm, cx);
    }

    public BAlarmDetailsDialog(BAlarmConsole console, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm, Context cx) {
        this(null, console, timeZoneDisplay, alarm, tm, cx);
    }

    public BAlarmDetailsDialog(BWidget owner, BAlarmService alarmService, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm, Context cx) {
        super(owner, "Alarm Record", true);
        this.init(alarmService, null, timeZoneDisplay, alarm, tm, cx);
    }

    public BAlarmDetailsDialog(BWidget owner, BAlarmService alarmService, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm, Context cx, String username, AlarmDbConnection connection) {
        super(owner, "Alarm Record", true);
        this.init(alarmService, null, timeZoneDisplay, alarm, tm, cx, username, connection);
    }

    protected BAlarmDetailsDialog(BAlarmService alarmService, BAlarmConsole console, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm, Context cx) {
        super((BWidget)console, "Alarm Record", true);
        this.init(alarmService, console, timeZoneDisplay, alarm, tm, cx);
    }

    private void init(BAlarmService alarmService, BAlarmConsole console, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm, Context cx) {
        this.init(alarmService, console, timeZoneDisplay, alarm, tm, cx, null, null);
    }

    private void init(BAlarmService alarmService, BAlarmConsole console, BTimeZoneDisplay timeZoneDisplay, BAlarmRecord alarm, ConsoleTableModel tm, Context cx, String username, AlarmDbConnection connection) {
        this.console = console;
        this.alarm = alarm;
        this.tm = tm;
        this.timeZoneDisplay = timeZoneDisplay;
        if (console != null) {
            this.alarmService = console.getAlarmService();
        }
        if (alarmService != null) {
            this.alarmService = alarmService;
        }
        this.username = username;
        this.connection = connection;
        this.hyperlinkCmd = new HyperlinkCommand((BWidget)this);
        BButton urlBtn = new BButton(this.hyperlinkCmd, true, true);
        this.ackCmd = new AckCommand((BWidget)this);
        BButton ackBtn = new BButton(this.ackCmd, true, true);
        this.notesCmd = new NotesCommand((BWidget)this);
        BButton notesBtn = new BButton(this.notesCmd, true, true);
        this.showVideoCmd = new ShowVideoCommand((BWidget)this);
        BButton showVideoBtn = new BButton(this.showVideoCmd, true, true);
        this.closeCmd = new CloseCommand((BWidget)this);
        BButton closeBtn = new BButton(this.closeCmd, true, true);
        this.nextCmd = new PrevCommand((BWidget)this, cx);
        BButton nextBtn = new BButton(this.nextCmd, false, true);
        this.prevCmd = new NextCommand((BWidget)this, cx);
        BButton prevBtn = new BButton(this.prevCmd, false, true);
        BOrdList src = alarm.getSource();
        boolean found = false;
        int size = tm.getAlarmCount(src);
        for (int i = 0; i < size; ++i) {
            if (!tm.getRecord(src, i).getUuid().equals((Object)alarm.getUuid())) continue;
            this.prevCmd.setEnabled(i != 0);
            this.nextCmd.setEnabled(i + 1 < size);
            found = true;
            break;
        }
        if (!found) {
            this.prevCmd.setEnabled(false);
            this.nextCmd.setEnabled(false);
        }
        this.createAlarmPane(cx);
        BGridPane toolBar = new BGridPane();
        toolBar.setColumnAlign(BHalign.fill);
        toolBar.setUniformColumnWidth(true);
        toolBar.add("next", (BValue)nextBtn);
        if (console != null) {
            BOrd videoCameraOrd;
            String alarmSourceExtCamera;
            BAlarmClass alarmClass = console.getAlarmService().lookupAlarmClass(alarm.getAlarmClass());
            if (alarmClass.getPermissions(console.ctx).hasOperatorWrite()) {
                toolBar.add("ack", (BValue)ackBtn);
            }
            toolBar.add("url", (BValue)urlBtn);
            toolBar.add("notes", (BValue)notesBtn);
            if (BAlarmConsole.isVideoDriverAvailable() && (alarmSourceExtCamera = alarm.getAlarmData().gets("cameraOrd", null)) != null && !(videoCameraOrd = BOrd.make((String)alarmSourceExtCamera)).equals((Object)BOrd.NULL)) {
                toolBar.add("showVideo", (BValue)showVideoBtn);
            }
        }
        toolBar.add("close", (BValue)closeBtn);
        toolBar.add("prev", (BValue)prevBtn);
        toolBar.setColumnCount(toolBar.getChildWidgets().length);
        BScrollPane scroll = new BScrollPane();
        BBorderPane borderPane = new BBorderPane();
        scroll.setContent((BWidget)borderPane);
        borderPane.setContent((BWidget)this.alarmPane);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)scroll));
        pane.setBottom((BWidget)new BBorderPane((BWidget)toolBar));
        this.setContent((BWidget)pane);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    void createAlarmPane(Context cx) {
        Property[] props = this.alarm.loadSlots().getPropertiesArray();
        int rows = props.length;
        this.alarmPane.removeAll();
        this.alarmPane.setColorRows(true);
        this.alarmPane.setRowAlign(BValign.top);
        this.alarmPane.setColumnGap(9.0);
        for (int i = 0; i < rows; ++i) {
            if (Flags.isHidden((BComplex)this.alarm, (Slot)props[i])) continue;
            BLabel label = new BLabel(this.alarm.getDisplayName((Slot)props[i], this.console != null ? this.console.ctx : null), BHalign.left);
            label.setFont(Theme.label().getBoldText());
            this.alarmPane.add(null, (BValue)label, null);
            if (props[i].getName().equals("alarmData")) {
                BGridPane dataPane = new BGridPane(2);
                dataPane.setHalign(BHalign.fill);
                dataPane.setColumnGap(5.0);
                dataPane.setRowAlign(BValign.top);
                Object[] keys = ((BFacets)this.alarm.get(props[i])).list();
                keys = this.addNotePropertyIfNotPresent((String[])keys);
                SortUtil.sort((Object[])keys, (Object[])keys, String::compareToIgnoreCase);
                for (Object key : keys) {
                    if ("unconvertedHyperlinkOrd".equals(key)) continue;
                    BLabel facetLabel = new BLabel(lex.get("alarmData." + (String)key, TextUtil.toFriendly((String)key)), BHalign.left);
                    facetLabel.setFont(Theme.label().getBoldText());
                    dataPane.add(null, (BValue)facetLabel, null);
                    if (((String)key).equals("notes")) {
                        Command cmd = new Command((BWidget)this, "", BImage.make((BIcon)BIcon.std((String)"doubleArrowRight.png")), null, ""){

                            public CommandArtifact doInvoke() {
                                try {
                                    BAlarmDetailsDialog.this.notesCmd.doInvoke();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return null;
                            }
                        };
                        BToolBar toolBar = new BToolBar();
                        toolBar.add("eb", (BValue)new BButton(cmd, false, true));
                        dataPane.add(null, (BValue)toolBar, null);
                        continue;
                    }
                    String value = this.alarm.getFormattedAlarmDataValue((String)key, cx);
                    value = TextUtil.replace((String)value, (String)"\\n", (String)"\n");
                    BTextEditor editor = new BTextEditor(value, false);
                    editor.setRenderer(new TextRenderer(){

                        public BBrush getBackground() {
                            return BBrush.NULL;
                        }
                    });
                    dataPane.add(null, (BValue)editor);
                }
                this.alarmPane.add(null, (BValue)dataPane, null);
                continue;
            }
            if (props[i].getType().is(BOrdList.TYPE)) {
                try {
                    BString sourceName;
                    BOrdList src = (BOrdList)this.alarm.get(props[i]);
                    StringBuilder source = new StringBuilder();
                    for (int k = src.size() - 1; k >= 0; --k) {
                        if (k < src.size() - 1) {
                            source.append("-> ");
                        }
                        source.append(SlotPath.unescape((String)src.get(k).encodeToString()).toString());
                        if (k - 1 < 0) continue;
                        source.append("\n");
                    }
                    if (props[i].getName().equals("source") && (sourceName = (BString)this.alarm.getAlarmData().get("sourceName")) != null && sourceName != BString.DEFAULT) {
                        source.insert(0, BFormat.make((String)sourceName.toString(cx)).format((Object)this.alarm) + "\n");
                    }
                    BTextEditor textEditor = new BTextEditor(source.toString(), false);
                    textEditor.setRenderer(new TextRenderer(){

                        public BBrush getBackground() {
                            return BBrush.NULL;
                        }
                    });
                    this.alarmPane.add(null, (BValue)textEditor, null);
                }
                catch (Exception e) {
                    this.alarmPane.add(null, (BValue)new BLabel("unknown"), null);
                }
                continue;
            }
            if (props[i].getType().is(BAbsTime.TYPE)) {
                BAbsTime ts = (BAbsTime)this.alarm.get(props[i]);
                String value = "";
                value = this.timeZoneDisplay == BTimeZoneDisplay.source ? ts.toString((Context)BFacets.make((BFacets)this.alarm.getAlarmData(), (BFacets)TIME_FACETS)) : ts.toString((Context)BFacets.make((BFacets)TIME_FACETS, (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
                BTextEditor editor = new BTextEditor(value, false);
                editor.setRenderer(new TextRenderer(){

                    public BBrush getBackground() {
                        return BBrush.NULL;
                    }
                });
                this.alarmPane.add(null, (BValue)editor);
                continue;
            }
            String value = SlotPath.unescape((String)this.alarm.get(props[i].getName()).toString());
            value = TextUtil.replace((String)value, (String)"\\n", (String)"\n");
            if (props[i].getName().equals("alarmClass")) {
                value = this.alarmService.getAlarmClassDisplayName((Object)BString.make((String)this.alarm.get(props[i].getName()).toString()), cx).toString();
            }
            BTextEditor editor = new BTextEditor(value, false);
            editor.setRenderer(new TextRenderer(){

                public BBrush getBackground() {
                    return BBrush.NULL;
                }
            });
            this.alarmPane.add(null, (BValue)editor);
        }
        BString str = (BString)this.alarm.getAlarmData().get("hyperlinkOrd");
        BOrd hyperlink = BOrd.NULL;
        if (str != null) {
            hyperlink = BOrd.make((String)str.toString());
        }
        if (hyperlink == null || hyperlink.isNull() && this.console != null) {
            BAlarmClassMapping mapping = this.console.options.getAlarmClassMapping();
            BAlarmClassDef acDef = mapping.getAlarmClassDefFor(this.alarm.getAlarmClass());
            hyperlink = acDef.getAlarmUrl();
        }
        if (hyperlink != null && !hyperlink.isNull()) {
            this.hyperlinkCmd.setEnabled(true);
        } else {
            this.hyperlinkCmd.setEnabled(false);
        }
    }

    protected void alarmCleared() {
        this.notesCmd.setEnabled(false);
        this.ackCmd.setEnabled(false);
        this.hyperlinkCmd.setEnabled(false);
    }

    private String[] addNotePropertyIfNotPresent(String[] keys) {
        boolean isNotesPresent = false;
        for (int k = 0; k < keys.length; ++k) {
            if (!"notes".equals(keys[k])) continue;
            isNotesPresent = true;
            break;
        }
        if (!isNotesPresent) {
            String[] temp = new String[keys.length + 1];
            int k = 0;
            for (k = 0; k < keys.length; ++k) {
                temp[k] = keys[k];
            }
            temp[k] = "notes";
            keys = temp;
        }
        return keys;
    }

    private class ShowVideoCommand
    extends Command {
        public ShowVideoCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.showVideo");
        }

        public CommandArtifact doInvoke() {
            block8: {
                try {
                    Class videoAlmConsoleExt = Sys.loadClass((String)"videoDriver", (String)"com.tridium.videoDriver.ui.alarm.AlarmConsoleExt");
                    if (videoAlmConsoleExt != null) {
                        Method doShowVideoMethod = videoAlmConsoleExt.getMethod("doShowVideo", BAlarmConsole.class, BAlarmRecord.class);
                        if (doShowVideoMethod != null) {
                            doShowVideoMethod.invoke((Object)videoAlmConsoleExt, BAlarmDetailsDialog.this.console, BAlarmDetailsDialog.this.alarm);
                        } else {
                            System.out.println("The 'doShowVideo' method was not found on class AlarmConsoleExt in videoDriver.jar. Please have my program fixed");
                        }
                        break block8;
                    }
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)cnfe);
                }
                catch (NoSuchMethodException nsme) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)nsme);
                }
                catch (InvocationTargetException ite) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)ite);
                }
                catch (IllegalAccessException iae) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)iae);
                }
            }
            return null;
        }
    }

    private class NextCommand
    extends Command {
        Context cx;

        public NextCommand(BWidget owner, Context cx) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.forward");
            this.cx = cx;
        }

        public String getLabel() {
            return "Previous";
        }

        public CommandArtifact doInvoke() {
            BOrdList src = BAlarmDetailsDialog.this.alarm.getSource();
            int size = BAlarmDetailsDialog.this.tm.getAlarmCount(src);
            for (int i = 0; i < size; ++i) {
                if (!BAlarmDetailsDialog.this.tm.getRecord(src, i).getUuid().equals((Object)BAlarmDetailsDialog.this.alarm.getUuid())) continue;
                if (i > 0) {
                    BAlarmDetailsDialog.this.alarm = BAlarmDetailsDialog.this.tm.getRecord(src, i - 1);
                    BAlarmDetailsDialog.this.createAlarmPane(this.cx);
                    BAlarmDetailsDialog.this.alarmPane.relayout();
                    --i;
                }
                BAlarmDetailsDialog.this.prevCmd.setEnabled(i != 0);
                BAlarmDetailsDialog.this.nextCmd.setEnabled(i + 1 < size);
                return null;
            }
            BAlarmDetailsDialog.this.prevCmd.setEnabled(false);
            BAlarmDetailsDialog.this.nextCmd.setEnabled(false);
            return null;
        }
    }

    private class PrevCommand
    extends Command {
        Context cx;

        public PrevCommand(BWidget owner, Context cx) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.back");
            this.cx = cx;
        }

        public String getLabel() {
            return "Next";
        }

        public CommandArtifact doInvoke() {
            BOrdList src = BAlarmDetailsDialog.this.alarm.getSource();
            int size = BAlarmDetailsDialog.this.tm.getAlarmCount(src);
            for (int i = 0; i < size; ++i) {
                if (!BAlarmDetailsDialog.this.tm.getRecord(src, i).getUuid().equals((Object)BAlarmDetailsDialog.this.alarm.getUuid())) continue;
                if (i + 1 < size) {
                    BAlarmDetailsDialog.this.alarm = BAlarmDetailsDialog.this.tm.getRecord(src, i + 1);
                    BAlarmDetailsDialog.this.createAlarmPane(this.cx);
                    BAlarmDetailsDialog.this.alarmPane.relayout();
                    ++i;
                }
                BAlarmDetailsDialog.this.prevCmd.setEnabled(i != 0);
                BAlarmDetailsDialog.this.nextCmd.setEnabled(i + 1 < size);
                return null;
            }
            BAlarmDetailsDialog.this.prevCmd.setEnabled(false);
            BAlarmDetailsDialog.this.nextCmd.setEnabled(false);
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand(BWidget owner) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.close");
        }

        public CommandArtifact doInvoke() {
            BAlarmDetailsDialog.this.close();
            return null;
        }
    }

    private class HyperlinkCommand
    extends Command {
        public HyperlinkCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.hyperlink");
        }

        public CommandArtifact doInvoke() {
            BAlarmDetailsDialog.this.console.hyperlink(BAlarmDetailsDialog.this.alarm);
            return null;
        }
    }

    private class NotesCommand
    extends Command {
        public NotesCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.notes");
        }

        public CommandArtifact doInvoke() {
            if (BAlarmDetailsDialog.this.console != null) {
                BAlarmDetailsDialog.this.console.showNotes((BWidget)BAlarmDetailsDialog.this.alarmPane, new BAlarmRecord[]{BAlarmDetailsDialog.this.alarm});
            } else {
                if (BAlarmDetailsDialog.this.connection == null) {
                    AlarmException exception = new AlarmException("Unable to find alarmConnection");
                    BAlarmDetailsDialog.this.logger.log(Level.WARNING, "Unable to find alarmDBChannel", (Throwable)exception);
                    throw exception;
                }
                this.showAndAddNotes();
            }
            return null;
        }

        private void showAndAddNotes() {
            String notes = "";
            try {
                notes = ((BString)BAlarmDetailsDialog.this.alarm.getAlarmData().getFacet("notes")).getString();
            }
            catch (Exception e) {
                BAlarmDetailsDialog.this.logger.log(Level.WARNING, "Exception occurred while fetching the notes ", e);
            }
            BNotesDialog dlg = new BNotesDialog(null, notes, BAlarmDetailsDialog.this.username, true);
            dlg.setBoundsCenteredOnOwner();
            dlg.open();
            String newText = dlg.getNewNotes();
            if (newText != null) {
                String[] keys;
                notes = newText + notes;
                BFacets alarmData = BAlarmDetailsDialog.this.alarm.getAlarmData();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String key : keys = alarmData.list()) {
                    if (key.equals("notes")) continue;
                    BIDataValue value = (BIDataValue)alarmData.get(key);
                    map.put(key, value);
                }
                map.put("notes", BString.make((String)notes));
                BFacets f = BFacets.make(map);
                BAlarmDetailsDialog.this.alarm.setAlarmData(f);
                try {
                    BAlarmDetailsDialog.this.connection.update(BAlarmDetailsDialog.this.alarm);
                }
                catch (Exception e) {
                    BAlarmDetailsDialog.this.logger.log(Level.WARNING, "Exception while updating the notes for an alarm", e);
                }
            }
        }
    }

    private class AckCommand
    extends Command {
        public AckCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.acknowledge");
        }

        public CommandArtifact doInvoke() {
            BAlarmDetailsDialog.this.console.acknowledgeAlarms(new BAlarmRecord[]{BAlarmDetailsDialog.this.alarm});
            BAlarmDetailsDialog.this.prevCmd.setEnabled(false);
            BAlarmDetailsDialog.this.nextCmd.setEnabled(false);
            return null;
        }
    }
}

