/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.alarm.ui.SourceTableModel;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.nre.util.SortUtil;

public class AlarmTableModel
extends ConsoleTableModel {
    private SourceTableModel.AlarmList alarmList;

    public AlarmTableModel(ConsoleColumns columns, SourceTableModel.AlarmList alarmList) {
        super(columns);
        this.alarmList = alarmList;
        alarmList.setModel(this);
        this.sortByColumn(this.getLastSortColumn(), this.getLastSortAscending());
    }

    @Override
    public int getAlarmCount() {
        return this.getRowCount();
    }

    @Override
    public int getSourceCount() {
        return 1;
    }

    public int getRowCount() {
        return this.alarmList.size();
    }

    @Override
    public BAlarmRecord getRecord(int row) {
        SourceTableModel.AlarmEntry entry = this.alarmList.getEntry(row);
        return entry.rec;
    }

    @Override
    public void close() {
        super.close();
        this.alarmList.setModel(null);
    }

    public synchronized void sortByColumn(int col, boolean ascending) {
        if (col < 0 || col >= super.getColumnCount()) {
            return;
        }
        this.setInitialSort(col, ascending);
        ConsoleColumns.Column column = this.getColumns().getColumn(col);
        if (ascending) {
            this.alarmList.sort(column, SortUtil.ASCENDING);
        } else {
            this.alarmList.sort(column, SortUtil.DESCENDING);
        }
    }
}

