/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:NumericWritable"})})
@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.POSITIVE_INTEGER_VALUE)", flags=64, override=true)
public class BBacnetPositiveIntegerValuePrioritizedDescriptor
extends BBacnetAnalogWritableDescriptor {
    @Generated
    public static final Property objectId = BBacnetPositiveIntegerValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(48), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetPositiveIntegerValuePrioritizedDescriptor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BBacnetReliability validatePoint(BNumericPoint point, BStatusNumeric pointOut) {
        return this.validatePositiveIntegerPoint(point, pointOut);
    }

    @Override
    public int asnType() {
        return 2;
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnUnsigned((long)value);
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }

    @Override
    public void appendToAsn(AsnOutputStream out, double value) {
        out.writeUnsignedInteger((long)value);
    }

    @Override
    public double readFromAsn(AsnInputStream in) throws AsnException {
        return in.readUnsignedInteger();
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.units);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        this.addPrioritizedValueObjectOptionalProps(v);
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(48);
        }
        return super.getSlotFacets(s);
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        switch (pId) {
            case 388: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getHighLimit()));
            }
            case 389: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getLowLimit()));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 388: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.highLimit, this.convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
            case 389: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.lowLimit, this.convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

