/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.schedule.ScheduleSupport16;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"schedule:CalendarSchedule"})})
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="calendarOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=64, facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:Component\"")}), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.CALENDAR)", flags=64), @NiagaraProperty(name="objectName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="description", type="String", defaultValue="")})
public class BBacnetCalendarDescriptor
extends BComponent
implements BIBacnetExportObject,
BacnetPropertyListProvider {
    @Generated
    public static final Property status = BBacnetCalendarDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BBacnetCalendarDescriptor.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property calendarOrd = BBacnetCalendarDescriptor.newProperty((int)64, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    @Generated
    public static final Property objectId = BBacnetCalendarDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(6), null);
    @Generated
    public static final Property objectName = BBacnetCalendarDescriptor.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property description = BBacnetCalendarDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetCalendarDescriptor.class);
    private boolean fatalFault = false;
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"calendar.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private BCalendarSchedule calendar;
    private BBacnetObjectIdentifier oldId = null;
    private String oldName = null;
    private boolean duplicate = false;
    private static final AsnInputStream asnIn = new AsnInputStream();
    private static final AsnOutputStream asnOut = new AsnOutputStream();
    private static ScheduleSupport0 supp = new ScheduleSupport16();
    private static final Logger log = Logger.getLogger("bacnet.server");
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 85, 23};
    private static final int[] OPTIONAL_PROPS = new int[]{28};

    @Override
    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BOrd getCalendarOrd() {
        return (BOrd)this.get(calendarOrd);
    }

    @Generated
    public void setCalendarOrd(BOrd v) {
        this.set(calendarOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    @Generated
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    @Generated
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        local.unsubscribe(this, this.calendar);
        this.oldId = null;
        this.oldName = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(calendarOrd)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.getName() == "protocolRevision") {
            BBacnetCalendarDescriptor.setSupport(((BInteger)this.get("protocolRevision")).getInt());
        }
    }

    private static void setSupport(int protocolRevision) {
        supp = ScheduleSupport0.makeForProtocolRevision(protocolRevision, supp);
        log.info("Server calendar support (new) is now " + supp.getClass());
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(6);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public final BObject getObject() {
        return this.getCalendar();
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getCalendarOrd();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(calendarOrd, (BValue)objectOrd, cx);
    }

    @Override
    public void checkConfiguration() {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        local.unsubscribe(this, this.calendar);
        this.findCalendar();
        boolean configOk = true;
        if (this.calendar == null) {
            this.setFaultCause("Cannot find exported calendar");
            configOk = false;
        } else {
            local.subscribe(this, this.calendar);
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            configOk = false;
        }
        if (configOk) {
            String err = local.export(this);
            if (err != null) {
                this.duplicate = true;
                this.setFaultCause(err);
                configOk = false;
            } else {
                this.duplicate = false;
            }
        }
        if (configOk) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (!configOk ? 1 : 0) != 0));
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        this.getCalendar();
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        this.getCalendar();
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(new PropertyValue[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        this.getCalendar();
        if (this.calendar == null) {
            return new ReadRangeAck(1, 1000);
        }
        int propertyId = rangeReference.getPropertyId();
        if (!BBacnetCalendarDescriptor.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 23) {
            return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (rangeReference.getPropertyArrayIndex() != -1) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        int rangeType = rangeReference.getRangeType();
        switch (rangeType) {
            case 6: {
                return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotNumbered);
            }
            case 7: {
                return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotTimestamped);
            }
            case -1: 
            case 3: {
                break;
            }
            default: {
                return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.parameterOutOfRange);
            }
        }
        int maxDataLength = -1;
        if (rangeReference instanceof BacnetConfirmedRequest) {
            maxDataLength = ((BacnetConfirmedRequest)((Object)rangeReference)).getMaxDataLength() - 23 + 3 + 5;
        }
        boolean[] rflags = new boolean[]{false, false, false};
        BAbstractSchedule[] dateList = (BAbstractSchedule[])this.calendar.getChildren(BAbstractSchedule.class);
        int len = dateList.length;
        if (rangeType == 3) {
            int i;
            int refNdx = (int)rangeReference.getReferenceIndex();
            int count = rangeReference.getCount();
            if (refNdx > len || refNdx < 1) {
                return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
            }
            Array a = new Array(BAbstractSchedule.class);
            int itemsFound = 0;
            if (count > 0) {
                for (i = refNdx - 1; i < len && itemsFound < count; ++itemsFound, ++i) {
                    a.add((Object)dateList[i]);
                }
                if (refNdx == 1) {
                    rflags[0] = true;
                }
                if (refNdx + count - 1 >= len) {
                    rflags[1] = true;
                }
            } else if (count < 0) {
                count = -count;
                for (i = refNdx - 1; i >= 0 && itemsFound < count; ++itemsFound, --i) {
                    a.add((Object)dateList[i]);
                }
                a = a.reverse();
                if (refNdx - count <= 0) {
                    rflags[0] = true;
                }
                if (refNdx == len) {
                    rflags[1] = true;
                }
            } else {
                return new ReadRangeAck(5, 7);
            }
            ListIterator it = a.iterator();
            int itemCount = 0;
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                if (maxDataLength > 0) {
                    while (it.hasNext()) {
                        if (maxDataLength - asnOut.size() < 12) {
                            rflags[1] = false;
                            break;
                        }
                        supp.encodeCalendarEntry((BAbstractSchedule)it.next(), asnOut);
                        ++itemCount;
                    }
                } else {
                    itemCount = itemsFound;
                    while (it.hasNext()) {
                        supp.encodeCalendarEntry((BAbstractSchedule)it.next(), asnOut);
                    }
                }
                if (itemCount < itemsFound) {
                    rflags[2] = true;
                }
                return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, asnOut.toByteArray());
            }
        }
        rflags[0] = false;
        int itemCount = 0;
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            if (maxDataLength > 0) {
                for (int i = 0; i < len; ++i) {
                    supp.encodeCalendarEntry(dateList[i], asnOut);
                    ++itemCount;
                    if (maxDataLength - asnOut.size() < 12) break;
                }
                if (itemCount > 0) {
                    rflags[0] = true;
                }
                if (itemCount > 0 && itemCount == len) {
                    rflags[1] = true;
                }
            } else {
                itemCount = len;
                for (int i = 0; i < len; ++i) {
                    supp.encodeCalendarEntry(dateList[i], asnOut);
                }
                if (itemCount > 0) {
                    rflags[0] = true;
                }
                if (itemCount > 0 && itemCount == len) {
                    rflags[1] = true;
                }
            }
            if (itemCount < len) {
                rflags[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, asnOut.toByteArray());
        }
    }

    private static boolean hasProperty(int propertyId) {
        for (int id : REQUIRED_PROPS) {
            if (id != propertyId) continue;
            return true;
        }
        for (int id : OPTIONAL_PROPS) {
            if (id != propertyId) continue;
            return true;
        }
        return propertyId == 371;
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        this.getCalendar();
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        BCalendarSchedule c = this.getCalendar();
        if (c == null) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        int propertyId = propertyValue.getPropertyId();
        if (!BBacnetCalendarDescriptor.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 23) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        return this.addDates(propertyValue);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        BCalendarSchedule c = this.getCalendar();
        if (c == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        int propertyId = propertyValue.getPropertyId();
        if (!BBacnetCalendarDescriptor.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 23) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        return this.removeDates(propertyValue);
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, OPTIONAL_PROPS);
    }

    protected PropertyValue readProperty(int pId, int ndx) {
        if (this.calendar == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && pId != 371) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 371: {
                return this.readPropertyList(ndx);
            }
            case 85: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.calendar.getOut().getValue()));
            }
            case 23: {
                return this.readDateList(ndx);
            }
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        if (this.calendar == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && pId != 371) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 75: 
                case 79: 
                case 85: 
                case 371: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName(this, objectName, val);
                }
                case 23: {
                    return this.writeDateList(val);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return new NErrorType(2, 32);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + "]";
    }

    protected final BCalendarSchedule getCalendar() {
        if (this.calendar == null) {
            return this.findCalendar();
        }
        return this.calendar;
    }

    private BCalendarSchedule findCalendar() {
        try {
            if (!calendarOrd.isEquivalentToDefaultValue((BValue)this.getCalendarOrd())) {
                BObject o = this.getCalendarOrd().get((BObject)this);
                this.calendar = o instanceof BCalendarSchedule ? (BCalendarSchedule)o : null;
            }
        }
        catch (Exception e) {
            log.warning("Unable to resolve calendar ord for " + this + ":" + this.getCalendarOrd() + ": " + e);
            this.calendar = null;
        }
        if (this.calendar == null && this.isRunning()) {
            this.setFaultCause("Cannot find exported calendar");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NReadPropertyResult readDateList(int ndx) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            supp.encodeDateList(this.calendar, asnOut);
            return new NReadPropertyResult(23, ndx, asnOut.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorType writeDateList(byte[] encodedValue) {
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(encodedValue);
                BCalendarSchedule newCalendar = supp.decodeDateList(asnIn);
                boolean cleanup = this.calendar.getCleanupExpiredEvents();
                newCalendar.setCleanupExpiredEvents(cleanup);
                this.calendar.copyFrom((BAbstractSchedule)newCalendar, BLocalBacnetDevice.getBacnetContext());
            }
            return null;
        }
        catch (OutOfRangeException e) {
            log.warning("Value out of range writing datelist in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.warning("AsnException writing datelist in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing datelist in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        catch (Exception e) {
            log.warning("Exception writing datelist in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NErrorType(2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeListError addDates(PropertyValue propertyValue) {
        int ffen = 1;
        ArrayList<BAbstractSchedule> v = new ArrayList<BAbstractSchedule>();
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                while (asnIn.peekTag() != -1) {
                    BAbstractSchedule ce = supp.decodeCalendarEntry(asnIn);
                    if (ce != null) {
                        v.add(ce);
                    }
                    ++ffen;
                }
            }
        }
        catch (AsnException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AsnException occurred in addDates in object " + (Object)((Object)this.getObjectId()), (Throwable)((Object)e));
            }
            return new NChangeListError(8, new NErrorType(2, 9), ffen);
        }
        try {
            for (BAbstractSchedule ce : v) {
                SlotCursor sc = this.calendar.getProperties();
                boolean alreadyHere = false;
                while (sc.next(BAbstractSchedule.class)) {
                    if (!ce.equivalent((Object)sc.get())) continue;
                    alreadyHere = true;
                    break;
                }
                if (alreadyHere) continue;
                this.calendar.add(null, (BValue)ce, BLocalBacnetDevice.getBacnetContext());
            }
            return null;
        }
        catch (PermissionException e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("PermissionException adding elements to datelist in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            }
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
        catch (Exception e) {
            log.warning("Exception adding elements to datelist in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NChangeListError(8, new NErrorType(2, 0), ffen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeListError removeDates(PropertyValue propertyValue) {
        BAbstractSchedule ce;
        int ffen = 1;
        ArrayList<BAbstractSchedule> v = new ArrayList<BAbstractSchedule>();
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                while (asnIn.peekTag() != -1) {
                    ce = supp.decodeCalendarEntry(asnIn);
                    if (ce != null) {
                        v.add(ce);
                    }
                    ++ffen;
                }
            }
        }
        catch (AsnException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AsnException occurred in removeDates in object " + (Object)((Object)this.getObjectId()), (Throwable)((Object)e));
            }
            return new NChangeListError(9, new NErrorType(2, 9), ffen);
        }
        try {
            BAbstractSchedule[] a = this.calendar.getSchedules();
            for (ffen = 1; ffen <= v.size(); ++ffen) {
                ce = (BAbstractSchedule)v.get(ffen - 1);
                boolean found = false;
                for (int i = 0; i < a.length; ++i) {
                    if (!ce.equivalent((Object)a[i])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return new NChangeListError(9, new NErrorType(5, 81), ffen);
            }
            block11: for (ffen = 0; ffen < v.size(); ++ffen) {
                ce = (BAbstractSchedule)v.get(ffen);
                for (int i = 0; i < a.length; ++i) {
                    if (!ce.equivalent((Object)a[i])) continue;
                    this.calendar.remove((BComplex)a[i]);
                    continue block11;
                }
            }
            return null;
        }
        catch (PermissionException e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("PermissionException removing elements from datelist in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            }
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
        catch (Exception e) {
            log.warning("Exception removing elements from datelist in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            return new NChangeListError(9, new NErrorType(2, 0), 0L);
        }
    }

    @Override
    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        BBacnetExportTable exports = null;
        BLocalBacnetDevice local = null;
        BBacnetNetwork network = null;
        if (this.fatalFault) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BBacnetExportTable) {
                exports = (BBacnetExportTable)parent;
                continue;
            }
            if (!(parent instanceof BLocalBacnetDevice)) continue;
            local = (BLocalBacnetDevice)parent;
            break;
        }
        if (exports == null || local == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (local.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + local.getFaultCause());
            return;
        }
        network = (BBacnetNetwork)local.getParent();
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        if (!network.hasServerLicense()) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetCalendarDescriptor", 2);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.prop((Object)"calendar", (Object)this.calendar);
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"duplicate", this.duplicate);
        out.prop((Object)"supp", (Object)supp);
        out.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }
}

