/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.logging.Level;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.conv.BReversePolarityConversion;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public abstract class BBacnetBinaryPointDescriptor
extends BBacnetPointDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBinaryPointDescriptor.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/booleanPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BBooleanPoint;
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BDiscreteTotalizerExt totExt = this.getTotalizerExt();
        if (totExt != null) {
            switch (pId) {
                case 16: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toBacnetDateTime(totExt.getChangeOfStateTime()));
                }
                case 15: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(totExt.getChangeOfStateCount()));
                }
                case 115: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toBacnetDateTime(totExt.getTimeOfStateCountReset()));
                }
                case 33: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(totExt.getElapsedActiveTime().getSeconds()));
                }
                case 114: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toBacnetDateTime(totExt.getTimeOfActiveTimeReset()));
                }
            }
        }
        BBooleanPoint pt = (BBooleanPoint)this.getPoint();
        switch (pId) {
            case 4: {
                BString tt = (BString)pt.getFacets().getFacet("trueText");
                if (tt == null) break;
                String trueText = BFormat.format((String)tt.toString(), null, null);
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(trueText));
            }
            case 46: {
                BString ft = (BString)pt.getFacets().getFacet("falseText");
                if (ft == null) break;
                String falseText = BFormat.format((String)ft.toString(), null, null);
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(falseText));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected byte[] makeInterfaceValue(BStatusValue proxyValue) {
        return AsnUtil.toAsnEnumerated(((BStatusBoolean)proxyValue).getValue());
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BDiscreteTotalizerExt totExt = this.getTotalizerExt();
        try {
            if (totExt != null) {
                switch (pId) {
                    case 16: {
                        return new NErrorType(2, 40);
                    }
                    case 15: {
                        long changeOfStateCount = AsnUtil.fromAsnUnsignedInteger(val);
                        if (changeOfStateCount == 0L) {
                            totExt.invoke(BDiscreteTotalizerExt.resetChangeOfStateCount, null, BLocalBacnetDevice.getBacnetContext());
                        } else {
                            if (changeOfStateCount > Integer.MAX_VALUE) {
                                return new NErrorType(2, 37);
                            }
                            totExt.setInt(BDiscreteTotalizerExt.changeOfStateCount, (int)changeOfStateCount, BLocalBacnetDevice.getBacnetContext());
                        }
                        return null;
                    }
                    case 115: {
                        BBacnetDateTime timeOfStateCountReset = new BBacnetDateTime();
                        AsnUtil.fromAsn(-4, val, (BValue)timeOfStateCountReset);
                        BBacnetBinaryPointDescriptor.checkDateTime(timeOfStateCountReset);
                        totExt.set(BDiscreteTotalizerExt.timeOfStateCountReset, (BValue)timeOfStateCountReset.toBAbsTime(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 33: {
                        long elapsedActiveTime = AsnUtil.fromAsnUnsignedInteger(val);
                        if (elapsedActiveTime == 0L) {
                            totExt.invoke(BDiscreteTotalizerExt.resetElapsedActiveTime, null, BLocalBacnetDevice.getBacnetContext());
                        } else {
                            if (elapsedActiveTime > Integer.MAX_VALUE) {
                                return new NErrorType(2, 37);
                            }
                            totExt.set(BDiscreteTotalizerExt.elapsedActiveTime, (BValue)BRelTime.makeSeconds((int)((int)elapsedActiveTime)), BLocalBacnetDevice.getBacnetContext());
                        }
                        return null;
                    }
                    case 114: {
                        BBacnetDateTime timeOfActiveTimeReset = new BBacnetDateTime();
                        AsnUtil.fromAsn(-4, val, (BValue)timeOfActiveTimeReset);
                        BBacnetBinaryPointDescriptor.checkDateTime(timeOfActiveTimeReset);
                        totExt.set(BDiscreteTotalizerExt.timeOfActiveTimeReset, (BValue)timeOfActiveTimeReset.toBAbsTime(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            BBooleanPoint pt = (BBooleanPoint)this.getPoint();
            switch (pId) {
                case 4: {
                    BString tt = (BString)pt.getFacets().getFacet("trueText");
                    if (tt == null) break;
                    pt.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)pt.getFacets(), (String)"trueText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(val))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 46: {
                    BString ft = (BString)pt.getFacets().getFacet("falseText");
                    if (ft == null) break;
                    pt.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)pt.getFacets(), (String)"falseText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(val))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return super.writeOptionalProperty(pId, ndx, val, pri);
        }
        catch (OutOfRangeException e) {
            log.warning("OutOfRangeException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    private static void checkDateTime(BBacnetDateTime dateTime) throws OutOfRangeException {
        BBacnetDate date = dateTime.getDate();
        if (date.isYearUnspecified() || date.isMonthUnspecified() || date.isMonthSpecial() || date.isDayOfMonthUnspecified() || date.isDayOfMonthSpecial()) {
            throw new OutOfRangeException("Date contains unspecified or special values for the year, month, or day-of-month: " + dateTime);
        }
        BBacnetTime time = dateTime.getTime();
        if (time.isHourUnspecified() || time.isMinuteUnspecified()) {
            throw new OutOfRangeException("Time contains unspecified values for the hour or minute: " + dateTime);
        }
    }

    @Override
    protected void validate() {
        if (!this.configOk.get()) {
            return;
        }
        if (this.getOosExt().getOutOfService()) {
            this.setFaultCause("");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            return;
        }
        BStatusBoolean sb = ((BBooleanPoint)this.getPoint()).getOut();
        BStatus s = sb.getStatus();
        if (s.isNull()) {
            this.setFaultCause("Invalid value for BACnet Object: " + sb);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            return;
        }
        this.setFaultCause("");
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
    }

    @Override
    BStatusValue getCurrentStatusValue() {
        BStatusBoolean sv = new BStatusBoolean(((BBooleanPoint)this.getPoint()).getOut().getValue());
        sv.setStatus(this.getStatusFlags());
        return sv;
    }

    @Override
    boolean checkCov(BStatusValue currentValue, BStatusValue covValue) {
        if (currentValue.getStatus().getBits() != covValue.getStatus().getBits()) {
            return true;
        }
        return ((BStatusBoolean)currentValue).getBoolean() != ((BStatusBoolean)covValue).getBoolean();
    }

    @Deprecated
    boolean checkCov(BControlPoint pt, BBacnetCovSubscription covSub) {
        boolean covValue;
        if (pt.getStatus().getBits() != covSub.getLastValue().getStatus().getBits()) {
            return true;
        }
        boolean currentValue = ((BBooleanPoint)pt).getBoolean();
        return currentValue != (covValue = ((BIBoolean)covSub.getLastValue()).getBoolean());
    }

    protected BDiscreteTotalizerExt getTotalizerExt() {
        BControlPoint pt = this.getPoint();
        if (pt == null) {
            return null;
        }
        SlotCursor c = pt.getProperties();
        if (c.next(BDiscreteTotalizerExt.class)) {
            return (BDiscreteTotalizerExt)c.get();
        }
        return null;
    }

    PropertyValue readPolarityProperty(BBooleanPoint pt) {
        BAbstractProxyExt proxyExt = pt.getProxyExt();
        if (proxyExt instanceof BProxyExt && ((BProxyExt)proxyExt).getConversion() instanceof BReversePolarityConversion) {
            return new NReadPropertyResult(84, AsnUtil.toAsnEnumerated(1));
        }
        return new NReadPropertyResult(84, AsnUtil.toAsnEnumerated(0));
    }

    protected ErrorType writePolarityProperty(BBooleanPoint pt, byte[] val) throws BacnetException {
        BAbstractProxyExt proxyExt = pt.getProxyExt();
        if (proxyExt instanceof BProxyExt) {
            if (AsnUtil.fromAsnEnumerated(val) == 1) {
                ((BProxyExt)proxyExt).setConversion((BProxyConversion)BReversePolarityConversion.DEFAULT);
            } else {
                ((BProxyExt)proxyExt).setConversion((BProxyConversion)BDefaultProxyConversion.DEFAULT);
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Cannot write the Polarity property when the associated point's proxy ext is not instanceof BProxyExt; object ID: " + (Object)((Object)this.getObjectId()) + ", object name: " + this.getObjectName());
        }
        return new NErrorType(2, 40);
    }

    public BIcon getIcon() {
        return icon;
    }
}

