/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperty(name="covIncrement", type="double", defaultValue="1.0")
public abstract class BBacnetAnalogPointDescriptor
extends BBacnetPointDescriptor {
    @Generated
    public static final Property covIncrement = BBacnetAnalogPointDescriptor.newProperty((int)0, (double)1.0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAnalogPointDescriptor.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/numericPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));

    @Generated
    public double getCovIncrement() {
        return this.getDouble(covIncrement);
    }

    @Generated
    public void setCovIncrement(double v) {
        this.setDouble(covIncrement, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BNumericPoint;
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.outOfRange;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BOutOfRangeAlgorithm;
        }
        return false;
    }

    public int asnType() {
        return 4;
    }

    public double getDeadBandValue(byte[] value) throws AsnException {
        return this.convertFromAsn(value);
    }

    public byte[] getDeadBandBytes(double value) {
        return this.convertToAsn(value);
    }

    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnReal(value);
    }

    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnReal(value);
    }

    public void appendToAsn(AsnOutputStream out, double value) {
        out.writeReal(value);
    }

    public double readFromAsn(AsnInputStream in) throws AsnException {
        return in.readReal();
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BNumericPoint pt = (BNumericPoint)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(pt.getOut().getValue()));
            }
            case 117: {
                BUnit u = (BUnit)pt.getFacets().getFacet("units");
                if (u != null) {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated((BEnum)BBacnetEngineeringUnits.make(u)));
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(95));
            }
            case 22: {
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(this.getCovIncrement()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BNumericPoint pt = (BNumericPoint)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 117: {
                    return new NErrorType(2, 40);
                }
                case 22: {
                    BNumber nmin = (BNumber)this.getPoint().getFacets().getFacet("min");
                    BNumber nmax = (BNumber)this.getPoint().getFacets().getFacet("max");
                    double min = nmin != null ? nmin.getDouble() : Double.NEGATIVE_INFINITY;
                    double max = nmax != null ? nmax.getDouble() : Double.POSITIVE_INFINITY;
                    double inc = this.getCovIncrement(val);
                    if (inc < 0.0 || inc > max - min) {
                        return new NErrorType(2, 37);
                    }
                    this.set(covIncrement, (BValue)BDouble.make((double)inc), BLocalBacnetDevice.getBacnetContext());
                    this.checkCov();
                    return null;
                }
            }
            return super.writeProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    protected double getCovIncrement(byte[] value) throws AsnException {
        return this.convertFromAsn(value);
    }

    protected void addValueObjectOptionalProps(Vector v) {
        BNumber prec;
        BNumber max;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.reliability);
        v.add(BBacnetPropertyIdentifier.outOfService);
        BControlPoint pt = this.getPoint();
        BNumber min = (BNumber)pt.getFacets().getFacet("min");
        if (min != null) {
            v.add(BBacnetPropertyIdentifier.minPresValue);
        }
        if ((max = (BNumber)pt.getFacets().getFacet("max")) != null) {
            v.add(BBacnetPropertyIdentifier.maxPresValue);
        }
        if ((prec = (BNumber)pt.getFacets().getFacet("precision")) != null) {
            v.add(BBacnetPropertyIdentifier.resolution);
        }
        v.add(BBacnetPropertyIdentifier.covIncrement);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.highLimit);
            v.add(BBacnetPropertyIdentifier.lowLimit);
            v.add(BBacnetPropertyIdentifier.deadband);
            v.add(BBacnetPropertyIdentifier.limitEnable);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
            if (alarmExt.getFaultAlgorithm() instanceof BOutOfRangeFaultAlgorithm) {
                v.add(BBacnetPropertyIdentifier.faultHighLimit);
                v.add(BBacnetPropertyIdentifier.faultLowLimit);
            }
        }
    }

    protected void addPrioritizedValueObjectOptionalProps(Vector v) {
        BNumber prec;
        BNumber max;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.reliability);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        BControlPoint pt = this.getPoint();
        BNumber min = (BNumber)pt.getFacets().getFacet("min");
        if (min != null) {
            v.add(BBacnetPropertyIdentifier.minPresValue);
        }
        if ((max = (BNumber)pt.getFacets().getFacet("max")) != null) {
            v.add(BBacnetPropertyIdentifier.maxPresValue);
        }
        if ((prec = (BNumber)pt.getFacets().getFacet("precision")) != null) {
            v.add(BBacnetPropertyIdentifier.resolution);
        }
        v.add(BBacnetPropertyIdentifier.covIncrement);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.highLimit);
            v.add(BBacnetPropertyIdentifier.lowLimit);
            v.add(BBacnetPropertyIdentifier.deadband);
            v.add(BBacnetPropertyIdentifier.limitEnable);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
            if (alarmExt.getFaultAlgorithm() instanceof BOutOfRangeFaultAlgorithm) {
                v.add(BBacnetPropertyIdentifier.faultHighLimit);
                v.add(BBacnetPropertyIdentifier.faultLowLimit);
            }
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BNumericPoint pt;
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BOutOfRangeAlgorithm alg = (BOutOfRangeAlgorithm)almExt.getOffnormalAlgorithm();
            switch (pId) {
                case 45: {
                    return new NReadPropertyResult(pId, ndx, this.convertToAsn(alg.getHighLimit()));
                }
                case 59: {
                    return new NReadPropertyResult(pId, ndx, this.convertToAsn(alg.getLowLimit()));
                }
                case 25: {
                    return new NReadPropertyResult(pId, ndx, this.getDeadBandBytes(alg.getDeadband()));
                }
                case 52: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetLimitEnable(alg.getLimitEnable())));
                }
            }
        }
        if ((pt = (BNumericPoint)this.getPoint()) == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        switch (pId) {
            case 69: {
                BNumber min = (BNumber)pt.getFacets().getFacet("min");
                if (min == null) break;
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(min.getDouble()));
            }
            case 65: {
                BNumber max = (BNumber)pt.getFacets().getFacet("max");
                if (max == null) break;
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(max.getDouble()));
            }
            case 106: {
                BNumber prec = (BNumber)pt.getFacets().getFacet("precision");
                if (prec == null) break;
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(Math.pow(10.0, -((double)prec.getFloat()))));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected byte[] makeInterfaceValue(BStatusValue proxyValue) {
        return AsnUtil.toAsnReal(((BStatusNumeric)proxyValue).getValue());
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        try {
            if (almExt != null) {
                BOutOfRangeAlgorithm alg = (BOutOfRangeAlgorithm)almExt.getOffnormalAlgorithm();
                BNumber nmin = (BNumber)this.getPoint().getFacets().getFacet("min");
                BNumber nmax = (BNumber)this.getPoint().getFacets().getFacet("max");
                double min = nmin != null ? nmin.getDouble() : Double.NEGATIVE_INFINITY;
                double max = nmax != null ? nmax.getDouble() : Double.POSITIVE_INFINITY;
                switch (pId) {
                    case 45: {
                        double hl = this.convertFromAsn(val);
                        if (hl < min || hl > max) {
                            return new NErrorType(2, 37);
                        }
                        alg.setDouble(BOutOfRangeAlgorithm.highLimit, this.convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 59: {
                        double ll = this.convertFromAsn(val);
                        if (ll < min || ll > max) {
                            return new NErrorType(2, 37);
                        }
                        alg.setDouble(BOutOfRangeAlgorithm.lowLimit, this.convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 25: {
                        double db = this.getDeadBandValue(val);
                        double hi = alg.getHighLimit();
                        double lo = alg.getLowLimit();
                        if (db < 0.0 || db > hi - lo) {
                            return new NErrorType(2, 37);
                        }
                        alg.setDouble(BOutOfRangeAlgorithm.deadband, db, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 52: {
                        BBacnetBitString le = AsnUtil.fromAsnBitString(val);
                        alg.set(BOutOfRangeAlgorithm.limitEnable, (BValue)BacnetBitStringUtil.getBLimitEnable(le), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            switch (pId) {
                case 65: {
                    BNumber max = (BNumber)this.getPoint().getFacets().getFacet("max");
                    if (max == null) break;
                    return new NErrorType(2, 40);
                }
                case 69: {
                    BNumber min = (BNumber)this.getPoint().getFacets().getFacet("min");
                    if (min == null) break;
                    return new NErrorType(2, 40);
                }
                case 106: {
                    BNumber prec = (BNumber)this.getPoint().getFacets().getFacet("precision");
                    if (prec == null) break;
                    return new NErrorType(2, 40);
                }
            }
            return super.writeOptionalProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected void validate() {
        BStatus pointStatus;
        BStatusNumeric pointOut;
        if (!this.configOk.get()) {
            return;
        }
        if (this.getOosExt().getOutOfService()) {
            this.setFaultCause("");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            BBacnetReliability algorithmicReliability = this.getAlgorithmicReliability();
            if (!algorithmicReliability.equals(BBacnetReliability.noFaultDetected)) {
                this.setReliability((BEnum)algorithmicReliability);
            } else {
                this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            }
            return;
        }
        BNumericPoint point = (BNumericPoint)this.getPoint();
        BBacnetReliability pointReliability = this.validatePoint(point, pointOut = point.getOut());
        if (!pointReliability.equals(BBacnetReliability.noFaultDetected)) {
            // empty if block
        }
        if ((pointStatus = pointOut.getStatus()).isFault()) {
            BBacnetReliability algorithmicReliability = this.getAlgorithmicReliability();
            if (!algorithmicReliability.equals(BBacnetReliability.noFaultDetected)) {
                this.setReliability((BEnum)algorithmicReliability);
            } else {
                this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            }
            return;
        }
        this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
    }

    protected BBacnetReliability validatePoint(BNumericPoint point, BStatusNumeric pointOut) {
        if (pointOut.getStatus().isNull()) {
            this.setFaultCause("Invalid value for BACnet Object: " + pointOut);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return BBacnetReliability.noFaultDetected;
        }
        this.setFaultCause("");
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        return BBacnetReliability.noFaultDetected;
    }

    BBacnetReliability validatePositiveIntegerPoint(BNumericPoint point, BStatusNumeric pointOut) {
        if (pointOut.getStatus().isNull()) {
            this.setFaultCause("Invalid value for BACnet Object: " + pointOut);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return BBacnetReliability.noFaultDetected;
        }
        BNumber min = (BNumber)point.getFacets().getFacet("min");
        if (min != null && BBacnetAnalogPointDescriptor.isFacetOutOfRange(min)) {
            this.setFaultCause(lex.getText("export.configurationFault.postiveIntergerValue.minValue", new Object[]{0L, 0xFFFFFFFFL}));
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return BBacnetReliability.noFaultDetected;
        }
        BNumber max = (BNumber)point.getFacets().getFacet("max");
        if (max != null && BBacnetAnalogPointDescriptor.isFacetOutOfRange(max)) {
            this.setFaultCause(lex.getText("export.configurationFault.postiveIntergerValue.maxValue", new Object[]{0L, 0xFFFFFFFFL}));
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return BBacnetReliability.noFaultDetected;
        }
        this.setFaultCause("");
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        return BBacnetReliability.noFaultDetected;
    }

    private static boolean isFacetOutOfRange(BNumber facet) {
        return facet.getLong() < 0L || facet.getLong() > 0xFFFFFFFFL;
    }

    private BBacnetReliability getAlgorithmicReliability() {
        BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm) {
            BOutOfRangeFaultAlgorithm outOfRange = (BOutOfRangeFaultAlgorithm)faultAlgorithm;
            if (outOfRange.getInLowState()) {
                return BBacnetReliability.underRange;
            }
            if (outOfRange.getInHighState()) {
                return BBacnetReliability.overRange;
            }
        }
        return BBacnetReliability.noFaultDetected;
    }

    @Override
    BStatusValue getCurrentStatusValue() {
        BStatusNumeric sv = new BStatusNumeric(((BNumericPoint)this.getPoint()).getOut().getValue());
        sv.setStatus(this.getStatusFlags());
        return sv;
    }

    @Override
    boolean checkCov(BStatusValue currentValue, BStatusValue covValue) {
        if (currentValue.getStatus().getBits() != covValue.getStatus().getBits()) {
            return true;
        }
        double cur = ((BStatusNumeric)currentValue).getNumeric();
        double lst = ((BStatusNumeric)covValue).getNumeric();
        if (Double.isNaN(cur)) {
            return !Double.isNaN(lst);
        }
        if (Double.isNaN(lst)) {
            return true;
        }
        return Math.abs(((BStatusNumeric)currentValue).getNumeric() - ((BStatusNumeric)covValue).getNumeric()) >= this.getCovIncrement();
    }

    @Deprecated
    boolean checkCov(BControlPoint pt, BBacnetCovSubscription covSub) {
        double covValue;
        if (pt.getStatus().getBits() != covSub.getLastValue().getStatus().getBits()) {
            return true;
        }
        double currentValue = ((BNumericPoint)pt).getNumeric();
        return Math.abs(currentValue - (covValue = ((BINumeric)covSub.getLastValue()).getNumeric())) >= this.getCovIncrement();
    }

    public BIcon getIcon() {
        return icon;
    }
}

