/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:NumericWritable"})})
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.ANALOG_OUTPUT)", flags=64, override=true), @NiagaraProperty(name="deviceType", type="String", defaultValue="")})
public class BBacnetAnalogOutputDescriptor
extends BBacnetAnalogWritableDescriptor {
    @Generated
    public static final Property objectId = BBacnetAnalogOutputDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(1), null);
    @Generated
    public static final Property deviceType = BBacnetAnalogOutputDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAnalogOutputDescriptor.class);

    @Generated
    public String getDeviceType() {
        return this.getString(deviceType);
    }

    @Generated
    public void setDeviceType(String v) {
        this.setString(deviceType, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(1);
        }
        return super.getSlotFacets(s);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.units);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        BNumber prec;
        BNumber max;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.deviceType);
        v.add(BBacnetPropertyIdentifier.reliability);
        BControlPoint pt = this.getPoint();
        BNumber min = (BNumber)pt.getFacets().getFacet("min");
        if (min != null) {
            v.add(BBacnetPropertyIdentifier.minPresValue);
        }
        if ((max = (BNumber)pt.getFacets().getFacet("max")) != null) {
            v.add(BBacnetPropertyIdentifier.maxPresValue);
        }
        if ((prec = (BNumber)pt.getFacets().getFacet("precision")) != null) {
            v.add(BBacnetPropertyIdentifier.resolution);
        }
        v.add(BBacnetPropertyIdentifier.covIncrement);
        v.add(BBacnetPropertyIdentifier.interfaceValue);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.highLimit);
            v.add(BBacnetPropertyIdentifier.lowLimit);
            v.add(BBacnetPropertyIdentifier.deadband);
            v.add(BBacnetPropertyIdentifier.limitEnable);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        switch (pId) {
            case 31: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDeviceType()));
            }
            case 387: {
                return this.readInterfaceValue();
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 31: 
            case 387: {
                return new NErrorType(2, 40);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

