/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BBacnetUnsigned
extends BSimple
implements BIComparable {
    private static final BBacnetUnsigned ZERO = new BBacnetUnsigned(0L);
    private static final BBacnetUnsigned ONE = new BBacnetUnsigned(1L);
    private static final BBacnetUnsigned TWO = new BBacnetUnsigned(2L);
    public static final long MAX_UNSIGNED_VALUE = 0xFFFFFFFFL;
    public static final long MIN_UNSIGNED_VALUE = 0L;
    public static final long MAX_UNSIGNED16_VALUE = 65535L;
    public static final long MAX_UNSIGNED8_VALUE = 255L;
    public static final BBacnetUnsigned DEFAULT = ZERO;
    public static final BBacnetUnsigned MAX_UNSIGNED = new BBacnetUnsigned(0xFFFFFFFFL);
    public static final Type TYPE = Sys.loadType(BBacnetUnsigned.class);
    private long value;

    public BBacnetUnsigned(long value) {
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("" + value);
        }
        this.value = value;
    }

    public static BBacnetUnsigned make(long value) {
        switch ((int)value) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
        }
        return new BBacnetUnsigned(value);
    }

    public int compareTo(Object obj) {
        int a = (int)this.value;
        int b = ((BNumber)obj).getInt();
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BBacnetUnsigned) {
            return ((BBacnetUnsigned)((Object)obj)).value == this.value;
        }
        return false;
    }

    public String toString(Context context) {
        BEnumRange r;
        if (context != null && (r = (BEnumRange)context.getFacet("range")) != null) {
            return SlotPath.unescape((String)r.getTag((int)this.value));
        }
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return (int)this.value;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public BObject decode(DataInput in) throws IOException {
        return BBacnetUnsigned.make(in.readLong());
    }

    public String encodeToString() throws IOException {
        return String.valueOf(this.value);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BBacnetUnsigned.make(Long.parseLong(s));
        }
        catch (Exception e) {
            throw new IOException("Invalid unsigned: " + s);
        }
    }

    public int getInt() {
        return (int)this.value;
    }

    public long getLong() {
        return this.value;
    }

    public long getUnsigned() {
        return this.value;
    }

    public Type getType() {
        return TYPE;
    }
}

