/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.AsyncEventNotificationRequest;
import com.tridium.bacnet.util.BacnetAlarmRecipientUtil;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeRange", type="BTimeRange", defaultValue="new BTimeRange(BTime.make(0, 0, 0, 0), BTime.make(23, 59, 59, 999))", override=true), @NiagaraProperty(name="transitions", type="BAlarmTransitionBits", defaultValue="BAlarmTransitionBits.make(BAlarmTransitionBits.TO_OFFNORMAL | BAlarmTransitionBits.TO_FAULT | BAlarmTransitionBits.TO_NORMAL)", override=true), @NiagaraProperty(name="routeAcks", type="boolean", defaultValue="true", flags=1, override=true), @NiagaraProperty(name="recipient", type="BBacnetRecipient", defaultValue="new BBacnetRecipient()", flags=8), @NiagaraProperty(name="processIdentifier", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.make(0)"), @NiagaraProperty(name="issueConfirmedNotifications", type="boolean", defaultValue="false")})
public class BBacnetDestination
extends BAlarmRecipient
implements BIBacnetDataType,
BacnetAlarmConst {
    @Generated
    public static final Property timeRange = BBacnetDestination.newProperty((int)0, (BValue)new BTimeRange(BTime.make((int)0, (int)0, (int)0, (int)0), BTime.make((int)23, (int)59, (int)59, (int)999)), null);
    @Generated
    public static final Property transitions = BBacnetDestination.newProperty((int)0, (BValue)BAlarmTransitionBits.make((int)7), null);
    @Generated
    public static final Property routeAcks = BBacnetDestination.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property recipient = BBacnetDestination.newProperty((int)8, (BValue)new BBacnetRecipient(), null);
    @Generated
    public static final Property processIdentifier = BBacnetDestination.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), null);
    @Generated
    public static final Property issueConfirmedNotifications = BBacnetDestination.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDestination.class);
    private boolean client = false;
    private BEnumRange eventStateRange = BBacnetEventState.DEFAULT.getRange();
    private final Logger log = Logger.getLogger("bacnet.server");
    public static final long LOCAL_PROCESS_ID = 0L;
    public static final int MAX_ENCODED_SIZE = 35;

    @Generated
    public BBacnetRecipient getRecipient() {
        return (BBacnetRecipient)this.get(recipient);
    }

    @Generated
    public void setRecipient(BBacnetRecipient v) {
        this.set(recipient, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getProcessIdentifier() {
        return (BBacnetUnsigned)this.get(processIdentifier);
    }

    @Generated
    public void setProcessIdentifier(BBacnetUnsigned v) {
        this.set(processIdentifier, (BValue)v, null);
    }

    @Generated
    public boolean getIssueConfirmedNotifications() {
        return this.getBoolean(issueConfirmedNotifications);
    }

    @Generated
    public void setIssueConfirmedNotifications(boolean v) {
        this.setBoolean(issueConfirmedNotifications, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void handleAlarm(BAlarmRecord alarmRecord) {
        try {
            BBacnetEventSource evtSrc;
            boolean stateChanged;
            BSourceState newToState;
            boolean ackAlarmAndNormal;
            BBacnetEventState fromState;
            BBacnetEventState toState;
            BBacnetObjectIdentifier eventObjectId;
            BComponent eventObject;
            BObject alarmSource;
            block61: {
                boolean traceOn = this.log.isLoggable(Level.FINE);
                if (traceOn) {
                    this.log.fine("handleAlarm on " + SlotPath.unescape((String)this.getName()) + ":" + alarmRecord + "\n alarmData=" + alarmRecord.getAlarmData() + "\n uuid=" + alarmRecord.getUuid());
                }
                alarmSource = alarmRecord.getSource().get(0).get((BObject)this);
                eventObject = alarmSource.asComplex().getParent().asComponent();
                eventObjectId = BacnetAlarmRecipientUtil.getEventObjectId(alarmSource);
                if (eventObjectId == null) {
                    this.log.warning("Alarm " + alarmRecord.getUuid() + " not sent to " + this.getRecipient() + ": object " + eventObject.getName() + " not exposed to BACnet!");
                    return;
                }
                BString toSt = (BString)alarmRecord.getAlarmFacet("toState");
                toState = toSt != null ? BBacnetEventState.make(toSt.getString()) : BBacnetEventState.make(alarmRecord.getSourceState());
                BString fromSt = (BString)alarmRecord.getAlarmFacet("fromState");
                fromState = fromSt != null ? BBacnetEventState.make(fromSt.getString()) : BBacnetEventState.make(alarmRecord.getSourceState());
                ackAlarmAndNormal = false;
                BInteger stateAcked = (BInteger)alarmRecord.getAlarmFacet("stateAcked");
                BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarmRecord.getAlarmClass());
                newToState = alarmRecord.getSourceState();
                String destinationPath = this.getSlotPathOrd().toString(null).substring(alarmService.getSlotPathOrd().toString(null).length());
                BInteger oldToState = (BInteger)alarmRecord.getAlarmFacet(SlotPath.escape((String)destinationPath));
                stateChanged = oldToState != null ? oldToState.getInt() != newToState.getOrdinal() : true;
                alarmRecord.addAlarmFacet(SlotPath.escape((String)destinationPath), (BIDataValue)BInteger.make((int)newToState.getOrdinal()));
                if (traceOn) {
                    this.log.fine("stateChanged=" + stateChanged + " ar:" + this.ackDump(alarmRecord));
                }
                if (stateChanged) {
                    Object acAckReq;
                    if (traceOn) {
                        this.log.fine("stateAcked=" + stateAcked + " ar:" + this.ackDump(alarmRecord));
                    }
                    if (stateAcked == null) {
                        BInteger acksReqFacet;
                        if (traceOn) {
                            this.log.fine(" new alarm - add acksReq to BAC_ACK_REQUIRED");
                        }
                        int acksReq = 0;
                        if (alarmSource instanceof BAlarmSourceExt && (acksReqFacet = (BInteger)alarmRecord.getAlarmFacet("bacnetAcksRequired")) != null) {
                            acksReq = acksReqFacet.getInt();
                        }
                        acAckReq = alarmClass.getAckRequired();
                        if (BBacnetEventState.isOffnormal((BEnum)toState)) {
                            if (acAckReq.isToOffnormal()) {
                                alarmRecord.removeAlarmFacet("offnormalAcked");
                                acksReq |= 4;
                            }
                        } else if (BBacnetEventState.isFault((BEnum)toState)) {
                            if (acAckReq.isToFault()) {
                                acksReq |= 2;
                            }
                        } else if (BBacnetEventState.isNormal((BEnum)toState)) {
                            boolean isNormalAlarmEnabledForAlarmSrcLogExt;
                            boolean isNormalAlarmEnabledForTrendLogExt = alarmSource instanceof BBacnetTrendLogAlarmSourceExt && !((BBacnetTrendLogAlarmSourceExt)alarmSource).getAlarmEnable().isToNormal();
                            boolean bl = isNormalAlarmEnabledForAlarmSrcLogExt = alarmSource instanceof BAlarmSourceExt && !((BAlarmSourceExt)alarmSource).getAlarmEnable().isToNormal();
                            if (isNormalAlarmEnabledForTrendLogExt || isNormalAlarmEnabledForAlarmSrcLogExt) {
                                return;
                            }
                            if (acAckReq.isToNormal()) {
                                acksReq |= 1;
                            }
                        }
                        alarmRecord.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BInteger.make((int)acksReq));
                    }
                    this.addToNotifyList(alarmRecord);
                    AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);
                    acAckReq = null;
                    try {
                        conn.update(alarmRecord);
                    }
                    catch (Throwable isNormalAlarmEnabledForTrendLogExt) {
                        acAckReq = isNormalAlarmEnabledForTrendLogExt;
                        throw isNormalAlarmEnabledForTrendLogExt;
                    }
                    finally {
                        if (conn != null) {
                            if (acAckReq != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable isNormalAlarmEnabledForTrendLogExt) {
                                    ((Throwable)acAckReq).addSuppressed(isNormalAlarmEnabledForTrendLogExt);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                if (alarmRecord.isAcknowledged() && alarmClass.getAckRequired().includes(alarmRecord.getSourceState()) || alarmRecord.getAckState() == BAckState.ackPending) {
                    BBacnetObjectIdentifier deviceId = BBacnetNetwork.localDevice().getObjectId();
                    if (BBacnetEventState.isNormal((BEnum)toState)) {
                        BBoolean offnormalAcked = (BBoolean)alarmRecord.getAlarmFacet("offnormalAcked");
                        ackAlarmAndNormal = offnormalAcked != null ? !offnormalAcked.getBoolean() : toSt == null || !toSt.equals((Object)fromSt);
                    } else if (BBacnetEventState.isOffnormal((BEnum)toState)) {
                        alarmRecord.addAlarmFacet("offnormalAcked", (BIDataValue)BBoolean.TRUE);
                        try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
                            conn.update(alarmRecord);
                        }
                    }
                    if (traceOn) {
                        this.log.fine("acknowledged - stateAcked=" + stateAcked + " ar:" + this.ackDump(alarmRecord) + ", toState(alarm)=" + toState);
                    }
                    if (stateAcked != null) {
                        toState = BBacnetEventState.make(stateAcked.getInt());
                    }
                    BAlarmRecord rec = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler().getRecordFromEventBuffer(toState.getOrdinal(), deviceId, eventObjectId, 0L, alarmRecord.getUuid(), false);
                    if (traceOn) {
                        this.log.fine("dest " + this.getName() + ": rec=" + (rec != null ? rec.getUuid().toString() : "null"));
                    }
                    if (rec == null) {
                        if (traceOn) {
                            this.log.fine("Skipping event notification: No matching record in event buffer for " + (Object)((Object)deviceId) + " " + (Object)((Object)eventObjectId) + " " + 0L + " with UUID " + alarmRecord.getUuid());
                        }
                        return;
                    }
                    this.removeFromNotifyList(alarmRecord);
                } else {
                    return;
                }
                evtSrc = null;
                try {
                    evtSrc = (BBacnetEventSource)BBacnetNetwork.localDevice().lookupBacnetObject(eventObjectId);
                }
                catch (ClassCastException e) {
                    if (!traceOn) break block61;
                    this.log.fine("BBacnetObjectIdentifier is not an BacnetEventSource");
                }
            }
            if (evtSrc != null && !evtSrc.getEventDetectionEnable()) {
                this.log.fine("Do not send event notification for an when event source, eventdetectionenable is false");
                return;
            }
            BBoolean stale = (BBoolean)alarmRecord.getAlarmFacet("staleAck");
            if (stale != null && stale.getBoolean()) {
                this.log.fine("Skipping event notification for stale ack (BAC_STALE_ACK)");
                return;
            }
            if (newToState.equals((Object)BSourceState.normal) && alarmSource instanceof BAlarmSourceExt && !((BAlarmSourceExt)alarmSource).isLastNormalRecord(alarmRecord)) {
                this.log.fine("Skipping event notification for to-normal transition of record that is not the alarm source's last normal record");
                return;
            }
            if (BBacnetEventState.isFault((BEnum)fromState) && BBacnetEventState.isOffnormal((BEnum)toState)) {
                this.faultToOffNormalTransition(alarmRecord, eventObjectId, eventObject, ackAlarmAndNormal, stateChanged);
            } else {
                AsyncEventNotificationRequest request = new AsyncEventNotificationRequest(alarmRecord, eventObjectId, eventObject, this.getProcessIdentifier().getUnsigned(), this.getRecipient(), this.getIssueConfirmedNotifications(), ackAlarmAndNormal);
                request.setAlarm(stateChanged);
                this.sendNotification(request);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Exception handling alarm in " + this.getName() + ":" + e, e);
        }
    }

    private void faultToOffNormalTransition(BAlarmRecord alarmRecord, BBacnetObjectIdentifier eventObjectId, BComponent eventObject, boolean ackAlarmAndNormal, boolean stateChanged) {
        BBacnetObjectIdentifier oid = BBacnetNetwork.localDevice().lookupBacnetObjectId(eventObject.getHandleOrd());
        BIBacnetExportObject descriptor = BBacnetNetwork.localDevice().lookupBacnetObject(oid);
        int[] eventPriorities = ((BBacnetEventSource)descriptor).getEventPriorities();
        int eventPriority = eventPriorities[2];
        alarmRecord.setPriority(eventPriority);
        this.notification(alarmRecord, eventObjectId, eventObject, ackAlarmAndNormal, stateChanged, (BEnum)BBacnetEventState.fault, (BEnum)BBacnetEventState.normal);
        eventPriority = eventPriorities[0];
        alarmRecord.setPriority(eventPriority);
        BString toStateFacet = (BString)alarmRecord.getAlarmFacet("toState");
        BBacnetEventState toState = toStateFacet != null ? BBacnetEventState.make(toStateFacet.getString()) : BBacnetEventState.make(alarmRecord.getSourceState());
        this.notification(alarmRecord, eventObjectId, eventObject, ackAlarmAndNormal, stateChanged, (BEnum)BBacnetEventState.normal, (BEnum)toState);
    }

    private void notification(BAlarmRecord alarmRecord, BBacnetObjectIdentifier eventObjectId, BComponent eventObject, boolean ackAlarmAndNormal, boolean stateChanged, BEnum from, BEnum to) {
        BOrd source = alarmRecord.getSource().get(0);
        String alarmClass = alarmRecord.getAlarmClass();
        BFacets alarmData = (BFacets)alarmRecord.getAlarmData().newCopy();
        alarmData = BFacets.make((BFacets)alarmData, (String)"fromState", (BIDataValue)BString.make((String)from.getTag()));
        alarmData = BFacets.make((BFacets)alarmData, (String)"toState", (BIDataValue)BString.make((String)to.getTag()));
        BAlarmRecord alarmRecord_transition = new BAlarmRecord(source, alarmClass, alarmData);
        alarmRecord_transition.setPriority(alarmRecord.getPriority());
        AsyncEventNotificationRequest request = new AsyncEventNotificationRequest(alarmRecord_transition, eventObjectId, eventObject, this.getProcessIdentifier().getUnsigned(), this.getRecipient(), this.getIssueConfirmedNotifications(), ackAlarmAndNormal);
        request.setAlarm(stateChanged);
        this.sendNotification(request);
    }

    protected void sendNotification(AsyncEventNotificationRequest request) {
        BBacnetNetwork.bacnet().postAsync(request);
    }

    public final boolean recipientEquals(BBacnetRecipient recip) {
        return this.getRecipient().equivalent(recip);
    }

    public final boolean destinationEquals(BBacnetDestination dest) {
        return this.destinationEquals(dest, false);
    }

    public final boolean destinationEquals(BBacnetDestination dest, boolean compareMillis) {
        if (dest == null) {
            return false;
        }
        int mask = BAlarmTransitionBits.ALL.getBits() & 0xFFFFFFF7;
        int mybits = this.getTransitions().getBits() & mask;
        int dbits = dest.getTransitions().getBits() & mask;
        return this.timeRangesEquivalent(this.getTimeRange(), dest.getTimeRange(), compareMillis) && this.getDaysOfWeek().equals((Object)dest.getDaysOfWeek()) && mybits == dbits && this.getTransitions().getBits() == dest.getTransitions().getBits() && this.getRecipient().equivalent(dest.getRecipient()) && this.getProcessIdentifier().equals((Object)dest.getProcessIdentifier()) && this.getIssueConfirmedNotifications() == dest.getIssueConfirmedNotifications();
    }

    public final boolean timeRangesEquivalent(BTimeRange tr1, BTimeRange tr2, boolean compareMillis) {
        if (compareMillis) {
            return tr1.equivalent((Object)tr2);
        }
        return tr1.getStartTime().getHour() == tr2.getStartTime().getHour() && tr1.getStartTime().getMinute() == tr2.getStartTime().getMinute() && tr1.getStartTime().getSecond() == tr2.getStartTime().getSecond() && tr1.getEndTime().getHour() == tr2.getEndTime().getHour() && tr1.getEndTime().getMinute() == tr2.getEndTime().getMinute() && tr1.getEndTime().getSecond() == tr2.getEndTime().getSecond();
    }

    public final void started() {
        if (this.getParent() instanceof BBacnetListOf) {
            this.client = true;
        }
        if (Sys.atSteadyState() && this.isRunning()) {
            this.resolveRecipient();
        }
    }

    public final void changed(Property p, Context cx) {
        BComplex parent;
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(recipient)) {
            this.resolveRecipient();
        }
        if ((parent = this.getParent()) != null) {
            parent.asComponent().changed(this.getPropertyInParent(), cx);
        }
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        this.resolveRecipient();
    }

    public final void subscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty((BComponent)this);
        if (vp != null) {
            vp.childSubscribed((BComponent)this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty((BComponent)this);
        if (vp != null) {
            vp.childSubscribed((BComponent)this);
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BAlarmService || parent instanceof BBacnetListOf;
    }

    public final BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual((BComponent)this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public final BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual((BComponent)this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public final BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual((BComponent)this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    public boolean accept(BAlarmRecord rec) {
        BAbsTime ts = BAbsTime.now();
        if (!this.getDaysOfWeek().includes(ts.getWeekday())) {
            return false;
        }
        if (!this.getTimeRange().includes(ts)) {
            return false;
        }
        return this.getTransitions().includes(rec.getSourceState());
    }

    private void resolveRecipient() {
        if (!this.client) {
            if (this.getRecipient().isDevice()) {
                BBacnetObjectIdentifier deviceId = this.getRecipient().getDevice();
                if (deviceId.isValid() && deviceId.getObjectType() == 8 && BBacnetNetwork.bacnet().doLookupDeviceById(deviceId) == null) {
                    try {
                        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().whoIs(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, deviceId.getInstanceNumber(), deviceId.getInstanceNumber());
                    }
                    catch (BacnetException e) {
                        this.log.log(Level.WARNING, "Unable to determine address for Bacnet Destination " + this.getName() + ": " + this.getRecipient(), (Throwable)((Object)e));
                    }
                }
            } else {
                BBacnetAddress address = this.getRecipient().getAddress();
                if (BBacnetNetwork.bacnet().doLookupDeviceByAddress(address) == null) {
                    try {
                        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().whoIs(address);
                    }
                    catch (BacnetException e) {
                        this.log.log(Level.SEVERE, "Unable to resolve address for Bacnet Destination " + this.getName() + ": " + this.getRecipient(), (Throwable)((Object)e));
                    }
                }
            }
        }
    }

    private void addToNotifyList(BAlarmRecord r) {
        BString notify = (BString)r.getAlarmFacet("bacNotify");
        notify = notify == null ? BString.make((String)this.getHandle().toString()) : BString.make((String)(notify.getString() + ";" + this.getHandle().toString()));
        r.addAlarmFacet("bacNotify", (BIDataValue)notify);
    }

    private boolean removeFromNotifyList(BAlarmRecord r) {
        BString notify = (BString)r.getAlarmFacet("bacNotify");
        String h = this.getHandle().toString();
        if (notify != null) {
            StringTokenizer st = new StringTokenizer(notify.getString(), ";");
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (h.equals(tok)) continue;
                sb.append(tok).append(";");
            }
            if (sb.length() == 0) {
                r.removeAlarmFacet("bacNotify");
                return false;
            }
            r.addAlarmFacet("bacNotify", (BIDataValue)BString.make((String)sb.toString()));
            return true;
        }
        return false;
    }

    @Override
    public final void writeAsn(AsnOutput out) {
        out.writeBitString(BacnetBitStringUtil.getBacnetDaysOfWeek(this.getDaysOfWeek()).getBits());
        out.writeTime(this.getTimeRange().getStartTime());
        out.writeTime(this.getTimeRange().getEndTime());
        this.getRecipient().writeAsn(out);
        out.writeUnsigned(this.getProcessIdentifier());
        out.writeBoolean(this.getIssueConfirmedNotifications());
        out.writeBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(this.getTransitions()).getBits());
    }

    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        BDaysOfWeekBits daysOfWeek;
        try {
            daysOfWeek = BacnetBitStringUtil.getBDaysOfWeekBits(in.readBitString());
        }
        catch (IllegalArgumentException iae) {
            throw new AsnException(BBacnetErrorCode.invalidDataType.getTag());
        }
        BBacnetTime startTime = in.readTime();
        BBacnetTime endTime = in.readTime();
        if (startTime.getHour() == -1 || startTime.getMinute() == -1 || startTime.getSecond() == -1 || startTime.getHundredth() == -1) {
            throw new AsnException(BBacnetErrorCode.valueOutOfRange.getTag());
        }
        if (endTime.getHour() == -1 || endTime.getMinute() == -1 || endTime.getSecond() == -1 || endTime.getHundredth() == -1) {
            throw new AsnException(BBacnetErrorCode.valueOutOfRange.getTag());
        }
        BTime bajaStartTime = BBacnetTime.getBTime(startTime, true);
        BTime bajaEndTime = BBacnetTime.getBTime(endTime, false);
        BBacnetRecipient recipient = new BBacnetRecipient();
        recipient.readAsn(in);
        long processIdentifier = in.readUnsignedInteger();
        boolean issueConfirmedNotifications = in.readBoolean();
        BAlarmTransitionBits transitions = BacnetBitStringUtil.getBAlarmTransitionBits(in.readBitString());
        this.set(BAlarmRecipient.daysOfWeek, (BValue)daysOfWeek, noWrite);
        this.getTimeRange().set(BTimeRange.startTime, (BValue)bajaStartTime, noWrite);
        this.getTimeRange().set(BTimeRange.endTime, (BValue)bajaEndTime, noWrite);
        this.set(BBacnetDestination.recipient, (BValue)recipient, noWrite);
        this.set(BBacnetDestination.processIdentifier, (BValue)BBacnetUnsigned.make(processIdentifier), noWrite);
        this.setBoolean(BBacnetDestination.issueConfirmedNotifications, issueConfirmedNotifications, noWrite);
        this.set(BBacnetDestination.transitions, (BValue)transitions, noWrite);
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRecipient().toString(cx)).append(" pId=").append((Object)this.getProcessIdentifier()).append(" conf=").append(this.getIssueConfirmedNotifications()).append(" times=").append(this.getTimeRange().toString(cx)).append(" days=").append(this.getDaysOfWeek().toString(cx)).append(" trans=").append(this.getTransitions().toString(cx));
        return sb.toString();
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetDestination", 2);
        out.prop((Object)"client", this.client);
        out.prop((Object)"eventStateRange", (Object)this.eventStateRange);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual((BComponent)this));
        out.endProps();
    }

    private String ackDump(BAlarmRecord alarmRecord) {
        return alarmRecord.getSourceState() + "/" + alarmRecord.getAckState() + "/" + alarmRecord.getAckRequired();
    }
}

