/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BAddArrayElementAction;
import com.tridium.bacnet.datatypes.BRemoveArrayElementAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.GrandchildChangedContext;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="arrayTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=4), @NiagaraProperty(name="size", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="fixedSize", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="addElement", parameterType="BValue", defaultValue="BBacnetUnsigned.DEFAULT", flags=4), @NiagaraAction(name="removeElement", parameterType="BInteger", defaultValue="BInteger.make(0)", flags=4)})
@NiagaraTopic(name="arrayPropertyChanged")
public class BBacnetArray
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property arrayTypeSpec = BBacnetArray.newProperty((int)4, (BValue)BTypeSpec.DEFAULT, null);
    @Generated
    public static final Property size = BBacnetArray.newProperty((int)4, (int)0, null);
    @Generated
    public static final Property fixedSize = BBacnetArray.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Action addElement = BBacnetArray.newAction((int)4, (BValue)BBacnetUnsigned.DEFAULT, null);
    @Generated
    public static final Action removeElement = BBacnetArray.newAction((int)4, (BValue)BInteger.make((int)0), null);
    @Generated
    public static final Topic arrayPropertyChanged = BBacnetArray.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetArray.class);
    private int asnType;
    private boolean config;
    private static final Logger loggerBacnetClient = Logger.getLogger("bacnet.client");
    private static final Logger loggerBacnet = Logger.getLogger("bacnet");
    private static final Logger loggerBacnetDebug = Logger.getLogger("bacnet.debug");
    public static final String ELEMENT_0 = "element0";

    @Generated
    public BTypeSpec getArrayTypeSpec() {
        return (BTypeSpec)this.get(arrayTypeSpec);
    }

    @Generated
    public void setArrayTypeSpec(BTypeSpec v) {
        this.set(arrayTypeSpec, (BValue)v, null);
    }

    @Generated
    public int getSize() {
        return this.getInt(size);
    }

    @Generated
    public void setSize(int v) {
        this.setInt(size, v, null);
    }

    @Generated
    public boolean getFixedSize() {
        return this.getBoolean(fixedSize);
    }

    @Generated
    public void setFixedSize(boolean v) {
        this.setBoolean(fixedSize, v, null);
    }

    @Generated
    public void addElement(BValue parameter) {
        this.invoke(addElement, parameter, null);
    }

    @Generated
    public void removeElement(BInteger parameter) {
        this.invoke(removeElement, (BValue)parameter, null);
    }

    @Generated
    public void fireArrayPropertyChanged(BValue event) {
        this.fire(arrayPropertyChanged, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetArray() {
    }

    public BBacnetArray(Type arrayType) {
        this.setArrayTypeSpec(BTypeSpec.make((Type)arrayType));
    }

    public BBacnetArray(Type arrayType, int fixedSize) {
        this.setArrayTypeSpec(BTypeSpec.make((Type)arrayType));
        this.setFixedSize(true);
        this.setSize(fixedSize);
        this.checkSize(true, null);
    }

    public final void started() {
        if (this.getParent() instanceof BBacnetObject) {
            this.config = true;
        }
        this.checkSize(true, null);
        if (!this.getFixedSize()) {
            if (this.get("addArrayElement") == null) {
                BAddArrayElementAction addElement = new BAddArrayElementAction();
                addElement.setParameterTypeSpec(this.getArrayTypeSpec());
                this.add("addArrayElement", (BValue)addElement, 2);
            }
            if (this.get("removeArrayElement") == null) {
                BRemoveArrayElementAction removeElement = new BRemoveArrayElementAction();
                removeElement.setParameterTypeSpec(BDynamicEnum.TYPE.getTypeSpec());
                this.add("removeArrayElement", (BValue)removeElement, 2);
            }
        }
    }

    public final void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(size)) {
            Property e0 = this.getProperty(ELEMENT_0);
            if (e0 != null) {
                this.setInt(e0, this.getSize(), cx);
            }
            if (cx != noWrite) {
                this.checkSize(true, cx);
            }
        } else if (!p.equals(fixedSize) && !p.equals(arrayTypeSpec) && !p.getName().equals(ELEMENT_0) && p.getName().startsWith("element") && cx != noWrite) {
            if (this.config) {
                try {
                    ((BBacnetObject)this.getParent()).writeProperty(this.getPropertyInParent(), this.index(p), AsnUtil.toAsn(this.asnType(), this.get(p)));
                }
                catch (BacnetException e) {
                    loggerBacnetClient.warning("Unable to write array element " + this.index(p) + " in property " + this.getPropertyInParent() + " of " + this.getParent() + ":" + (Object)((Object)e));
                }
            } else if (BacnetVirtualUtil.isVirtual(this)) {
                this.getParent().asComponent().changed(this.getPropertyInParent(), (Context)new GrandchildChangedContext(this.index(p), AsnUtil.toAsn(this.asnType(), this.get(p))));
            }
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty vp;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().subscribed();
        }
        if ((vp = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            vp.childSubscribed(this);
        }
    }

    public void unsubscribed() {
        BBacnetVirtualProperty vp;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().unsubscribed();
        }
        if ((vp = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            vp.childUnsubscribed(this);
        }
    }

    public boolean isChildLegal(BComponent child) {
        if (!this.isRunning()) {
            return true;
        }
        return child.getType().is(this.getArrayTypeSpec().getTypeInfo());
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    public final void doAddElement(BValue arrayElement) {
        if (this.getFixedSize()) {
            loggerBacnetDebug.severe(this + ".doAddElement:Fixed size array; can't add element!");
            return;
        }
        int size = this.getSize();
        if (arrayElement.getType() == this.getArrayType()) {
            this.add(this.name(size), arrayElement);
            this.setSize(++size);
            BComplex parent = this.getParent();
            if (parent instanceof BComponent) {
                ((BComponent)parent).changed(this.getPropertyInParent(), null);
            }
        } else if (arrayElement instanceof BOrd) {
            this.add(this.name(size), arrayElement);
            this.setSize(++size);
        } else {
            loggerBacnetDebug.severe(this + ".doAddElement:Wrong element type: this is an array of " + this.getArrayType().getTypeName());
        }
    }

    public final void doRemoveElement(BInteger index) {
        if (this.getFixedSize()) {
            loggerBacnetDebug.severe(this + ".doRemoveElement:Fixed size array; can't remove element!");
            return;
        }
        this.remove(this.name(index.getInt()));
        this.reIndex();
        this.setSize(this.getSize() - 1);
        this.getParent().asComponent().changed(this.getPropertyInParent(), null);
    }

    public String toString(Context cx) {
        this.loadSlots();
        if (cx != null && cx instanceof BasicContext) {
            return "BacnetARRAY[" + this.getSize() + "] of " + this.getArrayTypeSpec();
        }
        StringBuilder sb = new StringBuilder("{");
        int len = this.getSize();
        for (int i = 1; i <= len; ++i) {
            sb.append(this.getElement(i)).append(',');
        }
        if (sb.length() == 1) {
            return "{}";
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public final BValue getElement(int index) {
        if (index == 0) {
            return this.get(size);
        }
        return this.get(this.name(index - 1));
    }

    public final void setElement(int index, BValue value) {
        if (value.getType() == this.getArrayType() && index > 0 && index <= this.getSize()) {
            this.set(this.name(index - 1), value);
        }
    }

    public static int index(String propName) {
        int sc = (propName = SlotPath.unescape((String)propName)).indexOf(";");
        if (sc < 0) {
            return Integer.parseInt(propName.substring(7));
        }
        return Integer.parseInt(propName.substring(7, sc));
    }

    private Type getArrayType() {
        try {
            return this.getArrayTypeSpec().getResolvedType();
        }
        catch (Exception e) {
            loggerBacnet.log(Level.SEVERE, "Exception occurred in getArrayType", e);
            return null;
        }
    }

    private int asnType() {
        Type t = this.getArrayType();
        this.asnType = t == BBacnetNull.TYPE ? 0 : (t == BBoolean.TYPE ? 1 : (t == BBacnetUnsigned.TYPE ? 2 : (t == BInteger.TYPE ? 3 : (t == BFloat.TYPE ? 4 : (t == BDouble.TYPE ? 5 : (t == BBacnetOctetString.TYPE ? 6 : (t == BString.TYPE ? 7 : (t == BBacnetBitString.TYPE ? 8 : (BEnum.class.isAssignableFrom(t.getTypeClass()) ? 9 : (t == BBacnetDate.TYPE ? 10 : (t == BBacnetTime.TYPE ? 11 : (t == BBacnetObjectIdentifier.TYPE ? 12 : -1))))))))))));
        return this.asnType;
    }

    private synchronized void checkSize(boolean trim, Context cx) {
        SlotCursor c = this.getProperties();
        int count = 0;
        while (c.next(this.getArrayType().getTypeClass())) {
            if (!c.property().isDynamic()) continue;
            ++count;
        }
        if (trim) {
            this.trimToSize(count, cx);
        } else {
            this.setInt(size, count, cx);
            Property p = this.getProperty(ELEMENT_0);
            if (p != null) {
                this.setInt(p, count, cx);
            }
        }
    }

    private void trimToSize(int count, Context cx) {
        block3: {
            int siz;
            block2: {
                siz = this.getSize();
                if (siz >= count) break block2;
                for (int i = siz; i < count; ++i) {
                    this.remove(this.name(i), cx);
                }
                break block3;
            }
            if (siz <= count) break block3;
            for (int i = count; i < siz; ++i) {
                this.add(this.name(i), (BValue)this.getArrayType().getInstance(), cx);
            }
        }
    }

    private String name(int ndx) {
        return "element" + (ndx + 1);
    }

    private int index(Property p) {
        return Integer.parseInt(p.getName().substring(7));
    }

    private static void copyFrom(BComponent src, BComponent dst, Context cx) {
        Context txn = Transaction.start((BComponent)dst, (Context)cx);
        Property[] props = dst.getPropertiesArray();
        int i = props.length;
        while (--i >= 0) {
            if (!props[i].isDynamic()) continue;
            dst.remove(props[i], cx);
        }
        SlotCursor c = src.getProperties();
        while (c.next()) {
            Property p = c.property();
            BValue o = c.get();
            if (o instanceof BComplex) {
                o = o.newCopy(true);
            }
            if (dst.get(p.getName()) != null) {
                dst.set(p, o, cx);
                continue;
            }
            dst.asComponent().add(p.getName(), o, cx);
        }
        try {
            Transaction.end((BComponent)dst, (Context)txn);
        }
        catch (Exception x) {
            throw new BajaRuntimeException((Throwable)x);
        }
    }

    private void reIndex() {
        if (this.getFixedSize()) {
            return;
        }
        int siz = this.getSize();
        for (int ndx = 1; ndx < siz; ++ndx) {
            BValue elem = this.getElement(ndx);
            if (elem != null) continue;
            int i = ndx;
            while (elem == null && i < siz) {
                elem = this.getElement(++i);
            }
            this.add(this.name(ndx - 1), elem);
            this.remove(this.name(i - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeAsn(AsnOutput out) {
        AsnOutput asnOutput = out;
        synchronized (asnOutput) {
            SlotCursor c = this.getProperties();
            block20: while (c.next()) {
                try {
                    BValue arrayElement = c.get();
                    if (arrayElement instanceof BOrd) {
                        arrayElement = ((BOrd)arrayElement).get((BObject)this);
                    }
                    if (arrayElement == null || arrayElement.getType() != this.getArrayType()) continue;
                    switch (this.asnType()) {
                        case 0: {
                            out.writeNull();
                            continue block20;
                        }
                        case 1: {
                            out.writeBoolean((BBoolean)c.get());
                            continue block20;
                        }
                        case 2: {
                            out.writeUnsigned((BBacnetUnsigned)c.get());
                            continue block20;
                        }
                        case 3: {
                            out.writeSignedInteger((BInteger)c.get());
                            continue block20;
                        }
                        case 4: {
                            out.writeReal((BNumber)((BFloat)c.get()));
                            continue block20;
                        }
                        case 5: {
                            out.writeDouble((BNumber)((BDouble)c.get()));
                            continue block20;
                        }
                        case 6: {
                            out.writeOctetString((BBacnetOctetString)c.get());
                            continue block20;
                        }
                        case 7: {
                            out.writeCharacterString((BString)c.get());
                            continue block20;
                        }
                        case 8: {
                            out.writeBitString((BBacnetBitString)c.get());
                            continue block20;
                        }
                        case 9: {
                            out.writeEnumerated((BEnum)c.get());
                            continue block20;
                        }
                        case 10: {
                            out.writeDate((BBacnetDate)c.get());
                            continue block20;
                        }
                        case 11: {
                            out.writeTime((BBacnetTime)c.get());
                            continue block20;
                        }
                        case 12: {
                            out.writeObjectIdentifier((BBacnetObjectIdentifier)c.get());
                            continue block20;
                        }
                    }
                    ((BIBacnetDataType)c.get()).writeAsn(out);
                }
                catch (Exception e) {
                    loggerBacnet.log(Level.WARNING, this.getName() + ":" + this + ": writeAsn: Exception!", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        void var6_15;
        Subscriber[] subs = this.getSubscribers();
        if (subs == null || subs.length == 0) {
            Property p;
            BComponent[] ckids = this.getChildComponents();
            boolean keepSub = false;
            for (int i = 0; i < ckids.length; ++i) {
                if (!ckids[i].isSubscribed()) continue;
                keepSub = true;
                break;
            }
            if (!keepSub && (p = this.getProperty(ELEMENT_0)) != null) {
                this.remove(p);
            }
        }
        ArrayList<BSimple> v = new ArrayList<BSimple>();
        AsnInput keepSub = in;
        synchronized (keepSub) {
            while (in.peekTag() != -1) {
                BSimple arrayElement;
                switch (this.asnType()) {
                    case 0: {
                        arrayElement = in.readNull();
                        break;
                    }
                    case 1: {
                        arrayElement = BBoolean.make((boolean)in.readBoolean());
                        break;
                    }
                    case 2: {
                        arrayElement = in.readUnsigned();
                        break;
                    }
                    case 3: {
                        arrayElement = BInteger.make((int)in.readSignedInteger());
                        break;
                    }
                    case 4: {
                        arrayElement = BFloat.make((float)in.readReal());
                        break;
                    }
                    case 5: {
                        arrayElement = BDouble.make((double)in.readDouble());
                        break;
                    }
                    case 6: {
                        arrayElement = BBacnetOctetString.make(in.readOctetString());
                        break;
                    }
                    case 7: {
                        arrayElement = BString.make((String)in.readCharacterString());
                        break;
                    }
                    case 8: {
                        arrayElement = in.readBitString();
                        break;
                    }
                    case 9: {
                        BEnum bEnum = (BEnum)this.getArrayType().getInstance();
                        arrayElement = bEnum.getRange().get(in.readEnumerated());
                        break;
                    }
                    case 10: {
                        arrayElement = in.readDate();
                        break;
                    }
                    case 11: {
                        arrayElement = in.readTime();
                        break;
                    }
                    case 12: {
                        arrayElement = in.readObjectIdentifier();
                        break;
                    }
                    default: {
                        arrayElement = (BValue)this.getArrayType().getInstance();
                        ((BIBacnetDataType)arrayElement).readAsn(in);
                    }
                }
                if (arrayElement == null) continue;
                v.add(arrayElement);
            }
        }
        int ndx = 0;
        for (BValue bValue : v) {
            String name;
            Property p;
            if ((p = this.getProperty(name = this.name(ndx++))) != null) {
                if (p.getType().is(BSimple.TYPE)) {
                    this.set(p, bValue, noWrite);
                    continue;
                }
                if (p.getType().is(BComponent.TYPE)) {
                    BBacnetArray.copyFrom(bValue.asComponent(), this.get(p).asComponent(), noWrite);
                    continue;
                }
                ((BComplex)this.get(p)).copyFrom(bValue.asComplex(), noWrite);
                continue;
            }
            this.add(name, bValue, noWrite);
        }
        Property property = this.getProperty(this.name(ndx++));
        while (var6_15 != null) {
            this.remove((Property)var6_15, noWrite);
            Property property2 = this.getProperty(this.name(ndx++));
        }
        this.checkSize(false, noWrite);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetArray", 2);
        out.prop((Object)"asnType", this.asnType);
        out.prop((Object)"config", this.config);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }
}

