/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.stack.DeviceRegistry;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetAddressBinding;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.DefaultFileCopy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.DEVICE)", flags=8, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)")}, override=true), @NiagaraProperty(name="objectType", type="BEnum", defaultValue="BDynamicEnum.make(BBacnetObjectType.DEVICE, BEnumRange.make(BBacnetObjectType.TYPE))", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)")}, override=true), @NiagaraProperty(name="systemStatus", type="BEnum", defaultValue="BDynamicEnum.make(BBacnetDeviceStatus.OPERATIONAL, BEnumRange.make(BBacnetDeviceStatus.TYPE))", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.SYSTEM_STATUS, ASN_ENUMERATED)")}), @NiagaraProperty(name="vendorName", type="String", defaultValue="", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.VENDOR_NAME, ASN_CHARACTER_STRING)")}), @NiagaraProperty(name="vendorIdentifier", type="BBacnetUnsigned", defaultValue="new BBacnetUnsigned(-1)", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.VENDOR_IDENTIFIER, ASN_UNSIGNED)")}), @NiagaraProperty(name="modelName", type="String", defaultValue="", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.MODEL_NAME, ASN_CHARACTER_STRING)")}), @NiagaraProperty(name="firmwareRevision", type="String", defaultValue="", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.FIRMWARE_REVISION, ASN_CHARACTER_STRING)")}), @NiagaraProperty(name="applicationSoftwareVersion", type="String", defaultValue="", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.APPLICATION_SOFTWARE_VERSION, ASN_CHARACTER_STRING)")}), @NiagaraProperty(name="protocolVersion", type="BBacnetUnsigned", defaultValue="new BBacnetUnsigned(1)", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.PROTOCOL_VERSION, ASN_UNSIGNED)")}), @NiagaraProperty(name="protocolRevision", type="BBacnetUnsigned", defaultValue="new BBacnetUnsigned(0)", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.PROTOCOL_REVISION, ASN_UNSIGNED)")}), @NiagaraProperty(name="protocolServicesSupported", type="BBacnetBitString", defaultValue="BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetServicesSupported\"))", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.PROTOCOL_SERVICES_SUPPORTED, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_MAP)")}), @NiagaraProperty(name="protocolObjectTypesSupported", type="BBacnetBitString", defaultValue="BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetObjectTypesSupported\"))", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.PROTOCOL_OBJECT_TYPES_SUPPORTED, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_MAP)")}), @NiagaraProperty(name="objectList", type="BBacnetArray", defaultValue="new BBacnetArray(BBacnetObjectIdentifier.TYPE)", flags=5, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_LIST, ASN_BACNET_ARRAY)")}), @NiagaraProperty(name="maxAPDULengthAccepted", type="BBacnetUnsigned", defaultValue="new BBacnetUnsigned(ConfirmedRequestPdu.MAX_APDU_LENGTH_UP_TO_MIN_MSG_SIZE)", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.MAX_APDU_LENGTH_ACCEPTED, ASN_UNSIGNED)")}), @NiagaraProperty(name="segmentationSupported", type="BBacnetSegmentation", defaultValue="BBacnetSegmentation.noSegmentation", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.SEGMENTATION_SUPPORTED, ASN_ENUMERATED)")}), @NiagaraProperty(name="apduTimeout", type="BBacnetUnsigned", defaultValue="new BBacnetUnsigned(3000)", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.APDU_TIMEOUT, ASN_UNSIGNED)")}), @NiagaraProperty(name="numberOfAPDURetries", type="BBacnetUnsigned", defaultValue="new BBacnetUnsigned(3)", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.NUMBER_OF_APDU_RETRIES, ASN_UNSIGNED)")}), @NiagaraProperty(name="deviceAddressBinding", type="BBacnetListOf", defaultValue="new BBacnetListOf(BBacnetAddressBinding.TYPE)", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.DEVICE_ADDRESS_BINDING, ASN_BACNET_LIST)")}), @NiagaraProperty(name="databaseRevision", type="BBacnetUnsigned", defaultValue="new BBacnetUnsigned(-1)", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.DATABASE_REVISION, ASN_UNSIGNED)")})})
public class BBacnetDeviceObject
extends BBacnetObject {
    @Generated
    public static final Property objectId = BBacnetDeviceObject.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(8), (BFacets)BBacnetDeviceObject.makeFacets(75, 12));
    @Generated
    public static final Property objectType = BBacnetDeviceObject.newProperty((int)1, (BValue)BDynamicEnum.make((int)8, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetDeviceObject.makeFacets(79, 9));
    @Generated
    public static final Property systemStatus = BBacnetDeviceObject.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetDeviceStatus.TYPE)), (BFacets)BBacnetDeviceObject.makeFacets(112, 9));
    @Generated
    public static final Property vendorName = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(121, 7));
    @Generated
    public static final Property vendorIdentifier = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(-1L), (BFacets)BBacnetDeviceObject.makeFacets(120, 2));
    @Generated
    public static final Property modelName = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(70, 7));
    @Generated
    public static final Property firmwareRevision = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(44, 7));
    @Generated
    public static final Property applicationSoftwareVersion = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(12, 7));
    @Generated
    public static final Property protocolVersion = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(1L), (BFacets)BBacnetDeviceObject.makeFacets(98, 2));
    @Generated
    public static final Property protocolRevision = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(0L), (BFacets)BBacnetDeviceObject.makeFacets(139, 2));
    @Generated
    public static final Property protocolServicesSupported = BBacnetDeviceObject.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported")), (BFacets)BBacnetDeviceObject.makeFacets(97, 8, BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_MAP));
    @Generated
    public static final Property protocolObjectTypesSupported = BBacnetDeviceObject.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetObjectTypesSupported")), (BFacets)BBacnetDeviceObject.makeFacets(96, 8, BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_MAP));
    @Generated
    public static final Property objectList = BBacnetDeviceObject.newProperty((int)5, (BValue)new BBacnetArray(BBacnetObjectIdentifier.TYPE), (BFacets)BBacnetDeviceObject.makeFacets(76, -2));
    @Generated
    public static final Property maxAPDULengthAccepted = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(50L), (BFacets)BBacnetDeviceObject.makeFacets(62, 2));
    @Generated
    public static final Property segmentationSupported = BBacnetDeviceObject.newProperty((int)1, (BValue)BBacnetSegmentation.noSegmentation, (BFacets)BBacnetDeviceObject.makeFacets(107, 9));
    @Generated
    public static final Property apduTimeout = BBacnetDeviceObject.newProperty((int)0, (BValue)new BBacnetUnsigned(3000L), (BFacets)BBacnetDeviceObject.makeFacets(11, 2));
    @Generated
    public static final Property numberOfAPDURetries = BBacnetDeviceObject.newProperty((int)0, (BValue)new BBacnetUnsigned(3L), (BFacets)BBacnetDeviceObject.makeFacets(73, 2));
    @Generated
    public static final Property deviceAddressBinding = BBacnetDeviceObject.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetAddressBinding.TYPE), (BFacets)BBacnetDeviceObject.makeFacets(30, -3));
    @Generated
    public static final Property databaseRevision = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(-1L), (BFacets)BBacnetDeviceObject.makeFacets(155, 2));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDeviceObject.class);
    private BBacnetObjectIdentifier oldId;

    @Generated
    public BEnum getSystemStatus() {
        return (BEnum)this.get(systemStatus);
    }

    @Generated
    public void setSystemStatus(BEnum v) {
        this.set(systemStatus, (BValue)v, null);
    }

    @Generated
    public String getVendorName() {
        return this.getString(vendorName);
    }

    @Generated
    public void setVendorName(String v) {
        this.setString(vendorName, v, null);
    }

    @Generated
    public BBacnetUnsigned getVendorIdentifier() {
        return (BBacnetUnsigned)this.get(vendorIdentifier);
    }

    @Generated
    public void setVendorIdentifier(BBacnetUnsigned v) {
        this.set(vendorIdentifier, (BValue)v, null);
    }

    @Generated
    public String getModelName() {
        return this.getString(modelName);
    }

    @Generated
    public void setModelName(String v) {
        this.setString(modelName, v, null);
    }

    @Generated
    public String getFirmwareRevision() {
        return this.getString(firmwareRevision);
    }

    @Generated
    public void setFirmwareRevision(String v) {
        this.setString(firmwareRevision, v, null);
    }

    @Generated
    public String getApplicationSoftwareVersion() {
        return this.getString(applicationSoftwareVersion);
    }

    @Generated
    public void setApplicationSoftwareVersion(String v) {
        this.setString(applicationSoftwareVersion, v, null);
    }

    @Generated
    public BBacnetUnsigned getProtocolVersion() {
        return (BBacnetUnsigned)this.get(protocolVersion);
    }

    @Generated
    public void setProtocolVersion(BBacnetUnsigned v) {
        this.set(protocolVersion, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getProtocolRevision() {
        return (BBacnetUnsigned)this.get(protocolRevision);
    }

    @Generated
    public void setProtocolRevision(BBacnetUnsigned v) {
        this.set(protocolRevision, (BValue)v, null);
    }

    @Generated
    public BBacnetBitString getProtocolServicesSupported() {
        return (BBacnetBitString)this.get(protocolServicesSupported);
    }

    @Generated
    public void setProtocolServicesSupported(BBacnetBitString v) {
        this.set(protocolServicesSupported, (BValue)v, null);
    }

    @Generated
    public BBacnetBitString getProtocolObjectTypesSupported() {
        return (BBacnetBitString)this.get(protocolObjectTypesSupported);
    }

    @Generated
    public void setProtocolObjectTypesSupported(BBacnetBitString v) {
        this.set(protocolObjectTypesSupported, (BValue)v, null);
    }

    @Generated
    public BBacnetArray getObjectList() {
        return (BBacnetArray)this.get(objectList);
    }

    @Generated
    public void setObjectList(BBacnetArray v) {
        this.set(objectList, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getMaxAPDULengthAccepted() {
        return (BBacnetUnsigned)this.get(maxAPDULengthAccepted);
    }

    @Generated
    public void setMaxAPDULengthAccepted(BBacnetUnsigned v) {
        this.set(maxAPDULengthAccepted, (BValue)v, null);
    }

    @Generated
    public BBacnetSegmentation getSegmentationSupported() {
        return (BBacnetSegmentation)this.get(segmentationSupported);
    }

    @Generated
    public void setSegmentationSupported(BBacnetSegmentation v) {
        this.set(segmentationSupported, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getApduTimeout() {
        return (BBacnetUnsigned)this.get(apduTimeout);
    }

    @Generated
    public void setApduTimeout(BBacnetUnsigned v) {
        this.set(apduTimeout, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getNumberOfAPDURetries() {
        return (BBacnetUnsigned)this.get(numberOfAPDURetries);
    }

    @Generated
    public void setNumberOfAPDURetries(BBacnetUnsigned v) {
        this.set(numberOfAPDURetries, (BValue)v, null);
    }

    @Generated
    public BBacnetListOf getDeviceAddressBinding() {
        return (BBacnetListOf)this.get(deviceAddressBinding);
    }

    @Generated
    public void setDeviceAddressBinding(BBacnetListOf v) {
        this.set(deviceAddressBinding, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getDatabaseRevision() {
        return (BBacnetUnsigned)this.get(databaseRevision);
    }

    @Generated
    public void setDatabaseRevision(BBacnetUnsigned v) {
        this.set(databaseRevision, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (BBacnetPropertyIdentifier.maxSegmentsAccepted.getTag().equals(p.getName())) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.device().getName() + " added slot maxSegmentsAccepted " + this.device().getMaxSegmentsAccepted());
            }
            DeviceRegistry.update(this.device());
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.device().getName() + " deviceObject added callback execution finish for property " + p);
            }
        }
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || cx == fallback) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetObjectIdentifier newId = this.getObjectId();
            BBacnetNetwork network = BBacnetNetwork.bacnet();
            if (newId.equals((Object)this.oldId)) {
                return;
            }
            BBacnetDevice d = network.doLookupDeviceById(newId);
            if (d != null && d != this.device()) {
                log.severe("Duplicate Object ID:" + (Object)((Object)newId) + ", used by " + d.getName() + "!\n  Resetting to old id:" + (Object)((Object)this.oldId));
                this.set(objectId, (BValue)this.oldId, fallback);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Object ID changed from " + (Object)((Object)this.oldId) + " to " + (Object)((Object)newId));
                }
                this.device().objectIdChanged();
                network.getLocalDevice().updateAddressBinding(this.oldId, newId);
                network.updateDevice(this.device());
                if (this.oldId != null) {
                    DeviceRegistry.remove(this.oldId);
                }
                DeviceRegistry.update(this.device());
                this.oldId = newId;
            }
        } else if (p.equals(protocolRevision)) {
            DeviceRegistry.update(this.device());
        } else if (p.equals(segmentationSupported)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.device().getName() + " segmentationSupported changed to " + (Object)((Object)this.device().getSegmentationSupported()));
            }
            DeviceRegistry.update(this.device());
        } else if (p.equals(maxAPDULengthAccepted)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.device().getName() + " maxAPDULengthAccepted changed to " + this.device().getMaxAPDULengthAccepted());
            }
            DeviceRegistry.update(this.device());
        } else if (BBacnetPropertyIdentifier.maxSegmentsAccepted.getTag().equals(p.getName())) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.device().getName() + " maxSegmentsAccepted changed to " + this.device().getMaxSegmentsAccepted());
            }
            DeviceRegistry.update(this.device());
        }
        if (p.equals(protocolServicesSupported)) {
            this.device().updateServicesSupported();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.device().getName() + " deviceObject changed callback execution finish for property " + p);
        }
    }

    @Override
    public String toString(Context context) {
        return this.getObjectName() + " [" + this.getObjectId().toString(context) + "]";
    }

    @Override
    protected boolean shouldPoll(int propertyId) {
        switch (propertyId) {
            case 24: 
            case 56: 
            case 57: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void doUpload(BUploadParameters p, Context cx) {
        block10: {
            if (!this.device().getEnabled() || this.getStatus().isDown()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.device().getName() + " is either disabled or status is down, deviceObject upload is unsuccessful.");
                }
                return;
            }
            if (!this.getObjectId().isValid()) {
                return;
            }
            try {
                this.readProperty(maxAPDULengthAccepted);
                this.readProperty(segmentationSupported);
                this.readProperty(vendorIdentifier);
                this.readProperty(modelName);
                this.readProperty(firmwareRevision);
                this.readProperty(applicationSoftwareVersion);
                if (this.getVendorIdentifier().getInt() != 36 || !this.getFirmwareRevision().startsWith("3")) break block10;
                try {
                    BOrd vendorObjectTypesFile = (BOrd)this.device().get("vendorObjectTypesFile");
                    if (vendorObjectTypesFile != null && !vendorObjectTypesFile.equals((Object)BOrd.NULL)) {
                        DefaultFileCopy.copyFile((String)"niagaraAxBacnetObjectTypes.xml");
                        this.device().set("vendorObjectTypesFile", (BValue)BOrd.make((String)"file!defaults/niagaraAxBacnetObjectTypes.xml"));
                    }
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Exception setting vendorObjectTypesFile for BACnet deviceObject " + this + ":" + e, e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block10;
                log.log(Level.FINE, "Exception uploading BACnet deviceObject " + this + ":" + e, e);
            }
        }
        super.doUpload(p, cx);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.device().getName() + "deviceObject upload execution finish.");
        }
    }

    public int getMaxSegmentsAccepted() {
        BBacnetUnsigned msa = (BBacnetUnsigned)this.get(BBacnetPropertyIdentifier.maxSegmentsAccepted.getTag());
        if (msa != null) {
            return msa.getInt();
        }
        return 0;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetDeviceObject", 2);
        out.prop((Object)"oldId", (Object)this.oldId);
        out.endProps();
    }
}

