/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.alarm;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BEventHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.alarm.BBacnetEventProcessor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"alarm:AlarmClassFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"alarm:AlarmClassEditor\"")}, override=true), @NiagaraProperty(name="niagaraProcessId", type="long", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="BLong.make(0)"), @Facet(name="BFacets.MAX", value="BLong.make(0x7FFFFFFF)")})})
public class BBacnetAlarmDeviceExt
extends BAlarmDeviceExt
implements BacnetAlarmConst {
    @Generated
    public static final Property alarmClass = BBacnetAlarmDeviceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"alarm:AlarmClassFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"alarm:AlarmClassEditor")));
    @Generated
    public static final Property niagaraProcessId = BBacnetAlarmDeviceExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)0L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BLong.make((long)Integer.MAX_VALUE))));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAlarmDeviceExt.class);
    private static final Logger logger = Logger.getLogger("bacnet");

    @Generated
    public long getNiagaraProcessId() {
        return this.getLong(niagaraProcessId);
    }

    @Generated
    public void setNiagaraProcessId(long v) {
        this.setLong(niagaraProcessId, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        return this.getEventHandler().doAckAlarm(ackRequest);
    }

    public void doRouteAlarm(BAlarmRecord record) throws Exception {
        try {
            BString s = (BString)record.getAlarmFacet("processId");
            if (s != null) {
                long processId = Long.parseLong(s.getString());
                boolean noEventProcessor = true;
                if (processId == this.getNiagaraProcessId()) {
                    noEventProcessor = false;
                    BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                    as.routeAlarm(record);
                }
                SlotCursor sc = this.getProperties();
                while (sc.next(BBacnetEventProcessor.class)) {
                    BBacnetEventProcessor proc = (BBacnetEventProcessor)sc.get();
                    if (proc.getProcessId() != processId) continue;
                    noEventProcessor = false;
                    proc.routeAlarm(record);
                }
                if (noEventProcessor) {
                    logger.info("AlarmDeviceExt(procId " + this.getNiagaraProcessId() + "): no event processor for alarm record:\n" + record);
                }
            }
        }
        catch (ServiceNotFoundException e) {
            logger.log(Level.SEVERE, "AlarmDeviceExt.processEvent:Unable to find Alarm Service!", e);
        }
    }

    private BEventHandler getEventHandler() {
        return ((BBacnetStack)((BBacnetNetwork)this.getNetwork()).getBacnetComm()).getServer().getEventHandler();
    }
}

