/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.transport.AbortPdu;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.ClientTransaction;
import com.tridium.bacnet.stack.transport.ComplexAckPdu;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import com.tridium.bacnet.stack.transport.SegmentAckPdu;
import com.tridium.bacnet.stack.transport.TransportStateMachine;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.log.Log;

public class ClientStateMachine
extends TransportStateMachine {
    private static final Log logger = Log.getLog((String)"bacnet.transport");

    @Override
    public String getName() {
        return "BacnetClientTSM";
    }

    @Override
    public void route(ApplicationPdu apdu) {
        ClientStateMachine.process(apdu);
    }

    public static final void process(ApplicationPdu apdu) {
        block13: {
            ClientTransaction transaction = null;
            try {
                transaction = ClientTransaction.find(apdu);
                if (transaction == null) {
                    Idle.process(apdu);
                    return;
                }
                switch (transaction.getState()) {
                    case 1: {
                        SegmentedRequest.process(apdu, transaction);
                        break;
                    }
                    case 2: {
                        AwaitConfirmation.process(apdu, transaction);
                        break;
                    }
                    case 3: {
                        SegmentedConf.process(apdu, transaction);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("CSM.process():" + apdu.trace());
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                if (transaction != null) {
                    transaction.stopRequestTimer();
                }
                if (apdu != null && apdu instanceof ConfirmedRequestPdu) {
                    ((ConfirmedRequestPdu)apdu).cannotSend(e);
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(1)) {
                    logger.message("Exception in CSM.process:transaction=" + transaction + " apdu=" + apdu.trace() + "\n exception:", (Throwable)e);
                }
                if (transaction != null) {
                    logger.message("transaction pdu:" + transaction.getRequestPdu().trace());
                    transaction.stopRequestTimer();
                }
                if (apdu == null || !(apdu instanceof ConfirmedRequestPdu)) break block13;
                ((ConfirmedRequestPdu)apdu).abandon(e);
            }
        }
    }

    private static void sendConfirmedRequest(ClientTransaction transaction, ConfirmedRequestPdu apdu) {
        int devMaxLen = DeviceRegistry.getMaxApduLengthSupported(apdu.getServerAddress());
        int myMaxLen = apdu.getMaxAPDULengthAccepted();
        int maxLength = Math.min(devMaxLen, myMaxLen);
        if (apdu.getLength() + 4 > maxLength) {
            BBacnetSegmentation seg = DeviceRegistry.getSegmentationSupported(apdu.getServerAddress());
            if (!BBacnetNetwork.localDevice().getSegmentationSupported().isSegmentedTransmit()) {
                throw new UnsupportedOperationException("Cannot send segmented packet: Niagara not configured for segmentation");
            }
            int deviceMaxSegs = DeviceRegistry.getMaxSegmentsAccepted(apdu.getServerAddress());
            if (!seg.isSegmentedReceive()) {
                throw new UnsupportedOperationException("For device address: " + apdu.getServerAddress() + ": Cannot send segmented packet: device does not support segmentation " + (Object)((Object)seg) + "; device maxAPDULength: " + devMaxLen + "; maxSegmentsAccepted: " + deviceMaxSegs);
            }
            int numSegments = apdu.getLength() / (maxLength - 6) + 1;
            if (!ConfirmedRequestPdu.canFit(deviceMaxSegs, numSegments)) {
                throw new UnsupportedOperationException("For device address: " + apdu.getServerAddress() + ": Cannot send segmented packet: number of segments required " + numSegments + " exceeds device's max segments accepted: " + deviceMaxSegs + "; device maxAPDULength: " + devMaxLen + "; segmentation:  " + (Object)((Object)seg));
            }
            ClientStateMachine.sendConfirmedRequestSegmented(transaction, apdu, maxLength, numSegments);
        } else {
            ClientStateMachine.sendConfirmedRequestUnsegmented(transaction, apdu);
        }
    }

    private static void sendConfirmedRequestUnsegmented(ClientTransaction transaction, ConfirmedRequestPdu apdu) {
        transaction.setSentAllSegments(true);
        apdu.setSegmentedMessage(false);
        ClientStateMachine.network().sendRequest(transaction.getServerAddress(), apdu);
        transaction.setState(2);
        transaction.startRequestTimer(BBacnetNetwork.localDevice().getApduTimeout());
    }

    private static void sendConfirmedRequestSegmented(ClientTransaction transaction, ConfirmedRequestPdu apdu, int maxSegmentLength, int numSegments) {
        apdu.setSegmentedMessage(true);
        ConfirmedRequestPdu seg = new ConfirmedRequestPdu(apdu, 0, maxSegmentLength, 0);
        transaction.setSentAllSegments(false);
        transaction.setSegmentRetryCount(0);
        transaction.setInitialSequenceNumber(0);
        transaction.setSegmentCounter(0);
        transaction.setProposedWindowSize(DEFAULT_SEGMENTATION_WINDOW_SIZE);
        transaction.setActualWindowSize(1);
        transaction.setSegmentSize(maxSegmentLength);
        transaction.setNumSegments(numSegments);
        seg.setMoreFollows(true);
        seg.setProposedWindowSize(transaction.getProposedWindowSize());
        ClientStateMachine.network().sendRequest(transaction.getServerAddress(), seg);
        transaction.setState(1);
        transaction.startSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
    }

    private static void sendAbort(ApplicationPdu apdu, int abortReason) {
        AbortPdu abort = new AbortPdu(apdu.getServerAddress(), apdu.getPriority(), apdu.getInvokeId(), abortReason, false);
        ClientStateMachine.network().sendRequest(apdu.getServerAddress(), abort);
    }

    private static void fillWindow(ClientTransaction transaction) {
        int segmentCounter;
        int ix = 0;
        int lastSegment = transaction.getNumSegments() - 1;
        int sequenceNumber = transaction.getInitialSequenceNumber();
        int segSize = transaction.getSegmentSize();
        int seqNum = sequenceNumber;
        int segCtr = segmentCounter = transaction.getSegmentCounter();
        ConfirmedRequestPdu req = transaction.getRequestPdu();
        do {
            ConfirmedRequestPdu seg;
            seqNum = sequenceNumber + ix;
            segCtr = segmentCounter + ix;
            if (segCtr >= lastSegment) {
                seqNum = lastSegment;
                seg = new ConfirmedRequestPdu(req, ClientStateMachine.modulo(seqNum, 256), segSize, segCtr);
                seg.setSegmentedMessage(true);
                seg.setMoreFollows(false);
                seg.setProposedWindowSize(transaction.getProposedWindowSize());
                ClientStateMachine.network().sendRequest(transaction.getServerAddress(), seg);
                transaction.setSentAllSegments(true);
                return;
            }
            seg = new ConfirmedRequestPdu(req, ClientStateMachine.modulo(seqNum, 256), segSize, segCtr);
            seg.setSegmentedMessage(true);
            seg.setMoreFollows(true);
            seg.setProposedWindowSize(transaction.getProposedWindowSize());
            ClientStateMachine.network().sendRequest(transaction.getServerAddress(), seg);
        } while (++ix < transaction.getActualWindowSize());
    }

    private static void sendSegmentNak(ClientTransaction transaction, int sequenceNumber) {
        ClientStateMachine.sendSegmentAck(transaction, true, sequenceNumber);
    }

    private static void sendSegmentAck(ClientTransaction transaction, boolean negativeAck, int sequenceNumber) {
        SegmentAckPdu segAck = new SegmentAckPdu(negativeAck, false, transaction.getInvokeId(), sequenceNumber, transaction.getActualWindowSize());
        ClientStateMachine.network().sendRequest(transaction.getServerAddress(), segAck);
    }

    private static void receiveSegmentedComplexAck(ClientTransaction transaction, ComplexAckPdu complexAck) {
        transaction.stopRequestTimer();
        transaction.setComplexAck(complexAck);
        transaction.setActualWindowSize(complexAck.getProposedWindowSize());
        transaction.setLastSequenceNumber(0);
        transaction.setInitialSequenceNumber(0);
        transaction.setDuplicateCount(0);
        ClientStateMachine.sendSegmentAck(transaction, false, 0);
        transaction.startSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
        transaction.setState(3);
    }

    private static BBacnetNetworkLayer network() {
        return stack.getNetwork();
    }

    private static class SegmentedConf {
        private SegmentedConf() {
        }

        public static final void process(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getSource()) {
                case 0: {
                    SegmentedConf.processApplication(apdu, transaction);
                    break;
                }
                case 1: {
                    SegmentedConf.processNetworkIndication(apdu, transaction);
                    break;
                }
                case 3: {
                    SegmentedConf.processSegmentTimeout(apdu, transaction);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedConf.process():" + apdu.trace());
                }
            }
        }

        private static void processApplication(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getType()) {
                case 7: {
                    transaction.stopSegmentTimer();
                    ClientStateMachine.network().sendRequest(transaction.getServerAddress(), apdu);
                    transaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedConf.processApplication():" + apdu.trace());
                }
            }
        }

        private static void processNetworkIndication(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getType()) {
                case 3: {
                    ComplexAckPdu complexAck = (ComplexAckPdu)apdu;
                    if (!complexAck.isSegmentedMessage()) {
                        transaction.stopSegmentTimer();
                        transaction.timeout();
                        ClientStateMachine.sendAbort(apdu, 2);
                        transaction.setState(0);
                        return;
                    }
                    int lastSeqNum = transaction.getLastSequenceNumber();
                    int thisSeqNum = complexAck.getSequenceNumber();
                    int initSeqNum = transaction.getInitialSequenceNumber();
                    int actWinSize = transaction.getActualWindowSize();
                    if (thisSeqNum != TransportStateMachine.modulo(lastSeqNum + 1, 256)) {
                        if (TransportStateMachine.duplicateInWindow(thisSeqNum, TransportStateMachine.modulo(initSeqNum + 1, 256), lastSeqNum, actWinSize)) {
                            transaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                            if (transaction.getDuplicateCount() < actWinSize) {
                                transaction.incrementDuplicateCount();
                            } else {
                                ClientStateMachine.sendSegmentNak(transaction, lastSeqNum);
                                transaction.setDuplicateCount(0);
                            }
                        } else {
                            ClientStateMachine.sendSegmentAck(transaction, true, lastSeqNum);
                            transaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                            transaction.setInitialSequenceNumber(lastSeqNum);
                            transaction.setDuplicateCount(0);
                            return;
                        }
                    }
                    if (complexAck.getMoreFollows()) {
                        if (thisSeqNum != TransportStateMachine.modulo(initSeqNum + actWinSize, 256)) {
                            transaction.getResponse().appendSegment(complexAck);
                            transaction.setLastSequenceNumber(TransportStateMachine.modulo(lastSeqNum + 1, 256));
                            transaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                            return;
                        }
                        transaction.getResponse().appendSegment(complexAck);
                        lastSeqNum = TransportStateMachine.modulo(lastSeqNum + 1, 256);
                        transaction.setLastSequenceNumber(lastSeqNum);
                        transaction.setInitialSequenceNumber(lastSeqNum);
                        transaction.setDuplicateCount(0);
                        ClientStateMachine.sendSegmentAck(transaction, false, thisSeqNum);
                        transaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    transaction.getResponse().appendSegment(complexAck);
                    transaction.stopSegmentTimer();
                    ClientStateMachine.sendSegmentAck(transaction, false, thisSeqNum);
                    transaction.postConfirmation(transaction.getResponse());
                    transaction.setState(0);
                    break;
                }
                case 7: {
                    transaction.stopSegmentTimer();
                    transaction.postConfirmation(apdu);
                    transaction.setState(0);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    transaction.stopSegmentTimer();
                    transaction.timeout();
                    ClientStateMachine.sendAbort(apdu, 2);
                    transaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedConf.processNetworkIndication():" + apdu.trace());
                }
            }
        }

        private static void processSegmentTimeout(ApplicationPdu apdu, ClientTransaction transaction) {
            transaction.stopSegmentTimer();
            transaction.timeout();
            transaction.setState(0);
        }
    }

    private static class AwaitConfirmation {
        private AwaitConfirmation() {
        }

        public static final void process(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getSource()) {
                case 0: {
                    AwaitConfirmation.processApplication(apdu, transaction);
                    break;
                }
                case 1: {
                    AwaitConfirmation.processNetworkIndication(apdu, transaction);
                    break;
                }
                case 2: {
                    AwaitConfirmation.processRequestTimeout(apdu, transaction);
                    break;
                }
                default: {
                    throw new IllegalStateException("AwaitConfirmation.process():" + apdu.trace());
                }
            }
        }

        private static void processApplication(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getType()) {
                case 7: {
                    transaction.stopRequestTimer();
                    ClientStateMachine.network().sendRequest(transaction.getServerAddress(), apdu);
                    transaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("AwaitConfirmation.processApplication():" + apdu.trace());
                }
            }
        }

        private static void processNetworkIndication(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getType()) {
                case 2: {
                    transaction.stopRequestTimer();
                    transaction.postConfirmation(apdu);
                    transaction.setState(0);
                    break;
                }
                case 3: {
                    ComplexAckPdu complexAck = (ComplexAckPdu)apdu;
                    if (complexAck.isSegmentedMessage()) {
                        if (!BBacnetNetwork.localDevice().getSegmentationSupported().isSegmentedReceive()) {
                            transaction.stopRequestTimer();
                            transaction.timeout();
                            ClientStateMachine.sendAbort(apdu, 4);
                            transaction.setState(0);
                            break;
                        }
                        if (complexAck.getSequenceNumber() != 0) {
                            transaction.stopRequestTimer();
                            transaction.timeout();
                            ClientStateMachine.sendAbort(apdu, 2);
                            transaction.setState(0);
                            break;
                        }
                        ClientStateMachine.receiveSegmentedComplexAck(transaction, complexAck);
                        break;
                    }
                    transaction.stopRequestTimer();
                    transaction.postConfirmation(apdu);
                    transaction.setState(0);
                    break;
                }
                case 5: {
                    transaction.stopRequestTimer();
                    transaction.postConfirmation(apdu);
                    transaction.setState(0);
                    break;
                }
                case 6: {
                    transaction.stopRequestTimer();
                    transaction.postConfirmation(apdu);
                    transaction.setState(0);
                    break;
                }
                case 7: {
                    transaction.stopRequestTimer();
                    transaction.postConfirmation(apdu);
                    transaction.setState(0);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalStateException("AwaitConfirmation.processNetworkIndication():" + apdu.trace());
                }
            }
        }

        private static void processRequestTimeout(ApplicationPdu apdu, ClientTransaction transaction) {
            int numRetries = transaction.getRetryCount();
            if (numRetries < BBacnetNetwork.localDevice().getNumberOfApduRetries()) {
                transaction.setRetryCount(++numRetries);
                ClientStateMachine.sendConfirmedRequest(transaction, (ConfirmedRequestPdu)apdu);
            } else {
                transaction.stopRequestTimer();
                transaction.timeout();
                transaction.setState(0);
            }
        }
    }

    private static class SegmentedRequest {
        private SegmentedRequest() {
        }

        public static final void process(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getSource()) {
                case 0: {
                    SegmentedRequest.processApplication(apdu, transaction);
                    break;
                }
                case 1: {
                    SegmentedRequest.processNetworkIndication(apdu, transaction);
                    break;
                }
                case 3: {
                    SegmentedRequest.processSegmentTimeout(apdu, transaction);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedRequest.process():" + apdu.trace());
                }
            }
        }

        private static void processApplication(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getType()) {
                case 7: {
                    transaction.stopSegmentTimer();
                    ClientStateMachine.network().sendRequest(transaction.getServerAddress(), apdu);
                    transaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedRequest.processApplication():" + apdu.trace());
                }
            }
        }

        private static void processNetworkIndication(ApplicationPdu apdu, ClientTransaction transaction) {
            switch (apdu.getType()) {
                case 4: {
                    SegmentAckPdu segAck = (SegmentAckPdu)apdu;
                    if (!TransportStateMachine.inWindow(segAck.getSequenceNumber(), transaction.getInitialSequenceNumber(), segAck.getActualWindowSize())) {
                        transaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    if (!transaction.getSentAllSegments()) {
                        int segCtr = transaction.getSegmentCounter();
                        transaction.setSegmentCounter(segCtr + transaction.getActualWindowSize());
                        transaction.setInitialSequenceNumber(TransportStateMachine.modulo(segAck.getSequenceNumber() + 1, 256));
                        transaction.setActualWindowSize(segAck.getActualWindowSize());
                        transaction.setSegmentRetryCount(0);
                        ClientStateMachine.fillWindow(transaction);
                        transaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    transaction.stopSegmentTimer();
                    transaction.startRequestTimer(BBacnetNetwork.localDevice().getApduTimeout());
                    transaction.setState(2);
                    break;
                }
                case 7: {
                    transaction.stopSegmentTimer();
                    transaction.postConfirmation(apdu);
                    transaction.setState(0);
                    break;
                }
                case 2: {
                    if (transaction.getSentAllSegments()) {
                        transaction.stopRequestTimer();
                        transaction.stopSegmentTimer();
                        transaction.postConfirmation(apdu);
                        transaction.setState(0);
                        break;
                    }
                    transaction.stopSegmentTimer();
                    transaction.timeout();
                    ClientStateMachine.sendAbort(apdu, 2);
                    transaction.setState(0);
                    break;
                }
                case 3: {
                    ComplexAckPdu complexAck = (ComplexAckPdu)apdu;
                    if (!transaction.getSentAllSegments()) {
                        transaction.stopSegmentTimer();
                        transaction.timeout();
                        ClientStateMachine.sendAbort(apdu, 2);
                        transaction.setState(0);
                        return;
                    }
                    if (!complexAck.isSegmentedMessage()) {
                        transaction.stopRequestTimer();
                        transaction.stopSegmentTimer();
                        transaction.postConfirmation(apdu);
                        transaction.setState(0);
                        return;
                    }
                    if (complexAck.getSequenceNumber() != 0) {
                        transaction.stopSegmentTimer();
                        transaction.timeout();
                        ClientStateMachine.sendAbort(apdu, 2);
                        transaction.setState(0);
                        return;
                    }
                    transaction.stopSegmentTimer();
                    ClientStateMachine.receiveSegmentedComplexAck(transaction, complexAck);
                    break;
                }
                case 5: 
                case 6: {
                    if (transaction.getSentAllSegments()) {
                        transaction.stopRequestTimer();
                        transaction.stopSegmentTimer();
                        transaction.postConfirmation(apdu);
                        transaction.setState(0);
                        break;
                    }
                    transaction.stopSegmentTimer();
                    transaction.timeout();
                    ClientStateMachine.sendAbort(apdu, 2);
                    transaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedRequest.processNetworkIndication():" + apdu.trace());
                }
            }
        }

        private static void processSegmentTimeout(ApplicationPdu apdu, ClientTransaction transaction) {
            int numRetries = transaction.getSegmentRetryCount();
            if (numRetries < BBacnetNetwork.localDevice().getNumberOfApduRetries()) {
                transaction.setSegmentRetryCount(++numRetries);
                ClientStateMachine.fillWindow(transaction);
                transaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
            } else {
                transaction.stopSegmentTimer();
                transaction.timeout();
                transaction.setState(0);
            }
        }
    }

    static class Idle {
        Idle() {
        }

        public static void process(ApplicationPdu apdu) {
            switch (apdu.getSource()) {
                case 0: {
                    Idle.processApplication(apdu);
                    break;
                }
                case 1: {
                    Idle.processNetworkIndication(apdu);
                    break;
                }
                default: {
                    logger.warning("invalid apdu source:" + apdu.getSource());
                    throw new IllegalStateException("Idle.process():" + apdu.trace());
                }
            }
        }

        private static void processApplication(ApplicationPdu apdu) {
            int apduType = apdu.getType();
            switch (apduType) {
                case 1: {
                    ClientStateMachine.network().sendRequest(apdu.getServerAddress(), apdu);
                    break;
                }
                case 0: {
                    ClientTransaction transaction = new ClientTransaction((ConfirmedRequestPdu)apdu);
                    transaction.setRetryCount(0);
                    ClientStateMachine.sendConfirmedRequest(transaction, (ConfirmedRequestPdu)apdu);
                    break;
                }
                default: {
                    throw new IllegalStateException("Idle.processApplication():" + apdu.trace());
                }
            }
        }

        private static void processNetworkIndication(ApplicationPdu apdu) {
            switch (apdu.getType()) {
                case 3: {
                    ComplexAckPdu complexAck = (ComplexAckPdu)apdu;
                    if (!complexAck.isSegmentedMessage()) break;
                    ClientStateMachine.sendAbort(apdu, 2);
                    break;
                }
                case 4: {
                    if (!apdu.isServerPDU()) break;
                    ClientStateMachine.sendAbort(apdu, 2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Idle.processNetworkIndication():" + apdu.trace());
                }
            }
        }
    }
}

