/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.util;

import com.tridium.bacnet.stack.link.ip.BacnetNetworkAdapter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;

public final class LinkLayerUtil {
    public static final boolean NUMBER_DUPLICATES = true;
    private static final int NONE_IDX = -1;
    private static final int FIRST_IDX = 0;
    private static List<Pattern> includedPatterns;
    private static List<Pattern> excludedPatterns;
    private static boolean isAutoAdapterChangeDisabled;

    private LinkLayerUtil() {
    }

    public static boolean isAutoAdapterChangeDisabled() {
        return isAutoAdapterChangeDisabled;
    }

    public static BDynamicEnum select(int ord, BEnumRange range) {
        return BDynamicEnum.make((int)ord, (BEnumRange)range);
    }

    public static Collection<BacnetNetworkAdapter> filterAdapters(Collection<BacnetNetworkAdapter> adapters) {
        List<Pattern> includedPatterns = LinkLayerUtil.getIncludedPatterns();
        List<Pattern> excludedPatterns = LinkLayerUtil.getExcludedPatterns();
        ArrayList<BacnetNetworkAdapter> filtered = new ArrayList<BacnetNetworkAdapter>(adapters.size());
        for (BacnetNetworkAdapter adapter : adapters) {
            String identifier = adapter.getIdentifier().trim();
            if (!includedPatterns.isEmpty() && !LinkLayerUtil.matchesAny(identifier, includedPatterns) || LinkLayerUtil.matchesAny(identifier, excludedPatterns)) continue;
            filtered.add(adapter);
        }
        return filtered;
    }

    private static boolean matchesAny(String identifier, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (pattern.pattern().isEmpty() || !pattern.matcher(identifier).matches()) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> getIncludedPatterns() {
        if (includedPatterns == null) {
            String patterns = AccessController.doPrivileged(() -> System.getProperty("niagara.bacnet.included.ip.adapters", "")).trim();
            includedPatterns = Collections.unmodifiableList(LinkLayerUtil.makePatternList(patterns));
        }
        return includedPatterns;
    }

    private static List<Pattern> getExcludedPatterns() {
        if (excludedPatterns == null) {
            String patterns = AccessController.doPrivileged(() -> System.getProperty("niagara.bacnet.excluded.ip.adapters", "")).trim();
            excludedPatterns = Collections.unmodifiableList(LinkLayerUtil.makePatternList(patterns));
        }
        return excludedPatterns;
    }

    private static List<Pattern> makePatternList(String patternStrings) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String patternString : patternStrings.split(";")) {
            String trimmed = patternString.trim();
            if (trimmed.isEmpty()) continue;
            patterns.add(Pattern.compile(trimmed));
        }
        patterns.trimToSize();
        return patterns;
    }

    public static BEnumRange makeIdRange(Collection<BacnetNetworkAdapter> adapters, String none) {
        Vector<String> ids = new Vector<String>();
        for (BacnetNetworkAdapter a : adapters) {
            ids.add(a.getIdentifier());
        }
        return LinkLayerUtil.makeEnumRange(ids, false, none);
    }

    public static BEnumRange makeIpRange(Collection<BacnetNetworkAdapter> adapters, String none) {
        Vector<String> ips = new Vector<String>();
        for (BacnetNetworkAdapter netIf : adapters) {
            ips.add(netIf.getAddress());
        }
        return LinkLayerUtil.makeEnumRange(ips, false, none);
    }

    public static BEnumRange makeDescRange(Collection<BacnetNetworkAdapter> adapters, String none) {
        Vector<String> desc = new Vector<String>();
        for (BacnetNetworkAdapter a : adapters) {
            desc.add(a.getDescription());
        }
        return LinkLayerUtil.makeEnumRange(desc, true, none);
    }

    public static BEnumRange makeEnumRange(Vector<String> v, boolean fixDuplicates, String none) {
        int size = v.size() + 1;
        String[] arr = new String[size];
        arr[0] = none;
        if (!v.isEmpty()) {
            int i;
            for (i = 1; i < size; ++i) {
                arr[i] = v.get(i - 1);
            }
            if (fixDuplicates) {
                LinkLayerUtil.fixDuplicates(arr);
            }
            for (i = 1; i < size; ++i) {
                arr[i] = SlotPath.escape((String)arr[i]);
            }
        }
        return BEnumRange.make((int[])LinkLayerUtil.ords(arr), (String[])arr);
    }

    public static int ordinal(String tag, BEnumRange range, String none) {
        int ordinal = 0;
        ordinal = !tag.equals(none) && range.isTag(tag) ? range.tagToOrdinal(tag) : (range.getOrdinals().length == 2 ? 0 : -1);
        return ordinal;
    }

    private static void fixDuplicates(String[] arr) {
        AdapterNode node;
        int i;
        HashMap<String, AdapterNode> names = new HashMap<String, AdapterNode>(arr.length);
        for (i = 1; i < arr.length; ++i) {
            node = (AdapterNode)names.get(arr[i]);
            if (node == null) {
                names.put(arr[i], new AdapterNode(arr[i]));
                continue;
            }
            node.increment();
        }
        for (i = arr.length - 1; i > 0; --i) {
            node = (AdapterNode)names.get(arr[i]);
            arr[i] = node.toString();
            node.decrement();
        }
    }

    private static int[] ords(String[] values) {
        int[] ords = new int[values.length];
        for (int i = 0; i < ords.length; ++i) {
            ords[i] = i - 1;
        }
        return ords;
    }

    public static String addressToString(byte[] address) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < address.length; ++i) {
            sb.append(address[i] & 0xFF).append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    static {
        isAutoAdapterChangeDisabled = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.bacnet.link.autoAdapterChange.disabled"));
    }

    private static class AdapterNode {
        public final String value;
        public int count = 1;
        public boolean hasDuplicates = false;

        public AdapterNode(String value) {
            this.value = value;
        }

        public void increment() {
            this.hasDuplicates = true;
            ++this.count;
        }

        public void decrement() {
            --this.count;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof AdapterNode) {
                AdapterNode node = (AdapterNode)other;
                return this.value.equals(node.value);
            }
            return false;
        }

        public String toString() {
            if (this.hasDuplicates) {
                return this.value + " #" + this.count;
            }
            return this.value;
        }
    }
}

