/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.authentication;

import com.tridium.authn.BAuthenticationService;
import com.tridium.bacnet.stack.link.sc.BScCredentials;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.authentication.BBacnetScAuthenticationScheme;
import com.tridium.bacnet.stack.link.sc.authentication.BBacnetScAuthenticator;
import com.tridium.bacnet.stack.link.sc.authentication.BCrlDescriptor;
import com.tridium.crypto.core.cert.CertUtils;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.security.BX509Certificate;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="issuerCertificate", type="BX509Certificate", defaultValue="BX509Certificate.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(value="BFacets.make(\"warningText\", \"%lexicon(bacnet:issuerCertEditor.warningText)%\")")}), @NiagaraProperty(name="useCrlDistributionPointInIssuer", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="crlDistributionPointUrls", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="crlDescriptor", type="BCrlDescriptor", defaultValue="new BCrlDescriptor()"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()")})
@NiagaraActions(value={@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4), @NiagaraAction(name="checkCrlExpiration", flags=4)})
public final class BIssuerCertAndCrl
extends BComponent
implements BIAlarmSource,
BIStatus {
    @Generated
    public static final Property status = BIssuerCertAndCrl.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property issuerCertificate = BIssuerCertAndCrl.newProperty((int)0, (BValue)BX509Certificate.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"warningText", (String)"%lexicon(bacnet:issuerCertEditor.warningText)%")));
    @Generated
    public static final Property useCrlDistributionPointInIssuer = BIssuerCertAndCrl.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property crlDistributionPointUrls = BIssuerCertAndCrl.newProperty((int)1, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"multiLine", (boolean)true)));
    @Generated
    public static final Property crlDescriptor = BIssuerCertAndCrl.newProperty((int)0, (BValue)new BCrlDescriptor(), null);
    @Generated
    public static final Property alarmSourceInfo = BIssuerCertAndCrl.newProperty((int)0, (BValue)BIssuerCertAndCrl.initAlarmSourceInfo(), null);
    @Generated
    public static final Action ackAlarm = BIssuerCertAndCrl.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Action checkCrlExpiration = BIssuerCertAndCrl.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIssuerCertAndCrl.class);
    private static final BasicContext UPDATE_CONTEXT = new BasicContext();
    private static final String CRL_EXTENSION = ".crl";
    private String cachedUrls = "";
    private String crlFilename;
    private AlarmSupport alarmSupport;
    private final AtomicReference<Clock.Ticket> expirationCheckTicket = new AtomicReference();
    private Instant crlExpirationInstant;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BX509Certificate getIssuerCertificate() {
        return (BX509Certificate)this.get(issuerCertificate);
    }

    @Generated
    public void setIssuerCertificate(BX509Certificate v) {
        this.set(issuerCertificate, (BValue)v, null);
    }

    @Generated
    public boolean getUseCrlDistributionPointInIssuer() {
        return this.getBoolean(useCrlDistributionPointInIssuer);
    }

    @Generated
    public void setUseCrlDistributionPointInIssuer(boolean v) {
        this.setBoolean(useCrlDistributionPointInIssuer, v, null);
    }

    @Generated
    public String getCrlDistributionPointUrls() {
        return this.getString(crlDistributionPointUrls);
    }

    @Generated
    public void setCrlDistributionPointUrls(String v) {
        this.setString(crlDistributionPointUrls, v, null);
    }

    @Generated
    public BCrlDescriptor getCrlDescriptor() {
        return (BCrlDescriptor)this.get(crlDescriptor);
    }

    @Generated
    public void setCrlDescriptor(BCrlDescriptor v) {
        this.set(crlDescriptor, (BValue)v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public void checkCrlExpiration() {
        this.invoke(checkCrlExpiration, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BScCredentials;
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.crlExpirationInstant = this.generateCrlExpirationInstant();
        if (this.crlExpirationInstant != null) {
            this.generateExpirationTicket(this.crlExpirationInstant);
        }
        this.updateAlarm();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(issuerCertificate)) {
            if (this.getUseCrlDistributionPointInIssuer()) {
                this.updateCrlDistributionPointFromCertificate();
                this.getCrlDescriptor().updateStatus();
            }
            this.deleteCrl();
            this.crlFilename = this.generateCrlFilename();
            BScLinkLayer linkLayer = ScLinkLayerUtil.getScLinkLayer((BComplex)this);
            if (BBacnetScAuthenticator.logger.isLoggable(Level.FINE)) {
                BBacnetScAuthenticator.logger.fine("issuerCertificate property has been changed in IssuerCertAndCrl " + this.getName() + " of SC port " + linkLayer.getParent().getName() + ": CRL has been deleted");
            }
            linkLayer.trustAnchorsUpdated();
            this.getCrlDescriptor().updateStatus();
        } else if (property.equals(useCrlDistributionPointInIssuer)) {
            if (this.getUseCrlDistributionPointInIssuer()) {
                this.setFlags((Slot)crlDistributionPointUrls, this.getFlags((Slot)crlDistributionPointUrls) | 1);
                this.cachedUrls = this.getCrlDistributionPointUrls();
                this.updateCrlDistributionPointFromCertificate();
            } else {
                this.setFlags((Slot)crlDistributionPointUrls, this.getFlags((Slot)crlDistributionPointUrls) & 0xFFFFFFFE);
                this.set(crlDistributionPointUrls, (BValue)BString.make((String)this.cachedUrls), (Context)UPDATE_CONTEXT);
            }
            this.getCrlDescriptor().updateStatus();
        } else if (property.equals(crlDistributionPointUrls) && context != UPDATE_CONTEXT) {
            if (this.getUseCrlDistributionPointInIssuer()) {
                BBacnetScAuthenticator.logger.info("CRL Distribution Point URLs was modified, but is configured to use values from the issuer certificate. Reverting to CRL distributions points found in the issuer certificate.");
                this.updateCrlDistributionPointFromCertificate();
            }
            this.getCrlDescriptor().updateStatus();
        }
        super.changed(property, context);
    }

    private void updateCrlDistributionPointFromCertificate() {
        X509Certificate configuredIssuer = this.getIssuerCertificate().getX509Certificate();
        if (configuredIssuer == null) {
            BBacnetScAuthenticator.logger.info("Issuer is configured to use CRL distribution points from the certificate, but no Issuer is configured");
            return;
        }
        List crlDistributionPoints = CertUtils.getCrlDistributionPointsFromCertificate((X509Certificate)configuredIssuer);
        if (crlDistributionPoints.isEmpty()) {
            BBacnetScAuthenticator.logger.info(String.format("Issuer <%s> is configured to use CRL distribution points from the certificate, but the certificate has no CRL distribution points", configuredIssuer.getSubjectX500Principal().toString()));
            this.set(crlDistributionPointUrls, (BValue)BString.make((String)""), (Context)UPDATE_CONTEXT);
            return;
        }
        this.set(crlDistributionPointUrls, (BValue)BString.make((String)String.join((CharSequence)"\n", crlDistributionPoints)), (Context)UPDATE_CONTEXT);
    }

    void validateCrl(X509CRL crl) throws Exception {
        X509Certificate crlIssuer = this.getIssuerCertificate().getX509Certificate();
        if (crlIssuer == null) {
            throw new Exception("CRL cannot be validated. Issuer Certificate is not set.");
        }
        crl.verify(crlIssuer.getPublicKey());
    }

    void saveCrl(X509CRL crl) throws Exception {
        File crlDir = BIssuerCertAndCrl.getCrlDir();
        if (crlDir == null) {
            throw new Exception("Could not save CRL for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName() + ": Directory does not exist and could not be created.");
        }
        String crlFilename = this.getCrlFilename();
        if (crlFilename.isEmpty()) {
            throw new Exception("Could not save CRL for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName() + ": Filename not generated");
        }
        Path crlPath = new File(crlDir, crlFilename).toPath();
        try {
            AccessController.doPrivileged(() -> {
                Files.write(crlPath, crl.getEncoded(), new OpenOption[0]);
                return null;
            });
            if (BBacnetScAuthenticator.logger.isLoggable(Level.FINE)) {
                BBacnetScAuthenticator.logger.fine("CRL was saved for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName() + "; directory: " + crlDir + ", filename: " + crlFilename);
            }
        }
        catch (PrivilegedActionException e) {
            throw new Exception("Could not write CRL for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName(), e.getException());
        }
        this.crlExpirationInstant = crl.getNextUpdate().toInstant();
        this.generateExpirationTicket(this.crlExpirationInstant);
        this.updateAlarm();
        BScLinkLayer linkLayer = ScLinkLayerUtil.getScLinkLayer((BComplex)this);
        if (BBacnetScAuthenticator.logger.isLoggable(Level.FINE)) {
            BBacnetScAuthenticator.logger.fine("CRL has been saved for property " + this.getName() + " of SC port " + linkLayer.getParent().getName() + ": signaling that trust anchors have been updated");
        }
        linkLayer.trustAnchorsUpdated();
    }

    private void deleteCrl() {
        String crlFilename;
        File crlDir = BIssuerCertAndCrl.getCrlDir();
        if (crlDir == null) {
            BBacnetScAuthenticator.logger.warning("Could not delete CRL for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName() + ": Directory does not exist and could not be created");
        }
        if ((crlFilename = this.getCrlFilename()).isEmpty()) {
            if (BBacnetScAuthenticator.logger.isLoggable(Level.FINE)) {
                BBacnetScAuthenticator.logger.fine("Filename has not yet been generated for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName() + ": skipping delete");
            }
            return;
        }
        Path crlPath = new File(crlDir, crlFilename).toPath();
        try {
            boolean wasDeleted = AccessController.doPrivileged(() -> Files.deleteIfExists(crlPath));
            if (BBacnetScAuthenticator.logger.isLoggable(Level.FINE)) {
                if (wasDeleted) {
                    BBacnetScAuthenticator.logger.fine("CRL was deleted for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName() + "; directory: " + crlDir + ", filename: " + crlFilename);
                } else {
                    BBacnetScAuthenticator.logger.fine("CRL was not deleted because it did not exist for " + this.getName() + " of SC port " + ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName() + "; directory: " + crlDir + ", filename: " + crlFilename);
                }
            }
        }
        catch (PrivilegedActionException e) {
            ScLinkLayerUtil.logException(BBacnetScAuthenticator.logger, new StringBuilder("Could not delete CRL for ").append(this.getName()).append(" of SC port ").append(ScLinkLayerUtil.getScLinkLayer((BComplex)this).getParent().getName()).append("; directory: ").append(crlDir).append(", filename: ").append(crlFilename), e.getException());
        }
        Clock.Ticket ticket = this.expirationCheckTicket.getAndSet(null);
        if (ticket != null) {
            ticket.cancel();
        }
        this.crlExpirationInstant = null;
        this.updateAlarm();
    }

    private String generateCrlFilename() {
        X509Certificate issuerCert = this.getIssuerCertificate().getX509Certificate();
        if (issuerCert == null) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA256");
            byte[] digest = md.digest(issuerCert.getSubjectX500Principal().getName().getBytes());
            return ByteArrayUtil.toHexString((byte[])digest) + CRL_EXTENSION;
        }
        catch (NoSuchAlgorithmException e) {
            ScLinkLayerUtil.logException(BBacnetScAuthenticator.logger, Level.SEVERE, new StringBuilder("Could not generate CRL filename for ").append(this.getName()), e);
            return "";
        }
    }

    static File getCrlDir() {
        return CrlDirHolder.CRL_DIR;
    }

    String getCrlFilename() {
        if (this.crlFilename == null) {
            this.crlFilename = this.generateCrlFilename();
        }
        return this.crlFilename;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<X509CRL> getCrl() throws CRLException {
        if (!this.isConfiguredForCrls()) {
            return Optional.empty();
        }
        File crlDir = BIssuerCertAndCrl.getCrlDir();
        String crlFilename = this.getCrlFilename();
        if (crlDir == null) return Optional.empty();
        if (crlFilename.isEmpty()) {
            return Optional.empty();
        }
        File crlFile = new File(crlDir, crlFilename);
        if (!AccessController.doPrivileged(crlFile::exists).booleanValue()) {
            this.getCrlDescriptor().execute();
            throw new CRLException("CRLs are configured for " + this.getName() + " but could not find CRL.");
        }
        try (FileInputStream fileInputStream = AccessController.doPrivileged(() -> new FileInputStream(crlFile));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(fileInputStream);
            this.validateCrl(crl);
            Optional<X509CRL> optional = Optional.of(crl);
            return optional;
        }
        catch (Exception e) {
            if (!(e instanceof PrivilegedActionException)) throw new CRLException("CRLs are configured for " + this.getName() + " but could not retrieve CRL from file.", e);
            e = ((PrivilegedActionException)e).getException();
            throw new CRLException("CRLs are configured for " + this.getName() + " but could not retrieve CRL from file.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Instant generateCrlExpirationInstant() {
        if (!this.isConfiguredForCrls()) {
            return null;
        }
        File crlDir = BIssuerCertAndCrl.getCrlDir();
        String crlFilename = this.getCrlFilename();
        if (crlDir == null) return null;
        if (crlFilename.isEmpty()) {
            return null;
        }
        File crlFile = new File(crlDir, crlFilename);
        if (AccessController.doPrivileged(crlFile::exists) == false) return null;
        try (FileInputStream inputStream = AccessController.doPrivileged(() -> new FileInputStream(crlFile));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(inputStream);
            Instant instant = crl.getNextUpdate().toInstant();
            return instant;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            ScLinkLayerUtil.logException(BBacnetScAuthenticator.logger, new StringBuilder("Could not load CRL for ").append(this.getName()).append(" to get expiration date"), e);
        }
        return null;
    }

    public boolean hasValidCrlFilename() {
        return BIssuerCertAndCrl.getCrlDir() != null && !this.getCrlFilename().isEmpty();
    }

    private boolean isConfiguredForCrls() {
        return !this.getCrlDistributionPointUrls().isEmpty() && !this.getIssuerCertificate().isNull();
    }

    private void generateExpirationTicket(Instant expirationInstant) {
        Clock.Ticket ticket = this.expirationCheckTicket.getAndSet(null);
        if (ticket != null) {
            ticket.cancel();
        }
        if (expirationInstant != null) {
            this.expirationCheckTicket.set(Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((long)expirationInstant.plusSeconds(5L).toEpochMilli()), (Action)checkCrlExpiration, null));
        }
    }

    public void doCheckCrlExpiration() {
        this.updateAlarm();
    }

    private void updateAlarm() {
        if (this.crlExpirationInstant != null && Instant.now().isAfter(this.crlExpirationInstant)) {
            this.alarmOffNormal();
        } else {
            this.alarmNormal();
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        try {
            boolean alarmAck = this.alarmSupport.ackAlarm(ackRequest);
            if (alarmAck) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
            return BBoolean.make((boolean)alarmAck);
        }
        catch (Exception e) {
            ScLinkLayerUtil.logException(BBacnetScAuthenticator.logger, new StringBuilder("Failed to ack alarm for ").append(BOrdList.make((BOrd)this.getNavOrd())), e);
            return BBoolean.FALSE;
        }
    }

    private void alarmOffNormal() {
        if (this.getStatus().isAlarm() || !BIssuerCertAndCrl.shouldGenerateAlarmOnExpiration() || !this.isRunning()) {
            return;
        }
        try {
            boolean ackRequired = this.alarmSupport.isAckRequired(BSourceState.offnormal);
            this.alarmSupport.newOffnormalAlarm();
            int statusBits = this.getStatus().getBits();
            statusBits |= 8;
            if (ackRequired) {
                statusBits |= 0x80;
            }
            this.setStatus(BStatus.make((int)statusBits));
        }
        catch (Exception e) {
            ScLinkLayerUtil.logException(BBacnetScAuthenticator.logger, new StringBuilder("Failed to send offNormal alarm for ").append(this.alarmSupport.getSourceOrd()), e);
        }
    }

    private void alarmNormal() {
        if (!this.getStatus().isAlarm() || !this.isRunning()) {
            return;
        }
        try {
            this.alarmSupport.toNormal(null);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        catch (Exception e) {
            ScLinkLayerUtil.logException(BBacnetScAuthenticator.logger, new StringBuilder("Failed to send toNormal alarm for ").append(this.alarmSupport.getSourceOrd()), e);
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo alarmSourceInfo = new BAlarmSourceInfo();
        alarmSourceInfo.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName%.%displayName%"));
        alarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(bacnet:issuerCertAndCrl.crlExpired)%"));
        alarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(bacnet:issuerCertAndCrl.crlNotExpired)%"));
        return alarmSourceInfo;
    }

    private static boolean shouldGenerateAlarmOnExpiration() {
        BAuthenticationService authnService = BAuthenticationService.getService();
        BBacnetScAuthenticationScheme[] bacnetSchemes = (BBacnetScAuthenticationScheme[])authnService.getAuthenticationSchemes().getChildren(BBacnetScAuthenticationScheme.class);
        if (bacnetSchemes.length == 0) {
            return false;
        }
        return bacnetSchemes[0].getGenerateAlarmOnCrlExpiration();
    }

    private static File fetchCrlDir() {
        File protectedStationHome = Sys.getProtectedStationHome();
        if (protectedStationHome == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(() -> {
                File dir = new File(protectedStationHome, "bacnet" + File.separator + "crls");
                if (!dir.exists() && !dir.mkdirs()) {
                    BBacnetScAuthenticator.logger.warning("Failed to retrieve or create directory for BACnet/SC CRLs");
                    return null;
                }
                return dir;
            });
        }
        catch (Exception e) {
            ScLinkLayerUtil.logException(BBacnetScAuthenticator.logger, new StringBuilder("Failed to retrieve or create directory for BACnet/SC CRLs"), e);
            return null;
        }
    }

    static /* synthetic */ File access$000() {
        return BIssuerCertAndCrl.fetchCrlDir();
    }

    private static final class CrlDirHolder {
        static final File CRL_DIR = BIssuerCertAndCrl.access$000();

        private CrlDirHolder() {
        }
    }
}

