/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;

public final class VmacUtil {
    private static final long MAX_VMAC = 0xFFFFFFFFFFFFL;
    private static final long MIN_VMAC = 0L;
    public static final long NULL_VMAC = -1L;
    public static final long BROADCAST_VMAC = 0xFFFFFFFFFFFFL;

    private VmacUtil() {
    }

    public static byte[] regenerateVmacAddress() {
        Random random = new Random();
        byte[] vmacBytes = new byte[6];
        do {
            random.nextBytes(vmacBytes);
        } while (!VmacUtil.isDeviceVmac(VmacUtil.bytesToVmac(vmacBytes)));
        return vmacBytes;
    }

    private static boolean isLegalVmac(long vmac) {
        return vmac >= 0L && vmac <= 0xFFFFFFFFFFFFL;
    }

    public static boolean isDeviceVmac(long vmac) {
        return vmac > 0L && vmac < 0xFFFFFFFFFFFFL;
    }

    public static boolean isDestinationVmac(long vmac) {
        return vmac > 0L && vmac <= 0xFFFFFFFFFFFFL;
    }

    public static void checkIsLegalVmac(long vmac) {
        if (!VmacUtil.isLegalVmac(vmac)) {
            throw new IllegalArgumentException("VMAC value is not valid [0x" + Long.toHexString(vmac) + ']');
        }
    }

    public static void checkIsDeviceVmac(long vmac) {
        if (!VmacUtil.isDeviceVmac(vmac)) {
            throw new IllegalArgumentException("Not a valid device VMAC: [0x" + Long.toHexString(vmac) + ']');
        }
    }

    public static void checkIsDestinationVmac(long vmac) {
        if (!VmacUtil.isDestinationVmac(vmac)) {
            throw new IllegalArgumentException("Not a valid destination VMAC: [0x" + Long.toHexString(vmac) + ']');
        }
    }

    public static long octetStringToVmac(BBacnetOctetString vmac) {
        return VmacUtil.bytesToVmac(vmac == null ? null : vmac.getAddr());
    }

    private static long bytesToVmac(int b0, int b1, int b2, int b3, int b4, int b5) {
        return ((long)b0 & 0xFFL) << 40 | ((long)b1 & 0xFFL) << 32 | ((long)b2 & 0xFFL) << 24 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 8 | (long)b5 & 0xFFL;
    }

    public static String vmacToString(long vmac) {
        if (!VmacUtil.isLegalVmac(vmac)) {
            return "null";
        }
        return TextUtil.byteToHexString((int)((int)(vmac >>> 40))) + ' ' + TextUtil.byteToHexString((int)((int)(vmac >>> 32))) + ' ' + TextUtil.byteToHexString((int)((int)(vmac >>> 24))) + ' ' + TextUtil.byteToHexString((int)((int)(vmac >>> 16))) + ' ' + TextUtil.byteToHexString((int)((int)(vmac >>> 8))) + ' ' + TextUtil.byteToHexString((int)((int)vmac));
    }

    public static BBacnetOctetString vmacToOctetString(long vmac) {
        return BBacnetOctetString.make(VmacUtil.vmacToBytes(vmac));
    }

    public static byte[] vmacToBytes(long vmac) {
        if (VmacUtil.isLegalVmac(vmac)) {
            return new byte[]{(byte)(vmac >>> 40), (byte)(vmac >>> 32), (byte)(vmac >>> 24), (byte)(vmac >>> 16), (byte)(vmac >>> 8), (byte)vmac};
        }
        return null;
    }

    public static void writeVmac(byte[] bytes, int offset, long vmac) {
        VmacUtil.checkIsLegalVmac(vmac);
        bytes[offset] = (byte)(vmac >>> 40);
        bytes[offset + 1] = (byte)(vmac >>> 32);
        bytes[offset + 2] = (byte)(vmac >>> 24);
        bytes[offset + 3] = (byte)(vmac >>> 16);
        bytes[offset + 4] = (byte)(vmac >>> 8);
        bytes[offset + 5] = (byte)vmac;
    }

    public static long bytesToVmac(byte[] b) {
        if (b == null || b.length != 6) {
            return -1L;
        }
        return VmacUtil.bytesToVmac(b[0], b[1], b[2], b[3], b[4], b[5]);
    }

    public static long readVmac(byte[] payload, int offset) {
        return VmacUtil.bytesToVmac(payload[offset], payload[offset + 1], payload[offset + 2], payload[offset + 3], payload[offset + 4], payload[offset + 5]);
    }

    public static long readVmac(ByteBuffer in) throws IOException {
        return VmacUtil.bytesToVmac(in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte());
    }

    public static void writeVmac(long vmac, DataOutput out) throws IOException {
        if (!VmacUtil.isLegalVmac(vmac)) {
            throw new IOException("Illegal VMAC");
        }
        out.write((byte)(vmac >>> 40));
        out.write((byte)(vmac >>> 32));
        out.write((byte)(vmac >>> 24));
        out.write((byte)(vmac >>> 16));
        out.write((byte)(vmac >>> 8));
        out.write((byte)vmac);
    }
}

