/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetBitStringTrendRecord;
import com.tridium.bacnet.history.BBacnetNumericIntervalTrendLogExt;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="propertyId", type="int", defaultValue="BBacnetPropertyIdentifier.STATUS_FLAGS", flags=1), @NiagaraProperty(name="length", type="int", defaultValue="0", flags=65)})
public class BBacnetBitStringTrendLogExt
extends BBacnetNumericIntervalTrendLogExt {
    @Generated
    public static final Property propertyId = BBacnetBitStringTrendLogExt.newProperty((int)1, (int)111, null);
    @Generated
    public static final Property length = BBacnetBitStringTrendLogExt.newProperty((int)65, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBitStringTrendLogExt.class);
    private BBacnetBitStringTrendRecord rec;
    private boolean trigger;
    private static Logger logger = Logger.getLogger("bacnet.server");
    private Object SEQUENCE_LOCK = new Object();

    @Generated
    public int getPropertyId() {
        return this.getInt(propertyId);
    }

    @Generated
    public void setPropertyId(int v) {
        this.setInt(propertyId, v, null);
    }

    @Generated
    public int getLength() {
        return this.getInt(length);
    }

    @Generated
    public void setLength(int v) {
        this.setInt(length, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)precision, 4);
        this.setFlags((Slot)minRolloverValue, 4);
        this.setFlags((Slot)maxRolloverValue, 4);
        this.rec = new BBacnetBitStringTrendRecord(this.getPropertyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atSteadyState() {
        block9: {
            if (this.isRunning()) {
                try {
                    BAbsTime timestamp = BAbsTime.now();
                    if (!this.getEnabled() || !this.getActivePeriod().isActive(timestamp)) break block9;
                    Object object = this.SEQUENCE_LOCK;
                    synchronized (object) {
                        this.trigger = true;
                        long sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount());
                        BTrendEvent event = BTrendEvent.LOG_STATUS_ENABLED;
                        BStatus status = BStatus.DEFAULT;
                        BacnetTrendLogUtil.writeEvent(this, timestamp, status, sequenceNumber, event);
                    }
                    BacnetTrendLogUtil.initHistoryExt((BHistoryExt)this);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error storing log status enabled event", e);
                }
                finally {
                    this.trigger = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            if (!this.isParentLegal(this.getParent().asComponent())) {
                logger.severe("Tried to enable BacnetTrendLogExt inside an illegal parent!?");
                this.setEnabled(false);
            } else {
                try {
                    this.trigger = true;
                    BAbsTime timestamp = BAbsTime.make();
                    Object object = this.SEQUENCE_LOCK;
                    synchronized (object) {
                        BacnetTrendLogUtil.writeEvent(this, timestamp, this.getStatus(), BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), this.getEnabled() ? BTrendEvent.LOG_STATUS_ENABLED : BTrendEvent.LOG_STATUS_DISABLED);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error storing event", e);
                }
                finally {
                    this.trigger = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStopLogging() {
        try {
            Object object = this.SEQUENCE_LOCK;
            synchronized (object) {
                this.trigger = true;
                BAbsTime timestamp = BAbsTime.make();
                BacnetTrendLogUtil.writeEvent(this, timestamp, BStatus.DEFAULT, BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_DISABLED);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error storing event", e);
        }
        finally {
            this.trigger = false;
            this.setEnabled(false);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return Boolean.TRUE;
    }

    @Override
    public BBacnetTrendRecord getRecord() {
        return this.rec;
    }

    @Override
    public boolean getTrigger() {
        return this.trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeRecord(BAbsTime timestamp, BStatusValue out) throws IOException {
        try {
            Object object = this.SEQUENCE_LOCK;
            synchronized (object) {
                this.trigger = true;
                BacnetTrendLogUtil.writeRecord(this, timestamp, out);
            }
        }
        finally {
            this.trigger = false;
        }
    }

    @Override
    public Type getRecordType() {
        return BBacnetBitStringTrendRecord.TYPE;
    }
}

