/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.datatypes;

import com.tridium.bacnet.datatypes.ListManipulation;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNcRecipientList
extends BBacnetListOf {
    @Generated
    public static final Type TYPE = Sys.loadType(BNcRecipientList.class);
    protected boolean addActions = false;
    private boolean config;
    private static final Logger logger = Logger.getLogger("bacnet");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNcRecipientList() {
    }

    public BNcRecipientList(Type listType) {
        super(listType);
    }

    @Override
    public final void started() {
        super.started();
        if (this.getParent() instanceof BBacnetObject) {
            this.config = true;
        }
    }

    @Override
    public Property addListElement(BValue listElement, Context cx) {
        BBacnetObject o;
        if (this.config && (o = (BBacnetObject)this.getParent()).getObjectId().getInstanceNumber() >= 0) {
            o.postAsync(new RecipientListManipulation(o, this.getPropertyInParent(), listElement, true));
            o.upload(new BUploadParameters());
            return null;
        }
        if (listElement.getType().is(this.getListType())) {
            if (!this.contains(listElement)) {
                return this.add(null, listElement, cx);
            }
            return null;
        }
        if (listElement instanceof BOrd) {
            return this.add(null, listElement, 2, cx);
        }
        log.severe(this + ".addListElement:Wrong element type: this is a list of " + this.getListType().getTypeName());
        return null;
    }

    @Override
    public void removeListElement(BValue listElement, Context cx) {
        if (this.config) {
            BBacnetObject o = (BBacnetObject)this.getParent();
            o.postAsync(new RecipientListManipulation(o, this.getPropertyInParent(), listElement, false));
            o.upload(new BUploadParameters());
            return;
        }
        SlotCursor c = this.getProperties();
        while (c.next()) {
            if (!c.get().equivalent((Object)listElement)) continue;
            this.remove(c.property(), cx);
            return;
        }
    }

    static class RecipientListManipulation
    extends ListManipulation {
        RecipientListManipulation(BBacnetObject o, Property p, BValue v, boolean add) {
            super(o, p, v, add);
        }

        @Override
        protected boolean checkEquals(BObject o, BValue v) {
            if (o.getType().is(BBacnetDestination.TYPE) && v.getType().is(BBacnetDestination.TYPE)) {
                return ((BBacnetDestination)o).destinationEquals((BBacnetDestination)v);
            }
            return false;
        }
    }
}

