/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NErrorType;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAny;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetTimeValue;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class AsnUtil
implements AsnConst {
    private static final int MAX_ASN_COUNT = 10;
    private static AsnOutputStream[] asnPool = new AsnOutputStream[10];
    private static int asnCnt = 0;
    static Lexicon lex = Lexicon.make((String)"bacnet");
    private static final Logger logger = Logger.getLogger("bacnet.asn");
    private static IntHashMap asnNamesByType = new IntHashMap();
    private static HashMap<String, Integer> asnTypesByName;
    private static IntHashMap sizesBySpec;

    public static String getAsnTypeName(int asnType) {
        String name = (String)asnNamesByType.get(asnType);
        if (name == null) {
            return "???";
        }
        return name;
    }

    public static String getAsnTypeName(BInteger asnType) {
        if (asnType == null) {
            return "";
        }
        return AsnUtil.getAsnTypeName(asnType.getInt());
    }

    public static int getAsnType(String asnTypeName) {
        Integer type = asnTypesByName.get(asnTypeName);
        if (type == null) {
            return -1;
        }
        return type;
    }

    public static BBacnetNull fromAsnNull(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BBacnetNull bBacnetNull = asnIn.readNull();
            return bBacnetNull;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnNull() {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeNull();
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnNull(BBacnetNull n) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeNull();
        return AsnUtil.releaseAsn(asnOut);
    }

    public static boolean fromAsnBoolean(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            int tag = asnIn.peekTag();
            if (tag == 1) {
                boolean bl = asnIn.readBoolean();
                return bl;
            }
            if (tag == 9) {
                boolean bl = asnIn.readEnumerated() != 0;
                return bl;
            }
            throw new AsnException("Invalid tag: " + tag);
        }
        finally {
            asnIn.release();
        }
    }

    public static boolean fromOnlyAsnBoolean(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            int tag = asnIn.peekTag();
            if (tag == 1) {
                boolean bl = asnIn.readBoolean();
                return bl;
            }
            throw new AsnException("Invalid tag: " + tag);
        }
        finally {
            asnIn.release();
        }
    }

    public static boolean fromOnlyBinaryPv(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            boolean bl = AsnUtil.fromOnlyBinaryPv(asnIn);
            return bl;
        }
        finally {
            asnIn.release();
        }
    }

    public static boolean fromOnlyBinaryPv(AsnInput asnIn) throws AsnException {
        int tag = asnIn.peekTag();
        if (tag == 9) {
            int val = asnIn.readEnumerated();
            if (val == 0) {
                return false;
            }
            if (val == 1) {
                return true;
            }
            throw new OutOfRangeException("Invalid boolean value");
        }
        throw new AsnException("Invalid tag: " + tag);
    }

    public static byte[] toAsnBoolean(boolean b) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeBoolean(b);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnBoolean(BBoolean b) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeBoolean(b.getBoolean());
        return AsnUtil.releaseAsn(asnOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fromAsnUnsignedInteger(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            long l = asnIn.readUnsignedInteger();
            return l;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnUnsigned(long i) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeUnsignedInteger(i);
        return AsnUtil.releaseAsn(asnOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fromAsnUnsignedInt(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            long ret = asnIn.readUnsignedInteger();
            if (ret > Integer.MAX_VALUE) {
                throw new OutOfRangeException("Unsigned int is too big:" + ret);
            }
            int n = (int)ret;
            return n;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnUnsigned(BBacnetUnsigned u) {
        return AsnUtil.toAsnUnsigned(u.getUnsigned());
    }

    public static byte[] toAsnUnsigned(BEnum e) {
        return AsnUtil.toAsnUnsigned(e.getOrdinal());
    }

    public static BBacnetUnsigned fromAsnUnsigned(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BBacnetUnsigned bBacnetUnsigned = BBacnetUnsigned.make(asnIn.readUnsignedInteger());
            return bBacnetUnsigned;
        }
        finally {
            asnIn.release();
        }
    }

    public static int fromAsnSignedInteger(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            int n = asnIn.readSignedInteger();
            return n;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnInteger(int i) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeSignedInteger(i);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnInteger(BInteger i) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeSignedInteger(i.getInt());
        return AsnUtil.releaseAsn(asnOut);
    }

    public static int fromAsnInteger(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            int n = asnIn.readInteger();
            return n;
        }
        finally {
            asnIn.release();
        }
    }

    public static float fromAsnReal(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            float f = asnIn.readReal();
            return f;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnReal(double f) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeReal(f);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnReal(BFloat f) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeReal(f.getFloat());
        return AsnUtil.releaseAsn(asnOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double fromAsnDouble(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            double d = asnIn.readDouble();
            return d;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnDouble(double d) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeDouble(d);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnDouble(BDouble d) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeDouble(d.getDouble());
        return AsnUtil.releaseAsn(asnOut);
    }

    public static BBacnetOctetString fromAsnOctetString(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BBacnetOctetString bBacnetOctetString = BBacnetOctetString.make(asnIn.readOctetString());
            return bBacnetOctetString;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnOctetString(byte[] b) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeOctetString(b);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnOctetString(BBacnetOctetString b) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeOctetString(b);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static String fromAsnCharacterString(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            String string = asnIn.readCharacterString();
            return string;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnCharacterString(String s) {
        return AsnUtil.toAsnCharacterString(s, BBacnetNetwork.localDevice().getCharacterSet());
    }

    public static byte[] toAsnCharacterString(String s, BCharacterSetEncoding encoding) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeCharacterString(s, encoding);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnCharacterString(BString s) {
        return AsnUtil.toAsnCharacterString(s.getString(), BBacnetNetwork.localDevice().getCharacterSet());
    }

    public static BCharacterSetEncoding getCharacterSetEncoding(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BCharacterSetEncoding bCharacterSetEncoding = asnIn.peekEncoding();
            return bCharacterSetEncoding;
        }
        finally {
            asnIn.release();
        }
    }

    public static BBacnetBitString fromAsnBitString(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BBacnetBitString bBacnetBitString = asnIn.readBitString();
            return bBacnetBitString;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnBitString(boolean[] bits) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeBitString(bits);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnBitString(BBacnetBitString bs) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeBitString(bs.getBits());
        return AsnUtil.releaseAsn(asnOut);
    }

    public static int fromAsnEnumerated(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            int n = asnIn.readEnumerated();
            return n;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnEnumerated(int value) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeEnumerated(value);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toAsnEnumerated(boolean value) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeEnumerated(value ? 1 : 0);
        return AsnUtil.releaseAsn(asnOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BEnum fromAsnEnumerated(BEnum discrete, byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BEnum bEnum = discrete.getRange().get(asnIn.readEnumerated());
            return bEnum;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnEnumerated(BEnum discrete) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeEnumerated(discrete.getOrdinal());
        return AsnUtil.releaseAsn(asnOut);
    }

    public static BBacnetDate fromAsnDate(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BBacnetDate bBacnetDate = asnIn.readDate();
            return bBacnetDate;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnDate(BBacnetDate date) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeDate(date);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static BBacnetTime fromAsnTime(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BBacnetTime bBacnetTime = asnIn.readTime();
            return bBacnetTime;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnTime(BBacnetTime time) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeTime(time);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static BBacnetObjectIdentifier fromAsnObjectId(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BBacnetObjectIdentifier bBacnetObjectIdentifier = asnIn.readObjectIdentifier();
            return bBacnetObjectIdentifier;
        }
        finally {
            asnIn.release();
        }
    }

    public static byte[] toAsnObjectId(BBacnetObjectIdentifier objectId) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeObjectIdentifier(objectId);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static BValue fromAsn(int asnType, byte[] encodedValue) throws AsnException {
        return AsnUtil.fromAsn(asnType, encodedValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue fromAsn(byte[] encodedValue, BValue obj) throws AsnException {
        if (obj != null) {
            Type t = obj.getType();
            if (t == BBacnetNull.TYPE) {
                return AsnUtil.fromAsnNull(encodedValue);
            }
            if (t == BBoolean.TYPE) {
                return BBoolean.make((boolean)AsnUtil.fromAsnBoolean(encodedValue));
            }
            if (t == BBacnetUnsigned.TYPE) {
                return AsnUtil.fromAsnUnsigned(encodedValue);
            }
            if (t == BInteger.TYPE) {
                return BInteger.make((int)AsnUtil.fromAsnInteger(encodedValue));
            }
            if (t == BFloat.TYPE) {
                return BFloat.make((float)AsnUtil.fromAsnReal(encodedValue));
            }
            if (t == BDouble.TYPE) {
                return BDouble.make((double)AsnUtil.fromAsnDouble(encodedValue));
            }
            if (t == BBacnetOctetString.TYPE) {
                return AsnUtil.fromAsnOctetString(encodedValue);
            }
            if (t == BString.TYPE) {
                return BString.make((String)AsnUtil.fromAsnCharacterString(encodedValue));
            }
            if (t == BBacnetBitString.TYPE) {
                return AsnUtil.fromAsnBitString(encodedValue);
            }
            if (t.is(BEnum.TYPE)) {
                return ((BEnum)obj).getRange().get(AsnUtil.fromAsnEnumerated(encodedValue));
            }
            if (t == BBacnetDate.TYPE) {
                return AsnUtil.fromAsnDate(encodedValue);
            }
            if (t == BBacnetTime.TYPE) {
                return AsnUtil.fromAsnTime(encodedValue);
            }
            if (t == BBacnetObjectIdentifier.TYPE) {
                return AsnUtil.fromAsnObjectId(encodedValue);
            }
            if (t.is(BIBacnetDataType.TYPE)) {
                AsnInputStream asnIn = AsnInputStream.make(encodedValue);
                try {
                    ((BIBacnetDataType)obj).readAsn(asnIn);
                    BValue bValue = obj;
                    return bValue;
                }
                finally {
                    asnIn.release();
                }
            }
        }
        return AsnUtil.asnToValue(encodedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue fromAsn(int asnType, byte[] encodedValue, BValue obj) throws AsnException {
        switch (asnType) {
            case 0: {
                return BBacnetNull.DEFAULT;
            }
            case 1: {
                return BBoolean.make((boolean)AsnUtil.fromAsnBoolean(encodedValue));
            }
            case 2: {
                if (obj == null || obj.getType() != BDynamicEnum.TYPE) {
                    return AsnUtil.fromAsnUnsigned(encodedValue);
                }
                return ((BDynamicEnum)obj).getRange().get(AsnUtil.fromAsnUnsignedInt(encodedValue));
            }
            case 3: {
                return BInteger.make((int)AsnUtil.fromAsnInteger(encodedValue));
            }
            case 4: {
                return BFloat.make((float)AsnUtil.fromAsnReal(encodedValue));
            }
            case 5: {
                return BDouble.make((double)AsnUtil.fromAsnDouble(encodedValue));
            }
            case 6: {
                return AsnUtil.fromAsnOctetString(encodedValue);
            }
            case 7: {
                return BString.make((String)AsnUtil.fromAsnCharacterString(encodedValue));
            }
            case 8: {
                return AsnUtil.fromAsnBitString(encodedValue);
            }
            case 9: {
                if (obj == null) {
                    return BInteger.make((int)AsnUtil.fromAsnEnumerated(encodedValue));
                }
                return ((BEnum)obj).getRange().get(AsnUtil.fromAsnEnumerated(encodedValue));
            }
            case 10: {
                return AsnUtil.fromAsnDate(encodedValue);
            }
            case 11: {
                return AsnUtil.fromAsnTime(encodedValue);
            }
            case 12: {
                return AsnUtil.fromAsnObjectId(encodedValue);
            }
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                AsnInputStream asnIn = AsnInputStream.make(encodedValue);
                try {
                    ((BIBacnetDataType)obj).readAsn(asnIn);
                    BValue bValue = obj;
                    return bValue;
                }
                finally {
                    asnIn.release();
                }
            }
            case -6: {
                return AsnUtil.asnToValue(encodedValue);
            }
        }
        throw new AsnException("Invalid tag: " + asnType);
    }

    public static BValue[] fromAsn(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BValue[] bValueArray = AsnUtil.fromAsn(asnIn, -1);
            return bValueArray;
        }
        finally {
            asnIn.release();
        }
    }

    public static BValue asnToValue(PropertyInfo info, byte[] encodedValue) throws AsnException {
        return AsnUtil.asnToValue(info, encodedValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BValue asnToValue(PropertyInfo info, byte[] encodedValue, BValue val) throws AsnException {
        try {
            if (info == null) {
                return AsnUtil.asnToValue(encodedValue);
            }
            switch (info.getAsnType()) {
                case 0: {
                    return BBacnetNull.DEFAULT;
                }
                case 1: {
                    return BBoolean.make((boolean)AsnUtil.fromAsnBoolean(encodedValue));
                }
                case 2: {
                    return AsnUtil.fromAsnUnsigned(encodedValue);
                }
                case 3: {
                    return BInteger.make((int)AsnUtil.fromAsnInteger(encodedValue));
                }
                case 4: {
                    return BFloat.make((float)AsnUtil.fromAsnReal(encodedValue));
                }
                case 5: {
                    return BDouble.make((double)AsnUtil.fromAsnDouble(encodedValue));
                }
                case 6: {
                    return AsnUtil.fromAsnOctetString(encodedValue);
                }
                case 7: {
                    return BString.make((String)AsnUtil.fromAsnCharacterString(encodedValue));
                }
                case 8: {
                    return AsnUtil.fromAsnBitString(encodedValue);
                }
                case 9: {
                    BTypeSpec tspec = BTypeSpec.make((String)info.getType());
                    BEnum e = (BEnum)tspec.getInstance();
                    if (!info.isExtensible()) return e.getRange().get(AsnUtil.fromAsnEnumerated(encodedValue));
                    return BDynamicEnum.make((int)AsnUtil.fromAsnEnumerated(encodedValue), (BEnumRange)BEnumRange.make((Type)e.getType()));
                }
                case 10: {
                    return AsnUtil.fromAsnDate(encodedValue);
                }
                case 11: {
                    return AsnUtil.fromAsnTime(encodedValue);
                }
                case 12: {
                    return AsnUtil.fromAsnObjectId(encodedValue);
                }
                case -5: 
                case -1: {
                    BTypeSpec tspec = BTypeSpec.make((String)info.getType());
                    BValue o = (BValue)tspec.getInstance();
                    AsnInputStream asnIn = AsnInputStream.make(encodedValue);
                    try {
                        ((BIBacnetDataType)o).readAsn(asnIn);
                        BValue bValue = o;
                        return bValue;
                    }
                    finally {
                        asnIn.release();
                    }
                }
                case -2: {
                    BTypeSpec tspec = BTypeSpec.make((String)info.getType());
                    Type t = tspec.getResolvedType();
                    BBacnetArray array = info.getSize() >= 0 ? new BBacnetArray(t, info.getSize()) : new BBacnetArray(t);
                    AsnInputStream asnIn = AsnInputStream.make(encodedValue);
                    try {
                        array.readAsn(asnIn);
                        BBacnetArray bBacnetArray = array;
                        return bBacnetArray;
                    }
                    finally {
                        asnIn.release();
                    }
                }
                case -3: {
                    BTypeSpec tspec = BTypeSpec.make((String)info.getType());
                    Type t = tspec.getResolvedType();
                    BBacnetListOf list = new BBacnetListOf(t);
                    AsnInputStream asnIn = AsnInputStream.make(encodedValue);
                    try {
                        list.readAsn(asnIn);
                        BBacnetListOf bBacnetListOf = list;
                        return bBacnetListOf;
                    }
                    finally {
                        asnIn.release();
                    }
                }
                case -4: {
                    return BBacnetAny.make(encodedValue);
                }
                case -6: {
                    return AsnUtil.asnToValue(encodedValue);
                }
            }
            throw new AsnException("Invalid tag: " + info.getAsnType());
        }
        catch (Exception e) {
            if (!logger.isLoggable(Level.FINE)) throw new AsnException("Asn conversion failed");
            logger.log(Level.FINE, "Unable to decode Asn value:" + ByteArrayUtil.toHexString((byte[])encodedValue), e);
            throw new AsnException("Asn conversion failed");
        }
    }

    public static BValue asnToValue(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BValue bValue = AsnUtil.asnToValue(asnIn, -1);
            return bValue;
        }
        finally {
            asnIn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue asnToValue(AsnInput in, int closingTag) throws AsnException {
        AsnInput asnInput = in;
        synchronized (asnInput) {
            BValue[] vals = AsnUtil.fromAsn(in, closingTag);
            if (vals.length == 1) {
                return vals[0];
            }
            BComponent c = new BComponent();
            for (int i = 0; i < vals.length; ++i) {
                c.add(null, vals[i]);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue[] fromAsn(AsnInput in, int closingTag) throws AsnException {
        Array a = new Array(BValue.class);
        AsnInput asnInput = in;
        synchronized (asnInput) {
            int tag = in.peekTag();
            BSimple o = null;
            while (tag != -1 && !in.isClosingTag(closingTag)) {
                o = null;
                if (in.isApplicationTag(tag)) {
                    switch (tag) {
                        case 0: {
                            o = in.readNull();
                            break;
                        }
                        case 1: {
                            o = BBoolean.make((boolean)in.readBoolean());
                            break;
                        }
                        case 2: {
                            o = in.readUnsigned();
                            break;
                        }
                        case 3: {
                            o = in.readSigned();
                            break;
                        }
                        case 4: {
                            o = in.readFloat();
                            break;
                        }
                        case 5: {
                            o = BDouble.make((double)in.readDouble());
                            break;
                        }
                        case 6: {
                            o = in.readBacnetOctetString();
                            break;
                        }
                        case 7: {
                            o = BString.make((String)in.readCharacterString());
                            break;
                        }
                        case 8: {
                            o = in.readBitString();
                            break;
                        }
                        case 9: {
                            o = BDynamicEnum.make((int)in.readEnumerated());
                            break;
                        }
                        case 10: {
                            o = in.readDate();
                            break;
                        }
                        case 11: {
                            o = in.readTime();
                            break;
                        }
                        case 12: {
                            o = in.readObjectIdentifier();
                        }
                    }
                    tag = in.peekTag();
                } else if (in.isOpeningTag(tag)) {
                    in.skipTag();
                    o = AsnUtil.asnToValue(in, tag);
                    tag = in.peekTag();
                } else if (in.isValueTag(tag)) {
                    byte[] b = in.readContextTaggedData();
                    o = BString.make((String)("context-tagged data [" + tag + "]:" + ByteArrayUtil.toHexString((byte[])b)));
                    tag = in.peekTag();
                } else if (in.isClosingTag(tag)) {
                    in.skipTag();
                    tag = in.peekTag();
                }
                if (o == null) continue;
                if (a.size() == 0 && tag == -1) {
                    return new BValue[]{o};
                }
                a.add((Object)o);
            }
            return (BValue[])a.trim();
        }
    }

    public static byte[] toAsn(BValue o) {
        Type t = o.getType();
        if (t == BBacnetNull.TYPE) {
            return AsnUtil.toAsnNull();
        }
        if (t == BBoolean.TYPE) {
            return AsnUtil.toAsnBoolean((BBoolean)o);
        }
        if (t == BBacnetUnsigned.TYPE) {
            return AsnUtil.toAsnUnsigned((BBacnetUnsigned)o);
        }
        if (t == BInteger.TYPE) {
            return AsnUtil.toAsnInteger((BInteger)o);
        }
        if (t == BFloat.TYPE) {
            return AsnUtil.toAsnReal((BFloat)o);
        }
        if (t == BDouble.TYPE) {
            return AsnUtil.toAsnDouble((BDouble)o);
        }
        if (t == BBacnetOctetString.TYPE) {
            return AsnUtil.toAsnOctetString((BBacnetOctetString)o);
        }
        if (t == BString.TYPE) {
            return AsnUtil.toAsnCharacterString((BString)o);
        }
        if (t == BBacnetBitString.TYPE) {
            return AsnUtil.toAsnBitString((BBacnetBitString)o);
        }
        if (o instanceof BEnum) {
            return AsnUtil.toAsnEnumerated((BEnum)o);
        }
        if (t == BBacnetDate.TYPE) {
            return AsnUtil.toAsnDate((BBacnetDate)o);
        }
        if (t == BBacnetTime.TYPE) {
            return AsnUtil.toAsnTime((BBacnetTime)o);
        }
        if (t == BBacnetObjectIdentifier.TYPE) {
            return AsnUtil.toAsnObjectId((BBacnetObjectIdentifier)o);
        }
        if (t.is(BIBacnetDataType.TYPE)) {
            AsnOutputStream asnOut = AsnUtil.getAsnOut();
            asnOut.reset();
            ((BIBacnetDataType)o).writeAsn(asnOut);
            return AsnUtil.releaseAsn(asnOut);
        }
        return AsnUtil.toAsnCharacterString(o.toString());
    }

    public static byte[] toAsn(int asnType, BValue o) {
        switch (asnType) {
            case 0: {
                return AsnUtil.toAsnNull((BBacnetNull)o);
            }
            case 1: {
                return AsnUtil.toAsnBoolean((BBoolean)o);
            }
            case 2: {
                return AsnUtil.toAsnUnsigned((BBacnetUnsigned)o);
            }
            case 3: {
                return AsnUtil.toAsnInteger(((BNumber)o).getInt());
            }
            case 4: {
                return AsnUtil.toAsnReal(((BNumber)o).getFloat());
            }
            case 5: {
                return AsnUtil.toAsnDouble(((BNumber)o).getDouble());
            }
            case 6: {
                return AsnUtil.toAsnOctetString((BBacnetOctetString)o);
            }
            case 7: {
                return AsnUtil.toAsnCharacterString((BString)o);
            }
            case 8: {
                return AsnUtil.toAsnBitString((BBacnetBitString)o);
            }
            case 9: {
                return AsnUtil.toAsnEnumerated((BEnum)o);
            }
            case 10: {
                return AsnUtil.toAsnDate((BBacnetDate)o);
            }
            case 11: {
                return AsnUtil.toAsnTime((BBacnetTime)o);
            }
            case 12: {
                return AsnUtil.toAsnObjectId((BBacnetObjectIdentifier)o);
            }
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                AsnOutputStream asnOut = AsnUtil.getAsnOut();
                asnOut.reset();
                ((BIBacnetDataType)o).writeAsn(asnOut);
                return AsnUtil.releaseAsn(asnOut);
            }
        }
        throw new IllegalArgumentException("Invalid tag: " + asnType);
    }

    public static int getAsnType(Type t) {
        if (t == BBacnetNull.TYPE) {
            return 0;
        }
        if (t == BBoolean.TYPE) {
            return 1;
        }
        if (t == BBacnetUnsigned.TYPE) {
            return 2;
        }
        if (t == BInteger.TYPE) {
            return 3;
        }
        if (t == BFloat.TYPE) {
            return 4;
        }
        if (t == BDouble.TYPE) {
            return 5;
        }
        if (t == BBacnetOctetString.TYPE) {
            return 6;
        }
        if (t == BString.TYPE) {
            return 7;
        }
        if (t == BBacnetBitString.TYPE) {
            return 8;
        }
        if (t.is(BEnum.TYPE)) {
            return 9;
        }
        if (t == BBacnetDate.TYPE) {
            return 10;
        }
        if (t == BBacnetTime.TYPE) {
            return 11;
        }
        if (t == BBacnetObjectIdentifier.TYPE) {
            return 12;
        }
        return -6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAsnType(byte[] encodedValue) throws AsnException {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            asnIn.setBuffer(encodedValue);
            int tag = asnIn.skipTag();
            if (asnIn.peekApplicationTag() == -1) {
                int n = tag;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            asnIn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BStatus asnStatusFlagsToBStatus(byte[] encodedValue) {
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BStatus bStatus = asnIn.readStatusFlags();
            return bStatus;
        }
        catch (AsnException e) {
            BStatus bStatus = null;
            return bStatus;
        }
        finally {
            asnIn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BStatus addPriority(BStatus status, byte[] encodedPriority) {
        BStatus s = status;
        if (encodedPriority != null) {
            s = BStatus.make((BStatus)s, (String)"bac", (BIDataValue)BString.make((String)"def"));
            AsnInputStream asnIn = AsnInputStream.make(encodedPriority);
            try {
                int tag = 0;
                int activeLevel = 0;
                for (activeLevel = 1; activeLevel <= 16; ++activeLevel) {
                    tag = asnIn.skipTag();
                    if (tag == 0) continue;
                    s = BStatus.make((BStatus)s, (String)"bac", (BIDataValue)BInteger.make((int)activeLevel));
                    break;
                }
            }
            catch (AsnException e) {
                BStatus bStatus = status;
                return bStatus;
            }
            finally {
                asnIn.release();
            }
        }
        return s;
    }

    public static byte[] statusToAsnStatusFlags(BStatus s) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeStatusFlags(s);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static byte[] toBacnetDateTime(BAbsTime t) {
        AsnOutputStream asnOut = AsnUtil.getAsnOut();
        asnOut.reset();
        asnOut.writeDate(t);
        asnOut.writeTime(t);
        return AsnUtil.releaseAsn(asnOut);
    }

    public static int getSize(BTypeSpec typeSpec) {
        BInteger i = (BInteger)sizesBySpec.get(typeSpec.hashCode());
        if (i == null) {
            return 10;
        }
        return i.getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsnOutputStream getAsnOut() {
        AsnOutputStream[] asnOutputStreamArray = asnPool;
        synchronized (asnPool) {
            if (asnCnt > 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return asnPool[--asnCnt];
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new AsnOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] releaseAsn(AsnOutputStream aos) {
        byte[] ba = aos.toByteArray();
        AsnOutputStream[] asnOutputStreamArray = asnPool;
        synchronized (asnPool) {
            if (asnCnt < asnPool.length) {
                AsnUtil.asnPool[AsnUtil.asnCnt++] = aos;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ba;
        }
    }

    public static final NErrorType peekTagAndPerform(AsnInput asnIn, int matchTag, int errorCode, Runnable perform) throws AsnException {
        int tag = asnIn.peekTag();
        if (matchTag != tag) {
            return new NErrorType(2, errorCode);
        }
        perform.run();
        return null;
    }

    static {
        asnNamesByType.put(0, (Object)lex.getText("asn.null"));
        asnNamesByType.put(1, (Object)lex.getText("asn.boolean"));
        asnNamesByType.put(2, (Object)lex.getText("asn.unsigned"));
        asnNamesByType.put(3, (Object)lex.getText("asn.integer"));
        asnNamesByType.put(4, (Object)lex.getText("asn.real"));
        asnNamesByType.put(5, (Object)lex.getText("asn.double"));
        asnNamesByType.put(6, (Object)lex.getText("asn.octetString"));
        asnNamesByType.put(7, (Object)lex.getText("asn.characterString"));
        asnNamesByType.put(8, (Object)lex.getText("asn.bitString"));
        asnNamesByType.put(9, (Object)lex.getText("asn.enumerated"));
        asnNamesByType.put(10, (Object)lex.getText("asn.date"));
        asnNamesByType.put(11, (Object)lex.getText("asn.time"));
        asnNamesByType.put(12, (Object)lex.getText("asn.objectId"));
        asnNamesByType.put(13, (Object)lex.getText("asn.reserved13"));
        asnNamesByType.put(14, (Object)lex.getText("asn.reserved14"));
        asnNamesByType.put(15, (Object)lex.getText("asn.reserved15"));
        asnNamesByType.put(-1, (Object)lex.getText("asn.constructed"));
        asnNamesByType.put(-2, (Object)lex.getText("asn.array"));
        asnNamesByType.put(-3, (Object)lex.getText("asn.list"));
        asnNamesByType.put(-4, (Object)lex.getText("asn.any"));
        asnNamesByType.put(-5, (Object)lex.getText("asn.choice"));
        asnNamesByType.put(-6, (Object)lex.getText("asn.unknown"));
        asnTypesByName = new HashMap();
        asnTypesByName.put(lex.getText("asn.null"), 0);
        asnTypesByName.put(lex.getText("asn.boolean"), 1);
        asnTypesByName.put(lex.getText("asn.unsigned"), 2);
        asnTypesByName.put(lex.getText("asn.integer"), 3);
        asnTypesByName.put(lex.getText("asn.real"), 4);
        asnTypesByName.put(lex.getText("asn.double"), 5);
        asnTypesByName.put(lex.getText("asn.octetString"), 6);
        asnTypesByName.put(lex.getText("asn.characterString"), 7);
        asnTypesByName.put(lex.getText("asn.bitString"), 8);
        asnTypesByName.put(lex.getText("asn.enumerated"), 9);
        asnTypesByName.put(lex.getText("asn.date"), 10);
        asnTypesByName.put(lex.getText("asn.time"), 11);
        asnTypesByName.put(lex.getText("asn.objectId"), 12);
        asnTypesByName.put(lex.getText("asn.reserved13"), 13);
        asnTypesByName.put(lex.getText("asn.reserved14"), 14);
        asnTypesByName.put(lex.getText("asn.reserved15"), 15);
        asnTypesByName.put(lex.getText("asn.constructed"), -1);
        asnTypesByName.put(lex.getText("asn.array"), -2);
        asnTypesByName.put(lex.getText("asn.list"), -3);
        asnTypesByName.put(lex.getText("asn.any"), -4);
        asnTypesByName.put(lex.getText("asn.choice"), -5);
        asnTypesByName.put(lex.getText("asn.unknown"), -6);
        sizesBySpec = new IntHashMap();
        sizesBySpec.put(BBacnetNull.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)1));
        sizesBySpec.put(BBoolean.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)1));
        sizesBySpec.put(BBacnetUnsigned.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BInteger.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BFloat.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BDouble.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)9));
        sizesBySpec.put(BBacnetOctetString.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)27));
        sizesBySpec.put(BString.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)28));
        sizesBySpec.put(BBacnetBitString.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)8));
        sizesBySpec.put(BEnum.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)3));
        sizesBySpec.put(BBacnetDate.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BBacnetTime.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BBacnetObjectIdentifier.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BBacnetDateTime.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)10));
        sizesBySpec.put(BBacnetTimeStamp.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)12));
        sizesBySpec.put(BBacnetTimeValue.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)10));
    }
}

