/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.ui;

import com.tridium.nrio.components.BNrioIOPointEntry;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridium.nrio.points.BNrioProxyExt;
import com.tridiumx.accessDriver.components.BBaseReaderModulePoints;
import com.tridiumx.accessDriver.components.BRemoteReaderModulePoints;
import com.tridiumx.accessDriver.enums.BAccessIoTypeEnum;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"accessDriver:Access2ReaderPoints"}, requiredPermissions="r")})
public class BR2RPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BR2RPointManager.class);
    static final Lexicon lex = Lexicon.make(MgrController.class);
    static Lexicon abstractLex = Lexicon.make(BPointManager.class);
    static Lexicon ndioLex = Lexicon.make((String)"ndio");
    static BImage booleanIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(1);
    MgrColumn colInstance = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNrioProxyExt.instance}, 1);
    MgrColumn colIsSdi = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAccessProxyExt.isSdi}, 7);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colString = new MgrColumn.ToString("Value", 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colInstance, this.colIsSdi, this.colConversion, this.colString, this.colFacets};
    static final Logger log = Logger.getLogger("access");
    private static final AccessMgrTypeInfo[] diType = new AccessMgrTypeInfo[]{new AccessMgrTypeInfo(Sys.getRegistry().getType("control:BooleanPoint"), false)};
    private static final AccessMgrTypeInfo[] sdiType = new AccessMgrTypeInfo[]{new AccessMgrTypeInfo(Sys.getRegistry().getType("control:BooleanPoint"), true)};
    private static final AccessMgrTypeInfo[] roType = new AccessMgrTypeInfo[]{new AccessMgrTypeInfo(Sys.getRegistry().getType("control:BooleanWritable"), false)};
    private boolean isRemoteModule;
    private BNrioPointDeviceExt deviceExt;
    private BNrioIOPointEntry[] lastLearn;

    public Type getType() {
        return TYPE;
    }

    protected void init() {
        super.init();
        try {
            this.deviceExt = (BNrioPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
            this.isRemoteModule = this.deviceExt.getNrioDevice().getIsRemote();
            if (this.getCurrentValue() != this.deviceExt) {
                this.registerForComponentEvents((BComponent)this.deviceExt);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = (BNrioIOPointEntry[])event.getChildren(BNrioIOPointEntry.class);
        this.lastLearn = rows;
        for (int i = 0; i < rows.length; ++i) {
            rows[i].loadSlots();
        }
        this.getLearn().updateRoots(rows);
    }

    static /* synthetic */ BNrioIOPointEntry[] access$502(BR2RPointManager x0, BNrioIOPointEntry[] x1) {
        x0.lastLearn = x1;
        return x1;
    }

    static class State
    extends MgrState {
        BNrioIOPointEntry[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BR2RPointManager manager = (BR2RPointManager)m;
            this.lastLearn = manager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BR2RPointManager manager = (BR2RPointManager)m;
            if (this.lastLearn != null) {
                BR2RPointManager.access$502(manager, this.lastLearn);
                manager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    static class AccessMgrTypeInfo
    extends MgrTypeInfo {
        private final TypeInfo pntType;
        private final boolean isSdi;

        AccessMgrTypeInfo(TypeInfo pntType, boolean isSdi) {
            this.pntType = pntType;
            this.isSdi = isSdi;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public boolean isSdi() {
            return this.isSdi;
        }

        public BImage getIcon() {
            return null;
        }

        public String getDisplayName() {
            return this.pntType.getDisplayName(null);
        }

        public BComponent newInstance() {
            BControlPoint pnt = (BControlPoint)this.pntType.getInstance();
            BAccessProxyExt ext = new BAccessProxyExt();
            pnt.setProxyExt((BAbstractProxyExt)ext);
            if (!(pnt instanceof BEnumPoint) && pnt instanceof BBooleanPoint) {
                ext.setIsSdi(this.isSdi);
                pnt.setProxyExt((BAbstractProxyExt)ext);
                pnt.setFacets(BFacets.makeBoolean((String)"Active", (String)"Inactive"));
            }
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return ((BAccessProxyExt)((BControlPoint)db).getProxyExt()).getInstance() == 0;
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BR2RPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        public String makeTableTitle() {
            return "Hardware Points";
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BNrioIOPointEntry.ioType, 0), new MgrColumn.Prop(BNrioIOPointEntry.instance, 0), new MgrColumn.Prop(BNrioIOPointEntry.usedByPoint, 0)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
            BNrioIOPointEntry disc = (BNrioIOPointEntry)discovery;
            if (disc.getIoType().equals((Object)BAccessIoTypeEnum.digitalInput)) {
                return diType;
            }
            if (disc.getIoType().equals((Object)BAccessIoTypeEnum.supervisedDigitalInput)) {
                return sdiType;
            }
            return roType;
        }

        public boolean isMatchable(Object dis, BComponent db) {
            try {
                BNrioIOPointEntry entry = (BNrioIOPointEntry)dis;
                return entry.isMatchable(db);
            }
            catch (Throwable e) {
                return false;
            }
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BR2RPointManager.this.updateDiscoveryRows((BComponent)job);
        }

        public BImage getIcon(Object dis) {
            return booleanIcon;
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            BNrioIOPointEntry entry = (BNrioIOPointEntry)discovery;
            row.setDefaultName(entry.getName());
            row.setCell(BR2RPointManager.this.colInstance, (BValue)BInteger.make((int)entry.getInstance()));
            row.setCell(BR2RPointManager.this.colIsSdi, (BValue)BBoolean.make((boolean)entry.getIoType().equals((Object)BAccessIoTypeEnum.supervisedDigitalInput)));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            try {
                BNrioIOPointEntry entry = (BNrioIOPointEntry)discovery;
                if (entry.matches(component)) {
                    entry.setUsedByPoint(component.getParent().getDisplayName(null) + "." + component.getDisplayName(null));
                }
                return entry.matches(component);
            }
            catch (Throwable e) {
                return false;
            }
        }
    }

    public class Model
    extends PointModel {
        Model(BR2RPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BR2RPointManager.this.cols;
        }
    }

    public class Controller
    extends PointController {
        Controller(BR2RPointManager manager) {
            super((BPointManager)manager);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            return new MgrController.IMgrCommand[]{this.allDescendants, this.edit, this.learnMode, this.discover, this.add, this.match};
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            return null;
        }

        public void updateCommands() {
            super.updateCommands();
            try {
                Object[] selectedRows = this.getLearnTable().getSelectedObjects();
                boolean enableAdd = selectedRows.length > 0;
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (BR2RPointManager.this.getLearn().getExisting(selectedRows[i]) == null) continue;
                    enableAdd = false;
                    break;
                }
                this.add.setEnabled(enableAdd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            if (BR2RPointManager.this.isRemoteModule) {
                BR2RPointManager.this.updateDiscoveryRows(new BRemoteReaderModulePoints());
            } else {
                BR2RPointManager.this.updateDiscoveryRows(new BBaseReaderModulePoints());
            }
            return null;
        }

        public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
            if (this.add.isEnabled()) {
                this.add.invoke();
            }
        }
    }
}

