/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.points;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridium.nrio.points.BNrioProxyExt;
import com.tridiumx.accessDriver.BAccess2ReaderModule;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessSdi;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BIAccessDevice;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="conversion", type="BProxyConversion", defaultValue="BDefaultProxyConversion.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"nrio:NrioProxyConversionFE\"")}, override=true), @NiagaraProperty(name="isStrike", type="boolean", defaultValue="false", flags=5, override=true), @NiagaraProperty(name="isSdi", type="boolean", defaultValue="false", flags=5, override=true)})
public class BAccessProxyExt
extends BNrioProxyExt {
    public static final Property conversion = BAccessProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"nrio:NrioProxyConversionFE"));
    public static final Property isStrike = BAccessProxyExt.newProperty((int)5, (boolean)false, null);
    public static final Property isSdi = BAccessProxyExt.newProperty((int)5, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BAccessProxyExt.class);
    public static final byte[] ACTIVE_DATA = new byte[]{1};
    public static final byte[] INACTIVE_DATA = new byte[]{0};
    private int undoInstance = -1;

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BAccessNetwork network = (BAccessNetwork)this.getNetwork();
            this.undoInstance = this.getInstance();
            if (this.getEnabled()) {
                network.getPollScheduler().subscribe((BIPollable)this);
            }
        }
        this.setFlags((Slot)conversion, this.getFlags((Slot)conversion) | Integer.MIN_VALUE);
        this.getParent().setFlags((Slot)this.getPropertyInParent(), this.getParent().getFlags((Slot)this.getPropertyInParent()) | Integer.MIN_VALUE);
        if (this.getParent().getParent() instanceof BDeviceExt) {
            this.setFlags((Slot)instance, this.getFlags((Slot)instance) | 1);
        }
    }

    public void stopped() throws Exception {
        if (this.isRunning()) {
            BAccessNetwork network = (BAccessNetwork)this.getNetwork();
            network.getPollScheduler().unsubscribe((BIPollable)this);
        }
        super.stopped();
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.equals((Object)conversion)) {
            if (this.getParent() instanceof BAccessStrike) {
                return BAccessNetwork.lex.getText("AccessStrike.conversion");
            }
            if (this.getParent() instanceof BAccessSdi) {
                return BAccessNetwork.lex.getText("AccessSdi.conversion");
            }
            return BAccessNetwork.lex.getText("conversion");
        }
        return super.getDisplayName(slot, cx);
    }

    public boolean requiresPointSubscription() {
        return false;
    }

    public Type getDeviceExtType() {
        return BNrioPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void doReadPoint() {
        this.read();
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && context != Context.decoding) {
            if (prop.equals(instance)) {
                BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                if (conflictPoint != null) {
                    this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                    this.setEnabled(false);
                } else {
                    this.undoInstance = this.getInstance();
                }
                this.device().updateProxyValues();
                this.accessDevice().fixGeneralUsePoints();
            } else if (prop.equals(enabled)) {
                if (this.getEnabled()) {
                    BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                    if (conflictPoint != null) {
                        this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                        this.setEnabled(false);
                    } else {
                        this.readOk(this.getReadValue());
                    }
                    this.device().updateProxyValues();
                }
                this.accessDevice().fixGeneralUsePoints();
            }
        }
    }

    public void poll() {
        BAccessNetwork network = this.getAccessNetwork();
        if (network.getLog().isTraceOn()) {
            network.getLog().trace((Object)((Object)this) + ".poll()");
        }
        this.read();
        if (!this.getStatus().isStale()) {
            network.getPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    private void read() {
        if (this.getParentPoint() instanceof BBooleanWritable) {
            this.readOk(this.getWriteValue());
        } else {
            this.device().updateProxyValues();
        }
    }

    public void writeData(BStatusValue out) {
        BAccessNetwork network = (BAccessNetwork)this.getNetwork();
        if (network == null) {
            return;
        }
        if (this.device() instanceof BAccess2ReaderModule) {
            Object door = null;
            int wrStatus = this.device().setDoValue(((BStatusBoolean)out).getValue(), this.getInstance());
            if (wrStatus == 0) {
                this.writeOk(out);
            } else {
                this.writeFail("writeError: " + wrStatus);
            }
        } else {
            super.writeData(out);
        }
    }

    public void updateReaderStatus() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getParent().getParent() instanceof BAccessReader) {
            boolean shouldBeDisabled;
            BAccessReader reader = (BAccessReader)this.getParent().getParent();
            int status = this.getStatus().getBits();
            BStatus readerStatus = reader.getStatus();
            boolean shouldBeEnabled = this.getEnabled() && reader.getEnabled() && !this.getDevice().isDisabled();
            boolean bl = shouldBeDisabled = !shouldBeEnabled;
            if (shouldBeEnabled && this.getStatus().isDisabled()) {
                this.setStatus(BStatus.make((int)(status & 0xFFFFFFFE)));
            } else if (shouldBeDisabled && !this.getStatus().isDisabled()) {
                this.setStatus(BStatus.make((int)(status | 1)));
            }
            this.getTuning().transition();
            this.executePoint();
        }
    }

    public String toString(Context cx) {
        return super.toString(cx);
    }

    private BNrioDevice device() {
        return (BNrioDevice)this.getDevice();
    }

    private BIAccessDevice accessDevice() {
        return (BIAccessDevice)this.getDevice();
    }

    private BAccessNetwork getAccessNetwork() {
        return (BAccessNetwork)this.getDevice().getNetwork();
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }
}

